/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.internal;

import com.amazon.agui.swing.KindleFrameFactory;
import com.amazon.ebook.util.file.UserPreferences;
import com.amazon.ebook.util.thread.ThreadPool;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.device.ScreenRotationService;
import com.amazon.kindle.device.time.TimeService;
import com.amazon.kindle.identity.KindleIdentity;
import com.amazon.kindle.kindlet.KindletContext;
import com.amazon.kindle.kindlet.device.Device;
import com.amazon.kindle.kindlet.input.GlobalGestureHandler;
import com.amazon.kindle.kindlet.input.keyboard.OnscreenKeyboardManager;
import com.amazon.kindle.kindlet.internal.IllegalKindletStateException;
import com.amazon.kindle.kindlet.internal.KindletAppContextFactory;
import com.amazon.kindle.kindlet.internal.KindletBooklet;
import com.amazon.kindle.kindlet.internal.KindletContainer;
import com.amazon.kindle.kindlet.internal.KindletContainerException;
import com.amazon.kindle.kindlet.internal.KindletContainerFactory;
import com.amazon.kindle.kindlet.internal.KindletCrashLog;
import com.amazon.kindle.kindlet.internal.KindletEventQueueMonitor;
import com.amazon.kindle.kindlet.internal.KindletException;
import com.amazon.kindle.kindlet.internal.KindletExecutionException;
import com.amazon.kindle.kindlet.internal.KindletFileSystem;
import com.amazon.kindle.kindlet.internal.KindletLoadException;
import com.amazon.kindle.kindlet.internal.KindletProcess;
import com.amazon.kindle.kindlet.internal.KindletThreadGroup;
import com.amazon.kindle.kindlet.internal.KindletUIStateHelper;
import com.amazon.kindle.kindlet.internal.StandardKindletContext;
import com.amazon.kindle.kindlet.internal.capability.DeviceImpl;
import com.amazon.kindle.kindlet.internal.input.KindletGlobalGestureHandler;
import com.amazon.kindle.kindlet.internal.input.keyboard.KindletOnscreenKeyboardManager;
import com.amazon.kindle.kindlet.internal.install.Application;
import com.amazon.kindle.kindlet.internal.lifecycle.KindletLifeCycle;
import com.amazon.kindle.kindlet.internal.lifecycle.State;
import com.amazon.kindle.kindlet.internal.lifecycle.StateChange;
import com.amazon.kindle.kindlet.internal.lifecycle.StateChangeHandler;
import com.amazon.kindle.kindlet.internal.log.Logger;
import com.amazon.kindle.kindlet.internal.log.LoggerFactory;
import com.amazon.kindle.kindlet.internal.net.ConnectivityRequestor;
import com.amazon.kindle.kindlet.internal.net.KindletConnectivity;
import com.amazon.kindle.kindlet.internal.net.KindletConnectivityRequestor;
import com.amazon.kindle.kindlet.internal.net.KindletURLStreamHandlerDelegate;
import com.amazon.kindle.kindlet.internal.net.NetworkAccessRequester;
import com.amazon.kindle.kindlet.internal.net.NetworkAccessRequesterFactory;
import com.amazon.kindle.kindlet.internal.net.NetworkContext;
import com.amazon.kindle.kindlet.internal.net.NetworkContextProperties;
import com.amazon.kindle.kindlet.internal.portability.DeviceServicesAccessor;
import com.amazon.kindle.kindlet.internal.portability.capability.DeviceCapabilityAdapter;
import com.amazon.kindle.kindlet.internal.portability.device.KindletStorage;
import com.amazon.kindle.kindlet.internal.portability.net.NetworkAdapter;
import com.amazon.kindle.kindlet.internal.portability.net.URLStreamHandlerDelegateAdapter;
import com.amazon.kindle.kindlet.internal.portability.security.KindletCertificateManager;
import com.amazon.kindle.kindlet.internal.portability.service.MarketplaceServiceHelper;
import com.amazon.kindle.kindlet.internal.portability.ui.EventQueueExceptionListener;
import com.amazon.kindle.kindlet.internal.security.KindletSecretKey;
import com.amazon.kindle.kindlet.internal.security.KindletSecureStorage;
import com.amazon.kindle.kindlet.internal.security.KindletSerialToPID;
import com.amazon.kindle.kindlet.internal.subscription.FileSubscriptionClient;
import com.amazon.kindle.kindlet.internal.subscription.KindletSubscription;
import com.amazon.kindle.kindlet.internal.subscription.SubscriptionClient;
import com.amazon.kindle.kindlet.internal.subscription.SubscriptionManager;
import com.amazon.kindle.kindlet.internal.ui.KindleToolbar;
import com.amazon.kindle.kindlet.internal.ui.KindletKRepaintManager;
import com.amazon.kindle.kindlet.internal.ui.KindletOrientationController;
import com.amazon.kindle.kindlet.internal.ui.KindletRootContainer;
import com.amazon.kindle.kindlet.internal.ui.KindletToolbarImpl;
import com.amazon.kindle.kindlet.internal.ui.KindletUIResourcesImpl;
import com.amazon.kindle.kindlet.internal.ui.TitleBar;
import com.amazon.kindle.kindlet.internal.ui.TitleBarImpl;
import com.amazon.kindle.kindlet.internal.ui.WindowUpdateModeHandler;
import com.amazon.kindle.kindlet.internal.ui.helper.KindletFocusOwnerHelper;
import com.amazon.kindle.kindlet.internal.ui.helper.KindletKMenuHelper;
import com.amazon.kindle.kindlet.internal.ui.helper.KindletKOptionPaneHelper;
import com.amazon.kindle.kindlet.internal.util.EventQueueHelper;
import com.amazon.kindle.kindlet.internal.util.KindletBookletStore;
import com.amazon.kindle.kindlet.net.Connectivity;
import com.amazon.kindle.kindlet.security.SecureStorage;
import com.amazon.kindle.kindlet.ui.KMenu;
import com.amazon.kindle.kindlet.ui.OrientationController;
import com.amazon.kindle.kindlet.ui.ToolbarStyle;
import com.amazon.kindle.kindlet.util.helper.ThreadGroupHelper;
import com.amazon.kindle.restricted.booklet.BookletContextExtension;
import com.amazon.kindle.restricted.device.DisplayManager;
import com.amazon.kindle.restricted.device.KindleSystemServices;
import com.amazon.kindle.restricted.net.AuthenticatorDelegate;
import com.amazon.kindle.restricted.runtime.Framework;
import com.amazon.kindle.webservices.registration.AmazonRegistrationService;
import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JFrame;
import sun.awt.AppContext;

public class BookletSandboxKindletProcess
implements KindletProcess {
    private static final String S = "TrustedAppContextMissingEventQueue";
    private static final String T = "KindletAppContextMissingEventQueue";
    private static final String R = "KindletOrphanFramesOnSandboxShutdown";
    private static final long Z = 5000L;
    private static final int p = 50;
    private static final long w = 5000L;
    private final Logger o;
    private final KindletSecretKey t;
    private final KindletCertificateManager Q;
    private KindletOnscreenKeyboardManager V;
    private final BookletContext u;
    private final KindletBooklet y;
    private final Application O;
    private final KindletAppContextFactory x;
    private KindletContainer f;
    private Container M;
    private JFrame J;
    private JFrame G;
    private KindletContext a;
    private KindletFileSystem i;
    private TitleBar E;
    private KindleToolbar C;
    private DeviceServicesAccessor d;
    private EventQueueExceptionListener j;
    private ExecutorService g;
    private final SubscriptionManager e;
    private Exception I;
    private NetworkAccessRequesterFactory F;
    private KindletEventQueueMonitor L;
    private final KindletStorage c;
    private final Device l;
    DisposeJFrameWindowListener k;
    final AtomicBoolean m = new AtomicBoolean(true);
    static /* synthetic */ Class B;
    static /* synthetic */ Class D;

    public BookletSandboxKindletProcess(Application a, KindletSecretKey a2, KindletCertificateManager a3, BookletContext a4, DeviceServicesAccessor a5, KindletBooklet a6, KindletAppContextFactory a7, NetworkAccessRequesterFactory a8, KindletStorage a9, SubscriptionManager a10, Device a11) {
        BookletSandboxKindletProcess a12;
        a12.O = a;
        a12.x = a7;
        a12.t = a2;
        a12.Q = a3;
        a12.u = a4;
        a12.d = a5;
        a12.y = a6;
        a12.F = a8;
        a12.I = null;
        a12.e = a10;
        a12.c = a9;
        a12.E = null;
        a12.l = a11;
        a12.o = LoggerFactory.getLogger((String)"BookletSandboxKindletProcess");
    }

    private void initialize() throws KindletContainerException, KindletExecutionException, KindletLoadException {
        BookletSandboxKindletProcess a;
        a.i = a.initializeFileSystem(a.O, a.c);
        a.i.clearTempDirectory();
        a.f = a.createSandbox(a.O, a.i, a.u, a.Q, a.x);
        a.initializeThreadGroupHelper(a.f);
        EventQueue a2 = a.createEventQueue(a.f, a.u);
        a.initializeDeviceCapability();
        KindletUIStateHelper a3 = new KindletUIStateHelper();
        KindletConnectivity a4 = a.initializeNetworking(a.O, a.f, a.u, a3, a2);
        SecureStorage a5 = a.initializeSecureStorage(a.O, a.i, a.t);
        KindletOrientationController a6 = a.initializeOrientationSupport(a.u);
        a.M = a.createUserInterface(a.O, a.f, a.u, a.y);
        GlobalGestureHandler a7 = a.initializeGestureHandler(a.u);
        a.V = KindletOnscreenKeyboardManager.newInstance(a.u, a);
        a.E = new TitleBarImpl(a.u, a.f);
        a.C = new KindletToolbarImpl(a.u, a.y.getChromeHeaderRequest(), a);
        KMenu a8 = a.initMenu(a.f);
        WindowUpdateModeHandler a9 = new WindowUpdateModeHandler(a.u);
        a.a = new StandardKindletContext(a5, a.M, a.i.getWorkDirectory(), (Connectivity)a4, a7, a.E, a.C, (OrientationController)a6, a8, a9, (OnscreenKeyboardManager)a.V);
        a.initToolbarStyle();
        a3.setKindletRootContainer(a.M);
        a.f.setKindletContext(a.a);
        System.setProperty("kindlet.home", a.i.getWorkDirectory().getAbsolutePath());
        a.registerSubscriptionAPI(a.i);
        a.kindleAuthenticatorCheck();
        a.registerConnectivityResourceHandlers(a4);
        KindletBookletStore.initialize(a.f.getAppContext());
    }

    private void initToolbarStyle() {
        BookletSandboxKindletProcess a;
        ToolbarStyle a2 = ToolbarStyle.TOOLBAR_PERSISTENT;
        if (a.O.getMetadata() != null) {
            try {
                ToolbarStyle a3 = a.O.getMetadata().getToolbarStyle();
                if (a3 != null) {
                    a2 = a3;
                    a.o.debug("Setting application's toolbar style to " + a2);
                }
            }
            catch (IllegalArgumentException a4) {
                a.o.warn("Error in parsing toolbar style; defaulting to " + a2);
            }
        }
        a.C.setToolbarStyle(a2);
    }

    private KMenu initMenu(KindletContainer a) throws KindletContainerException {
        BookletSandboxKindletProcess a2;
        final AtomicReference a3 = new AtomicReference(null);
        Runnable a4 = new Runnable(){
            {
                1 a;
            }

            public void run() {
                1 a;
                if (a.BookletSandboxKindletProcess.this.o.isLoggable(1024)) {
                    a.BookletSandboxKindletProcess.this.o.debug("creating default KMenu in " + AppContext.getAppContext());
                }
                a.a3.set((Object)new KMenu());
            }
        };
        a2.trustedKindletInvokeAndWait(a.getAppContext(), a4);
        return (KMenu)a3.get();
    }

    private void kindleAuthenticatorCheck() throws KindletContainerException, KindletExecutionException {
        BookletSandboxKindletProcess a;
        final PasswordAuthentication[] a2 = new PasswordAuthentication[1];
        a.kindletInvokeAndWait(a.f.getAppContext(), false, new Runnable(){
            {
                2 a;
            }

            public void run() {
                a.a2[0] = AuthenticatorDelegate.requestPasswordAuthentication(null, null, (int)0, null, null, null);
            }
        });
        if (a2[0] != null) {
            throw new KindletContainerException("KindleAuthentication did not initialize properly.");
        }
    }

    KindletFileSystem initializeFileSystem(Application a, KindletStorage a2) throws KindletContainerException {
        try {
            return new KindletFileSystem(a2, a);
        }
        catch (IOException a3) {
            throw new KindletContainerException("Could not initialize Kindlet filesystem.", (Throwable)a3);
        }
    }

    KindletOrientationController initializeOrientationSupport(BookletContext a) {
        ScreenRotationService a2 = (ScreenRotationService)a.getService(ScreenRotationService.class);
        return new KindletOrientationController(a, a2);
    }

    KindletConnectivity initializeNetworking(Application a, KindletContainer a2, BookletContext a3, KindletUIStateHelper a4, EventQueue a5) throws KindletContainerException, KindletExecutionException {
        BookletSandboxKindletProcess a6;
        AuthenticatorDelegate.setDefault((ThreadGroup)a2.getThreadGroup(), (AuthenticatorDelegate)new AuthenticatorDelegate(){
            {
                3 a;
            }

            protected PasswordAuthentication getPasswordAuthentication() {
                return null;
            }
        });
        a6.registerURLStreamHandlers(a2.getThreadGroup(), a3, a6.d.getNetworkAdapter());
        NetworkContext a7 = a6.publishNetworkContext(a, a2.getThreadGroup(), a3);
        ExecutorService a8 = a2.getThreadGroup().newSingleThreadExecutor("ConnectivityThread");
        EventQueue a9 = Toolkit.getDefaultToolkit().getSystemEventQueue();
        NetworkAccessRequester a10 = a6.F.create(a7, a4, a5, a9);
        KindletConnectivityRequestor a11 = new KindletConnectivityRequestor(a10);
        return new KindletConnectivity((ConnectivityRequestor)a11, a8);
    }

    private NetworkContext publishNetworkContext(Application a, final KindletThreadGroup a2, BookletContext a3) throws KindletContainerException, KindletExecutionException {
        NetworkContext a4;
        BookletSandboxKindletProcess a5;
        boolean a6 = ((AmazonRegistrationService)a3.getService(AmazonRegistrationService.class)).isRegistered();
        final UserPreferences a7 = Framework.getFrameworkPrefs();
        Set a8 = null;
        try {
            a8 = a.getMetadata().getNetworkAccessGrants();
            if (a8 == null) {
                throw new KindletContainerException("Failed to publish NetworkContext, due to a failue to obtain a valid set of network access grants.");
            }
        }
        catch (ParseException a9) {
            KindletExecutionException a10 = KindletExecutionException.createExceptionWithTrustedDetails((String)"A failure was encountered while attempting to parse Network-Access-Grants from the manifest for this application.");
            a5.appendToCrashLog(a10);
            throw a10;
        }
        try {
            a4 = new NetworkContext(a.getId(), a6, a8, new NetworkContextProperties(){
                public static final String K = "device.tz.country";
                {
                    4 a;
                }

                public String getCountryCode() {
                    4 a;
                    return a.a7.getProperty(K, "");
                }
            }, a5.d.getAmazonProxyAuthentication());
            a2.execute(new Callable(){
                {
                    5 a;
                }

                public Object call() {
                    5 a;
                    a.BookletSandboxKindletProcess.this.y.getNetworkManager().addNetworkContext(a.a4, a.a2);
                    return null;
                }
            }, 5000L, TimeUnit.MILLISECONDS);
            String a11 = a2.getRootKindletThreadGroup() != null ? a2.getRootKindletThreadGroup().getName() : "Null isolated thread group";
            a5.o.info("publishNetworkContextInfo", "Published NetworkContext.", new String[]{"ThreadGroup"}, new Object[]{a11});
        }
        catch (KindletExecutionException a12) {
            throw new KindletContainerException("Failed to publish NetworkContext.", a12.getCause());
        }
        catch (KindletContainerException a13) {
            throw new KindletContainerException("Failed to publish NetworkContext.", (Throwable)a13);
        }
        return a4;
    }

    private void registerURLStreamHandlers(KindletThreadGroup a, BookletContext a2, final NetworkAdapter a3) throws KindletContainerException {
        try {
            BookletSandboxKindletProcess a4;
            if (!a.isDestroyed()) {
                String a5;
                a.execute(new Callable(){
                    {
                        6 a;
                    }

                    public Object call() {
                        6 a;
                        KindletURLStreamHandlerDelegate a2 = new KindletURLStreamHandlerDelegate(a.BookletSandboxKindletProcess.this.y.getNetworkManager(), a.a3);
                        a.a3.addURLStreamHandlerDelegate("http", (URLStreamHandlerDelegateAdapter)a2);
                        a.a3.addURLStreamHandlerDelegate("https", (URLStreamHandlerDelegateAdapter)a2);
                        return null;
                    }
                }, 5000L, TimeUnit.MILLISECONDS);
                String string = a5 = a.getRootKindletThreadGroup() != null ? a.getRootKindletThreadGroup().getName() : "Null isolated thread group";
                if (a4.o.isLoggable(1024)) {
                    a4.o.debug("registerURLStreamHandlers", "Registered URLStreamHandlers.", new String[]{"ThreadGroup"}, new Object[]{a5});
                }
            } else {
                a4.o.error("not registering URL handlers since threadgroup is being destroyed.");
            }
        }
        catch (KindletExecutionException a6) {
            throw new KindletContainerException("Failed to register URLStreamHandlers: ", a6.getCause());
        }
        catch (KindletContainerException a7) {
            throw new KindletContainerException("Failed to register URLStreamHandlers.", (Throwable)a7);
        }
    }

    KindletContainer createSandbox(Application a, KindletFileSystem a2, BookletContext a3, KindletCertificateManager a4, KindletAppContextFactory a5) throws KindletContainerException, KindletExecutionException, KindletLoadException {
        BookletSandboxKindletProcess a6;
        KindleIdentity a7 = (KindleIdentity)a3.getService(KindleIdentity.class);
        if (a7 == null) {
            throw new KindletContainerException("Could not retrieve identity service");
        }
        String a8 = KindletSerialToPID.getPID((String)a7.getDeviceSerialID());
        PermissionCollection a9 = a2.getWorkDirectoryPermissions();
        return KindletContainerFactory.createContainer(a, a9, a6.c, a8, a4, a5, a6);
    }

    void initializeThreadGroupHelper(final KindletContainer a) {
        BookletSandboxKindletProcess a2;
        ThreadGroupHelper a3 = new ThreadGroupHelper(){
            {
                7 a2;
            }

            public void addExecutor(ExecutorService a3) {
                7 a2;
                a2.a.getThreadGroup().addExecutor(a3);
            }

            public ThreadFactory createThreadFactory(String a3) {
                7 a2;
                return a2.a.getThreadGroup().createThreadFactory(a3);
            }

            public ThreadGroup getKindletThreadGroup() {
                7 a2;
                return a2.a.getThreadGroup().getRootKindletThreadGroup();
            }
        };
        a.getAppContext().put(ThreadGroupHelper.class, a3);
    }

    SecureStorage initializeSecureStorage(Application a, KindletFileSystem a2, KindletSecretKey a3) {
        return new KindletSecureStorage(a3, a2.getMetaDataDirectory(), a);
    }

    GlobalGestureHandler initializeGestureHandler(BookletContext a) {
        KindletGlobalGestureHandler a2 = new KindletGlobalGestureHandler(a);
        a2.clearActionMap();
        return a2;
    }

    private void initializeDeviceCapability() throws KindletExecutionException {
        int a;
        String[] a2;
        BookletSandboxKindletProcess a3;
        DeviceCapabilityAdapter a4 = a3.d.getDeviceCapabilityAdapter();
        File a5 = new File(a4.getPendingOverrideCapabilityFile().getFile());
        if (a5.exists()) {
            a2 = new File(a4.getOverrideCapabilityFile().getFile());
            try {
                if (!a5.renameTo((File)a2)) {
                    a3.o.error("Could not replace old override file with new capability overrides.");
                }
            }
            catch (SecurityException a6) {
                a3.o.error("Could not replace old override file with new capability overrides due to security exception.", (Throwable)a6);
            }
        }
        ((DeviceImpl)a3.l).initializeCapabilityOverrides(a4.getOverrideCapabilityFile());
        a3.f.getAppContext().put(Device.class, a3.l);
        a2 = a3.O.getMetadata().getRequiredCapabilities();
        int a7 = a2.length;
        boolean a8 = true;
        int n = a = 0;
        int n2 = a7;
        while (n < n2 && a8) {
            try {
                URI a9 = new URI(a2[a]);
                Device.SupportLevel a10 = a3.l.isSupported(a9);
                if (Device.SupportLevel.SUPPORTED.equals((Object)a10)) {
                    a3.o.debug("Capability: " + a2[a] + " - [" + a10 + "]");
                } else {
                    String a11 = "Capability: " + a2[a] + " - [" + a10 + "]";
                    a3.o.warn(a11);
                    a3.appendToCrashLog(a11);
                    a8 = false;
                }
            }
            catch (NumberFormatException a12) {
                a3.appendToCrashLog("Error in data format for capability specified in the manifest: " + a2[a]);
                a8 = false;
            }
            catch (URISyntaxException a13) {
                a3.appendToCrashLog("Malformed URI specified in the manifest: " + a2[a]);
                a8 = false;
            }
            n = ++a;
            n2 = a7;
        }
        if (!a8) {
            String a14 = MarketplaceServiceHelper.getURLMessage((String)"com.amazon.kindle.kindlet.internal.resources.KindletBookletResources", (String)"kindlet.capability.fail.pattern");
            throw new KindletExecutionException(a14, "", true);
        }
    }

    protected EventQueue createEventQueue(final KindletContainer a, BookletContext a2) throws KindletContainerException {
        EventQueue a3;
        BookletSandboxKindletProcess a4;
        try {
            a3 = (EventQueue)a.getThreadGroup().executeTrustedCallable(new Callable(){
                {
                    8 a2;
                }

                public Object call() {
                    8 a5;
                    EventQueue a2 = (EventQueue)a5.a.getAppContext().get(AppContext.EVENT_QUEUE_KEY);
                    a2.postEvent(new InvocationEvent((Object)a5, new Runnable(){
                        {
                            1 a;
                        }

                        public void run() {
                        }
                    }));
                    a5.BookletSandboxKindletProcess.this.j = new EventQueueExceptionHandler();
                    a5.BookletSandboxKindletProcess.this.d.getUIManagerAdapter().addEventQueueExceptionListener(a5.BookletSandboxKindletProcess.this.j);
                    TimeService a3 = (TimeService)a5.BookletSandboxKindletProcess.this.u.getService(B == null ? (B = BookletSandboxKindletProcess.class$("com.amazon.kindle.device.time.TimeService")) : B);
                    KindleSystemServices a4 = (KindleSystemServices)a5.BookletSandboxKindletProcess.this.u.getService(D == null ? (D = BookletSandboxKindletProcess.class$("com.amazon.kindle.restricted.device.KindleSystemServices")) : D);
                    a5.BookletSandboxKindletProcess.this.L = new KindletEventQueueMonitor(a5.a, a3, a4, a5.BookletSandboxKindletProcess.this.d.getKindletSystemAlert(), a2, 60000L, 1500L);
                    return a2;
                }
            });
        }
        catch (KindletException a5) {
            throw new KindletContainerException("Could not create container in child appcontext.", (Throwable)a5);
        }
        a4.L.createExecutor((ThreadGroupHelper)a.getAppContext().get(ThreadGroupHelper.class), (EventQueue)AppContext.getAppContext().get(AppContext.EVENT_QUEUE_KEY));
        return a3;
    }

    Container createUserInterface(final Application a, final KindletContainer a2, final BookletContext a3, KindletBooklet a4) throws KindletContainerException {
        BookletSandboxKindletProcess a5;
        Runnable a6 = new Runnable(){
            {
                9 a;
            }

            public void run() {
                9 a;
                if (a.BookletSandboxKindletProcess.this.o.isLoggable(1024)) {
                    a.BookletSandboxKindletProcess.this.o.debug("initializing the device display theme.");
                }
                DisplayManager.initLookAndFeel();
            }
        };
        a5.trustedKindletInvokeAndWait(a2.getAppContext(), a6);
        a5.createFrames();
        a5.k = a5.new DisposeJFrameWindowListener();
        a5.J.addWindowListener(a5.k);
        Container a7 = a3.getUIContainer();
        final AtomicReference a8 = new AtomicReference(null);
        Runnable a9 = new Runnable(){
            {
                10 a;
            }

            public void run() {
                10 a;
                if (a.BookletSandboxKindletProcess.this.o.isLoggable(1024)) {
                    a.BookletSandboxKindletProcess.this.o.debug("creating Kindlet's top level container in " + AppContext.getAppContext());
                }
                KindletRootContainer a2 = new KindletRootContainer(a.a3);
                a2.setVisible(false);
                a2.setFocusable(true);
                a2.setFocusCycleRoot(true);
                a.a8.set((Object)a2);
            }
        };
        a5.trustedKindletInvokeAndWait(a2.getAppContext(), a9);
        a7.add((Container)a8.get());
        KindletUIResourcesImpl.makeAvailableStatically(a2.getAppContext(), new KindletUIResourcesImpl());
        Runnable a10 = new Runnable(){
            {
                11 a;
            }

            public void run() {
                11 a;
                if (a.BookletSandboxKindletProcess.this.o.isLoggable(1024)) {
                    a.BookletSandboxKindletProcess.this.o.debug("registering UI helpers in " + AppContext.getAppContext());
                }
                KindletKOptionPaneHelper.initialize((AppContext)a.a2.getAppContext(), (Container)((Container)a.a8.get()), (BookletContext)a.a3);
                KindletFocusOwnerHelper.initialize((AppContext)a.a2.getAppContext(), (Container)((Container)a.a8.get()));
                KindletKMenuHelper.initialize((AppContext)a.a2.getAppContext(), (BookletContext)a.a3);
                KindletKRepaintManager.initialize((AppContext)a.a2.getAppContext(), (KindletRootContainer)((KindletRootContainer)a.a8.get()));
            }
        };
        a5.trustedKindletInvokeAndWait(a2.getAppContext(), a10);
        a2.getLifeCycle().addTrustedStateChangeHandler(new StateChangeHandler(){
            {
                12 a3;
            }

            public void handleStateChange(StateChange a6) throws KindletContainerException, KindletExecutionException {
                12 a22;
                if (KindletLifeCycle.l.equals((Object)a6) && a22.BookletSandboxKindletProcess.this.E != null) {
                    a22.BookletSandboxKindletProcess.this.o.debug("Setting kindlet's title.");
                    a22.BookletSandboxKindletProcess.this.E.setTitle(a22.a.getMetadata().getName());
                }
                if (KindletLifeCycle.k.equals((Object)a6)) {
                    // empty if block
                }
                if (KindletLifeCycle.m.equals((Object)a6)) {
                    a22.BookletSandboxKindletProcess.this.kindletInvokeAndWait(a22.a2.getAppContext(), false, new Runnable(){
                        {
                            1 a;
                        }

                        public void run() {
                            1 a;
                            BookletSandboxKindletProcess.this.o.debug("setting the ui and topLevelFrame to be visible");
                            BookletSandboxKindletProcess.this.J.setVisible(true);
                            BookletSandboxKindletProcess.this.M.setVisible(true);
                            if ((a.this).BookletSandboxKindletProcess.this.m.get()) {
                                BookletSandboxKindletProcess.this.o.debug("The app is being displayed for the first time. Requesting focus on the ui.");
                                BookletSandboxKindletProcess.this.M.requestFocus();
                                (a.this).BookletSandboxKindletProcess.this.m.set(false);
                            }
                            BookletSandboxKindletProcess.this.o.debug("restoring focus back to the component that had focus before stop was called");
                            if (KindletFocusOwnerHelper.getHelper() != null) {
                                Component a2 = KindletFocusOwnerHelper.getHelper().popFocusOwner();
                                BookletSandboxKindletProcess.this.o.debug("component popped from stack is " + a2);
                            } else {
                                BookletSandboxKindletProcess.this.o.warn("No KindletFocusOwnerHelper instance");
                            }
                        }
                    });
                }
                if (KindletLifeCycle.h.equals((Object)a6)) {
                    AtomicReference a3;
                    block10: {
                        block9: {
                            a3 = new AtomicReference(null);
                            a22.BookletSandboxKindletProcess.this.o.debug("waiting for the event queue to be cleared.");
                            try {
                                a22.BookletSandboxKindletProcess.this.kindletInvokeAndWait(a22.a2.getAppContext(), false, new Runnable(){
                                    {
                                        2 a;
                                    }

                                    public void run() {
                                    }
                                });
                            }
                            catch (KindletExecutionException a4) {
                                a22.BookletSandboxKindletProcess.this.o.warn("handleStateChangeFail", "KindletExecutionException caught while waiting for the event queue. Emptying the event queue.", (Throwable)a4);
                                a22.BookletSandboxKindletProcess.this.emptyEventQueue(a22.a2);
                                a22.BookletSandboxKindletProcess.this.pushNewEventQueue(a22.a2);
                                a22.BookletSandboxKindletProcess.this.L.replaceEventQueue((EventQueue)a22.a2.getAppContext().get(AppContext.EVENT_QUEUE_KEY));
                                if (a3.get() != null) break block9;
                                a3.set((Object)a4);
                            }
                        }
                        a22.BookletSandboxKindletProcess.this.o.debug("saving last focus owner and setting root pane and frame visibility to false");
                        try {
                            a22.BookletSandboxKindletProcess.this.kindletInvokeAndWait(a22.a2.getAppContext(), false, new Runnable(){
                                {
                                    3 a;
                                }

                                public void run() {
                                    3 a;
                                    KindletFocusOwnerHelper.getHelper().pushFocusOwner();
                                    BookletSandboxKindletProcess.this.M.setVisible(false);
                                    BookletSandboxKindletProcess.this.J.setVisible(false);
                                }
                            });
                        }
                        catch (KindletExecutionException a5) {
                            a22.BookletSandboxKindletProcess.this.o.warn("handleStateChangeFail", "KindletExecutionException caught while trying to save the last focus owner and setting root pane visibility to false.", (Throwable)a5);
                            if (a3.get() != null) break block10;
                            a3.set((Object)a5);
                        }
                    }
                    if (a3.get() != null) {
                        a22.BookletSandboxKindletProcess.this.o.warn("error during executing stop(). notifying handler");
                        throw (KindletExecutionException)((Object)a3.get());
                    }
                    a22.BookletSandboxKindletProcess.this.o.debug("done stopping kindlet");
                }
            }
        });
        return (Container)a8.get();
    }

    void pushNewEventQueue(final KindletContainer a) throws KindletContainerException {
        BookletSandboxKindletProcess a2;
        a2.o.info("Pushing alternate event queue after draining all the events");
        a.getThreadGroup().executeTrustedCallable(new Callable(){
            {
                13 a2;
            }

            public Object call() {
                13 a4;
                EventQueue a2 = (EventQueue)a4.a.getAppContext().get(AppContext.EVENT_QUEUE_KEY);
                EventQueue a3 = new EventQueue();
                if (a4.BookletSandboxKindletProcess.this.o.isLoggable(1024)) {
                    a4.BookletSandboxKindletProcess.this.o.debug("Replacing kindlet event queue from " + a2 + " by  " + a3);
                }
                a2.push(a3);
                if (a4.BookletSandboxKindletProcess.this.o.isLoggable(1024)) {
                    a4.BookletSandboxKindletProcess.this.o.debug("Pushing new EventQueue is successful. New one = " + (EventQueue)a4.a.getAppContext().get(AppContext.EVENT_QUEUE_KEY));
                }
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new InvocationEvent((Object)a4, new Runnable(){
                    {
                        1 a;
                    }

                    public void run() {
                    }
                }));
                return null;
            }
        });
    }

    private void emptyEventQueue(KindletContainer a) throws KindletContainerException {
        BookletSandboxKindletProcess a2;
        EventQueue a3 = (EventQueue)a.getAppContext().get(AppContext.EVENT_QUEUE_KEY);
        if (null == a3) {
            throw new KindletContainerException("AppContext is missing an EventQueue");
        }
        a2.M.setVisible(false);
        a2.J.setVisible(false);
        int a4 = 0;
        while (null != a3.peekEvent()) {
            ++a4;
            try {
                a3.getNextEvent();
            }
            catch (InterruptedException a5) {
                a2.o.error("emptyEventQueueFail", "Exception caught while clearing the event queue", (Throwable)a5);
                Thread.currentThread().interrupt();
                throw new KindletContainerException("Interrupted while clearing the Kindlet's event queue.", (Throwable)a5);
            }
        }
        if (a4 > 0) {
            a2.o.warn("emptyEventQueueInfo", "Removed " + a4 + " events.");
        }
    }

    private void trustedKindletInvokeAndWait(AppContext a, Runnable a2) throws KindletContainerException {
        EventQueue a3 = (EventQueue)a.get(AppContext.EVENT_QUEUE_KEY);
        if (null == a3) {
            BookletSandboxKindletProcess a4;
            a4.logAppContextMissingDetEvent(a);
            throw new KindletContainerException("AppContext is missing an EventQueue");
        }
        try {
            if (!EventQueueHelper.invokeAndWaitOnInstanceRuntime((EventQueue)a3, (Runnable)a2, (long)5000L)) {
                throw new KindletContainerException("Kindlet event queue failed to respond for " + String.valueOf(5000L) + "ms.");
            }
        }
        catch (InterruptedException a5) {
            Thread.currentThread().interrupt();
            throw new KindletContainerException("Interrupted while waiting for the Kindlet's event queue.", (Throwable)a5);
        }
    }

    private void trustedKindletInvokeLater(AppContext a, Runnable a2) throws KindletContainerException {
        EventQueue a3 = (EventQueue)a.get(AppContext.EVENT_QUEUE_KEY);
        if (null == a3) {
            BookletSandboxKindletProcess a4;
            a4.logAppContextMissingDetEvent(a);
            throw new KindletContainerException("AppContext is missing an EventQueue");
        }
        EventQueueHelper.invokeLaterOnInstance((EventQueue)a3, (Runnable)a2);
    }

    private void kindletInvokeAndWait(AppContext a, boolean a2, Runnable a3) throws KindletExecutionException, KindletContainerException {
        BookletSandboxKindletProcess a4;
        if (a2 && a4.f.getLifeCycle().getState() == State.SHUTDOWN) {
            return;
        }
        EventQueue a5 = (EventQueue)a.get(AppContext.EVENT_QUEUE_KEY);
        if (null == a5) {
            a4.logAppContextMissingDetEvent(a);
            throw new KindletContainerException("AppContext is missing an EventQueue");
        }
        try {
            if (!EventQueueHelper.invokeAndWaitOnInstanceRuntime((EventQueue)a5, (Runnable)a3, (long)5000L)) {
                throw KindletExecutionException.createExceptionWithTrustedDetails((String)("User interface call took longer than " + String.valueOf(5000L) + "ms."));
            }
        }
        catch (InterruptedException a6) {
            Thread.currentThread().interrupt();
            throw new KindletContainerException("Interrupted while waiting for the Kindlet's event queue.", (Throwable)a6);
        }
    }

    private void kindletInvokeLater(AppContext a, boolean a2, Runnable a3) throws KindletExecutionException, KindletContainerException {
        BookletSandboxKindletProcess a4;
        if (a2 && a4.f.getLifeCycle().getState() == State.SHUTDOWN) {
            return;
        }
        EventQueue a5 = (EventQueue)a.get(AppContext.EVENT_QUEUE_KEY);
        if (null == a5) {
            a4.logAppContextMissingDetEvent(a);
            throw new KindletContainerException("AppContext is missing an EventQueue");
        }
        EventQueueHelper.invokeLaterOnInstance((EventQueue)a5, (Runnable)a3);
    }

    public void shutdownNetworkContext(KindletThreadGroup a) throws KindletContainerException {
        BookletSandboxKindletProcess a2;
        try {
            if (a != null && !a.isDestroyed()) {
                a.executeTrustedCallable(new Callable(){
                    {
                        14 a;
                    }

                    public Object call() throws IOException {
                        14 a;
                        a.BookletSandboxKindletProcess.this.y.getNetworkManager().shutdownNetworkContext();
                        return null;
                    }
                }, 5000L, TimeUnit.MILLISECONDS);
                if (a2.o.isLoggable(1024)) {
                    a2.o.debug("removeNetworkContextSuccess", "Removed NetworkContext.", new String[]{"ThreadGroup"}, new Object[]{a.getName()});
                }
            }
        }
        catch (KindletContainerException a3) {
            a2.o.error("removeNetworkContextError", "Failed to remove NetworkContext.", new String[]{"ThreadGroup", "exception"}, new Object[]{a.getName(), a3});
        }
    }

    public Application getApplication() {
        BookletSandboxKindletProcess a;
        return a.O;
    }

    public boolean run() throws KindletExecutionException, KindletContainerException, KindletLoadException {
        BookletSandboxKindletProcess a;
        try {
            a.initialize();
            a.f.getLifeCycle().transition(State.RUNNING);
        }
        catch (KindletExecutionException a2) {
            a.appendToCrashLog(a2);
            throw a2;
        }
        return State.RUNNING.equals(a.f.getLifeCycle().getState());
    }

    public boolean pause() throws KindletExecutionException, KindletContainerException {
        BookletSandboxKindletProcess a;
        try {
            a.f.getLifeCycle().transition(State.READY);
        }
        catch (KindletExecutionException a2) {
            a.appendToCrashLog(a2);
            throw a2;
        }
        return State.READY.equals(a.f.getLifeCycle().getState());
    }

    public boolean resume() throws KindletExecutionException, KindletContainerException {
        BookletSandboxKindletProcess a;
        try {
            a.f.getLifeCycle().transition(State.RUNNING);
        }
        catch (KindletExecutionException a2) {
            a.appendToCrashLog(a2);
            throw a2;
        }
        return State.RUNNING.equals(a.f.getLifeCycle().getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopNetworking() throws KindletContainerException {
        BookletSandboxKindletProcess a;
        try {
            if (a.a != null && a.a.getConnectivity() != null) {
                ((KindletConnectivity)a.a.getConnectivity()).close();
            }
            if (a.f != null) {
                a.shutdownNetworkContext(a.f.getThreadGroup());
            }
        }
        finally {
            if (a.f != null) {
                AuthenticatorDelegate.remove((ThreadGroup)a.f.getThreadGroup());
                AuthenticatorDelegate.remove((ThreadGroup)a.f.getThreadGroup().getRootKindletThreadGroup());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws KindletExecutionException, IllegalKindletStateException, KindletContainerException {
        BookletSandboxKindletProcess a;
        AtomicReference a2 = new AtomicReference(null);
        final AtomicReference a3 = new AtomicReference(null);
        try {
            block44: {
                block43: {
                    block42: {
                        block39: {
                            block38: {
                                if (a.f != null) {
                                    try {
                                        a.f.getLifeCycle().transition(State.SHUTDOWN);
                                    }
                                    catch (KindletExecutionException a4) {
                                        a.o.error("transitionToShutdownError", "Failed to transition to shutodwn state in life cycle.", new String[]{"KindletExecutionException"}, new Object[]{a4});
                                        a.appendToCrashLog(a4);
                                        if (a2.get() == null) {
                                            a2.set((Object)a4);
                                        }
                                    }
                                    catch (KindletContainerException a5) {
                                        a.o.error("transitionToShutdownError", "Failed to transition to shutdown state in life cycle.", new String[]{"KindletContainerException"}, new Object[]{a5});
                                        if (a3.get() != null) break block38;
                                        a3.set((Object)new IllegalKindletStateException("Could not inform Kindlet of desire to shutdown.", (Throwable)a5));
                                    }
                                }
                            }
                            if (a.f != null) {
                                try {
                                    a.kindletInvokeAndWait(a.f.getAppContext(), false, new Runnable(){
                                        {
                                            15 a;
                                        }

                                        public void run() {
                                        }
                                    });
                                }
                                catch (KindletExecutionException a6) {
                                    a.o.warn("emptyEventQueueOnKill", "During kill(), waiting for event queue to be emptied. Replacing with a new EventQueue.", (Throwable)a6);
                                    a.emptyEventQueue(a.f);
                                    a.pushNewEventQueue(a.f);
                                }
                            }
                            try {
                                a.stopNetworking();
                            }
                            catch (KindletContainerException a7) {
                                a.o.error("shutdownNetworkError", "Failed to shutdown Networking sub-system.", new String[]{"KindletContainerException"}, new Object[]{a7});
                                if (a3.get() != null) break block39;
                                a3.set((Object)new IllegalKindletStateException("An error occured while shutting down the networking sub-system.", (Throwable)a7));
                            }
                        }
                        if (a.f != null && a.V != null) {
                            a.V.shutdown();
                            a.V = null;
                        }
                        if (a.C != null) {
                            a.C.cleanup();
                        }
                        if (a.f != null) {
                            block41: {
                                block40: {
                                    try {
                                        KindletKOptionPaneHelper.unregister((AppContext)a.f.getAppContext());
                                        KindletFocusOwnerHelper.unregister((AppContext)a.f.getAppContext());
                                        KindletKMenuHelper.getHelper((AppContext)a.f.getAppContext()).cleanUp();
                                        KindletKMenuHelper.unregister((AppContext)a.f.getAppContext());
                                        KindletKRepaintManager.unregister((AppContext)a.f.getAppContext());
                                    }
                                    catch (RuntimeException a8) {
                                        a.o.error("removeKindletHelpersError", "Failed to shutdown kindlet helpers", new String[]{"RuntimeException"}, new Object[]{a8});
                                        if (a3 != null) break block40;
                                        a3.set((Object)new IllegalKindletStateException("An error occured while shutting down the Kindlet helpers.", (Throwable)a8));
                                    }
                                }
                                a.removeWindowListenerIsNecessary();
                                a.removeOrphanWindows();
                                try {
                                    a.kindletInvokeAndWait(a.f.getAppContext(), false, new Runnable(){
                                        {
                                            16 a;
                                        }

                                        public void run() {
                                            16 a;
                                            ArrayList a2 = KindleFrameFactory.getWindowsForApplication((String)a.BookletSandboxKindletProcess.this.y.getName());
                                            if (a2 != null && a.BookletSandboxKindletProcess.this.o.isLoggable(1024)) {
                                                a.BookletSandboxKindletProcess.this.o.debug("Remaining windows yet to be cleaned: " + a2.size());
                                            }
                                        }
                                    });
                                }
                                catch (KindletExecutionException a9) {
                                    a.o.error("cleanUpOrphanWindowError", "Failed to clean orphan Window for ", new String[]{"appId", "KindletExecutionException"}, new Object[]{a.y.getName(), a9});
                                    a.appendToCrashLog(a9);
                                    if (a2.get() != null) break block41;
                                    a2.set((Object)a9);
                                }
                            }
                            try {
                                a.kindletInvokeAndWait(a.f.getAppContext(), false, new Runnable(){
                                    {
                                        17 a;
                                    }

                                    public void run() {
                                        17 a;
                                        if (a.BookletSandboxKindletProcess.this.u instanceof BookletContextExtension) {
                                            a.BookletSandboxKindletProcess.this.o.debug("Disposing all Kindlet specific UI frames");
                                            ((BookletContextExtension)a.BookletSandboxKindletProcess.this.u).disposeFrames();
                                            a.BookletSandboxKindletProcess.this.o.debug("disposeFrames() has returned.");
                                        } else {
                                            a.BookletSandboxKindletProcess.this.o.error("BookletContext not instance of BookletContextExtension and hence cannot dispose UI frames");
                                            if (a.a3.get() == null) {
                                                a.a3.set((Object)new IllegalKindletStateException("Unable to dispose UI frames"));
                                            }
                                        }
                                    }
                                });
                            }
                            catch (KindletExecutionException a10) {
                                a.o.error("disposeFrameError", "Failed to dispose Kindlet UI frames.", new String[]{"KindletExecutionException"}, new Object[]{a10});
                                a.appendToCrashLog(a10);
                                if (a2.get() == null) {
                                    a2.set((Object)a10);
                                }
                            }
                            catch (KindletContainerException a11) {
                                a.o.error("disposeFrameError", "Failed to dispose kindlet UI frames", new String[]{"KindletContainerException"}, new Object[]{a11});
                                if (a3.get() != null) break block42;
                                a3.set((Object)new IllegalKindletStateException("An error occured while disposing Kindlet UI frames.", (Throwable)a11));
                            }
                        }
                    }
                    try {
                        a.shutdownSubscriptionAPI();
                    }
                    catch (RuntimeException a12) {
                        a.o.error("shutdownSubscriptionError", "Failed to shutdown subscription API", new String[]{"RuntimeException"}, new Object[]{a12});
                        if (a3.get() != null) break block43;
                        a3.set((Object)new IllegalKindletStateException("An error occured while shutting down the subscription API.", (Throwable)a12));
                    }
                }
                if (a.a != null) {
                    ((KindletGlobalGestureHandler)a.a.getGlobalGestureHandler()).clearActionMap();
                }
                try {
                    if (a.f != null) {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){
                            {
                                18 a;
                            }

                            public Object run() throws IllegalKindletStateException {
                                18 a;
                                a.BookletSandboxKindletProcess.this.f.shutdown();
                                return null;
                            }
                        });
                    }
                }
                catch (PrivilegedActionException a13) {
                    if (a13.getCause() instanceof IllegalKindletStateException) {
                        IllegalKindletStateException a14 = (IllegalKindletStateException)a13.getCause();
                        a.o.error("shutdownSandboxError", "Failed to shutdown Kindlet sandbox.", new String[]{"IllegalKindletStateException"}, new Object[]{a14});
                        a.appendToCrashLog(a14.getMessage());
                        if (a3.get() == null) {
                            a3.set((Object)a14);
                        }
                    }
                    a.o.error("shutdownSandboxError", "Error while shutting down sandbox.", new String[]{"Exception"}, new Object[]{a13.getCause()});
                    if (a3.get() != null) break block44;
                    a3.set((Object)a13.getCause());
                }
            }
            ArrayList a15 = KindleFrameFactory.getWindowsForApplication((String)a.y.getName());
            if (a15 != null) {
                if (a.o.isLoggable(1024)) {
                    a.o.debug("After shutting down sandbox, un-cleaned windows remaining = " + a15.size());
                }
                if (a15.size() > 0) {
                    a.o.error(R, "Orphan frames after sandbox shutdown", new String[]{"applicationId", "orphanFrameSize"}, new Object[]{a.O.getId(), String.valueOf(a15.size())});
                }
            }
        }
        finally {
            a.d.getUIManagerAdapter().removeEventQueueExceptionListener(a.j);
            if (a.L != null) {
                a.L.destroyExecutor();
            }
            a.clearPendingException();
        }
        if (a3.get() != null) {
            throw (IllegalKindletStateException)((Object)a3.get());
        }
        if (a2.get() != null) {
            throw (KindletExecutionException)((Object)a2.get());
        }
    }

    public void removeOrphanWindows() {
        BookletSandboxKindletProcess a;
        ArrayList a2 = KindleFrameFactory.getWindowsForApplication((String)a.y.getName());
        if (a2 != null && a.o.isLoggable(1024)) {
            a.o.debug("Number of frames that need to be cleaned = " + a2.size());
        }
        KindleFrameFactory.cleanUpApplicationDialogs((String)a.y.getName());
    }

    public boolean isRunning() {
        BookletSandboxKindletProcess a;
        if (a.f != null) {
            return State.RUNNING.equals(a.f.getLifeCycle().getState());
        }
        return false;
    }

    private void registerConnectivityResourceHandlers(final KindletConnectivity a) {
        BookletSandboxKindletProcess a2;
        a2.f.getLifeCycle().addTrustedPrerequisiteStateChangeHandler(new StateChangeHandler(){
            {
                19 a2;
            }

            public void handleStateChange(StateChange a3) throws KindletExecutionException, KindletContainerException {
                if (KindletLifeCycle.m.equals((Object)a3)) {
                    19 a2;
                    a2.a.start();
                }
            }
        });
        a2.f.getLifeCycle().addTrustedStateChangeHandler(new StateChangeHandler(){
            {
                20 a2;
            }

            public void handleStateChange(StateChange a3) throws KindletExecutionException, KindletContainerException {
                if (KindletLifeCycle.h.equals((Object)a3)) {
                    20 a2;
                    a2.a.stop();
                }
                if (KindletLifeCycle.m.equals((Object)a3)) {
                    // empty if block
                }
            }
        });
    }

    private void registerSubscriptionAPI(KindletFileSystem a) {
        BookletSandboxKindletProcess a2;
        if (a2.O.isDeveloper()) {
            a2.g = Executors.newSingleThreadExecutor();
            FileSubscriptionClient a3 = new FileSubscriptionClient(a.getSubscriptionFile());
            SubscriptionManager a4 = new SubscriptionManager(a2.g, (SubscriptionClient)a3);
            KindletSubscription.initialize((AppContext)a2.f.getAppContext(), (SubscriptionManager)a4, (Application)a2.O);
        } else {
            KindletSubscription.initialize((AppContext)a2.f.getAppContext(), (SubscriptionManager)a2.e, (Application)a2.O);
        }
    }

    private void shutdownSubscriptionAPI() {
        BookletSandboxKindletProcess a;
        if (a.g != null) {
            a.g.shutdown();
            a.g = null;
        }
    }

    public void appendToCrashLog(String a) {
        BookletSandboxKindletProcess a2;
        a2.appendToCrashLogWithExecutionException(KindletExecutionException.createExceptionWithTrustedDetails((String)a));
    }

    public void appendToCrashLog(Throwable a) {
        BookletSandboxKindletProcess a2;
        a2.appendToCrashLogWithExecutionException(KindletExecutionException.convertThrowable((Throwable)a));
    }

    private void appendToCrashLogWithExecutionException(KindletExecutionException a) {
        BookletSandboxKindletProcess a2;
        new KindletCrashLog(a2.O, a2.i.getCrashLogFile()).appendEntry(a);
    }

    public Container getKindletContainer() {
        BookletSandboxKindletProcess a;
        return a.M;
    }

    public boolean hasPendingException() {
        BookletSandboxKindletProcess a;
        return a.I != null;
    }

    public Exception getPendingException() {
        BookletSandboxKindletProcess a;
        return a.I;
    }

    public void clearPendingException() {
        a.I = null;
    }

    public void setPendingException(Exception a) throws IllegalArgumentException {
        if (a instanceof KindletExecutionException || a instanceof KindletContainerException || a instanceof IllegalKindletStateException) {
            a.I = a;
            return;
        }
        throw new IllegalArgumentException("Pending exception is not of the expected type");
    }

    public void throwPendingException() throws KindletExecutionException, KindletContainerException, IllegalKindletStateException, IllegalArgumentException {
        BookletSandboxKindletProcess a;
        if (a.I instanceof KindletExecutionException) {
            KindletExecutionException a2 = (KindletExecutionException)((Object)a.I);
            throw new KindletExecutionException(a2.getKindletClassName(), a2.getKindletMessage(), a2.getKindletStackTrace());
        }
        if (a.I instanceof KindletContainerException) {
            throw new KindletContainerException("Throwing pending exception", (Throwable)a.I);
        }
        if (a.I instanceof IllegalKindletStateException) {
            throw new IllegalKindletStateException("Throwing pending exception", (Throwable)a.I);
        }
        throw new IllegalArgumentException("Pending exception is not of the expected type");
    }

    private String getFrameName() {
        BookletSandboxKindletProcess a;
        return a.y.getName();
    }

    public void createFrames() throws KindletContainerException {
        BookletSandboxKindletProcess a;
        final AtomicReference a2 = new AtomicReference(null);
        final AtomicReference a3 = new AtomicReference(null);
        Runnable a4 = new Runnable(){
            {
                21 a;
            }

            public void run() {
                21 a;
                if (a.BookletSandboxKindletProcess.this.o.isLoggable(1024)) {
                    a.BookletSandboxKindletProcess.this.o.debug("creating Kindlet's top level frame in " + AppContext.getAppContext());
                }
                JFrame a22 = KindleFrameFactory.createKindleFrame((String)a.BookletSandboxKindletProcess.this.getFrameName(), (String)"A", (String)"application");
                a.a2.set((Object)a22);
                JFrame a32 = KindleFrameFactory.createKindleFrame((String)a.BookletSandboxKindletProcess.this.getFrameName(), (String)"C", (String)"footerBar");
                a.a3.set((Object)a32);
            }
        };
        a.trustedKindletInvokeAndWait(a.f.getAppContext(), a4);
        a.J = (JFrame)a2.get();
        a.G = (JFrame)a3.get();
    }

    public JFrame getFrame(String a, String a2) {
        BookletSandboxKindletProcess a3;
        if ("application".equals(a2)) {
            return a3.J;
        }
        if ("footerBar".equals(a2)) {
            return a3.G;
        }
        a3.o.error("getFrameError", "No frame supported. ", new String[]{"layer", "role"}, new Object[]{a, a2});
        return null;
    }

    public void invokeLater(Runnable a, boolean a2) {
        if (a != null) {
            BookletSandboxKindletProcess a3;
            if (a2) {
                if (a3.f != null) {
                    try {
                        if (a3.o.isLoggable(1024)) {
                            a3.o.debug("Executing trusted runnable in sandbox's eventqueue");
                        }
                        a3.trustedKindletInvokeLater(a3.f.getAppContext(), a);
                    }
                    catch (KindletContainerException a4) {
                        a3.o.error("Unable to invoke runnable on sandbox's Event Queue: ", (Throwable)a4);
                    }
                } else {
                    a3.o.error("This should not happen: invoking a runnable without sandbox being initialized");
                }
            } else {
                if (a3.o.isLoggable(1024)) {
                    a3.o.debug("Executing trusted runnable in sandbox");
                }
                a3.f.getThreadGroup().executeTrustedRunnable(a);
            }
        }
    }

    private void logAppContextMissingDetEvent(AppContext a) {
        BookletSandboxKindletProcess a2;
        a2.o.error(T, "AppContext is missing an EventQueue", new String[]{"lifecycle.state", "context.isDisposed()"}, new Object[]{a2.f.getLifeCycle().getState().getName(), new Boolean(a.isDisposed())});
    }

    public void prepareForShutdown() {
        BookletSandboxKindletProcess a;
        a.removeWindowListenerIsNecessary();
    }

    public boolean isShutdown() {
        BookletSandboxKindletProcess a;
        return State.SHUTDOWN.equals(a.f.getLifeCycle().getState());
    }

    public void removeWindowListenerIsNecessary() {
        BookletSandboxKindletProcess a;
        if (null != a.k && null != a.J) {
            a.J.removeWindowListener(a.k);
            a.k = null;
        }
    }

    public class DisposeJFrameWindowListener
    extends WindowAdapter {
        volatile AtomicBoolean B = new AtomicBoolean(false);

        public DisposeJFrameWindowListener() {
            DisposeJFrameWindowListener a;
        }

        public void windowClosed(WindowEvent a) {
            DisposeJFrameWindowListener a2;
            if (a2.B.compareAndSet(false, true)) {
                a2.BookletSandboxKindletProcess.this.o.debug("JFrame has been disposed. Going home");
                a2.postGoHome();
            }
        }

        void postGoHome() {
            DisposeJFrameWindowListener a;
            ThreadPool.getInstance().runIt(new Runnable(){
                {
                    1 a;
                }

                public void run() {
                    1 a;
                    BookletSandboxKindletProcess.this.y.postGoHomeSilently();
                }
            }, "DisposeJFrameWindowListener");
        }

        public boolean hasGoHomeBeenIssued() {
            DisposeJFrameWindowListener a;
            return a.B.get();
        }
    }

    private class EventQueueExceptionHandler
    implements EventQueueExceptionListener {
        private int B = 0;

        private EventQueueExceptionHandler() {
            EventQueueExceptionHandler a;
        }

        public void exceptionThrown(Throwable a) {
            EventQueueExceptionHandler a2;
            try {
                if (a2.B < 50) {
                    ++a2.B;
                    a2.BookletSandboxKindletProcess.this.appendToCrashLog(a);
                }
            }
            catch (Throwable a3) {
                try {
                    a2.BookletSandboxKindletProcess.this.o.error("KDK EventQueueExceptionHandler encountered an error while handling EDT exceptions.");
                    a2.BookletSandboxKindletProcess.this.appendToCrashLog("An error happened on the event dispatch thread.");
                    a2.BookletSandboxKindletProcess.this.o.error("The details are: " + a3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

