/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.apps.util.sidecar;

import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.kindle.apps.util.sidecar.SidecarFileUtil;
import com.amazon.kindle.content.catalog.CatalogEntry;
import com.amazon.kindle.content.catalog.CatalogService;
import com.amazon.kindle.content.catalog.CollationCriteria;
import com.amazon.kindle.content.catalog.Predicate;
import com.amazon.kindle.content.catalog.PredicateFactory;
import java.io.File;
import java.io.IOException;

public class AcxSidecarAccess {
    private static final Log A = Log.getInstance((String)"AcxSidecarAccess");
    private static final LogMessage H = new LogMessage("MissingBook", new String[]{"asin"});
    public static final String b = "asc";
    public static final char K = '.';
    private static final String B = "/mnt/us/documents/sidecars";

    public AcxSidecarAccess() {
        AcxSidecarAccess a;
    }

    public static String getNonBookSpecificACXSidecarDirectory() {
        return B;
    }

    public static String getACXSidecarDirectory(ReaderSDK a, String a2) {
        if (a2 == null) {
            return AcxSidecarAccess.getNonBookSpecificACXSidecarDirectory();
        }
        CatalogService a3 = (CatalogService)a.getService(CatalogService.class);
        if (a3 == null) {
            A.warning(H, new String[]{a2}, "Cannot calculate final directory because content catalog is missing");
            return null;
        }
        Predicate[] predicateArray = new Predicate[3];
        Predicate[] a4 = predicateArray;
        predicateArray[0] = PredicateFactory.inList((String)"cdeKey", (String[])new String[]{a2});
        a4[1] = PredicateFactory.not((Predicate)PredicateFactory.isTrue((String)"isArchived"));
        a4[2] = PredicateFactory.not((Predicate)PredicateFactory.inList((String)"cdeType", (String[])new String[]{"EBSP"}));
        CatalogEntry[] a5 = a3.find(PredicateFactory.and((Predicate[])a4), CollationCriteria.SORT_BY_TITLE, 1, 0);
        if (a5 == null || a5.length == 0) {
            A.warning(H, new String[]{a2}, "Cannot calculate final directory because book is missing");
            return null;
        }
        return AcxSidecarAccess.getSidecarDirNameForBookPath(a5[0].getLocation());
    }

    public static String getSidecarDirNameForBookPath(String a) {
        return SidecarFileUtil.getSidecarDirectory(new File(a));
    }

    public static boolean sidecarExists(String a, String a2, String a3, ReaderSDK a4) throws IOException {
        return AcxSidecarAccess.sidecarExistsInDirectory(new SidecarDirectoryFileWrapper(a4, a), a, a2, a3);
    }

    public static boolean sidecarExists(String a, String a2, String a3, String a4) throws IOException {
        return AcxSidecarAccess.sidecarExistsInDirectory(new SidecarDirectoryFileWrapper(a4), a, a2, a3);
    }

    public static boolean sidecarExistsInDirectory(FileWrapper a, String a2, String a3, String a4) throws IOException {
        String a5 = AcxSidecarAccess.generateSidecarName(a2, a3, a4);
        if (a5 == null) {
            return false;
        }
        return a.fileExists(a5.toString());
    }

    public static String generateSidecarName(String a, String a2, String a3) {
        if (a2 == null || a3 == null) {
            return null;
        }
        int a4 = a2.length() + a2.length() + (a == null ? 0 : a.length()) + 6;
        StringBuffer a5 = new StringBuffer(a4);
        a5.append(a2);
        a5.append('.');
        a5.append(a3);
        a5.append('.');
        if (a != null) {
            a5.append(a);
            a5.append('.');
        }
        a5.append(b);
        return a5.toString();
    }

    private static class SidecarDirectoryFileWrapper
    implements FileWrapper {
        private final File D;

        public SidecarDirectoryFileWrapper(ReaderSDK a, String a2) {
            SidecarDirectoryFileWrapper a3;
            String a4 = AcxSidecarAccess.getACXSidecarDirectory(a, a2);
            a3.D = a4 == null ? null : new File(a4);
        }

        public SidecarDirectoryFileWrapper(String a) {
            SidecarDirectoryFileWrapper a2;
            String a3 = AcxSidecarAccess.getSidecarDirNameForBookPath(a);
            a2.D = a3 == null ? null : new File(a3);
        }

        public boolean fileExists(String a) {
            SidecarDirectoryFileWrapper a2;
            if (a2.D != null && a2.D.isDirectory()) {
                return new File(a2.D, a).isFile();
            }
            return false;
        }
    }

    public static interface FileWrapper {
        public boolean fileExists(String var1);
    }
}

