/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.apps.util;

import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.identity.KindleIdentity;

public class NetworkUtils {
    public NetworkUtils() {
        NetworkUtils a;
    }

    public static boolean hasWan(Booklet a) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return false;
        }
        BookletContext a2 = a.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return false;
        }
        return ((KindleIdentity)a2.getService(KindleIdentity.class)).hasHardwareFeature("wan");
    }

    public static boolean hasWifi(Booklet a) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return false;
        }
        BookletContext a2 = a.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return false;
        }
        return ((KindleIdentity)a2.getService(KindleIdentity.class)).hasHardwareFeature("wifi");
    }

    public static boolean isWifiOnly(Booklet a) {
        return NetworkUtils.hasWifi(a) && !NetworkUtils.hasWan(a);
    }

    public static boolean isWifiWan(Booklet a) {
        return NetworkUtils.hasWifi(a) && NetworkUtils.hasWan(a);
    }

    public static boolean hasWireless(Booklet a) {
        return NetworkUtils.hasWifi(a) || NetworkUtils.hasWan(a);
    }
}

