/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.apps.util;

import com.amazon.kindle.apps.util.MetadataUtils;
import com.amazon.kindle.content.catalog.CatalogEntry;
import com.amazon.kindle.content.catalog.CatalogEntryCollection;
import com.amazon.kindle.restricted.runtime.Const;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconUtils {
    public static final int K = 4;
    public static final int B = 4;
    private static final String D = "apps";

    public IconUtils() {
        IconUtils a;
    }

    public static Icon getDefaultIcon(CatalogEntry a) {
        if (a == null) {
            throw new IllegalArgumentException("null entry");
        }
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.apps.util.resources.UtilResources");
        if (a instanceof CatalogEntryCollection) {
            return (Icon)a2.getObject("collection.icon");
        }
        if (MetadataUtils.isReceipt(a)) {
            return (Icon)a2.getObject("receipt.icon");
        }
        if (MetadataUtils.isNotice(a)) {
            return (Icon)a2.getObject("notice.icon");
        }
        if (MetadataUtils.isBook(a) || MetadataUtils.isBookSample(a)) {
            return (Icon)a2.getObject("book.icon");
        }
        if (MetadataUtils.isLetter(a)) {
            return (Icon)a2.getObject("letter.icon");
        }
        if (MetadataUtils.isBlog(a)) {
            return (Icon)a2.getObject("blog.icon");
        }
        if (MetadataUtils.isNewspaper(a)) {
            return (Icon)a2.getObject("newspaper.icon");
        }
        if (MetadataUtils.isMagazine(a)) {
            return (Icon)a2.getObject("magazine.icon");
        }
        if (MetadataUtils.isMP3(a)) {
            return (Icon)a2.getObject("mp3.icon");
        }
        if (MetadataUtils.isAudible(a) || MetadataUtils.isAudibleSample(a)) {
            return (Icon)a2.getObject("audible.icon");
        }
        if (MetadataUtils.isPDF(a)) {
            return (Icon)a2.getObject("pdf.icon");
        }
        if (MetadataUtils.isMyClippings(a)) {
            return (Icon)a2.getObject("myclippings.icon");
        }
        if (MetadataUtils.isPDoc(a)) {
            return (Icon)a2.getObject("pdoc.icon");
        }
        if (MetadataUtils.isArchivedItems(a)) {
            return (Icon)a2.getObject("archiveditems.icon");
        }
        if (MetadataUtils.isPBI(a)) {
            return (Icon)a2.getObject("pbi.icon");
        }
        if (MetadataUtils.isOOBE(a)) {
            return (Icon)a2.getObject("oobe.icon");
        }
        if (MetadataUtils.isApp(a)) {
            return (Icon)a2.getObject("app.icon");
        }
        if (MetadataUtils.isReceipt(a)) {
            return (Icon)a2.getObject("receipt.icon");
        }
        return (Icon)a2.getObject("default.icon");
    }

    public static ImageIcon getIconFromImgAppsDirectory(String a) {
        File a2 = new File(Const.getImageUIDirectory());
        return new ImageIcon(a2.getParent() + File.separator + D + File.separator + a);
    }
}

