/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.apps.util;

import com.amazon.agui.swing.ConfirmationDialog;
import com.amazon.ebook.pl.SystemServices;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.ebook.util.net.HTTPUtil;
import com.amazon.ebook.util.text.StringUtil;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.net.BrowserLoginRequiredException;
import com.amazon.kindle.net.CommunicationException;
import com.amazon.kindle.net.ErrorMessageData;
import com.amazon.kindle.net.NoConnectionException;
import com.amazon.kindle.net.RequiredHardwareUnavailableException;
import com.amazon.kindle.net.ServerException;
import com.amazon.kindle.net.Wireless;
import com.amazon.kindle.net.WirelessSwitchOffException;
import com.amazon.kindle.restricted.net.KindleAuthenticatedConnectionService;
import com.amazon.kindle.webservices.registration.AmazonAccount;
import com.amazon.kindle.webservices.registration.AmazonRegistrationService;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;

public class CommunicationUtils {
    public static final Log h = Log.getInstance((String)"CommunicationUtils");
    private static final LogMessage A = new LogMessage("AmazonRegistrationServiceFailed", new String[]{"purpose"});
    private static final LogMessage H = new LogMessage("CommunicationExceptionDialogTrace", new String[]{"title", "message"});

    public CommunicationUtils() {
        CommunicationUtils a;
    }

    public static String getDeviceName(Booklet a) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return CommunicationUtils.getDefaultName();
        }
        BookletContext a2 = a.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return CommunicationUtils.getDefaultName();
        }
        if (!((AmazonRegistrationService)a2.getService(AmazonRegistrationService.class)).isRegistered()) {
            return CommunicationUtils.getDefaultName();
        }
        String a3 = CommunicationUtils.getUserDeviceName(a);
        if (StringUtil.isEmpty((String)a3)) {
            a3 = CommunicationUtils.getGivenName(a);
        }
        if (StringUtil.isEmpty((String)a3)) {
            a3 = CommunicationUtils.getUser(a);
        }
        if (StringUtil.isEmpty((String)a3)) {
            return CommunicationUtils.getDefaultName();
        }
        return a3;
    }

    public static boolean isRegistered(Booklet a) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return false;
        }
        BookletContext a2 = a.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return false;
        }
        try {
            AmazonRegistrationService a3 = (AmazonRegistrationService)a2.getService(AmazonRegistrationService.class);
            return a3.isRegistered();
        }
        catch (Exception a4) {
            h.error(A, new String[]{"isRegistered"}, "");
            return false;
        }
    }

    public static String getUser(Booklet a) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return null;
        }
        BookletContext a2 = a.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return null;
        }
        try {
            AmazonRegistrationService a3 = (AmazonRegistrationService)a2.getService(AmazonRegistrationService.class);
            AmazonAccount a4 = a3.getRegisteredAccount();
            return a4 != null ? a4.getUserName() : null;
        }
        catch (Exception a5) {
            h.error(A, new String[]{"getRegisteredAccount"}, "");
            return null;
        }
    }

    public static String getUserDeviceName(Booklet a) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return null;
        }
        BookletContext a2 = a.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return null;
        }
        try {
            AmazonRegistrationService a3 = (AmazonRegistrationService)a2.getService(AmazonRegistrationService.class);
            AmazonAccount a4 = a3.getRegisteredAccount();
            return a4 != null ? a4.getDeviceName() : null;
        }
        catch (Exception a5) {
            h.error(A, new String[]{"getRegisteredAccount"}, "");
            return null;
        }
    }

    public static String getGivenName(Booklet a) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return null;
        }
        BookletContext a2 = a.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return null;
        }
        try {
            AmazonRegistrationService a3 = (AmazonRegistrationService)a2.getService(AmazonRegistrationService.class);
            AmazonAccount a4 = a3.getRegisteredAccount();
            return a4 != null ? a4.getGivenName() : null;
        }
        catch (Exception a5) {
            h.error(A, new String[]{"getRegisteredAccount"}, "");
            return null;
        }
    }

    public static String getEmail(Booklet a) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return null;
        }
        BookletContext a2 = a.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return null;
        }
        try {
            AmazonRegistrationService a3 = (AmazonRegistrationService)a2.getService(AmazonRegistrationService.class);
            AmazonAccount a4 = a3.getRegisteredAccount();
            return a4 != null ? a4.getDeviceEmailAddress() : null;
        }
        catch (Exception a5) {
            h.error(A, new String[]{"getRegisteredAccount"}, "");
            return null;
        }
    }

    public static void setUserDeviceName(Booklet a, String a2) throws ServerException, IOException, NullPointerException {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a3 = a.getBookletContext();
        if (a3 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        ((AmazonRegistrationService)a3.getService(AmazonRegistrationService.class)).setDeviceName(a2);
    }

    public static boolean ensureConnection(Booklet a, boolean a2) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return false;
        }
        BookletContext a3 = a.getBookletContext();
        if (a3 == null) {
            LogUtils.logBookletContextIsNull();
            return false;
        }
        try {
            Wireless a4 = (Wireless)a3.getService(Wireless.class);
            a4.ensureConnection(false, a2 ? 1 : 0);
        }
        catch (BrowserLoginRequiredException a5) {
            return false;
        }
        catch (WirelessSwitchOffException a6) {
            return false;
        }
        catch (NoConnectionException a7) {
            if (a7.getReason() == 0) {
                h.error(Log.CATCHALL_EX, null, a7.getMessage(), (Throwable)a7);
            }
            return false;
        }
        catch (RequiredHardwareUnavailableException a8) {
            return false;
        }
        catch (IllegalStateException a9) {
            return false;
        }
        catch (CommunicationException a10) {
            return false;
        }
        return true;
    }

    public static boolean ensureConnection(Booklet a) {
        return CommunicationUtils.ensureConnection(a, true);
    }

    public static String doAuthenticatedConnection(String a, HashMap a2, Booklet a3) throws CommunicationException {
        String a4;
        if (a3 == null) {
            LogUtils.logBookletIsNull();
            return null;
        }
        BookletContext a5 = a3.getBookletContext();
        if (a5 == null) {
            LogUtils.logBookletContextIsNull();
            return null;
        }
        URL a6 = ((SystemServices)a5.getService(SystemServices.class)).getURLBuilder().getUrl(a, (Map)a2);
        KindleAuthenticatedConnectionService a7 = (KindleAuthenticatedConnectionService)a5.getService(KindleAuthenticatedConnectionService.class);
        if (a7 == null) {
            throw new CommunicationException("Unable to authenticate with server, no authentication service");
        }
        try {
            URLConnection a8 = a7.openConnection(a6);
            int a9 = ((HttpURLConnection)a8).getResponseCode();
            if (a9 != 200) {
                throw new ServerException("HTTP connection attempt failed, response code", a9);
            }
            a4 = HTTPUtil.getResponseString((InputStream)a8.getInputStream());
        }
        catch (IOException a10) {
            throw new CommunicationException("Unable to connect to server", (Throwable)a10);
        }
        return a4;
    }

    public static boolean preprocessCommunicationException(CommunicationException a, Booklet a2) {
        return CommunicationUtils.preprocessCommunicationException(a.getErrorMessageData(), a2);
    }

    public static boolean preprocessCommunicationException(final ErrorMessageData a, final Booklet a2) {
        if (a == null) {
            if (Log.isDebugOn()) {
                h.debug("There's no error message data associated with this communication exception");
            }
            return false;
        }
        h.warning(H, new String[]{a.getTitle(), a.getTitle()}, "CommunicationException about to popup a dialog", (Throwable)new Exception());
        String a3 = ResourceBundle.getBundle("com.amazon.kindle.apps.util.resources.UtilResources").getString("communicationexception.button.label");
        final String[] a4 = new String[]{a3};
        try {
            Runnable a5 = new Runnable(){
                {
                    1 a3;
                }

                public void run() {
                    1 a3;
                    if (a3.a2 == null) {
                        LogUtils.logBookletIsNull();
                        return;
                    }
                    BookletContext a22 = a3.a2.getBookletContext();
                    if (a22 == null) {
                        LogUtils.logBookletContextIsNull();
                        return;
                    }
                    ConfirmationDialog.showDialog((String)a22.getName(), (String)a3.a.getMessage(), (String)a3.a.getTitle(), (String[])a3.a4);
                }
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(a5);
            } else {
                a5.run();
            }
        }
        catch (Exception a6) {
            h.error(Log.CATCHALL_EX, null, "", (Throwable)a6);
        }
        return true;
    }

    public static boolean isConnected(Booklet a) {
        return CommunicationUtils.isConnected(a, true, true);
    }

    public static boolean isConnected(Booklet a, boolean a2, boolean a3) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return false;
        }
        BookletContext a4 = a.getBookletContext();
        if (a4 == null) {
            LogUtils.logBookletContextIsNull();
            return false;
        }
        Wireless a5 = (Wireless)a4.getService(Wireless.class);
        if (a5.isWirelessSwitchOn()) {
            int a6 = a5.getConnection();
            return a2 && a6 == 2 || a3 && a6 == 1 || !a2 && !a3;
        }
        return false;
    }

    private static String getDefaultName() {
        return ResourceBundle.getBundle("com.amazon.kindle.apps.util.resources.UtilResources").getString("device.default.name");
    }
}

