/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing.plaf.kindle;

import com.amazon.agui.swing.KindleColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.util.ResourceBundle;
import javax.swing.border.AbstractBorder;

public class RoundBorderWithCaret
extends AbstractBorder {
    private static final String RESOURCES = "com.amazon.agui.swing.resources.ComponentResources";
    public static final Color TOP_COLOR = Color.white;
    public static final Color BOTTOM_COLOR = KindleColor.darkGray;
    public static final int CARET_POSITION_NON = 0;
    public static final int CARET_POSITION_TOP = 1;
    public static final int CARET_POSITION_BOTTOM = 2;
    public static final int CARET_HORIZONTAL_OFFSET_CENTER = -1;
    public static final int CARET_HORIZONTAL_OFFSET_RIGHT = -2;
    public static final int CARET_HORIZONTAL_OFFSET_LEFT = -3;
    private static final int DEFAULT_THICKNESS = 2;
    private Insets insets = new Insets(2, 2, 2, 2);
    private int thickness;
    private int radiusX;
    private int radiusY;
    private Color topColor;
    private Color bottomColor;
    private int caretHeight;
    private int caretHorizontalOffset;
    private int caretPosition;
    private int currCaretHorizontalPosition = 50;

    public RoundBorderWithCaret(int a, int a2, int a3, Color a4, Color a5, int a6, int a7) {
        RoundBorderWithCaret a8;
        if (a < 0 || a2 < 0) {
            throw new IllegalArgumentException("radius");
        }
        if (a3 < 1) {
            throw new IllegalArgumentException("thickness");
        }
        if (a4 == null || a5 == null) {
            throw new NullPointerException("color");
        }
        a8.radiusX = a;
        a8.radiusY = a2;
        a8.topColor = a4;
        a8.bottomColor = a5;
        a8.thickness = a3;
        a8.setTrianglePosition(a6);
        a8.setCaretHorizontalPosition(a7);
    }

    public int getRadiusX() {
        RoundBorderWithCaret a;
        return a.radiusX;
    }

    public int getRadiusY() {
        RoundBorderWithCaret a;
        return a.radiusY;
    }

    public Color getTopColor() {
        RoundBorderWithCaret a;
        return a.topColor;
    }

    public Color getBottomColor() {
        RoundBorderWithCaret a;
        return a.bottomColor;
    }

    public Insets getBorderInsets(Component a) {
        RoundBorderWithCaret a2;
        return a2.insets;
    }

    public Insets getBorderInsets(Component a, Insets a2) {
        RoundBorderWithCaret a3;
        a2.top = a3.insets.top;
        a2.left = a3.insets.left;
        a2.bottom = a3.insets.bottom;
        a2.right = a3.insets.right;
        return a2;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component a, Graphics a2, int a3, int a4, int a5, int a6) {
        RoundBorderWithCaret a7;
        a7.draw(a2, a3, a4, --a5, --a6, a7.topColor, a7.bottomColor);
    }

    protected void draw(Graphics a, int a2, int a3, int a4, int a5, Color a6, Color a7) {
        RoundBorderWithCaret a8;
        int a9 = a4 >> 1 > a8.radiusX ? a8.radiusX : a4 >> 1;
        int a10 = a5 >> 1 > a8.radiusY ? a8.radiusY : a5 >> 1;
        int a11 = a3 + a5 - a10;
        int a12 = a3 + a10;
        int a13 = a3;
        int a14 = a2 + a9;
        int a15 = a2 + a4 - a9;
        int a16 = a2 + a4;
        int a17 = a3 + a5;
        int a18 = a9 << 1;
        int a19 = a10 << 1;
        if (a8.caretHeight > 0) {
            if (a8.caretPosition == 1) {
                a12 = a12 + a8.caretHeight - 3;
                a13 += a8.caretHeight;
            } else {
                a11 = a11 - a8.caretHeight + 3;
                a17 -= a8.caretHeight;
            }
        }
        BasicStroke a20 = new BasicStroke(a8.thickness);
        Stroke a21 = ((Graphics2D)a).getStroke();
        if (a8.thickness > 1) {
            ((Graphics2D)a).setStroke(a20);
        }
        GeneralPath a22 = new GeneralPath();
        a22.append(new Arc2D.Float(a2, a13, a18, a19, 180.0f, -90.0f, 0), false);
        a22.append(new Arc2D.Float(a16 - a18, a13, a18, a19, 90.0f, -90.0f, 0), true);
        a22.append(new Arc2D.Float(a16 - a18, a17 - a19, a18, a19, 0.0f, -90.0f, 0), true);
        a22.append(new Arc2D.Float(a2, a17 - a19, a18, a19, -90.0f, -90.0f, 0), true);
        a22.closePath();
        a.setColor(a6);
        ((Graphics2D)a).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)a).draw(a22);
        ((Graphics2D)a).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        ((Graphics2D)a).setStroke(a21);
        if (a8.caretHeight > 0) {
            a8.currCaretHorizontalPosition = a8.calcCaretHorizontalPosition(a4);
            int a23 = a2 + a8.currCaretHorizontalPosition;
            if (a8.caretPosition == 1) {
                Polygon a24 = new Polygon();
                a24.addPoint(a23, a13);
                a24.addPoint(a23 + a8.caretHeight, a3);
                a24.addPoint(a23 + a8.caretHeight * 2, a13);
                ((Graphics2D)a).fill(a24);
            } else {
                Polygon a25 = new Polygon();
                a25.addPoint(a23, a17);
                a25.addPoint(a23 + a8.caretHeight, a3 + a5);
                a25.addPoint(a23 + a8.caretHeight * 2, a17);
                ((Graphics2D)a).fill(a25);
            }
        }
    }

    public int getCaretHeight() {
        RoundBorderWithCaret a;
        return a.caretHeight;
    }

    public int getcaretPosition() {
        RoundBorderWithCaret a;
        return a.caretPosition;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTrianglePosition(int a) {
        if (a != 0 && a != 1 && a != 2) {
            throw new IllegalArgumentException("caretPosition");
        }
        a3.caretPosition = a;
        if (a == 0) {
            a3.caretHeight = 0;
        } else {
            ResourceBundle a2 = ResourceBundle.getBundle(RESOURCES);
            a3.caretHeight = (Integer)a2.getObject("roundborder.caret.height");
        }
        switch (a) {
            case 1: {
                RoundBorderWithCaret a3;
                a3.insets = new Insets(a3.caretHeight + a3.thickness - 1, a3.thickness, a3.thickness, a3.thickness);
                return;
            }
            case 2: {
                RoundBorderWithCaret a3;
                a3.insets = new Insets(a3.thickness, a3.thickness, a3.caretHeight + a3.thickness - 1, a3.thickness);
                return;
            }
            case 0: {
                RoundBorderWithCaret a3;
                a3.insets = new Insets(a3.thickness, a3.thickness, a3.thickness, a3.thickness);
                return;
            }
        }
    }

    public int getCurrCaretHorizontalPosition() {
        RoundBorderWithCaret a;
        return a.currCaretHorizontalPosition;
    }

    public void setCaretHorizontalPosition(int a) {
        a.caretHorizontalOffset = a < -3 ? -3 : a;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int calcCaretHorizontalPosition(int a) {
        RoundBorderWithCaret a2;
        int a3 = a - a2.radiusX - a2.caretHeight - 1 - 2;
        switch (a2.caretHorizontalOffset) {
            case -1: {
                return a / 2 - a2.caretHeight;
            }
            case -3: {
                return a2.radiusX;
            }
            case -2: {
                return a3;
            }
        }
        if (a2.caretHorizontalOffset < a2.radiusX) {
            return a2.radiusX;
        }
        if (a2.caretHorizontalOffset > a3) {
            return a3;
        }
        return a2.caretHorizontalOffset;
    }
}

