/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing.plaf.kindle;

import com.amazon.agui.swing.plaf.kindle.KindleTheme;
import com.amazon.ebook.util.log.Log;
import com.sun.java.swing.SwingUtilities2;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ActionMapUIResource;
import com.sun.java.swing.plaf.ComponentInputMapUIResource;
import com.sun.java.swing.plaf.InputMapUIResource;
import com.sun.java.swing.plaf.TextUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.text.DefaultCaret;
import com.sun.java.swing.text.DefaultEditorKit;
import com.sun.java.swing.text.DefaultHighlighter;
import com.sun.java.swing.text.TextAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class KindleTextUI
extends ComponentUI
implements TextUI,
ViewFactory {
    public static final String SELECT_ALL_TEXT_ON_FOCUS_GAINED = "selectAllTextOnFocusGained";
    private static final EditorKit defaultKit = new DefaultEditorKit();
    private static final Position.Bias[] discardBias = new Position.Bias[1];
    private static final Log LOG = Log.getInstance((String)"KindleTextUI");
    transient JTextComponent editor;
    transient boolean painted;
    transient RootView rootView;
    transient UpdateHandler updateHandler;
    private transient TextUIFocusListener focusListener;

    public KindleTextUI() {
        KindleTextUI a;
        a.rootView = a.new RootView();
        a.updateHandler = a.new UpdateHandler();
        a.painted = false;
    }

    protected Caret createCaret() {
        return new KindleCaret();
    }

    protected Highlighter createHighlighter() {
        return new KindleHighlighter();
    }

    protected String getKeymapName() {
        KindleTextUI a;
        String a2 = a.getClass().getName();
        int a3 = a2.lastIndexOf(46);
        if (a3 >= 0) {
            a2 = a2.substring(a3 + 1, a2.length());
        }
        return a2;
    }

    protected Keymap createKeymap() {
        KindleTextUI a;
        String a2 = a.getKeymapName();
        Keymap a3 = JTextComponent.getKeymap(a2);
        if (a3 == null) {
            Keymap a4 = JTextComponent.getKeymap("default");
            a3 = JTextComponent.addKeymap(a2, a4);
            String a5 = a.getPropertyPrefix();
            Object a6 = UIManager.get((Object)(a5 + ".keyBindings"));
            if (a6 != null && a6 instanceof JTextComponent.KeyBinding[]) {
                JTextComponent.KeyBinding[] a7 = (JTextComponent.KeyBinding[])a6;
                JTextComponent.loadKeymap(a3, a7, a.getComponent().getActions());
            }
        }
        return a3;
    }

    protected void propertyChange(PropertyChangeEvent a) {
    }

    protected abstract String getPropertyPrefix();

    protected void installDefaults() {
        Object a;
        Caret a2;
        Insets a3;
        Border a4;
        Color a5;
        Color a6;
        Color a7;
        Color a8;
        Color a9;
        Color a10;
        KindleTextUI a11;
        String a12 = a11.getPropertyPrefix();
        Font a13 = a11.editor.getFont();
        if (a13 == null || a13 instanceof UIResource) {
            a11.editor.setFont(UIManager.getFont((Object)(a12 + ".font")));
        }
        if ((a10 = a11.editor.getBackground()) == null || a10 instanceof UIResource) {
            a11.editor.setBackground(UIManager.getColor((Object)(a12 + ".background")));
        }
        if ((a9 = a11.editor.getForeground()) == null || a9 instanceof UIResource) {
            a11.editor.setForeground(UIManager.getColor((Object)(a12 + ".foreground")));
        }
        if ((a8 = a11.editor.getCaretColor()) == null || a8 instanceof UIResource) {
            a11.editor.setCaretColor(UIManager.getColor((Object)(a12 + ".caretForeground")));
        }
        if ((a7 = a11.editor.getSelectionColor()) == null || a7 instanceof UIResource) {
            a11.editor.setSelectionColor(UIManager.getColor((Object)(a12 + ".selectionBackground")));
        }
        if ((a6 = a11.editor.getSelectedTextColor()) == null || a6 instanceof UIResource) {
            a11.editor.setSelectedTextColor(UIManager.getColor((Object)(a12 + ".selectionForeground")));
        }
        if ((a5 = a11.editor.getDisabledTextColor()) == null || a5 instanceof UIResource) {
            a11.editor.setDisabledTextColor(UIManager.getColor((Object)(a12 + ".inactiveForeground")));
        }
        if ((a4 = a11.editor.getBorder()) == null || a4 instanceof UIResource) {
            a11.editor.setBorder(UIManager.getBorder((Object)(a12 + ".border")));
        }
        if ((a3 = a11.editor.getMargin()) == null || a3 instanceof UIResource) {
            a11.editor.setMargin(UIManager.getInsets((Object)(a12 + ".margin")));
        }
        if ((a2 = a11.editor.getCaret()) == null || a2 instanceof UIResource) {
            a2 = a11.createCaret();
            a11.editor.setCaret(a2);
            a = UIManager.get((Object)(a12 + ".caretBlinkRate"));
            if (a != null && a instanceof Integer) {
                Integer a14 = (Integer)a;
                a2.setBlinkRate(a14);
            }
        }
        if ((a = a11.editor.getHighlighter()) == null || a instanceof UIResource) {
            a11.editor.setHighlighter(a11.createHighlighter());
        }
        a11.editor.setFocusTraversalKeys(0, (Set)UIManager.get((Object)"Text.forwardTraversalKeys"));
        a11.editor.setFocusTraversalKeys(1, (Set)UIManager.get((Object)"Text.backwardTraversalKeys"));
        a11.editor.setFocusTraversalKeys(2, (Set)UIManager.get((Object)"Text.upCycleTraversalKeys"));
        a11.editor.setFocusTraversalKeys(3, (Set)UIManager.get((Object)"Text.downCycleTraversalKeys"));
    }

    protected void uninstallDefaults() {
        KindleTextUI a;
        if (a.editor.getCaretColor() instanceof UIResource) {
            a.editor.setCaretColor(null);
        }
        if (a.editor.getSelectionColor() instanceof UIResource) {
            a.editor.setSelectionColor(null);
        }
        if (a.editor.getDisabledTextColor() instanceof UIResource) {
            a.editor.setDisabledTextColor(null);
        }
        if (a.editor.getSelectedTextColor() instanceof UIResource) {
            a.editor.setSelectedTextColor(null);
        }
        if (a.editor.getBorder() instanceof UIResource) {
            a.editor.setBorder(null);
        }
        if (a.editor.getMargin() instanceof UIResource) {
            a.editor.setMargin(null);
        }
        if (a.editor.getCaret() instanceof UIResource) {
            a.editor.setCaret(null);
        }
        if (a.editor.getHighlighter() instanceof UIResource) {
            a.editor.setHighlighter(null);
        }
    }

    protected void installListeners() {
        KindleTextUI a;
        a.focusListener = a.new TextUIFocusListener();
        a.editor.addFocusListener(a.focusListener);
    }

    protected void uninstallListeners() {
        KindleTextUI a;
        a.editor.removeFocusListener(a.focusListener);
    }

    protected void installKeyboardActions() {
        ActionMap a;
        KindleTextUI a2;
        a2.editor.setKeymap(a2.createKeymap());
        InputMap a3 = a2.getInputMap();
        if (a3 != null) {
            SwingUtilities2.replaceUIInputMap((JComponent)a2.editor, (int)0, (InputMap)a3);
        }
        if ((a = a2.getActionMap()) != null) {
            SwingUtilities2.replaceUIActionMap((JComponent)a2.editor, (ActionMap)a);
        }
        a2.updateFocusAcceleratorBinding(false);
    }

    InputMap getInputMap() {
        KindleTextUI a;
        InputMapUIResource a2 = new InputMapUIResource();
        InputMap a3 = (InputMap)UIManager.get((Object)(a.getPropertyPrefix() + ".focusInputMap"));
        if (a3 != null) {
            a2.setParent(a3);
        }
        return a2;
    }

    void updateFocusAcceleratorBinding(boolean a) {
        KindleTextUI a2;
        char a3 = a2.editor.getFocusAccelerator();
        if (a || a3 != '\u0000') {
            InputMap a4 = SwingUtilities2.getUIInputMap((JComponent)a2.editor, (int)2);
            if (a4 == null && a3 != '\u0000') {
                a4 = new ComponentInputMapUIResource((JComponent)a2.editor);
                SwingUtilities2.replaceUIInputMap((JComponent)a2.editor, (int)2, (InputMap)a4);
                ActionMap a5 = a2.getActionMap();
                SwingUtilities2.replaceUIActionMap((JComponent)a2.editor, (ActionMap)a5);
            }
            if (a4 != null) {
                a4.clear();
                if (a3 != '\u0000') {
                    a4.put(KeyStroke.getKeyStroke((int)a3, 8), "requestFocus");
                }
            }
        }
    }

    void updateFocusTraversalKeys() {
        KindleTextUI a;
        EditorKit a2 = a.getEditorKit(a.editor);
        if (a2 != null && a2 instanceof DefaultEditorKit) {
            if (a.editor.isEditable()) {
                a.editor.setFocusTraversalKeys(0, (Set)UIManager.get((Object)"Text.forwardTraversalKeys"));
                a.editor.setFocusTraversalKeys(1, (Set)UIManager.get((Object)"Text.backwardTraversalKeys"));
            } else {
                a.editor.setFocusTraversalKeys(0, (Set)UIManager.get((Object)"Text.forwardTraversalKeysNoEdit"));
                a.editor.setFocusTraversalKeys(1, (Set)UIManager.get((Object)"Text.backwardTraversalKeysNoEdit"));
            }
        }
    }

    ActionMap getActionMap() {
        Action a;
        KindleTextUI a2;
        String a3 = a2.getPropertyPrefix() + ".actionMap";
        ActionMap a4 = (ActionMap)UIManager.get((Object)a3);
        if (a4 == null && (a4 = a2.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put((Object)a3, (Object)a4);
        }
        ActionMapUIResource a5 = new ActionMapUIResource();
        a5.put("requestFocus", a2.new FocusAction());
        if (a2.getEditorKit(a2.editor) instanceof DefaultEditorKit && a4 != null && (a = a4.get("insert-break")) != null && a instanceof DefaultEditorKit.InsertBreakAction) {
            TextActionWrapper a6 = a2.new TextActionWrapper((TextAction)a);
            a5.put(a6.getValue("Name"), (Action)((Object)a6));
        }
        if (a4 != null) {
            a5.setParent(a4);
        }
        return a5;
    }

    ActionMap createActionMap() {
        int a;
        KindleTextUI a2;
        ActionMapUIResource a3 = new ActionMapUIResource();
        Action[] a4 = a2.editor.getActions();
        int a5 = a4.length;
        int n = a = 0;
        while (n < a5) {
            Action a6 = a4[a];
            a3.put(a6.getValue("Name"), a6);
            n = ++a;
        }
        return a3;
    }

    protected void uninstallKeyboardActions() {
        KindleTextUI a;
        a.editor.setKeymap(null);
        SwingUtilities2.replaceUIInputMap((JComponent)a.editor, (int)2, null);
        SwingUtilities2.replaceUIActionMap((JComponent)a.editor, null);
    }

    protected void paintBackground(Graphics a) {
        KindleTextUI a2;
        a.setColor(a2.editor.getBackground());
        a.fillRect(0, 0, a2.editor.getWidth(), a2.editor.getHeight());
    }

    protected final JTextComponent getComponent() {
        KindleTextUI a;
        return a.editor;
    }

    protected void modelChanged() {
        KindleTextUI a;
        ViewFactory a2 = a.rootView.getViewFactory();
        Element a3 = a.editor.getDocument().getDefaultRootElement();
        a.setView(a2.create(a3));
    }

    protected final void setView(View a) {
        KindleTextUI a2;
        a2.editor.removeAll();
        a2.rootView.setView(a);
        a2.painted = false;
        a2.editor.revalidate();
        a2.editor.repaint();
    }

    protected void paintSafely(Graphics a) {
        KindleTextUI a2;
        a2.painted = true;
        Highlighter a3 = a2.editor.getHighlighter();
        Caret a4 = a2.editor.getCaret();
        if (a2.editor.isOpaque()) {
            a2.paintBackground(a);
        }
        if (a3 != null) {
            a3.paint(a);
        }
        Rectangle a5 = a2.getVisibleEditorRect();
        a2.rootView.paint(a, a5);
        if (a4 != null) {
            a4.paint(a);
        }
    }

    public void installUI(JComponent a) {
        if (a instanceof JTextComponent) {
            KindleTextUI a2;
            a2.editor = (JTextComponent)a;
            a2.installDefaults();
            a2.editor.setOpaque(true);
            a2.editor.setAutoscrolls(true);
            a2.editor.addPropertyChangeListener(a2.updateHandler);
            Document a3 = a2.editor.getDocument();
            if (a3 == null) {
                a2.editor.setDocument(a2.getEditorKit(a2.editor).createDefaultDocument());
            } else {
                a3.addDocumentListener(a2.updateHandler);
                a2.modelChanged();
            }
            a2.installListeners();
            a2.installKeyboardActions();
            LayoutManager a4 = a2.editor.getLayout();
            if (a4 == null || a4 instanceof UIResource) {
                a2.editor.setLayout(a2.updateHandler);
            }
        } else {
            throw new Error("TextUI needs JTextComponent");
        }
    }

    public void uninstallUI(JComponent a) {
        KindleTextUI a2;
        a2.editor.removePropertyChangeListener(a2.updateHandler);
        a2.editor.getDocument().removeDocumentListener(a2.updateHandler);
        a2.painted = false;
        a2.uninstallDefaults();
        a2.rootView.setView(null);
        a.removeAll();
        if (a.getLayout() instanceof UIResource) {
            a.setLayout(null);
        }
        a2.uninstallKeyboardActions();
        a2.uninstallListeners();
    }

    public void update(Graphics a, JComponent a2) {
        KindleTextUI a3;
        a3.paint(a, a2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics a, JComponent a2) {
        KindleTextUI a3;
        if (a3.rootView.getViewCount() > 0 && a3.rootView.getView(0) != null) {
            Document a4 = a3.editor.getDocument();
            if (a4 instanceof AbstractDocument) {
                ((AbstractDocument)a4).readLock();
            }
            try {
                a3.paintSafely(a);
            }
            finally {
                if (a4 instanceof AbstractDocument) {
                    ((AbstractDocument)a4).readUnlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize(JComponent a) {
        KindleTextUI a2;
        Document a3 = a2.editor.getDocument();
        Insets a4 = a.getInsets();
        Dimension a5 = a.getSize();
        if (a3 instanceof AbstractDocument) {
            ((AbstractDocument)a3).readLock();
        }
        try {
            if (a5.width > a4.left + a4.right && a5.height > a4.top + a4.bottom) {
                a2.rootView.setSize(a5.width - a4.left - a4.right, a5.height - a4.top - a4.bottom);
            } else if (a5.width == 0 && a5.height == 0) {
                a2.rootView.setSize(2.1474836E9f, 2.1474836E9f);
            }
            a5.width = (int)Math.min((long)a2.rootView.getPreferredSpan(0) + (long)a4.left + (long)a4.right, Integer.MAX_VALUE);
            a5.height = (int)Math.min((long)a2.rootView.getPreferredSpan(1) + (long)a4.top + (long)a4.bottom, Integer.MAX_VALUE);
        }
        finally {
            if (a3 instanceof AbstractDocument) {
                ((AbstractDocument)a3).readUnlock();
            }
        }
        return a5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMinimumSize(JComponent a) {
        KindleTextUI a2;
        Document a3 = a2.editor.getDocument();
        Insets a4 = a.getInsets();
        Dimension a5 = new Dimension();
        if (a3 instanceof AbstractDocument) {
            ((AbstractDocument)a3).readLock();
        }
        try {
            a5.width = (int)a2.rootView.getMinimumSpan(0) + a4.left + a4.right;
            a5.height = (int)a2.rootView.getMinimumSpan(1) + a4.top + a4.bottom;
        }
        finally {
            if (a3 instanceof AbstractDocument) {
                ((AbstractDocument)a3).readUnlock();
            }
        }
        return a5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMaximumSize(JComponent a) {
        KindleTextUI a2;
        Document a3 = a2.editor.getDocument();
        Insets a4 = a.getInsets();
        Dimension a5 = new Dimension();
        if (a3 instanceof AbstractDocument) {
            ((AbstractDocument)a3).readLock();
        }
        try {
            a5.width = (int)Math.min((long)a2.rootView.getMaximumSpan(0) + (long)a4.left + (long)a4.right, Integer.MAX_VALUE);
            a5.height = (int)Math.min((long)a2.rootView.getMaximumSpan(1) + (long)a4.top + (long)a4.bottom, Integer.MAX_VALUE);
        }
        finally {
            if (a3 instanceof AbstractDocument) {
                ((AbstractDocument)a3).readUnlock();
            }
        }
        return a5;
    }

    protected Rectangle getVisibleEditorRect() {
        KindleTextUI a;
        Rectangle a2 = a.editor.getBounds();
        if (a2.width > 0 && a2.height > 0) {
            a2.y = 0;
            a2.x = 0;
            Insets a3 = a.editor.getInsets();
            a2.x += a3.left;
            a2.y += a3.top;
            a2.width -= a3.left + a3.right;
            a2.height -= a3.top + a3.bottom;
            return a2;
        }
        return null;
    }

    public Rectangle modelToView(JTextComponent a, int a2) throws BadLocationException {
        KindleTextUI a3;
        return a3.modelToView(a, a2, Position.Bias.Forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle modelToView(JTextComponent a, int a2, Position.Bias a3) throws BadLocationException {
        KindleTextUI a4;
        Document a5 = a4.editor.getDocument();
        if (a5 instanceof AbstractDocument) {
            ((AbstractDocument)a5).readLock();
        }
        try {
            Rectangle a6 = a4.getVisibleEditorRect();
            if (a6 != null) {
                a4.rootView.setSize(a6.width, a6.height);
                Shape a7 = a4.rootView.modelToView(a2, a6, a3);
                Rectangle rectangle = a7 instanceof Rectangle ? (Rectangle)a7 : a7.getBounds();
                return rectangle;
            }
        }
        finally {
            if (a5 instanceof AbstractDocument) {
                ((AbstractDocument)a5).readUnlock();
            }
        }
        return null;
    }

    public int viewToModel(JTextComponent a, Point a2) {
        KindleTextUI a3;
        return a3.viewToModel(a, a2, discardBias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int viewToModel(JTextComponent a, Point a2, Position.Bias[] a3) {
        KindleTextUI a4;
        int a5 = -1;
        Document a6 = a4.editor.getDocument();
        if (a6 instanceof AbstractDocument) {
            ((AbstractDocument)a6).readLock();
        }
        try {
            Rectangle a7 = a4.getVisibleEditorRect();
            if (a7 != null) {
                a4.rootView.setSize(a7.width, a7.height);
                a5 = a4.rootView.viewToModel(a2.x, a2.y, a7, a3);
            }
        }
        finally {
            if (a6 instanceof AbstractDocument) {
                ((AbstractDocument)a6).readUnlock();
            }
        }
        return a5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextVisualPositionFrom(JTextComponent a, int a2, Position.Bias a3, int a4, Position.Bias[] a5) throws BadLocationException {
        KindleTextUI a6;
        Document a7 = a6.editor.getDocument();
        if (a7 instanceof AbstractDocument) {
            ((AbstractDocument)a7).readLock();
        }
        try {
            if (a6.painted) {
                Rectangle a8 = a6.getVisibleEditorRect();
                a6.rootView.setSize(a8.width, a8.height);
                int n = a6.rootView.getNextVisualPositionFrom(a2, a3, a8, a4, a5);
                return n;
            }
        }
        finally {
            if (a7 instanceof AbstractDocument) {
                ((AbstractDocument)a7).readUnlock();
            }
        }
        return -1;
    }

    public void damageRange(JTextComponent a, int a2, int a3) {
        KindleTextUI a4;
        a4.damageRange(a, a2, a3, Position.Bias.Forward, Position.Bias.Backward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void damageRange(JTextComponent a, int a2, int a3, Position.Bias a4, Position.Bias a5) {
        KindleTextUI a6;
        if (a6.painted) {
            Rectangle a7 = a6.getVisibleEditorRect();
            Document a8 = a.getDocument();
            if (a8 instanceof AbstractDocument) {
                ((AbstractDocument)a8).readLock();
            }
            try {
                a6.rootView.setSize(a7.width, a7.height);
                Shape a9 = a6.rootView.modelToView(a2, a4, a3, a5, a7);
                Rectangle a10 = a9 instanceof Rectangle ? (Rectangle)a9 : a9.getBounds();
                a6.editor.repaint(a10.x, a10.y, a10.width, a10.height);
            }
            catch (BadLocationException a11) {
            }
            finally {
                if (a8 instanceof AbstractDocument) {
                    ((AbstractDocument)a8).readUnlock();
                }
            }
        }
    }

    public EditorKit getEditorKit(JTextComponent a) {
        return defaultKit;
    }

    public View getRootView(JTextComponent a) {
        KindleTextUI a2;
        return a2.rootView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToolTipText(JTextComponent a, Point a2) {
        KindleTextUI a3;
        if (!a3.painted) {
            return null;
        }
        Document a4 = a3.editor.getDocument();
        String a5 = null;
        Rectangle a6 = a3.getVisibleEditorRect();
        if (a4 instanceof AbstractDocument) {
            ((AbstractDocument)a4).readLock();
        }
        try {
            a5 = a3.rootView.getToolTipText(a2.x, a2.y, a6);
        }
        finally {
            if (a4 instanceof AbstractDocument) {
                ((AbstractDocument)a4).readUnlock();
            }
        }
        return a5;
    }

    public View create(Element a) {
        return null;
    }

    public View create(Element a, int a2, int a3) {
        return null;
    }

    class FocusAction
    extends AbstractAction {
        FocusAction() {
            FocusAction a;
        }

        public void actionPerformed(ActionEvent a) {
            FocusAction a2;
            a2.KindleTextUI.this.editor.requestFocus();
        }

        public boolean isEnabled() {
            FocusAction a;
            return a.KindleTextUI.this.editor.isEditable();
        }
    }

    class TextActionWrapper
    extends TextAction {
        TextAction action;

        public TextActionWrapper(TextAction a) {
            TextActionWrapper a2;
            super((String)a.getValue("Name"));
            a2.action = null;
            a2.action = a;
        }

        public void actionPerformed(ActionEvent a) {
            TextActionWrapper a2;
            a2.action.actionPerformed(a);
        }

        public boolean isEnabled() {
            TextActionWrapper a;
            return a.KindleTextUI.this.editor == null || a.KindleTextUI.this.editor.isEditable() ? a.action.isEnabled() : false;
        }
    }

    class UpdateHandler
    implements PropertyChangeListener,
    DocumentListener,
    LayoutManager2,
    UIResource {
        private Hashtable constraints;
        private boolean i18nView = false;

        UpdateHandler() {
            UpdateHandler a;
        }

        public final void propertyChange(PropertyChangeEvent a) {
            UpdateHandler a2;
            Object a3 = a.getOldValue();
            Object a4 = a.getNewValue();
            String a5 = a.getPropertyName();
            if (a3 instanceof Document || a4 instanceof Document) {
                if (a3 != null) {
                    ((Document)a3).removeDocumentListener(a2);
                }
                if (a4 != null) {
                    ((Document)a4).addDocumentListener(a2);
                    if ("document".equals(a5)) {
                        a2.KindleTextUI.this.propertyChange(a);
                        a2.KindleTextUI.this.modelChanged();
                        return;
                    }
                }
                a2.KindleTextUI.this.modelChanged();
            }
            if ("focusAcceleratorKey".equals(a5)) {
                a2.KindleTextUI.this.updateFocusAcceleratorBinding(true);
            } else if ("componentOrientation".equals(a5)) {
                Document a6 = a2.KindleTextUI.this.editor.getDocument();
                if (a6 != null) {
                    Boolean a7 = SwingUtilities2.isLeftToRight((Component)a2.KindleTextUI.this.editor) ? TextAttribute.RUN_DIRECTION_LTR : TextAttribute.RUN_DIRECTION_RTL;
                    a6.putProperty(TextAttribute.RUN_DIRECTION, a7);
                }
                a2.KindleTextUI.this.modelChanged();
                a2.KindleTextUI.this.editor.invalidate();
            } else if ("font".equals(a5)) {
                a2.KindleTextUI.this.modelChanged();
            }
            a2.KindleTextUI.this.propertyChange(a);
        }

        public final void insertUpdate(DocumentEvent a) {
            UpdateHandler a2;
            Boolean a3;
            Object a4 = a.getDocument().getProperty("i18n");
            if (a4 instanceof Boolean && (a3 = (Boolean)a4) != a2.i18nView) {
                a2.i18nView = a3;
                a2.KindleTextUI.this.modelChanged();
                return;
            }
            a3 = a2.KindleTextUI.this.painted ? a2.KindleTextUI.this.getVisibleEditorRect() : null;
            a2.KindleTextUI.this.rootView.insertUpdate(a, (Shape)((Object)a3), a2.KindleTextUI.this.rootView.getViewFactory());
        }

        public final void removeUpdate(DocumentEvent a) {
            UpdateHandler a2;
            Rectangle a3 = a2.KindleTextUI.this.painted ? a2.KindleTextUI.this.getVisibleEditorRect() : null;
            a2.KindleTextUI.this.rootView.removeUpdate(a, a3, a2.KindleTextUI.this.rootView.getViewFactory());
        }

        public final void changedUpdate(DocumentEvent a) {
            UpdateHandler a2;
            Rectangle a3 = a2.KindleTextUI.this.painted ? a2.KindleTextUI.this.getVisibleEditorRect() : null;
            a2.KindleTextUI.this.rootView.changedUpdate(a, a3, a2.KindleTextUI.this.rootView.getViewFactory());
        }

        public void addLayoutComponent(String a, Component a2) {
        }

        public void removeLayoutComponent(Component a) {
            UpdateHandler a2;
            if (a2.constraints != null) {
                a2.constraints.remove(a);
            }
        }

        public Dimension preferredLayoutSize(Container a) {
            return null;
        }

        public Dimension minimumLayoutSize(Container a) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container a) {
            Rectangle a2;
            UpdateHandler a3;
            if (a3.constraints != null && !a3.constraints.isEmpty() && (a2 = a3.KindleTextUI.this.getVisibleEditorRect()) != null) {
                Document a4 = a3.KindleTextUI.this.editor.getDocument();
                if (a4 instanceof AbstractDocument) {
                    ((AbstractDocument)a4).readLock();
                }
                try {
                    a3.KindleTextUI.this.rootView.setSize(a2.width, a2.height);
                    Enumeration a5 = a3.constraints.keys();
                    while (a5.hasMoreElements()) {
                        Component a6 = (Component)a5.nextElement();
                        View a7 = (View)a3.constraints.get(a6);
                        Shape a8 = a3.calculateViewPosition(a2, a7);
                        if (a8 == null) continue;
                        Rectangle a9 = a8 instanceof Rectangle ? (Rectangle)a8 : a8.getBounds();
                        a6.setBounds(a9);
                    }
                }
                finally {
                    if (a4 instanceof AbstractDocument) {
                        ((AbstractDocument)a4).readUnlock();
                    }
                }
            }
        }

        Shape calculateViewPosition(Shape a, View a2) {
            UpdateHandler a3;
            View a4;
            int a5 = a2.getStartOffset();
            View a6 = null;
            View view = a4 = a3.KindleTextUI.this.rootView;
            while (view != null && a4 != a2) {
                int a7 = ((View)a4).getViewIndex(a5, Position.Bias.Forward);
                a = ((View)a4).getChildAllocation(a7, a);
                a6 = ((View)a4).getView(a7);
                view = a4 = a6;
            }
            return a6 != null ? a : null;
        }

        public void addLayoutComponent(Component a, Object a2) {
            if (a2 instanceof View) {
                UpdateHandler a3;
                if (a3.constraints == null) {
                    a3.constraints = new Hashtable(7);
                }
                a3.constraints.put(a, a2);
            }
        }

        public Dimension maximumLayoutSize(Container a) {
            return null;
        }

        public float getLayoutAlignmentX(Container a) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container a) {
            return 0.5f;
        }

        public void invalidateLayout(Container a) {
        }
    }

    class RootView
    extends View {
        private View view;

        RootView() {
            RootView a;
            super(null);
        }

        void setView(View a) {
            RootView a2;
            if (a2.view != null) {
                a2.view.setParent(null);
            }
            a2.view = a;
            if (a2.view != null) {
                a2.view.setParent(a2);
            }
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public float getPreferredSpan(int a) {
            RootView a2;
            if (a2.view != null) {
                return a2.view.getPreferredSpan(a);
            }
            return 10.0f;
        }

        public float getMinimumSpan(int a) {
            RootView a2;
            if (a2.view != null) {
                return a2.view.getMinimumSpan(a);
            }
            return 10.0f;
        }

        public float getMaximumSpan(int a) {
            return 2.1474836E9f;
        }

        public void preferenceChanged(View a, boolean a2, boolean a3) {
            RootView a4;
            a4.KindleTextUI.this.editor.revalidate();
        }

        public float getAlignment(int a) {
            RootView a2;
            if (a2.view != null) {
                return a2.view.getAlignment(a);
            }
            return 0.0f;
        }

        public void paint(Graphics a, Shape a2) {
            RootView a3;
            if (a3.view != null) {
                Rectangle a4 = a2 instanceof Rectangle ? (Rectangle)a2 : a2.getBounds();
                a3.setSize(a4.width, a4.height);
                a3.view.paint(a, a2);
            }
        }

        public void setParent(View a) {
            throw new Error("Can't set parent on root view");
        }

        public int getViewCount() {
            return 1;
        }

        public View getView(int a) {
            RootView a2;
            return a2.view;
        }

        public int getViewIndex(int a, Position.Bias a2) {
            return 0;
        }

        public Shape getChildAllocation(int a, Shape a2) {
            return a2;
        }

        public Shape modelToView(int a, Shape a2, Position.Bias a3) throws BadLocationException {
            RootView a4;
            if (a4.view != null) {
                return a4.view.modelToView(a, a2, a3);
            }
            return null;
        }

        public Shape modelToView(int a, Position.Bias a2, int a3, Position.Bias a4, Shape a5) throws BadLocationException {
            RootView a6;
            if (a6.view != null) {
                return a6.view.modelToView(a, a2, a3, a4, a5);
            }
            return null;
        }

        public int viewToModel(float a, float a2, Shape a3, Position.Bias[] a4) {
            RootView a5;
            if (a5.view != null) {
                return a5.view.viewToModel(a, a2, a3, a4);
            }
            return -1;
        }

        public int getNextVisualPositionFrom(int a, Position.Bias a2, Shape a3, int a4, Position.Bias[] a5) throws BadLocationException {
            RootView a6;
            if (a6.view != null) {
                int a7 = a6.view.getNextVisualPositionFrom(a, a2, a3, a4, a5);
                if (a7 != -1) {
                    a = a7;
                } else {
                    a5[0] = a2;
                }
            }
            return a;
        }

        public void insertUpdate(DocumentEvent a, Shape a2, ViewFactory a3) {
            RootView a4;
            if (a4.view != null) {
                a4.view.insertUpdate(a, a2, a3);
            }
        }

        public void removeUpdate(DocumentEvent a, Shape a2, ViewFactory a3) {
            RootView a4;
            if (a4.view != null) {
                a4.view.removeUpdate(a, a2, a3);
            }
        }

        public void changedUpdate(DocumentEvent a, Shape a2, ViewFactory a3) {
            RootView a4;
            if (a4.view != null) {
                a4.view.changedUpdate(a, a2, a3);
            }
        }

        public Document getDocument() {
            RootView a;
            return a.KindleTextUI.this.editor.getDocument();
        }

        public int getStartOffset() {
            RootView a;
            if (a.view != null) {
                return a.view.getStartOffset();
            }
            return a.getElement().getStartOffset();
        }

        public int getEndOffset() {
            RootView a;
            if (a.view != null) {
                return a.view.getEndOffset();
            }
            return a.getElement().getEndOffset();
        }

        public Element getElement() {
            RootView a;
            if (a.view != null) {
                return a.view.getElement();
            }
            return a.KindleTextUI.this.editor.getDocument().getDefaultRootElement();
        }

        public View breakView(int a, float a2, Shape a3) {
            throw new Error("Can't break root view");
        }

        public int getResizeWeight(int a) {
            RootView a2;
            if (a2.view != null) {
                return a2.view.getResizeWeight(a);
            }
            return 0;
        }

        public void setSize(float a, float a2) {
            RootView a3;
            if (a3.view != null) {
                a3.view.setSize(a, a2);
            }
        }

        public Container getContainer() {
            RootView a;
            return a.KindleTextUI.this.editor;
        }

        public ViewFactory getViewFactory() {
            RootView a;
            ViewFactory a2 = a.KindleTextUI.this.getEditorKit(a.KindleTextUI.this.editor).getViewFactory();
            if (a2 != null) {
                return a2;
            }
            return a.KindleTextUI.this;
        }
    }

    public static class KindleHighlighter
    extends DefaultHighlighter
    implements UIResource {
        public KindleHighlighter() {
            KindleHighlighter a;
        }
    }

    public static class KindleCaret
    extends DefaultCaret
    implements UIResource {
        public KindleCaret() {
            KindleCaret a;
        }
    }

    class TextUIFocusListener
    implements FocusListener {
        Border userBorder;

        TextUIFocusListener() {
            TextUIFocusListener a;
        }

        public void focusLost(FocusEvent a) {
            TextUIFocusListener a2;
            if (((JComponent)a.getSource()).isEnabled() && a2.KindleTextUI.this.editor != null && a2.KindleTextUI.this.editor.isEditable()) {
                a2.KindleTextUI.this.editor.setBorder(a2.userBorder);
            }
        }

        public void focusGained(FocusEvent a) {
            TextUIFocusListener a2;
            if (((JComponent)a.getSource()).isEnabled() && a2.KindleTextUI.this.editor != null && a2.KindleTextUI.this.editor.isEditable()) {
                Object a3;
                a2.userBorder = a2.KindleTextUI.this.editor.getBorder();
                if (a2.KindleTextUI.this.editor instanceof JTextField && a2.userBorder instanceof UIResource) {
                    a2.KindleTextUI.this.editor.setBorder((Border)KindleTheme.TEXT_FIELD_BORDER_FOCUSED);
                }
                if ((a3 = a2.KindleTextUI.this.editor.getClientProperty(KindleTextUI.SELECT_ALL_TEXT_ON_FOCUS_GAINED)) instanceof Boolean && ((Boolean)a3).booleanValue()) {
                    a2.KindleTextUI.this.editor.selectAll();
                }
            }
        }
    }
}

