/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing.plaf.kindle;

import com.amazon.agui.swing.plaf.kindle.KindleTextUI;
import com.sun.java.swing.SwingUtilities2;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.text.FieldView;
import com.sun.java.swing.text.GlyphView;
import com.sun.java.swing.text.ParagraphView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class KindleTextFieldUI
extends KindleTextUI {
    public static ComponentUI createUI(JComponent a) {
        return new KindleTextFieldUI();
    }

    public KindleTextFieldUI() {
        KindleTextFieldUI a;
    }

    public void installUI(JComponent a) {
        KindleTextFieldUI a2;
        super.installUI(a);
        a2.editableChanged(a, ((JTextComponent)a).isEditable());
        a.putClientProperty("selectAllTextOnFocusGained", Boolean.TRUE);
    }

    public Dimension getPreferredSize(JComponent a) {
        KindleTextFieldUI a2;
        Dimension a3 = super.getPreferredSize(a);
        if (a2.editor != null) {
            Border a4;
            FontMetrics a5 = Toolkit.getDefaultToolkit().getFontMetrics(a2.editor.getFont());
            int a6 = a5.getMaxAscent() - a5.getAscent();
            if (a6 > 0) {
                a3.height += a6;
            }
            if ((a4 = a2.editor.getBorder()) != null) {
                Insets a7 = a4.getBorderInsets(a2.editor);
                a3.height += a7.bottom + a7.bottom;
                a3.width += a7.left + a7.right;
            }
        }
        return a3;
    }

    protected void propertyChange(PropertyChangeEvent a) {
        if (a.getPropertyName().equals("editable")) {
            KindleTextFieldUI a2;
            JComponent a3 = (JComponent)a.getSource();
            boolean a4 = (Boolean)a.getNewValue();
            a2.editableChanged(a3, a4);
        }
    }

    private void editableChanged(JComponent a, boolean a2) {
        if (a.getBackground() instanceof UIResource) {
            KindleTextFieldUI a3;
            if (!a2) {
                a.setBackground(UIManager.getColor((Object)(a3.getPropertyPrefix() + ".inactiveBackground")));
            } else {
                a.setBackground(UIManager.getColor((Object)(a3.getPropertyPrefix() + ".background")));
            }
        }
    }

    protected String getPropertyPrefix() {
        return "TextField";
    }

    public View create(Element a) {
        String a2;
        Object a3 = a.getDocument().getProperty("i18n");
        if (a3 != null && a3.equals(Boolean.TRUE) && (a2 = a.getName()) != null) {
            if (a2.equals("content")) {
                return new GlyphView(a);
            }
            if (a2.equals("paragraph")) {
                return new I18nFieldView(a);
            }
        }
        return new FieldView(a);
    }

    static class I18nFieldView
    extends ParagraphView {
        I18nFieldView(Element a) {
            super(a);
            I18nFieldView a2;
        }

        public int getFlowSpan(int a) {
            return Integer.MAX_VALUE;
        }

        protected void setJustification(int a) {
        }

        Shape adjustAllocation(Shape a) {
            if (a != null) {
                Container a2;
                I18nFieldView a3;
                Rectangle a4 = a.getBounds();
                int a5 = (int)a3.getPreferredSpan(1);
                int a6 = (int)a3.getPreferredSpan(0);
                if (a4.height != a5) {
                    int a7 = a4.height - a5;
                    a4.y += a7 / 2;
                    a4.height -= a7;
                }
                if ((a2 = a3.getContainer()) instanceof JTextField) {
                    int a8;
                    BoundedRangeModel a9 = ((JTextField)a2).getHorizontalVisibility();
                    int a10 = Math.max(a6, a4.width);
                    int a11 = a9.getValue();
                    if (a11 + (a8 = Math.min(a10, a4.width - 1)) > a10) {
                        a11 = a10 - a8;
                    }
                    a9.setRangeProperties(a11, a8, a9.getMinimum(), a10, false);
                    if (a6 < a4.width) {
                        int a12 = a4.width - 1 - a6;
                        int a13 = ((JTextField)a2).getHorizontalAlignment();
                        if (SwingUtilities2.isLeftToRight((Component)a2)) {
                            if (a13 == 10) {
                                a13 = 2;
                            } else if (a13 == 11) {
                                a13 = 4;
                            }
                        } else if (a13 == 10) {
                            a13 = 4;
                        } else if (a13 == 11) {
                            a13 = 2;
                        }
                        switch (a13) {
                            case 0: {
                                a4.x += a12 / 2;
                                a4.width -= a12;
                                break;
                            }
                            case 4: {
                                while (false) {
                                }
                                a4.x += a12;
                                a4.width -= a12;
                            }
                        }
                    } else {
                        a4.width = a6;
                        a4.x -= a9.getValue();
                    }
                }
                return a4;
            }
            return null;
        }

        void updateVisibilityModel() {
            I18nFieldView a;
            Container a2 = a.getContainer();
            if (a2 instanceof JTextField) {
                BoundedRangeModel a3 = ((JTextField)a2).getHorizontalVisibility();
                int a4 = (int)a.getPreferredSpan(0);
                int a5 = a3.getExtent();
                int a6 = Math.max(a4, a5);
                a5 = a5 == 0 ? a6 : a5;
                int a7 = a6 - a5;
                int a8 = a3.getValue();
                if (a8 + a5 > a6) {
                    a8 = a6 - a5;
                }
                a7 = Math.max(0, Math.min(a7, a8));
                a3.setRangeProperties(a7, a5, 0, a6, false);
            }
        }

        public void paint(Graphics a, Shape a2) {
            I18nFieldView a3;
            Rectangle a4 = (Rectangle)a2;
            a.clipRect(a4.x, a4.y, a4.width, a4.height);
            super.paint(a, a3.adjustAllocation(a2));
        }

        public int getResizeWeight(int a) {
            if (a == 0) {
                return 1;
            }
            return 0;
        }

        public Shape modelToView(int a, Shape a2, Position.Bias a3) throws BadLocationException {
            I18nFieldView a4;
            return super.modelToView(a, a4.adjustAllocation(a2), a3);
        }

        public Shape modelToView(int a, Position.Bias a2, int a3, Position.Bias a4, Shape a5) throws BadLocationException {
            I18nFieldView a6;
            return super.modelToView(a, a2, a3, a4, a6.adjustAllocation(a5));
        }

        public int viewToModel(float a, float a2, Shape a3, Position.Bias[] a4) {
            I18nFieldView a5;
            return super.viewToModel(a, a2, a5.adjustAllocation(a3), a4);
        }

        public void insertUpdate(DocumentEvent a, Shape a2, ViewFactory a3) {
            I18nFieldView a4;
            super.insertUpdate(a, a4.adjustAllocation(a2), a3);
            a4.updateVisibilityModel();
        }

        public void removeUpdate(DocumentEvent a, Shape a2, ViewFactory a3) {
            I18nFieldView a4;
            super.removeUpdate(a, a4.adjustAllocation(a2), a3);
            a4.updateVisibilityModel();
        }
    }
}

