/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing.plaf.kindle;

import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SunCellRendererPane;
import com.sun.java.swing.SwingUtilities2;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ActionMapUIResource;
import com.sun.java.swing.plaf.TableUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.table.SunTableCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.access.AccessibleClass;

public class KindleTableUI
extends ComponentUI
implements TableUI {
    protected JTable table;
    protected SunCellRendererPane rendererPane;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    private PropertyChangeListener propertyChangeListener;
    private static Method getCellEditor_METHOD = AccessibleClass.getMethod((Class)JTable.class, (String)"getCellEditor", (Class[])new Class[0]);

    public KindleTableUI() {
        KindleTableUI a;
    }

    private static SunTableCellEditor getCellEditor(JTable a) {
        try {
            return (SunTableCellEditor)getCellEditor_METHOD.invoke((Object)a, new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected KeyListener createKeyListener() {
        return null;
    }

    protected FocusListener createFocusListener() {
        KindleTableUI a;
        return a.new FocusHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        KindleTableUI a;
        return a.new MouseInputHandler();
    }

    private PropertyChangeListener createPropertyChangeListener() {
        KindleTableUI a;
        return a.new PropertyChangeHandler();
    }

    public static ComponentUI createUI(JComponent a) {
        return new KindleTableUI();
    }

    public void installUI(JComponent a) {
        KindleTableUI a2;
        a2.table = (JTable)a;
        a2.rendererPane = new SunCellRendererPane();
        a2.table.add((Component)a2.rendererPane);
        a2.installDefaults();
        a2.installListeners();
        a2.installKeyboardActions();
    }

    protected void installDefaults() {
        Container a;
        Color a2;
        Color a3;
        Color a4;
        KindleTableUI a5;
        LookAndFeel.installColorsAndFont((JComponent)a5.table, (String)"Table.background", (String)"Table.foreground", (String)"Table.font");
        int a6 = UIManager.getInt((Object)"Table.rowHeight");
        if (a6 > 0) {
            a5.table.setRowHeight(a6);
        }
        if ((a4 = a5.table.getSelectionBackground()) == null || a4 instanceof UIResource) {
            a5.table.setSelectionBackground(UIManager.getColor((Object)"Table.selectionBackground"));
        }
        if ((a3 = a5.table.getSelectionForeground()) == null || a3 instanceof UIResource) {
            a5.table.setSelectionForeground(UIManager.getColor((Object)"Table.selectionForeground"));
        }
        if ((a2 = a5.table.getGridColor()) == null || a2 instanceof UIResource) {
            a5.table.setGridColor(UIManager.getColor((Object)"Table.gridColor"));
        }
        if ((a = a5.table.getParent()) != null && (a = a.getParent()) != null && a instanceof JScrollPane) {
            LookAndFeel.installBorder((JComponent)((JScrollPane)a), (String)"Table.scrollPaneBorder");
        }
    }

    protected void installListeners() {
        KindleTableUI a;
        a.focusListener = a.createFocusListener();
        a.keyListener = a.createKeyListener();
        a.mouseInputListener = a.createMouseInputListener();
        a.propertyChangeListener = a.createPropertyChangeListener();
        a.table.addFocusListener(a.focusListener);
        a.table.addKeyListener(a.keyListener);
        a.table.addMouseListener(a.mouseInputListener);
        a.table.addMouseMotionListener(a.mouseInputListener);
        a.table.addPropertyChangeListener(a.propertyChangeListener);
    }

    protected void installKeyboardActions() {
        KindleTableUI a;
        ActionMap a2 = a.getActionMap();
        SwingUtilities2.replaceUIActionMap((JComponent)a.table, (ActionMap)a2);
        InputMap a3 = a.getInputMap(1);
        SwingUtilities2.replaceUIInputMap((JComponent)a.table, (int)1, (InputMap)a3);
    }

    InputMap getInputMap(int a) {
        if (a == 1) {
            return (InputMap)UIManager.get((Object)"Table.ancestorInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        KindleTableUI a;
        ActionMap a2 = (ActionMap)UIManager.get((Object)"Table.actionMap");
        if (a2 == null && (a2 = a.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put((Object)"Table.actionMap", (Object)a2);
        }
        return a2;
    }

    ActionMap createActionMap() {
        ActionMapUIResource a = new ActionMapUIResource();
        a.put("selectNextColumn", new NavigationalAction(1, 0, false, false, false));
        a.put("selectPreviousColumn", new NavigationalAction(-1, 0, false, false, false));
        a.put("selectNextRow", new NavigationalAction(0, 1, false, false, false));
        a.put("selectPreviousRow", new NavigationalAction(0, -1, false, false, false));
        a.put("cancel", new CancelEditingAction());
        a.put("startEditing", new StartEditingAction());
        return a;
    }

    public void uninstallUI(JComponent a) {
        KindleTableUI a2;
        a2.uninstallDefaults();
        a2.uninstallListeners();
        a2.uninstallKeyboardActions();
        a2.table.remove((Component)a2.rendererPane);
        a2.rendererPane = null;
        a2.table = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        KindleTableUI a;
        a.table.removeFocusListener(a.focusListener);
        a.table.removeKeyListener(a.keyListener);
        a.table.removeMouseListener(a.mouseInputListener);
        a.table.removeMouseMotionListener(a.mouseInputListener);
        a.table.removePropertyChangeListener(a.propertyChangeListener);
        a.focusListener = null;
        a.keyListener = null;
        a.mouseInputListener = null;
        a.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        KindleTableUI a;
        SwingUtilities2.replaceUIInputMap((JComponent)a.table, (int)1, null);
        SwingUtilities2.replaceUIActionMap((JComponent)a.table, null);
    }

    private Dimension createTableSize(long a) {
        long a2;
        KindleTableUI a3;
        int a4 = 0;
        int a5 = a3.table.getRowCount();
        if (a5 > 0 && a3.table.getColumnCount() > 0) {
            Rectangle a6 = a3.table.getCellRect(a5 - 1, 0, true);
            a4 = a6.y + a6.height;
        }
        if ((a2 = Math.abs(a)) > Integer.MAX_VALUE) {
            a2 = Integer.MAX_VALUE;
        }
        return new Dimension((int)a2, a4);
    }

    public Dimension getMinimumSize(JComponent a) {
        KindleTableUI a2;
        Enumeration<TableColumn> a3;
        long a4 = 0L;
        Enumeration<TableColumn> enumeration = a3 = a2.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn a5 = a3.nextElement();
            a4 += (long)a5.getMinWidth();
            enumeration = a3;
        }
        return a2.createTableSize(a4);
    }

    public Dimension getPreferredSize(JComponent a) {
        KindleTableUI a2;
        Enumeration<TableColumn> a3;
        long a4 = 0L;
        Enumeration<TableColumn> enumeration = a3 = a2.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn a5 = a3.nextElement();
            a4 += (long)a5.getPreferredWidth();
            enumeration = a3;
        }
        return a2.createTableSize(a4);
    }

    public Dimension getMaximumSize(JComponent a) {
        KindleTableUI a2;
        Enumeration<TableColumn> a3;
        long a4 = 0L;
        Enumeration<TableColumn> enumeration = a3 = a2.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn a5 = a3.nextElement();
            a4 += (long)a5.getMaxWidth();
            enumeration = a3;
        }
        return a2.createTableSize(a4);
    }

    public void paint(Graphics a, JComponent a2) {
        KindleTableUI a3;
        if (a3.table.getRowCount() <= 0 || a3.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle a4 = a.getClipBounds();
        Point a5 = a4.getLocation();
        Point a6 = new Point(a4.x + a4.width - 1, a4.y + a4.height - 1);
        int a7 = a3.table.rowAtPoint(a5);
        int a8 = a3.table.rowAtPoint(a6);
        if (a7 == -1) {
            a7 = 0;
        }
        if (a8 == -1) {
            a8 = a3.table.getRowCount() - 1;
        }
        int a9 = a3.table.columnAtPoint(a5);
        int a10 = a3.table.columnAtPoint(a6);
        if (a9 == -1) {
            a9 = 0;
        }
        if (a10 == -1) {
            a10 = a3.table.getColumnCount() - 1;
        }
        a3.paintGrid(a, a7, a8, a9, a10);
        a3.paintCells(a, a7, a8, a9, a10);
    }

    private void paintGrid(Graphics a, int a2, int a3, int a4, int a5) {
        int a6;
        int a7;
        KindleTableUI a8;
        a.setColor(a8.table.getGridColor());
        Rectangle a9 = a8.table.getCellRect(a2, a4, true);
        Rectangle a10 = a8.table.getCellRect(a3, a5, true);
        Rectangle a11 = a9.union(a10);
        if (a8.table.getShowHorizontalLines()) {
            int a12 = a11.x + a11.width;
            a7 = a11.y;
            int n = a6 = a2;
            while (n <= a3) {
                a.drawLine(a11.x, (a7 += a8.table.getRowHeight(a6)) - 1, a12 - 1, a7 - 1);
                n = ++a6;
            }
        }
        if (a8.table.getShowVerticalLines()) {
            int a13;
            TableColumnModel a14 = a8.table.getColumnModel();
            a7 = a11.y + a11.height;
            a6 = a11.x;
            int n = a13 = a4;
            while (n <= a5) {
                int a15 = a14.getColumn(a13).getWidth();
                a.drawLine((a6 += a15) - 1, 0, a6 - 1, a7 - 1);
                n = ++a13;
            }
        }
    }

    private int viewIndexForColumn(TableColumn a) {
        int a2;
        KindleTableUI a3;
        TableColumnModel a4 = a3.table.getColumnModel();
        int n = a2 = 0;
        while (n < a4.getColumnCount()) {
            if (a4.getColumn(a2) == a) {
                return a2;
            }
            n = ++a2;
        }
        return -1;
    }

    private void paintCells(Graphics a, int a2, int a3, int a4, int a5) {
        int a6;
        KindleTableUI a7;
        JTableHeader a8 = a7.table.getTableHeader();
        TableColumn a9 = a8 == null ? null : a8.getDraggedColumn();
        TableColumnModel a10 = a7.table.getColumnModel();
        int a11 = a10.getColumnMargin();
        int n = a6 = a2;
        while (n <= a3) {
            Rectangle a12 = a7.table.getCellRect(a6, a4, false);
            int n2 = a4;
            while (n2 <= a5) {
                int a13;
                TableColumn a14 = a10.getColumn(a13);
                int a15 = a14.getWidth();
                a12.width = a15 - a11;
                if (a14 != a9) {
                    a7.paintCell(a, a12, a6, a13);
                }
                a12.x += a15;
                n2 = ++a13;
            }
            n = ++a6;
        }
        if (a9 != null) {
            a7.paintDraggedArea(a, a2, a3, a9, a8.getDraggedDistance());
        }
        a7.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics a, int a2, int a3, TableColumn a4, int a5) {
        int a6;
        int a7;
        KindleTableUI a8;
        int a9 = a8.viewIndexForColumn(a4);
        Rectangle a10 = a8.table.getCellRect(a2, a9, true);
        Rectangle a11 = a8.table.getCellRect(a3, a9, true);
        Rectangle a12 = a10.union(a11);
        a.setColor(a8.table.getParent().getBackground());
        a.fillRect(a12.x, a12.y, a12.width, a12.height);
        a12.x += a5;
        a.setColor(a8.table.getBackground());
        a.fillRect(a12.x, a12.y, a12.width, a12.height);
        if (a8.table.getShowVerticalLines()) {
            a.setColor(a8.table.getGridColor());
            a7 = a12.x;
            int a13 = a12.y;
            int a14 = a7 + a12.width - 1;
            a6 = a13 + a12.height - 1;
            a.drawLine(a7 - 1, a13, a7 - 1, a6);
            a.drawLine(a14, a13, a14, a6);
        }
        int n = a7 = a2;
        while (n <= a3) {
            Rectangle a15 = a8.table.getCellRect(a7, a9, false);
            a15.x += a5;
            a8.paintCell(a, a15, a7, a9);
            if (a8.table.getShowHorizontalLines()) {
                a.setColor(a8.table.getGridColor());
                Rectangle a16 = a8.table.getCellRect(a7, a9, true);
                a16.x += a5;
                a6 = a16.x;
                int a17 = a16.y;
                int a18 = a6 + a16.width - 1;
                int a19 = a17 + a16.height - 1;
                a.drawLine(a6, a19, a18, a19);
            }
            n = ++a7;
        }
    }

    private void paintCell(Graphics a, Rectangle a2, int a3, int a4) {
        KindleTableUI a5;
        TableCellRenderer a6 = a5.table.getCellRenderer(a3, a4);
        Component a7 = a5.table.prepareRenderer(a6, a3, a4);
        a5.rendererPane.paintComponent(a, a7, (Container)a5.table, a2.x, a2.y, a2.width, a2.height, true);
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
            PropertyChangeHandler a;
        }

        public void propertyChange(PropertyChangeEvent a) {
            String string = a.getPropertyName();
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private Component dispatchComponent;
        private boolean selectedOnPress;

        public MouseInputHandler() {
            MouseInputHandler a;
        }

        public void mouseClicked(MouseEvent a) {
        }

        private void setDispatchComponent(MouseEvent a) {
            MouseInputHandler a2;
            Component a3 = a2.KindleTableUI.this.table.getEditorComponent();
            Point a4 = a.getPoint();
            Point a5 = SwingUtilities.convertPoint(a2.KindleTableUI.this.table, a4, a3);
            a2.dispatchComponent = SwingUtilities.getDeepestComponentAt(a3, a5.x, a5.y);
        }

        private boolean repostEvent(MouseEvent a) {
            MouseInputHandler a2;
            if (a2.dispatchComponent == null || !a2.KindleTableUI.this.table.isEditing()) {
                return false;
            }
            MouseEvent a3 = SwingUtilities.convertMouseEvent(a2.KindleTableUI.this.table, a, a2.dispatchComponent);
            a2.dispatchComponent.dispatchEvent(a3);
            return true;
        }

        private void setValueIsAdjusting(boolean a) {
            MouseInputHandler a2;
            a2.KindleTableUI.this.table.getSelectionModel().setValueIsAdjusting(a);
            a2.KindleTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(a);
        }

        private boolean shouldIgnore(MouseEvent a) {
            MouseInputHandler a2;
            return a.isConsumed() || !SwingUtilities.isLeftMouseButton(a) || !a2.KindleTableUI.this.table.isEnabled();
        }

        public void mousePressed(MouseEvent a) {
            MouseInputHandler a2;
            if (a.isConsumed()) {
                a2.selectedOnPress = false;
                return;
            }
            a2.selectedOnPress = true;
            a2.adjustFocusAndSelection(a);
        }

        void adjustFocusAndSelection(MouseEvent a) {
            MouseInputHandler a2;
            if (a2.shouldIgnore(a)) {
                return;
            }
            Point a3 = a.getPoint();
            int a4 = a2.KindleTableUI.this.table.rowAtPoint(a3);
            int a5 = a2.KindleTableUI.this.table.columnAtPoint(a3);
            if (a5 == -1 || a4 == -1) {
                return;
            }
            if (a2.KindleTableUI.this.table.editCellAt(a4, a5, a)) {
                a2.setDispatchComponent(a);
                a2.repostEvent(a);
            } else if (a2.KindleTableUI.this.table.isRequestFocusEnabled()) {
                a2.KindleTableUI.this.table.requestFocus();
            }
            SunTableCellEditor a6 = KindleTableUI.getCellEditor(a2.KindleTableUI.this.table);
            if (a6 == null || a6.shouldSelectCell((EventObject)a)) {
                boolean a7 = a.getID() == 501;
                a2.setValueIsAdjusting(a7);
                a2.KindleTableUI.this.table.changeSelection(a4, a5, a.isControlDown(), a.isShiftDown());
            }
        }

        public void mouseReleased(MouseEvent a) {
            MouseInputHandler a2;
            if (a2.selectedOnPress) {
                if (a2.shouldIgnore(a)) {
                    return;
                }
                a2.dispatchComponent = null;
                a2.setValueIsAdjusting(false);
            } else {
                a2.adjustFocusAndSelection(a);
            }
        }

        public void mouseEntered(MouseEvent a) {
        }

        public void mouseExited(MouseEvent a) {
        }

        public void mouseMoved(MouseEvent a) {
        }

        public void mouseDragged(MouseEvent a) {
            MouseInputHandler a2;
            if (a2.shouldIgnore(a)) {
                return;
            }
            a2.repostEvent(a);
            SunTableCellEditor a3 = KindleTableUI.getCellEditor(a2.KindleTableUI.this.table);
            if (a3 == null || a3.shouldSelectCell((EventObject)a)) {
                Point a4 = a.getPoint();
                int a5 = a2.KindleTableUI.this.table.rowAtPoint(a4);
                int a6 = a2.KindleTableUI.this.table.columnAtPoint(a4);
                if (a6 == -1 || a5 == -1) {
                    return;
                }
                a2.KindleTableUI.this.table.changeSelection(a5, a6, false, true);
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        public FocusHandler() {
            FocusHandler a;
        }

        private void repaintAnchorCell() {
            FocusHandler a;
            int a2 = a.KindleTableUI.this.table.getRowCount();
            int a3 = a.KindleTableUI.this.table.getColumnCount();
            int a4 = a.KindleTableUI.this.table.getSelectionModel().getAnchorSelectionIndex();
            int a5 = a.KindleTableUI.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (a4 < 0 || a4 >= a2 || a5 < 0 || a5 >= a3) {
                return;
            }
            Rectangle a6 = a.KindleTableUI.this.table.getCellRect(a4, a5, false);
            a.KindleTableUI.this.table.repaint(a6);
        }

        public void focusGained(FocusEvent a) {
            FocusHandler a2;
            a2.repaintAnchorCell();
        }

        public void focusLost(FocusEvent a) {
            FocusHandler a2;
            a2.repaintAnchorCell();
        }
    }

    private static class StartEditingAction
    extends AbstractAction {
        private StartEditingAction() {
            StartEditingAction a;
        }

        public void actionPerformed(ActionEvent a) {
            JTable a2 = (JTable)a.getSource();
            if (!a2.hasFocus()) {
                SunTableCellEditor a3 = KindleTableUI.getCellEditor(a2);
                if (a3 != null && !a3.stopCellEditing()) {
                    return;
                }
                a2.requestFocus();
                return;
            }
            ListSelectionModel a4 = a2.getSelectionModel();
            int a5 = a4.getAnchorSelectionIndex();
            int a6 = a2.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            a2.editCellAt(a5, a6);
            Component a7 = a2.getEditorComponent();
            if (a7 != null) {
                a7.requestFocus();
            }
        }
    }

    private static class CancelEditingAction
    extends AbstractAction {
        private CancelEditingAction() {
            CancelEditingAction a;
        }

        public void actionPerformed(ActionEvent a) {
            ((JTable)a.getSource()).removeEditor();
        }
    }

    private static class NavigationalAction
    extends AbstractAction {
        protected int dx;
        protected int dy;
        protected boolean toggle;
        protected boolean extend;
        protected boolean inSelection;
        protected int anchorRow;
        protected int anchorColumn;
        protected int leadRow;
        protected int leadColumn;

        protected NavigationalAction(int a, int a2, boolean a3, boolean a4, boolean a5) {
            NavigationalAction a6;
            a6.dx = a;
            a6.dy = a2;
            a6.toggle = a3;
            a6.extend = a4;
            a6.inSelection = a5;
        }

        private int clipToRange(int a, int a2, int a3) {
            return Math.min(Math.max(a, a2), a3 - 1);
        }

        private void moveWithinTableRange(JTable a, int a2, int a3, boolean a4) {
            NavigationalAction a5;
            if (a4) {
                a5.leadRow = a5.clipToRange(a5.leadRow + a3, 0, a.getRowCount());
                a5.leadColumn = a5.clipToRange(a5.leadColumn + a2, 0, a.getColumnCount());
            } else {
                a5.anchorRow = a5.clipToRange(a5.anchorRow + a3, 0, a.getRowCount());
                a5.anchorColumn = a5.clipToRange(a5.anchorColumn + a2, 0, a.getColumnCount());
            }
        }

        private int selectionSpan(ListSelectionModel a) {
            return a.getMaxSelectionIndex() - a.getMinSelectionIndex() + 1;
        }

        private int compare(int a, ListSelectionModel a2) {
            NavigationalAction a3;
            return a3.compare(a, a2.getMinSelectionIndex(), a2.getMaxSelectionIndex() + 1);
        }

        private int compare(int a, int a2, int a3) {
            return a < a2 ? -1 : (a >= a3 ? 1 : 0);
        }

        private boolean moveWithinSelectedRange(JTable a, int a2, int a3, boolean a4) {
            int a5;
            int a6;
            int a7;
            boolean a8;
            NavigationalAction a9;
            ListSelectionModel a10 = a.getSelectionModel();
            ListSelectionModel a11 = a.getColumnModel().getSelectionModel();
            int a12 = a9.anchorRow + a3;
            int a13 = a9.anchorColumn + a2;
            int a14 = a9.selectionSpan(a10);
            boolean bl = a8 = a14 * (a7 = a9.selectionSpan(a11)) > 1;
            if (a8) {
                a6 = a9.compare(a12, a10);
                a5 = a9.compare(a13, a11);
            } else {
                a14 = a.getRowCount();
                a7 = a.getColumnCount();
                a6 = a9.compare(a12, 0, a14);
                a5 = a9.compare(a13, 0, a7);
            }
            a9.anchorRow = a12 - a14 * a6;
            a9.anchorColumn = a13 - a7 * a5;
            if (!a4) {
                return a9.moveWithinSelectedRange(a, a6, a5, true);
            }
            return a8;
        }

        public void actionPerformed(ActionEvent a) {
            NavigationalAction a2;
            JTable a3 = (JTable)a.getSource();
            ListSelectionModel a4 = a3.getSelectionModel();
            a2.anchorRow = a4.getAnchorSelectionIndex();
            a2.leadRow = a4.getLeadSelectionIndex();
            ListSelectionModel a5 = a3.getColumnModel().getSelectionModel();
            a2.anchorColumn = a5.getAnchorSelectionIndex();
            a2.leadColumn = a5.getLeadSelectionIndex();
            int a6 = a2.anchorRow;
            int a7 = a2.anchorColumn;
            SunTableCellEditor a8 = KindleTableUI.getCellEditor(a3);
            if (a3.isEditing() && a8 != null && a8.stopCellEditing()) {
                return;
            }
            if (a2.leadRow == 0) {
                if (a2.dy == -1 || a2.leadColumn == 0 && a2.dx == -1) {
                    a3.transferFocusBackward();
                    return;
                }
            } else if (a2.leadRow == a3.getRowCount() - 1 && (a2.dy == 1 || a2.leadColumn == a3.getColumnCount() - 1 && a2.dx == 1)) {
                a3.transferFocusBackward();
                return;
            }
            if (!a2.inSelection) {
                a2.moveWithinTableRange(a3, a2.dx, a2.dy, a2.extend);
                if (!a2.extend) {
                    a3.changeSelection(a2.anchorRow, a2.anchorColumn, false, a2.extend);
                } else {
                    a3.changeSelection(a2.leadRow, a2.leadColumn, false, a2.extend);
                }
            } else if (a2.moveWithinSelectedRange(a3, a2.dx, a2.dy, false)) {
                a3.changeSelection(a2.anchorRow, a2.anchorColumn, true, true);
            } else {
                a3.changeSelection(a2.anchorRow, a2.anchorColumn, false, false);
            }
        }
    }
}

