/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing.plaf.kindle;

import com.amazon.agui.swing.ArrowheadIcon;
import com.amazon.agui.swing.KDialog;
import com.amazon.agui.swing.KindleColor;
import com.amazon.agui.swing.MenuDialogLookFeel;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.text.StringUtil;
import com.amazon.ebook.util.thread.ThreadPool;
import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class KindleSwingUtilities
implements SwingConstants {
    public static final String RESOURCES = "com.amazon.agui.swing.resources.ComponentResources";
    public static final Dimension DEFAULT_KINDLE_SCREEN_SIZE = new Dimension(600, 800);
    public static final String NO_BUTTON_XOR = "buttons.noxor";
    public static final String MAX_COLUMNS = "maxColumns";
    public static final String MAX_ROWS = "maxRows";
    public static final String COLUMN_WIDTH = "columnWidth";
    public static final char COLUMN_WIDTH_LETTER = 'm';
    public static final String CLASSIC_LOOK_AND_FEEL = "classic.look";
    public static final String CLASSIC_LOOK_AND_FEEL_BUTTON_ROUND_BORDER = "classic.look.button.roundborder";
    public static final String RADIO_BUTTON_CHECK_BOX = "radiobutton.checkbox";
    public static final String FONT_BASELINE_ALIGNMENT = "font.baseline.alignment";
    public static final String SLIDER_TOTAL_BOXES = "slider.total.boxes";
    public static final String SEPARATOR_STYLE_KEY = "separator.style";
    public static final int ITEM_SEPARATOR_NONE = 0;
    public static final int ITEM_SEPARATOR_TOP_AND_BOTTOM = 1;
    public static final int ITEM_SEPARATOR_IN_BETWEEN = 2;
    public static final int ITEM_SEPARATOR_BETWEEN_AND_BOTTOM = 3;
    public static final String MENU_ITEM_ICON_STYLE = "menu.item.icon.style";
    public static final int MAX_RELATIVE_LENGTH = 2000000;
    public static final int MIN_RELATIVE_LENGTH = 60;

    public KindleSwingUtilities() {
        KindleSwingUtilities a;
    }

    private static int getColumnWidth(JComponent a) {
        int a2;
        Object a3 = a.getClientProperty(COLUMN_WIDTH);
        if (a3 instanceof Integer && (a2 = ((Integer)a3).intValue()) > 0) {
            return a2;
        }
        return 0;
    }

    public static Dimension getPreferredButtonSize(AbstractButton a, Rectangle[] a2, int a3, int a4, int a5) {
        if (a.getComponentCount() > 0) {
            return null;
        }
        Icon a6 = a.getIcon();
        String a7 = a.getText();
        Font a8 = a.getFont();
        FontMetrics a9 = a.getToolkit().getFontMetrics(a8);
        Rectangle a10 = new Rectangle();
        Rectangle a11 = new Rectangle();
        Rectangle a12 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        KindleSwingUtilities.layoutCompoundButtonLabel(a, a9, a7, a6, a.getVerticalAlignment(), a.getHorizontalAlignment(), a.getVerticalTextPosition(), a.getHorizontalTextPosition(), a12, a10, a11, a2, a3, a4, a7 == null ? 0 : a5);
        Rectangle a13 = a10.union(a11);
        Insets a14 = a.getInsets();
        a13.width += a14.left + a14.right;
        a13.height += a14.top + a14.bottom;
        return a13.getSize();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] layoutCompoundButtonLabel(AbstractButton a, FontMetrics a2, String a3, Icon a4, int a5, int a6, int a7, int a8, Rectangle a9, Rectangle a10, Rectangle a11, Rectangle[] a12, int a13, int a14, int a15) {
        int a16 = a6;
        int a17 = a8;
        switch (a6) {
            case 10: {
                a16 = 2;
                break;
            }
            case 11: {
                a16 = 4;
                break;
            }
        }
        switch (a8) {
            case 10: {
                a17 = 2;
                break;
            }
            case 11: {
                a17 = 4;
                break;
            }
        }
        int a18 = KindleSwingUtilities.getColumnWidth(a);
        if (a18 <= 0) {
            a18 = a2.charWidth('m');
        }
        return KindleSwingUtilities.layoutCompoundLabelImpl(a2, a3, a4, a5, a16, a7, a17, a9, a10, a11, a12, a13 * a18, a14, a15);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] layoutCompoundLabel(JComponent a, FontMetrics a2, String a3, Icon a4, int a5, int a6, int a7, int a8, Rectangle a9, Rectangle a10, Rectangle a11, Rectangle[] a12, int a13, int a14, int a15) {
        boolean a16 = true;
        int a17 = a6;
        int a18 = a8;
        if (a != null && !SwingUtilities2.isLeftToRight((Component)a)) {
            a16 = false;
        }
        switch (a6) {
            case 10: {
                a17 = a16 ? 2 : 4;
                break;
            }
            case 11: {
                a17 = a16 ? 4 : 2;
                break;
            }
        }
        switch (a8) {
            case 10: {
                a18 = a16 ? 2 : 4;
                break;
            }
            case 11: {
                a18 = a16 ? 4 : 2;
                break;
            }
        }
        int a19 = KindleSwingUtilities.getColumnWidth(a);
        if (a19 <= 0) {
            a19 = a2.charWidth('m');
        }
        return KindleSwingUtilities.layoutCompoundLabelImpl(a2, a3, a4, a5, a17, a7, a18, a9, a10, a11, a12, a13 * a19, a14, a15);
    }

    public static String[] layoutCompoundLabelImpl(FontMetrics a, String a2, Icon a3, int a4, int a5, int a6, int a7, Rectangle a8, Rectangle a9, Rectangle a10, Rectangle[] a11, int a12, int a13, int a14) {
        int a15;
        int a16;
        int a17;
        int a18;
        if (a3 != null) {
            a9.width = a3.getIconWidth();
            a9.height = a3.getIconHeight();
        } else {
            a9.height = 0;
            a9.width = 0;
        }
        boolean a19 = a2 == null || a2.equals("");
        boolean a20 = false;
        int a21 = a19 || a3 == null ? 0 : a14;
        int a22 = a12;
        String[] a23 = null;
        if (a19) {
            int n = a18 = 0;
            while (n < a11.length) {
                a11[a18].height = 0;
                a11[a18].width = 0;
                n = ++a18;
            }
            a2 = "";
            a23 = new String[]{};
        } else {
            a22 = a7 == 0 ? Math.max(a8.width, a12) : Math.max(a8.width - (a9.width + a21), a12);
            if (a22 < 0) {
                a22 = 0;
            }
            if (a12 > 0) {
                if (a12 < a22) {
                    a22 = a12;
                }
            } else if (a2.indexOf(10) < 0) {
                a13 = 1;
            }
            a18 = a.getHeight() * a13;
            if (a6 == 0) {
                a18 = Math.max(a8.height, a18);
            } else if ((a18 = Math.max(a8.height - (a9.height + a21), a18)) < 0) {
                a18 = 0;
            }
            a23 = StringUtil.wrapText((FontMetrics)a, (String)a2, (int)a22, (int)a13).toArray(new String[0]);
            int n = a17 = 0;
            while (n < a23.length) {
                a11[a17].width = a.stringWidth(a23[a17]);
                a11[a17].height = a.getHeight();
                n = ++a17;
            }
        }
        a18 = 0;
        int n = a17 = 0;
        while (n < a23.length) {
            a16 = a11[a17].width;
            if (a16 > a18) {
                a18 = a16;
            }
            n = ++a17;
        }
        a17 = a11[0].height * a23.length;
        a10.y = 0;
        a10.x = 0;
        a10.width = a18;
        a10.height = a17;
        a10.y = a6 == 1 ? (a7 != 0 ? 0 : -(a10.height + a21)) : (a6 == 0 ? a9.height / 2 - a10.height / 2 : (a7 != 0 ? a9.height - a10.height : a9.height + a21));
        a10.x = a7 == 2 ? -(a10.width + a21) : (a7 == 0 ? a9.width / 2 - a10.width / 2 : a9.width + a21);
        a16 = Math.min(a9.x, a10.x);
        int a24 = Math.max(a9.x + a9.width, a10.x + a10.width) - a16;
        int a25 = Math.min(a9.y, a10.y);
        int a26 = Math.max(a9.y + a9.height, a10.y + a10.height) - a25;
        int a27 = a4 == 1 ? a8.y - a25 : (a4 == 0 ? a8.y + a8.height / 2 - (a25 + a26 / 2) : a8.y + a8.height - (a25 + a26));
        int a28 = a5 == 2 ? a8.x - a16 : (a5 == 4 ? a8.x + a8.width - (a16 + a24) : a8.x + a8.width / 2 - (a16 + a24 / 2));
        a10.x += a28;
        a10.y += a27;
        a9.x += a28;
        a9.y += a27;
        int n2 = a15 = 0;
        while (n2 < a23.length) {
            a11[a15].x = a5 == 2 ? a10.x : (a5 == 4 ? a10.x + a10.width - a11[a15].width : a10.x + (a10.width - a11[a15].width) / 2);
            a11[a15].y = a15 == 0 ? a10.y : a11[a15 - 1].y + a11[a15 - 1].height;
            n2 = ++a15;
        }
        return a23;
    }

    public static AbstractButton createButton(Action a, Action a2, boolean a3) {
        if (a2 != null) {
            a = new DialogButtonAction(a, a2, a3);
        }
        return new JButton(a);
    }

    public static AbstractButton createRadioButton(Action a, Action a2, boolean a3) {
        if (a2 != null) {
            a = new DialogButtonAction(a, a2, a3);
        }
        JRadioButton a4 = new JRadioButton(a);
        a4.setVerticalAlignment(0);
        a4.putClientProperty(CLASSIC_LOOK_AND_FEEL, Boolean.TRUE);
        a4.putClientProperty(RADIO_BUTTON_CHECK_BOX, Boolean.TRUE);
        return a4;
    }

    public static AbstractButton configureButton(final AbstractButton a, boolean a2) {
        Serializable a3;
        Insets a4;
        ResourceBundle a5 = ResourceBundle.getBundle(RESOURCES);
        if (a2) {
            a.setIcon(new ArrowheadIcon(3));
            a.setHorizontalTextPosition(10);
            a.putClientProperty(MENU_ITEM_ICON_STYLE, Boolean.TRUE);
        }
        if (a.getBorder() == null) {
            a4 = (Insets)a5.getObject("MenuDialog.button.insets");
        } else {
            a4 = a.getBorder().getBorderInsets(a);
            a3 = (Insets)a5.getObject("MenuDialog.button.insets");
            a4.left = Math.max(a4.left, a3.left);
            a4.right = Math.max(a4.right, a3.right);
        }
        a3 = new EmptyBorder(a4){
            {
                1 a2;
                super(a3);
            }

            public void paintBorder(Component a9, Graphics a2, int a3, int a42, int a5, int a6) {
                1 a7;
                if (a7.a.getModel().isPressed() || a7.a.getModel().isSelected()) {
                    Color a8 = a2.getColor();
                    if (Boolean.getBoolean(KindleSwingUtilities.NO_BUTTON_XOR)) {
                        a2.setColor(KindleColor.white);
                    } else {
                        a2.setColor(KindleColor.black);
                    }
                    a2.fillRect(a3, a42, a7.a4.left, a6);
                    a2.fillRect(a3, a42, a5, a7.a4.top);
                    a2.fillRect(a3, a42 + a6 - a7.a4.bottom, a5, a7.a4.bottom);
                    a2.fillRect(a3 + a5 - a7.a4.right, a42, a7.a4.right, a6);
                    a2.setColor(a8);
                }
            }
        };
        a.setBorder((Border)((Object)a3));
        a.setHorizontalAlignment((Integer)a5.getObject("MenuDialog.button.horizontal.alignment"));
        a.setFont((Font)a5.getObject("MenuDialog.menu_entry.font"));
        Dimension a6 = a.getPreferredSize();
        a.getPreferredSize().height = (Integer)a5.getObject("MenuDialog.menu_entry.height");
        a.setPreferredSize(a6);
        a.setMinimumSize(a6);
        a.setMaximumSize(a6);
        return a;
    }

    public static boolean isInDialog(boolean a, Component a2) {
        Container a3;
        Container container = a3 = a2.getParent();
        while (container != null) {
            if (a3 instanceof KDialog) {
                if (a) {
                    if (a3 instanceof MenuDialogLookFeel) {
                        return true;
                    }
                    KDialog a4 = (KDialog)a3;
                    if (a4.getContentPane().getComponentCount() == 1 && a4.getContentPane().getComponent(0) instanceof MenuDialogLookFeel) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            container = a3.getParent();
        }
        return false;
    }

    public static int getProgessBarLength(int a, int a2) {
        return Math.max(60, a * a2 / 2000000);
    }

    public static int getMaxColumns(AbstractButton a) {
        int a2;
        Object a3 = a.getClientProperty(MAX_COLUMNS);
        if (a3 instanceof Integer && (a2 = ((Integer)a3).intValue()) > 0) {
            return a2;
        }
        return 0;
    }

    public static GridBagConstraints createGridBagConstraints(int a, int a2, int a3, int a4, double a5, double a6, int a7, int a8, Insets a9, int a10, int a11) {
        GridBagConstraints a12 = new GridBagConstraints();
        new GridBagConstraints().gridx = a;
        a12.gridy = a2;
        a12.gridwidth = a3;
        a12.gridheight = a4;
        a12.weightx = a5;
        a12.weighty = a6;
        a12.anchor = a7;
        a12.fill = a8;
        a12.insets = a9;
        a12.ipadx = a10;
        a12.ipady = a11;
        return a12;
    }

    protected static class DialogButtonAction
    extends AbstractAction {
        private static final Log LOG = Log.getInstance((String)"DialogButtonAction");
        private Action primaryAction;
        private Action closeAction;
        private boolean newThread;

        public DialogButtonAction(Action a, Action a2, boolean a3) {
            DialogButtonAction a4;
            a4.putValue("Name", a.getValue("Name"));
            a4.primaryAction = a;
            a4.closeAction = a2;
            a4.newThread = a3;
            if (!a4.primaryAction.isEnabled()) {
                a4.setEnabled(false);
            }
        }

        public void actionPerformed(final ActionEvent a) {
            DialogButtonAction a2;
            a2.closeAction.actionPerformed(a);
            if (a2.newThread) {
                if (Log.isDebugOn()) {
                    LOG.debug("action in thread pool: " + a2.primaryAction.getValue("Name"));
                }
                ThreadPool.getInstance().runIt(new Runnable(){
                    {
                        1 a2;
                    }

                    public void run() {
                        1 a2;
                        a2.DialogButtonAction.this.primaryAction.actionPerformed(a2.a);
                    }
                }, "primaryAction");
            } else {
                if (Log.isDebugOn()) {
                    LOG.debug("action in event queue: " + a2.primaryAction.getValue("Name"));
                }
                a2.primaryAction.actionPerformed(a);
            }
        }
    }
}

