/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing.plaf.kindle;

import com.amazon.agui.swing.SpinArrowButton;
import com.sun.access.swing.AJComponent;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SwingUtilities2;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ActionMapUIResource;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.text.InternationalFormatter;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;

public class KindleSpinnerUI
extends ComponentUI {
    private static Insets DEFAULT_INSETS = new Insets(0, 0, 0, 0);
    protected JSpinner spinner;
    private static final PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();
    private static final ArrowButtonHandler nextButtonHandler = new ArrowButtonHandler("increment", true);
    private static final ArrowButtonHandler previousButtonHandler = new ArrowButtonHandler("decrement", false);
    private static final Dimension zeroSize = new Dimension(0, 0);
    protected static int dragThreshold = 100;

    public KindleSpinnerUI() {
        KindleSpinnerUI a;
    }

    public static ComponentUI createUI(JComponent a) {
        return new KindleSpinnerUI();
    }

    private void maybeAdd(Component a, String a2) {
        if (a != null) {
            KindleSpinnerUI a3;
            a3.spinner.add(a, a2);
        }
    }

    public void installUI(JComponent a) {
        KindleSpinnerUI a2;
        a2.spinner = (JSpinner)a;
        a2.installDefaults();
        a2.installListeners();
        a2.maybeAdd(a2.createNextButton(), "Next");
        a2.maybeAdd(a2.createPreviousButton(), "Previous");
        a2.maybeAdd(a2.createEditor(), "Editor");
        a2.updateEnabledState();
        a2.installKeyboardActions();
    }

    public void uninstallUI(JComponent a) {
        KindleSpinnerUI a2;
        a2.uninstallDefaults();
        a2.uninstallListeners();
        a2.spinner = null;
        a.removeAll();
    }

    protected void installListeners() {
        KindleSpinnerUI a;
        a.spinner.addPropertyChangeListener(propertyChangeListener);
    }

    protected void uninstallListeners() {
        KindleSpinnerUI a;
        a.spinner.removePropertyChangeListener(propertyChangeListener);
        a.removeEditorBorderListener(a.spinner.getEditor());
    }

    protected void installDefaults() {
        KindleSpinnerUI a;
        a.spinner.setLayout(a.createLayout());
        LookAndFeel.installBorder((JComponent)a.spinner.getEditor(), (String)"Spinner.border");
        LookAndFeel.installColorsAndFont((JComponent)a.spinner, (String)"Spinner.background", (String)"Spinner.foreground", (String)"Spinner.font");
        dragThreshold = (Integer)UIManager.get((Object)"Spinner.dragThreshold");
        HashSet<KeyStroke> a2 = new HashSet<KeyStroke>();
        a2.add(KeyStroke.getKeyStroke(9, 2));
        a.spinner.setFocusTraversalKeys(0, a2);
        HashSet<KeyStroke> a3 = new HashSet<KeyStroke>();
        a3.add(KeyStroke.getKeyStroke(9, 3));
        a.spinner.setFocusTraversalKeys(1, a3);
    }

    protected void uninstallDefaults() {
        KindleSpinnerUI a;
        a.spinner.setLayout(null);
    }

    protected LayoutManager createLayout() {
        KindleSpinnerUI a;
        return a.new SpinnerLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected Component createPreviousButton() {
        KindleSpinnerUI a;
        return a.createArrowButton(5, previousButtonHandler);
    }

    protected Component createNextButton() {
        KindleSpinnerUI a;
        return a.createArrowButton(1, nextButtonHandler);
    }

    private Component createArrowButton(int a, ArrowButtonHandler a2) {
        SpinArrowButton a3 = new SpinArrowButton(a);
        a3.addActionListener(a2);
        a3.addMouseListener(a2);
        a3.addMouseMotionListener(a2);
        Border a4 = UIManager.getBorder((Object)"Spinner.arrowButtonBorder");
        if (a4 instanceof UIResource) {
            a3.setBorder(new CompoundBorder(a4, null));
        } else {
            a3.setBorder(a4);
        }
        return a3;
    }

    protected JComponent createEditor() {
        KindleSpinnerUI a;
        JComponent a2 = a.spinner.getEditor();
        a.maybeRemoveEditorBorder(a2);
        a.installEditorBorderListener(a2);
        return a2;
    }

    protected void replaceEditor(JComponent a, JComponent a2) {
        KindleSpinnerUI a3;
        a3.spinner.remove(a);
        a3.maybeRemoveEditorBorder(a2);
        a3.installEditorBorderListener(a2);
        a3.spinner.add((Component)a2, "Editor");
    }

    private void maybeRemoveEditorBorder(JComponent a) {
        if (!UIManager.getBoolean((Object)"Spinner.editorBorderPainted")) {
            if (a instanceof JPanel && a.getBorder() == null && a.getComponentCount() > 0) {
                a = (JComponent)a.getComponent(0);
            }
            if (a != null && a.getBorder() instanceof UIResource) {
                a.setBorder(null);
            }
        }
    }

    private void installEditorBorderListener(JComponent a) {
        if (!UIManager.getBoolean((Object)"Spinner.editorBorderPainted")) {
            if (a instanceof JPanel && a.getBorder() == null && a.getComponentCount() > 0) {
                a = (JComponent)a.getComponent(0);
            }
            if (a != null && (a.getBorder() == null || a.getBorder() instanceof UIResource)) {
                a.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    private void removeEditorBorderListener(JComponent a) {
        if (!UIManager.getBoolean((Object)"Spinner.editorBorderPainted")) {
            if (a instanceof JPanel && a.getComponentCount() > 0) {
                a = (JComponent)a.getComponent(0);
            }
            if (a != null) {
                a.removePropertyChangeListener(propertyChangeListener);
            }
        }
    }

    private void updateEnabledState() {
        KindleSpinnerUI a;
        a.updateEnabledState(a.spinner, a.spinner.isEnabled());
    }

    private void updateEnabledState(Container a, boolean a2) {
        int a3;
        int n = a3 = a.getComponentCount() - 1;
        while (n >= 0) {
            Component a4 = a.getComponent(a3);
            a4.setEnabled(a2);
            if (a4 instanceof Container) {
                KindleSpinnerUI a5;
                a5.updateEnabledState((Container)a4, a2);
            }
            n = --a3;
        }
    }

    private void installKeyboardActions() {
        KindleSpinnerUI a;
        InputMap a2 = a.getInputMap(1);
        SwingUtilities2.replaceUIInputMap((JComponent)a.spinner, (int)1, (InputMap)a2);
        SwingUtilities2.replaceUIActionMap((JComponent)a.spinner, (ActionMap)a.getActionMap());
    }

    private InputMap getInputMap(int a) {
        if (a == 1) {
            return (InputMap)UIManager.get((Object)"Spinner.ancestorInputMap");
        }
        return null;
    }

    private ActionMap getActionMap() {
        KindleSpinnerUI a;
        ActionMap a2 = (ActionMap)UIManager.get((Object)"Spinner.actionMap");
        if (a2 == null && (a2 = a.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put((Object)"Spinner.actionMap", (Object)a2);
        }
        return a2;
    }

    private ActionMap createActionMap() {
        ActionMapUIResource a = new ActionMapUIResource();
        a.put("increment", nextButtonHandler);
        a.put("decrement", previousButtonHandler);
        return a;
    }

    private static class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
            PropertyChangeHandler a;
        }

        public void propertyChange(PropertyChangeEvent a) {
            JSpinner a2;
            ComponentUI a3;
            JComponent a4;
            String a5 = a.getPropertyName();
            if (a.getSource() instanceof JSpinner) {
                JSpinner a6 = (JSpinner)a.getSource();
                ComponentUI a7 = AJComponent.accessor.getComponentUI((JComponent)a6);
                if (a7 instanceof KindleSpinnerUI) {
                    KindleSpinnerUI a8 = (KindleSpinnerUI)a7;
                    if ("editor".equals(a5)) {
                        JComponent a9 = (JComponent)a.getOldValue();
                        JComponent a10 = (JComponent)a.getNewValue();
                        a8.replaceEditor(a9, a10);
                        a8.updateEnabledState();
                    } else if ("enabled".equals(a5)) {
                        a8.updateEnabledState();
                    }
                }
            } else if (a.getSource() instanceof JComponent && (a4 = (JComponent)a.getSource()).getParent() instanceof JPanel && a4.getParent().getParent() instanceof JSpinner && "border".equals(a5) && (a3 = AJComponent.accessor.getComponentUI((JComponent)(a2 = (JSpinner)a4.getParent().getParent()))) instanceof KindleSpinnerUI) {
                KindleSpinnerUI a11 = (KindleSpinnerUI)a3;
                a11.maybeRemoveEditorBorder(a4);
            }
        }
    }

    private class SpinnerLayout
    implements LayoutManager {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;

        private SpinnerLayout() {
            SpinnerLayout a;
        }

        public void addLayoutComponent(String a, Component a2) {
            if ("Next".equals(a)) {
                a4.nextButton = a2;
            } else if ("Previous".equals(a)) {
                a4.previousButton = a2;
            } else if ("Editor".equals(a)) {
                JFormattedTextField a3;
                SpinnerLayout a4;
                a4.editor = a2;
                a4.editor.setFont(a4.KindleSpinnerUI.this.spinner.getFont());
                if (a4.editor instanceof JSpinner.DefaultEditor && (a3 = ((JSpinner.DefaultEditor)a4.editor).getTextField()) != null) {
                    a3.setFont(a4.KindleSpinnerUI.this.spinner.getFont());
                    a3.setEditable(false);
                    a3.setFocusable(false);
                    a3.setEnabled(false);
                }
            }
        }

        public void removeLayoutComponent(Component a) {
            SpinnerLayout a2;
            if (a == a2.nextButton) {
                a = null;
            } else if (a == a2.previousButton) {
                a2.previousButton = null;
            } else if (a == a2.editor) {
                a2.editor = null;
            }
        }

        private int getMaxEditorWidth() {
            SpinnerLayout a;
            FontMetrics a2 = a.editor.getFontMetrics(a.editor.getFont());
            int a3 = 0;
            SpinnerModel a4 = a.KindleSpinnerUI.this.spinner.getModel();
            if (a4 instanceof SpinnerListModel) {
                Iterator<?> a5;
                Iterator<?> iterator = a5 = ((SpinnerListModel)a4).getList().iterator();
                while (iterator.hasNext()) {
                    a3 = Math.max(a3, a2.stringWidth((String)a5.next()));
                    iterator = a5;
                }
                if (a.editor instanceof JSpinner.DefaultEditor) {
                    Insets a6 = ((JSpinner.DefaultEditor)a.editor).getTextField().getInsets();
                    a3 += a6.left + a6.right;
                    a6 = ((JSpinner.DefaultEditor)a.editor).getInsets();
                    a3 += a6.left + a6.right;
                }
            } else {
                a3 = a.preferredSize((Component)a.editor).width;
            }
            return a3;
        }

        private Dimension preferredSize(Component a) {
            return a == null ? zeroSize : a.getPreferredSize();
        }

        public Dimension preferredLayoutSize(Container a) {
            SpinnerLayout a2;
            Dimension a3 = a2.preferredSize(a2.editor);
            a2.preferredSize(a2.editor).width = Math.max(a3.width, a2.getMaxEditorWidth());
            Dimension a4 = a2.preferredSize(a2.nextButton);
            Dimension a5 = a2.preferredSize(a2.previousButton);
            Dimension a6 = new Dimension(a3.width, a3.height);
            a6.height += a4.height + a5.height;
            Insets a7 = a.getInsets();
            Insets a8 = UIManager.getInsets((Object)"Spinner.arrowButtonInsets");
            if (a8 == null) {
                a8 = DEFAULT_INSETS;
            }
            a6.height += a7.top + a7.bottom;
            a6.height += a8.top + a8.bottom;
            a6.width = Math.max(a6.width, a5.width);
            a6.width = Math.max(a6.width, a4.width);
            a6.width += a7.left + a7.right;
            Border a9 = a2.KindleSpinnerUI.this.spinner.getBorder();
            if (a9 != null) {
                Insets a10 = a9.getBorderInsets(a2.KindleSpinnerUI.this.spinner);
                a6.width += a10.left + a10.right;
                a6.height += a10.top + a10.bottom;
            }
            return a6;
        }

        public Dimension minimumLayoutSize(Container a) {
            SpinnerLayout a2;
            return a2.preferredLayoutSize(a);
        }

        private void setBounds(Component a, int a2, int a3, int a4, int a5) {
            if (a != null) {
                a.setBounds(a2, a3, a4, a5);
            }
        }

        public void layoutContainer(Container a) {
            Insets a2;
            int a3;
            SpinnerLayout a4;
            Dimension a5 = a4.preferredSize(a4.editor);
            a4.preferredSize(a4.editor).width = Math.max(a5.width, a4.getMaxEditorWidth());
            Dimension a6 = a4.preferredSize(a4.previousButton);
            Dimension a7 = a4.preferredSize(a4.nextButton);
            Insets a8 = a.getInsets();
            Border a9 = a4.KindleSpinnerUI.this.spinner.getBorder();
            if (a9 != null) {
                Insets a10 = a9.getBorderInsets(a4.KindleSpinnerUI.this.spinner);
                a8.left += a10.left;
                a8.right += a10.right;
                a8.top += a10.top;
                a8.bottom += a10.bottom;
            }
            int a11 = a3 = a8.left;
            int a12 = a3;
            int a13 = Math.max(Math.max(a6.width, a7.width), a5.width);
            if (a6.width < a13) {
                a12 += (a13 - a6.width) / 2;
            }
            if (a7.width < a13) {
                a11 += (a13 - a7.width) / 2;
            }
            if (a5.width < a13) {
                a3 += (a13 - a5.width) / 2;
            }
            if ((a2 = UIManager.getInsets((Object)"Spinner.arrowButtonInsets")) == null) {
                a2 = DEFAULT_INSETS;
            }
            int a14 = a8.top;
            a4.setBounds(a4.nextButton, a11, a14, a7.width, a7.height);
            a4.setBounds(a4.editor, a3, a14 += a6.height + a2.bottom, a5.width, a5.height);
            a4.setBounds(a4.previousButton, a12, a14 += a5.height + a2.top, a6.width, a6.height);
        }
    }

    private static class ArrowButtonHandler
    extends AbstractAction
    implements MouseListener,
    MouseMotionListener,
    UIResource {
        final Timer autoRepeatTimer;
        final boolean isNext;
        JSpinner spinner = null;
        Point point = null;

        ArrowButtonHandler(String a, boolean a2) {
            super(a);
            ArrowButtonHandler a3;
            a3.isNext = a2;
            a3.autoRepeatTimer = new Timer(120, a3);
            a3.autoRepeatTimer.setInitialDelay(300);
        }

        private JSpinner eventToSpinner(AWTEvent a) {
            Object a2 = a.getSource();
            boolean bl = a2 instanceof Component;
            while (bl && !(a2 instanceof JSpinner)) {
                a2 = ((Component)a2).getParent();
                bl = a2 instanceof Component;
            }
            return a2 instanceof JSpinner ? (JSpinner)a2 : null;
        }

        public void actionPerformed(ActionEvent a) {
            ArrowButtonHandler a2;
            JSpinner a3 = a2.spinner;
            if (!(a.getSource() instanceof Timer)) {
                a3 = a2.eventToSpinner(a);
            }
            if (a3 != null) {
                try {
                    Object a4;
                    int a5 = a2.getCalendarField(a3);
                    a3.commitEdit();
                    if (a5 != -1) {
                        ((SpinnerDateModel)a3.getModel()).setCalendarField(a5);
                    }
                    Object object = a4 = a2.isNext ? a3.getNextValue() : a3.getPreviousValue();
                    if (a4 != null) {
                        a3.setValue(a4);
                        a2.select(a3);
                    }
                }
                catch (IllegalArgumentException a6) {
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)a3);
                }
                catch (ParseException a7) {
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)a3);
                }
            }
        }

        private void select(JSpinner a) {
            JComponent a2 = a.getEditor();
            if (a2 instanceof JSpinner.DateEditor) {
                DateFormat.Field a3;
                Object a4;
                JSpinner.DateEditor a5 = (JSpinner.DateEditor)a2;
                JFormattedTextField a6 = a5.getTextField();
                SimpleDateFormat a7 = a5.getFormat();
                if (a7 != null && (a4 = a.getValue()) != null && (a3 = DateFormat.Field.ofCalendarField(a5.getModel().getCalendarField())) != null) {
                    try {
                        ArrowButtonHandler a8;
                        AttributedCharacterIterator a9 = ((Format)a7).formatToCharacterIterator(a4);
                        if (!a8.select(a6, a9, a3) && a3 == DateFormat.Field.HOUR0) {
                            a8.select(a6, a9, DateFormat.Field.HOUR1);
                        }
                    }
                    catch (IllegalArgumentException a10) {
                        // empty catch block
                    }
                }
            }
        }

        private boolean select(JFormattedTextField a, AttributedCharacterIterator a2, DateFormat.Field a3) {
            int a4 = a.getDocument().getLength();
            a2.first();
            do {
                Map<AttributedCharacterIterator.Attribute, Object> a5;
                if ((a5 = a2.getAttributes()) == null || !a5.containsKey(a3)) continue;
                int a6 = a2.getRunStart(a3);
                int a7 = a2.getRunLimit(a3);
                if (a6 != -1 && a7 != -1 && a6 <= a4 && a7 <= a4) {
                    a.select(a6, a7);
                }
                return true;
            } while (a2.next() != '\uffff');
            return false;
        }

        private int getCalendarField(JSpinner a) {
            JComponent a2 = a.getEditor();
            if (a2 instanceof JSpinner.DateEditor) {
                JFormattedTextField a3 = ((JSpinner.DateEditor)a2).getTextField();
                int a4 = a3.getSelectionStart();
                JFormattedTextField.AbstractFormatter a5 = a3.getFormatter();
                if (a5 instanceof InternationalFormatter) {
                    int a6;
                    Format.Field[] a7 = ((InternationalFormatter)a5).getFields(a4);
                    int n = a6 = 0;
                    while (n < a7.length) {
                        int a8;
                        if (a7[a6] instanceof DateFormat.Field && (a8 = a7[a6] == DateFormat.Field.HOUR1 ? 10 : ((DateFormat.Field)a7[a6]).getCalendarField()) != -1) {
                            return a8;
                        }
                        n = ++a6;
                    }
                }
            }
            return -1;
        }

        public void mousePressed(MouseEvent a) {
            if (SwingUtilities.isLeftMouseButton(a) && a.getComponent().isEnabled()) {
                ArrowButtonHandler a2;
                a2.spinner = a2.eventToSpinner(a);
                a2.autoRepeatTimer.start();
                a2.point = a.getPoint();
                a2.focusSpinnerIfNecessary();
            }
        }

        public void mouseReleased(MouseEvent a) {
            if (SwingUtilities.isLeftMouseButton(a) && a.getComponent().isEnabled()) {
                ArrowButtonHandler a2;
                a2.autoRepeatTimer.stop();
                a2.spinner = null;
                a2.point = null;
            }
        }

        public void mouseClicked(MouseEvent a) {
        }

        public void mouseEntered(MouseEvent a) {
        }

        public void mouseExited(MouseEvent a) {
        }

        public void mouseDragged(MouseEvent a) {
            ArrowButtonHandler a2;
            if (a2.point != null && (Math.abs(a.getX() - a2.point.x) > dragThreshold || Math.abs(a.getY() - a2.point.y) > dragThreshold)) {
                a2.autoRepeatTimer.stop();
                a2.spinner = null;
                a2.point = null;
            }
        }

        public void mouseMoved(MouseEvent a) {
        }

        private void focusSpinnerIfNecessary() {
            ArrowButtonHandler a;
            Component a2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (a.spinner.isRequestFocusEnabled() && (a2 == null || !SwingUtilities.isDescendingFrom(a2, a.spinner))) {
                Component a3;
                Container a4 = a.spinner;
                if (!a4.isFocusCycleRoot()) {
                    a4 = a4.getFocusCycleRootAncestor();
                }
                if (a4 != null && (a3 = a4.getFocusTraversalPolicy().getComponentAfter(a4, a.spinner)) != null && SwingUtilities.isDescendingFrom(a3, a.spinner)) {
                    a3.requestFocus();
                }
            }
        }
    }
}

