/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing.plaf.kindle;

import com.amazon.agui.swing.plaf.kindle.KindleLookAndFeel;
import com.amazon.agui.swing.plaf.kindle.KindleTheme;
import com.sun.access.swing.AJComponent;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SwingUtilities2;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ActionMapUIResource;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Set;
import javax.microedition.plaf.SliderUI;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;

public class KindleSliderUI
extends ComponentUI
implements SliderUI {
    protected final int TICK_BUFFER = 4;
    protected boolean filledSlider = false;
    protected static Color thumbColor;
    protected static Color highlightColor;
    protected static Color darkShadowColor;
    protected static boolean thumbJumpOnPress;
    protected static int trackWidth;
    protected static int tickLength;
    protected static Icon horizThumbIcon;
    protected static Icon vertThumbIcon;
    public static final int POSITIVE_SCROLL = 1;
    public static final int NEGATIVE_SCROLL = -1;
    public static final int MIN_SCROLL = -2;
    public static final int MAX_SCROLL = 2;
    protected Timer scrollTimer;
    protected JSlider slider;
    protected Insets focusInsets = null;
    protected Insets insetCache = null;
    protected Rectangle focusRect = null;
    protected Rectangle contentRect = null;
    protected Rectangle labelRect = null;
    protected Rectangle tickRect = null;
    protected Rectangle trackRect = null;
    protected Rectangle thumbRect = null;
    protected int trackBuffer = 0;
    private static final Dimension PREFERRED_HORIZONTAL_SIZE;
    private static final Dimension PREFERRED_VERTICAL_SIZE;
    private static final Dimension MINIMUM_HORIZONTAL_SIZE;
    private static final Dimension MINIMUM_VERTICAL_SIZE;
    private transient boolean isDragging;
    protected TrackListener trackListener;
    protected ChangeListener changeListener;
    protected ComponentListener componentListener;
    protected ScrollListener scrollListener;
    protected PropertyChangeListener propertyChangeListener;
    private Color shadowColor;
    private Color focusColor;
    protected final String SLIDER_FILL = "JSlider.isFilled";
    private int cellLength;
    private int cellSpacing;
    private static Rectangle unionRect;

    public static ComponentUI createUI(JComponent a) {
        return new KindleSliderUI();
    }

    public KindleSliderUI() {
        KindleSliderUI a;
    }

    public void installUI(JComponent a) {
        KindleSliderUI a2;
        trackWidth = (Integer)UIManager.get((Object)"Slider.trackWidth");
        Boolean a3 = (Boolean)UIManager.get((Object)"Slider.thumbJumpOnPress");
        if (a3 != null) {
            thumbJumpOnPress = a3;
        }
        tickLength = (Integer)UIManager.get((Object)"Slider.majorTickLength");
        horizThumbIcon = UIManager.getIcon((Object)"Slider.horizontalThumbIcon");
        vertThumbIcon = UIManager.getIcon((Object)"Slider.verticalThumbIcon");
        a2.cellLength = UIManager.getInt((Object)"Slider.cellLength");
        a2.cellSpacing = UIManager.getInt((Object)"Slider.cellSpacing");
        a2.slider = (JSlider)a;
        a2.slider.setEnabled(a2.slider.isEnabled());
        a2.slider.setOpaque(true);
        a2.isDragging = false;
        a2.trackListener = a2.createTrackListener(a2.slider);
        a2.changeListener = a2.createChangeListener(a2.slider);
        a2.componentListener = a2.createComponentListener(a2.slider);
        a2.scrollListener = a2.createScrollListener(a2.slider);
        a2.propertyChangeListener = a2.createPropertyChangeListener(a2.slider);
        a2.installDefaults(a2.slider);
        a2.installListeners(a2.slider);
        a2.installKeyboardActions(a2.slider);
        a2.scrollTimer = new Timer(100, a2.scrollListener);
        a2.scrollTimer.setInitialDelay(300);
        a2.insetCache = a2.slider.getInsets();
        a2.focusRect = new Rectangle();
        a2.contentRect = new Rectangle();
        a2.labelRect = new Rectangle();
        a2.tickRect = new Rectangle();
        a2.trackRect = new Rectangle();
        a2.thumbRect = new Rectangle();
        a2.calculateGeometry();
        thumbColor = UIManager.getColor((Object)"Slider.thumb");
        highlightColor = UIManager.getColor((Object)"Slider.highlight");
        darkShadowColor = UIManager.getColor((Object)"Slider.darkShadow");
        a2.scrollListener.setScrollByBlock(false);
        Object a4 = a.getClientProperty("JSlider.isFilled");
        if (a4 != null) {
            a2.filledSlider = (Boolean)a4;
        }
    }

    protected PropertyChangeListener createPropertyChangeListener(JSlider a) {
        KindleSliderUI a2;
        return a2.new MicroPropertyChangeListener();
    }

    public void paintThumb(Graphics a) {
        KindleSliderUI a2;
        Rectangle a3 = a2.thumbRect;
        a.translate(a3.x, a3.y);
        if (a2.slider.getOrientation() == 0) {
            horizThumbIcon.paintIcon(a2.slider, a, 0, 0);
        } else {
            vertThumbIcon.paintIcon(a2.slider, a, 0, 0);
        }
        a.translate(-a3.x, -a3.y);
    }

    public void paintTrack(Graphics a) {
        KindleSliderUI a2;
        KindleLookAndFeel.getTheme().sliderTrackIcon(a, a2.slider, a2.trackRect, a2.thumbRect, a2.getThumbOverhang(), a2.getTrackWidth(), a2.filledSlider, a2.drawInverted());
    }

    public void paintFocus(Graphics a) {
    }

    protected Dimension getThumbSize() {
        KindleSliderUI a;
        Dimension a2 = new Dimension();
        if (a.slider.getOrientation() == 1) {
            a2.width = vertThumbIcon.getIconWidth();
            a2.height = vertThumbIcon.getIconHeight();
        } else {
            a2.width = horizThumbIcon.getIconWidth();
            a2.height = horizThumbIcon.getIconHeight();
        }
        return a2;
    }

    public int getTickLength() {
        KindleSliderUI a;
        return a.slider.getOrientation() == 0 ? tickLength + 4 + 1 : tickLength + 4 + 3;
    }

    protected int getTrackWidth() {
        KindleSliderUI a;
        double a2 = 7.0;
        double a3 = 16.0;
        double a4 = 0.4375;
        if (a.slider.getOrientation() == 0) {
            return (int)(0.4375 * (double)a.thumbRect.height);
        }
        return (int)(0.4375 * (double)a.thumbRect.width);
    }

    protected int getTrackLength() {
        KindleSliderUI a;
        if (a.slider.getOrientation() == 0) {
            return a.trackRect.width;
        }
        return a.trackRect.height;
    }

    protected int getThumbOverhang() {
        KindleSliderUI a;
        return (a.getThumbSize().height - a.getTrackWidth()) / 2;
    }

    protected void scrollDueToClickInTrack(int a) {
        KindleSliderUI a2;
        a2.scrollByUnit(a);
    }

    private void scrollToClickLocation(Point a) {
        KindleSliderUI a2;
        if (a2.slider.getOrientation() == 0) {
            a2.slider.setValue((int)((float)a.x / (float)a2.slider.getWidth() * (float)(a2.slider.getMaximum() - a2.slider.getMinimum())));
        } else {
            a2.slider.setValue((int)((float)(a2.slider.getMaximum() - a2.slider.getMinimum()) - (float)a.y / (float)a2.slider.getHeight() * (float)(a2.slider.getMaximum() - a2.slider.getMinimum())));
        }
    }

    protected void paintMinorTickForHorizSlider(Graphics a, Rectangle a2, int a3) {
        KindleSliderUI a4;
        a.setColor(a4.slider.isEnabled() ? a4.slider.getForeground() : KindleLookAndFeel.getControlShadow());
        a.drawLine(a3, 4, a3, 4 + tickLength / 2);
    }

    protected void paintMajorTickForHorizSlider(Graphics a, Rectangle a2, int a3) {
        KindleSliderUI a4;
        a.setColor(a4.slider.isEnabled() ? a4.slider.getForeground() : KindleLookAndFeel.getControlShadow());
        a.drawLine(a3, 4, a3, 4 + (tickLength - 1));
    }

    protected void paintMinorTickForVertSlider(Graphics a, Rectangle a2, int a3) {
        KindleSliderUI a4;
        a.setColor(a4.slider.isEnabled() ? a4.slider.getForeground() : KindleLookAndFeel.getControlShadow());
        a.drawLine(4, a3, 4 + tickLength / 2, a3);
    }

    protected void paintMajorTickForVertSlider(Graphics a, Rectangle a2, int a3) {
        KindleSliderUI a4;
        a.setColor(a4.slider.isEnabled() ? a4.slider.getForeground() : KindleLookAndFeel.getControlShadow());
        a.drawLine(4, a3, 4 + tickLength, a3);
    }

    protected Color getShadowColor() {
        KindleSliderUI a;
        return a.shadowColor;
    }

    protected Color getHighlightColor() {
        return highlightColor;
    }

    protected Color getFocusColor() {
        KindleSliderUI a;
        return a.focusColor;
    }

    public void uninstallUI(JComponent a) {
        KindleSliderUI a2;
        if (a != a2.slider) {
            throw new IllegalComponentStateException(a2 + " was asked to deinstall() " + a + " when it only knows about " + a2.slider + ".");
        }
        LookAndFeel.uninstallBorder((JComponent)a2.slider);
        a2.scrollTimer.stop();
        a2.scrollTimer = null;
        a2.uninstallListeners(a2.slider);
        a2.uninstallKeyboardActions(a2.slider);
        a2.focusInsets = null;
        a2.insetCache = null;
        a2.focusRect = null;
        a2.contentRect = null;
        a2.labelRect = null;
        a2.tickRect = null;
        a2.trackRect = null;
        a2.thumbRect = null;
        a2.trackListener = null;
        a2.changeListener = null;
        a2.componentListener = null;
        a2.scrollListener = null;
        a2.propertyChangeListener = null;
        a2.slider = null;
    }

    protected void installDefaults(JSlider a) {
        LookAndFeel.installBorder((JComponent)a, (String)"Slider.border");
        LookAndFeel.installColors((JComponent)a, (String)"Slider.background", (String)"Slider.foreground");
        highlightColor = UIManager.getColor((Object)"Slider.highlight");
        a.shadowColor = UIManager.getColor((Object)"Slider.shadow");
        a.focusColor = UIManager.getColor((Object)"Slider.focus");
        a.focusInsets = (Insets)UIManager.get((Object)"Slider.focusInsets");
        a.setFocusTraversalKeys(0, (Set)UIManager.get((Object)"Slider.forwardTraversalKeys"));
        a.setFocusTraversalKeys(1, (Set)UIManager.get((Object)"Slider.backwardTraversalKeys"));
        a.setFocusTraversalKeys(2, (Set)UIManager.get((Object)"Slider.upCycleTraversalKeys"));
        a.setFocusTraversalKeys(3, (Set)UIManager.get((Object)"Slider.downCycleTraversalKeys"));
    }

    protected TrackListener createTrackListener(JSlider a) {
        KindleSliderUI a2;
        return a2.new TrackListener();
    }

    protected ChangeListener createChangeListener(JSlider a) {
        KindleSliderUI a2;
        return a2.new ChangeHandler();
    }

    protected ComponentListener createComponentListener(JSlider a) {
        KindleSliderUI a2;
        return a2.new ComponentHandler();
    }

    protected ScrollListener createScrollListener(JSlider a) {
        KindleSliderUI a2;
        return a2.new ScrollListener();
    }

    protected void installListeners(JSlider a) {
        KindleSliderUI a2;
        a.addMouseListener(a2.trackListener);
        a.addMouseMotionListener(a2.trackListener);
        a.addComponentListener(a2.componentListener);
        a.addPropertyChangeListener(a2.propertyChangeListener);
        a.getModel().addChangeListener(a2.changeListener);
    }

    protected void uninstallListeners(JSlider a) {
        KindleSliderUI a2;
        a.removeMouseListener(a2.trackListener);
        a.removeMouseMotionListener(a2.trackListener);
        a.removeComponentListener(a2.componentListener);
        a.removePropertyChangeListener(a2.propertyChangeListener);
        a.getModel().removeChangeListener(a2.changeListener);
    }

    protected void installKeyboardActions(JSlider a) {
        KindleSliderUI a2;
        InputMap a3 = a2.getInputMap(0);
        SwingUtilities2.replaceUIInputMap((JComponent)a, (int)0, (InputMap)a3);
        ActionMap a4 = a2.getActionMap();
        SwingUtilities2.replaceUIActionMap((JComponent)a, (ActionMap)a4);
    }

    InputMap getInputMap(int a) {
        if (a == 0) {
            return (InputMap)UIManager.get((Object)"Slider.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        KindleSliderUI a;
        ActionMap a2 = (ActionMap)UIManager.get((Object)"Slider.actionMap");
        if (a2 == null && (a2 = a.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put((Object)"Slider.actionMap", (Object)a2);
        }
        return a2;
    }

    ActionMap createActionMap() {
        ActionMapUIResource a = new ActionMapUIResource();
        a.put("downKey", new DownScroller(-1, false));
        a.put("rightKey", new RightScroller(1, false));
        a.put("upKey", new UpScroller(1, false));
        a.put("leftKey", new LeftScroller(-1, false));
        return a;
    }

    protected void uninstallKeyboardActions(JSlider a) {
        SwingUtilities2.replaceUIActionMap((JComponent)a, null);
        SwingUtilities2.replaceUIInputMap((JComponent)a, (int)0, null);
    }

    public Dimension getPreferredHorizontalSize() {
        return PREFERRED_HORIZONTAL_SIZE;
    }

    public Dimension getPreferredVerticalSize() {
        return PREFERRED_VERTICAL_SIZE;
    }

    public Dimension getMinimumHorizontalSize() {
        return MINIMUM_HORIZONTAL_SIZE;
    }

    public Dimension getMinimumVerticalSize() {
        return MINIMUM_VERTICAL_SIZE;
    }

    public Dimension getPreferredSize(JComponent a) {
        Dimension a2;
        KindleSliderUI a3;
        a3.recalculateIfInsetsChanged();
        if (a3.slider.getOrientation() == 1) {
            a2 = new Dimension(a3.getPreferredVerticalSize());
            new Dimension(a3.getPreferredVerticalSize()).width = a3.insetCache.left + a3.insetCache.right;
            a2.width += a3.focusInsets.left + a3.focusInsets.right;
            a2.width += a3.trackRect.width + a3.tickRect.width + a3.labelRect.width;
        } else {
            a2 = new Dimension(a3.getPreferredHorizontalSize());
            new Dimension(a3.getPreferredHorizontalSize()).height = a3.insetCache.top + a3.insetCache.bottom;
            a2.height += a3.focusInsets.top + a3.focusInsets.bottom;
            a2.height += a3.trackRect.height + a3.tickRect.height + a3.labelRect.height;
        }
        return a2;
    }

    public Dimension getMinimumSize(JComponent a) {
        Dimension a2;
        KindleSliderUI a3;
        a3.recalculateIfInsetsChanged();
        if (a3.slider.getOrientation() == 1) {
            a2 = new Dimension(a3.getMinimumVerticalSize());
            new Dimension(a3.getMinimumVerticalSize()).width = a3.insetCache.left + a3.insetCache.right;
            a2.width += a3.focusInsets.left + a3.focusInsets.right;
            a2.width += a3.trackRect.width + a3.tickRect.width + a3.labelRect.width;
        } else {
            a2 = new Dimension(a3.getMinimumHorizontalSize());
            new Dimension(a3.getMinimumHorizontalSize()).height = a3.insetCache.top + a3.insetCache.bottom;
            a2.height += a3.focusInsets.top + a3.focusInsets.bottom;
            a2.height += a3.trackRect.height + a3.tickRect.height + a3.labelRect.height;
        }
        return a2;
    }

    public Dimension getMaximumSize(JComponent a) {
        KindleSliderUI a2;
        Dimension a3 = a2.getPreferredSize(a);
        if (a2.slider.getOrientation() == 1) {
            a3.height = Short.MAX_VALUE;
        } else {
            a3.width = Short.MAX_VALUE;
        }
        return a3;
    }

    protected void calculateGeometry() {
        KindleSliderUI a;
        a.calculateFocusRect();
        a.calculateContentRect();
        a.calculateThumbSize();
        a.calculateTrackBuffer();
        a.calculateTrackRect();
        a.calculateTickRect();
        a.calculateLabelRect();
        a.calculateThumbLocation();
    }

    protected void calculateFocusRect() {
        KindleSliderUI a;
        a.focusRect.x = a.insetCache.left;
        a.focusRect.y = a.insetCache.top;
        a.focusRect.width = a.slider.getWidth() - (a.insetCache.left + a.insetCache.right);
        a.focusRect.height = a.slider.getHeight() - (a.insetCache.top + a.insetCache.bottom);
    }

    protected void calculateThumbSize() {
        KindleSliderUI a;
        Dimension a2 = a.getThumbSize();
        a.thumbRect.setSize(a2.width, a2.height);
    }

    protected void calculateContentRect() {
        KindleSliderUI a;
        a.contentRect.x = a.focusRect.x + a.focusInsets.left;
        a.contentRect.y = a.focusRect.y + a.focusInsets.top;
        a.contentRect.width = a.focusRect.width - (a.focusInsets.left + a.focusInsets.right);
        a.contentRect.height = a.focusRect.height - (a.focusInsets.top + a.focusInsets.bottom);
    }

    protected void calculateThumbLocation() {
        int a;
        KindleSliderUI a2;
        if (a2.slider.getSnapToTicks()) {
            int a3 = a = a2.slider.getValue();
            int a4 = a2.slider.getMajorTickSpacing();
            int a5 = a2.slider.getMinorTickSpacing();
            int a6 = 0;
            if (a5 > 0) {
                a6 = a5;
            } else if (a4 > 0) {
                a6 = a4;
            }
            if (a6 != 0) {
                if ((a - a2.slider.getMinimum()) % a6 != 0) {
                    int a7 = Math.round((float)(a - a2.slider.getMinimum()) / (float)a6);
                    a3 = a2.slider.getMinimum() + a7 * a6;
                }
                if (a3 != a) {
                    a2.slider.setValue(a3);
                }
            }
        }
        if (a2.slider.getOrientation() == 0) {
            a = a2.xPositionForValue(a2.slider.getValue());
            a2.thumbRect.x = a - a2.thumbRect.width / 2;
            a2.thumbRect.y = a2.trackRect.y;
        } else {
            a = a2.yPositionForValue(a2.slider.getValue());
            a2.thumbRect.x = a2.trackRect.x;
            a2.thumbRect.y = a - a2.thumbRect.height / 2;
        }
    }

    protected void calculateTrackBuffer() {
        KindleSliderUI a;
        if (a.slider.getPaintLabels() && a.slider.getLabelTable() != null) {
            Component a2 = a.getHighestValueLabel();
            Component a3 = a.getLowestValueLabel();
            if (a.slider.getOrientation() == 0) {
                a.trackBuffer = Math.max(a2.getBounds().width, a3.getBounds().width) / 2;
                a.trackBuffer = Math.max(a.trackBuffer, a.thumbRect.width / 2);
            } else {
                a.trackBuffer = Math.max(a2.getBounds().height, a3.getBounds().height) / 2;
                a.trackBuffer = Math.max(a.trackBuffer, a.thumbRect.height / 2);
            }
        } else {
            a.trackBuffer = a.slider.getOrientation() == 0 ? a.thumbRect.width / 2 : a.thumbRect.height / 2;
        }
    }

    protected void calculateTrackRect() {
        KindleSliderUI a;
        int a2 = 0;
        if (a.slider.getOrientation() == 0) {
            a2 = a.thumbRect.height;
            if (a.slider.getPaintTicks()) {
                a2 += a.getTickLength();
            }
            if (a.slider.getPaintLabels()) {
                a2 += a.getHeightOfTallestLabel();
            }
            a.trackRect.x = a.contentRect.x + a.trackBuffer;
            a.trackRect.y = a.contentRect.y + (a.contentRect.height - a2 - 1) / 2;
            a.trackRect.width = a.contentRect.width - a.trackBuffer * 2;
            a.trackRect.height = a.thumbRect.height;
        } else {
            a2 = a.thumbRect.width;
            if (a.slider.getPaintTicks()) {
                a2 += a.getTickLength();
            }
            if (a.slider.getPaintLabels()) {
                a2 += a.getWidthOfWidestLabel();
            }
            a.trackRect.x = a.contentRect.x + (a.contentRect.width - a2 - 1) / 2;
            a.trackRect.y = a.contentRect.y + a.trackBuffer;
            a.trackRect.width = a.thumbRect.width;
            a.trackRect.height = a.contentRect.height - a.trackBuffer * 2;
        }
    }

    protected void calculateTickRect() {
        KindleSliderUI a;
        if (a.slider.getOrientation() == 0) {
            a.tickRect.x = a.trackRect.x;
            a.tickRect.y = a.trackRect.y + a.trackRect.height;
            a.tickRect.width = a.trackRect.width;
            a.tickRect.height = a.getTickLength();
            if (!a.slider.getPaintTicks()) {
                --a.tickRect.y;
                a.tickRect.height = 0;
            }
        } else {
            a.tickRect.x = a.trackRect.x + a.trackRect.width;
            a.tickRect.width = a.getTickLength();
            a.tickRect.y = a.trackRect.y;
            a.tickRect.height = a.trackRect.height;
            if (!a.slider.getPaintTicks()) {
                --a.tickRect.x;
                a.tickRect.width = 0;
            }
        }
    }

    protected void calculateLabelRect() {
        KindleSliderUI a;
        if (a.slider.getPaintLabels()) {
            if (a.slider.getOrientation() == 0) {
                a.labelRect.x = a.tickRect.x - a.trackBuffer;
                a.labelRect.y = a.tickRect.y + a.tickRect.height;
                a.labelRect.width = a.tickRect.width + a.trackBuffer * 2;
                a.labelRect.height = a.getHeightOfTallestLabel();
            } else {
                a.labelRect.x = a.tickRect.x + a.tickRect.width;
                a.labelRect.width = a.getWidthOfWidestLabel();
                a.labelRect.y = a.tickRect.y - a.trackBuffer;
                a.labelRect.height = a.tickRect.height + a.trackBuffer * 2;
            }
        } else if (a.slider.getOrientation() == 0) {
            a.labelRect.x = a.tickRect.x;
            a.labelRect.y = a.tickRect.y + a.tickRect.height;
            a.labelRect.width = a.tickRect.width;
            a.labelRect.height = 0;
        } else {
            a.labelRect.x = a.tickRect.x + a.tickRect.width;
            a.labelRect.y = a.tickRect.y;
            a.labelRect.width = 0;
            a.labelRect.height = a.tickRect.height;
        }
    }

    protected int getWidthOfWidestLabel() {
        KindleSliderUI a;
        Dictionary a2 = a.slider.getLabelTable();
        int a3 = 0;
        if (a2 != null) {
            Enumeration a4;
            Enumeration enumeration = a4 = a2.keys();
            while (enumeration.hasMoreElements()) {
                a3 = Math.max(((Component)a2.get(a4.nextElement())).getPreferredSize().width, a3);
                enumeration = a4;
            }
        }
        return a3;
    }

    protected int getHeightOfTallestLabel() {
        KindleSliderUI a;
        Dictionary a2 = a.slider.getLabelTable();
        int a3 = 0;
        if (a2 != null) {
            Enumeration a4;
            Enumeration enumeration = a4 = a2.keys();
            while (enumeration.hasMoreElements()) {
                a3 = Math.max(((Component)a2.get(a4.nextElement())).getPreferredSize().height, a3);
                enumeration = a4;
            }
        }
        return a3;
    }

    protected int getWidthOfHighValueLabel() {
        KindleSliderUI a;
        Component a2 = a.getHighestValueLabel();
        int a3 = 0;
        if (a2 != null) {
            a3 = a2.getPreferredSize().width;
        }
        return a3;
    }

    protected int getWidthOfLowValueLabel() {
        KindleSliderUI a;
        Component a2 = a.getLowestValueLabel();
        int a3 = 0;
        if (a2 != null) {
            a3 = a2.getPreferredSize().width;
        }
        return a3;
    }

    protected int getHeightOfHighValueLabel() {
        KindleSliderUI a;
        Component a2 = a.getHighestValueLabel();
        int a3 = 0;
        if (a2 != null) {
            a3 = a2.getPreferredSize().height;
        }
        return a3;
    }

    protected int getHeightOfLowValueLabel() {
        KindleSliderUI a;
        Component a2 = a.getLowestValueLabel();
        int a3 = 0;
        if (a2 != null) {
            a3 = a2.getPreferredSize().height;
        }
        return a3;
    }

    protected boolean drawInverted() {
        KindleSliderUI a;
        return a.slider.getInverted();
    }

    protected Component getLowestValueLabel() {
        Enumeration a;
        KindleSliderUI a2;
        Dictionary a3 = a2.slider.getLabelTable();
        Component a4 = null;
        if (a3 != null && (a = a3.keys()).hasMoreElements()) {
            int a5 = (Integer)a.nextElement();
            Enumeration enumeration = a;
            while (enumeration.hasMoreElements()) {
                a5 = Math.min((Integer)a.nextElement(), a5);
                enumeration = a;
            }
            a4 = (Component)a3.get(new Integer(a5));
        }
        return a4;
    }

    protected Component getHighestValueLabel() {
        Enumeration a;
        KindleSliderUI a2;
        Dictionary a3 = a2.slider.getLabelTable();
        Component a4 = null;
        if (a3 != null && (a = a3.keys()).hasMoreElements()) {
            int a5 = (Integer)a.nextElement();
            Enumeration enumeration = a;
            while (enumeration.hasMoreElements()) {
                a5 = Math.max((Integer)a.nextElement(), a5);
                enumeration = a;
            }
            a4 = (Component)a3.get(new Integer(a5));
        }
        return a4;
    }

    private void paintKindleSlider(Graphics a, JComponent a2) {
        KindleSliderUI a3;
        Graphics2D a4 = (Graphics2D)a;
        AlphaComposite a5 = AlphaComposite.getInstance(2, 1.0f);
        a4.setComposite(a5);
        float[] a6 = new float[]{a3.cellLength, a3.cellSpacing};
        a4.setStroke(new BasicStroke(a3.cellLength, 0, 0, 1.0f, a6, 0.0f));
        if (a3.slider.getOrientation() == 0) {
            if (a3.cellLength + a3.cellSpacing > a3.contentRect.width) {
                return;
            }
            int a7 = (a3.contentRect.width - a3.cellSpacing) / (a3.cellLength + a3.cellSpacing);
            int a8 = (int)((float)a7 * ((float)a3.slider.getValue() / (float)(a3.slider.getMaximum() - a3.slider.getMinimum())));
            float a9 = (a3.contentRect.y + a3.contentRect.height) / 2;
            Line2D.Float a10 = new Line2D.Float(a3.contentRect.x + a3.cellSpacing, a9, (a3.cellLength + a3.cellSpacing) * a7, a9);
            a4.setColor((Color)KindleTheme.COLOR_WHITE);
            a4.draw(a10);
            if (a8 > 0) {
                a10 = new Line2D.Float(a3.contentRect.x + a3.cellSpacing, a9, a3.contentRect.x + a3.cellSpacing + (a3.cellLength + a3.cellSpacing) * a8, a9);
                a4.setColor(a3.slider.getForeground());
                a4.draw(a10);
            }
            a3.slider.putClientProperty("slider.total.boxes", new Integer(a7));
        } else {
            if (a3.cellLength + a3.cellSpacing > a3.contentRect.height) {
                return;
            }
            int a11 = a3.slider.getMaximum() - a3.slider.getMinimum();
            int a12 = (a3.contentRect.height - a3.cellSpacing) / (a3.cellLength + a3.cellSpacing);
            int a13 = (int)((float)a12 * ((float)(a11 - a3.slider.getValue()) / (float)a11));
            float a14 = (a3.contentRect.x + a3.contentRect.width) / 2;
            Line2D.Float a15 = new Line2D.Float(a14, a3.contentRect.y + a3.cellSpacing, a14, (a3.cellLength + a3.cellSpacing) * a12);
            a4.setColor((Color)KindleTheme.COLOR_WHITE);
            a4.draw(a15);
            if (a13 > 0) {
                a15 = new Line2D.Float(a14, a3.contentRect.y + a3.cellSpacing, a14, a3.contentRect.y + a3.cellSpacing + (a3.cellLength + a3.cellSpacing) * a13);
                a4.setColor(a3.slider.getForeground());
                a4.draw(a15);
            }
            a3.slider.putClientProperty("slider.total.boxes", new Integer(a12));
        }
    }

    public void paint(Graphics a, JComponent a2) {
        boolean a3;
        KindleSliderUI a4;
        a4.recalculateIfInsetsChanged();
        Rectangle a5 = a.getClipBounds();
        boolean bl = a3 = a2.getClientProperty("classic.look") != null;
        if (!a3) {
            a4.paintKindleSlider(a, a2);
            return;
        }
        if (!a5.intersects(a4.trackRect) && a4.slider.getPaintTrack()) {
            a4.calculateGeometry();
        }
        if (a4.slider.getPaintTrack() && a5.intersects(a4.trackRect)) {
            a4.paintTrack(a);
        }
        if (a4.slider.getPaintTicks() && a5.intersects(a4.tickRect)) {
            a4.paintTicks(a);
        }
        if (a4.slider.getPaintLabels() && a5.intersects(a4.labelRect)) {
            a4.paintLabels(a);
        }
        if (a4.slider.hasFocus() && a5.intersects(a4.focusRect)) {
            a4.paintFocus(a);
        }
        if (a5.intersects(a4.thumbRect)) {
            a4.paintThumb(a);
        }
    }

    protected void recalculateIfInsetsChanged() {
        KindleSliderUI a;
        Insets a2 = a.slider.getInsets();
        if (!a2.equals(a.insetCache)) {
            a.insetCache = a2;
            a.calculateGeometry();
        }
    }

    public void paintTicks(Graphics a) {
        KindleSliderUI a2;
        Rectangle a3 = a2.tickRect;
        int a4 = a3.width;
        int a5 = a3.height;
        a.setColor(a2.slider.getBackground());
        a.fillRect(a3.x, a3.y, a3.width, a3.height);
        a.setColor(Color.black);
        int a6 = a2.slider.getMajorTickSpacing();
        int a7 = a2.slider.getMinorTickSpacing();
        if (a2.slider.getOrientation() == 0) {
            a.translate(0, a3.y);
            int a8 = a2.slider.getMinimum();
            int a9 = 0;
            if (a2.slider.getMinorTickSpacing() > 0) {
                int n = a8;
                while (n <= a2.slider.getMaximum()) {
                    a9 = a2.xPositionForValue(a8);
                    a2.paintMinorTickForHorizSlider(a, a3, a9);
                    n = a8 + a2.slider.getMinorTickSpacing();
                }
            }
            if (a2.slider.getMajorTickSpacing() > 0) {
                int n = a8 = a2.slider.getMinimum();
                while (n <= a2.slider.getMaximum()) {
                    a9 = a2.xPositionForValue(a8);
                    a2.paintMajorTickForHorizSlider(a, a3, a9);
                    n = a8 + a2.slider.getMajorTickSpacing();
                }
            }
            a.translate(0, -a3.y);
        } else {
            a.translate(a3.x, 0);
            int a10 = a2.slider.getMinimum();
            int a11 = 0;
            if (a2.slider.getMinorTickSpacing() > 0) {
                boolean a12 = false;
                int n = a10;
                while (n <= a2.slider.getMaximum()) {
                    a11 = a2.yPositionForValue(a10);
                    a2.paintMinorTickForVertSlider(a, a3, a11);
                    n = a10 + a2.slider.getMinorTickSpacing();
                }
            }
            if (a2.slider.getMajorTickSpacing() > 0) {
                int n = a10 = a2.slider.getMinimum();
                while (n <= a2.slider.getMaximum()) {
                    a11 = a2.yPositionForValue(a10);
                    a2.paintMajorTickForVertSlider(a, a3, a11);
                    n = a10 + a2.slider.getMajorTickSpacing();
                }
            }
            a.translate(-a3.x, 0);
        }
    }

    public void paintLabels(Graphics a) {
        KindleSliderUI a2;
        Rectangle a3 = a2.labelRect;
        Dictionary a4 = a2.slider.getLabelTable();
        if (a4 != null) {
            Enumeration a5 = a4.keys();
            int a6 = a2.slider.getMinimum();
            int a7 = a2.slider.getMaximum();
            Graphics2D a8 = (Graphics2D)a;
            Composite a9 = a8.getComposite();
            a8.setComposite(AlphaComposite.SrcOver);
            while (a5.hasMoreElements()) {
                Integer a10 = (Integer)a5.nextElement();
                int a11 = a10;
                if (a11 < a6 || a11 > a7) continue;
                Component a12 = (Component)a4.get(a10);
                if (a2.slider.getOrientation() == 0) {
                    a.translate(0, a3.y);
                    a2.paintHorizontalLabel(a, a11, a12);
                    a.translate(0, -a3.y);
                    continue;
                }
                int a13 = 0;
                a.translate(a3.x + a13, 0);
                a2.paintVerticalLabel(a, a11, a12);
                a.translate(-a3.x - a13, 0);
            }
            a8.setComposite(a9);
        }
    }

    protected void paintHorizontalLabel(Graphics a, int a2, Component a3) {
        KindleSliderUI a4;
        int a5 = a4.xPositionForValue(a2) - a3.getPreferredSize().width / 2;
        Icon a6 = ((JLabel)a3).getIcon();
        if (a6 != null) {
            a6.paintIcon(a4.slider, a, a5, 0);
        }
        if (((JLabel)a3).getText() != null) {
            a.setColor(a4.slider.isEnabled() ? a4.slider.getForeground() : KindleLookAndFeel.getControlShadow());
            a.drawString(((JLabel)a3).getText(), a5, 10);
        }
    }

    protected void paintVerticalLabel(Graphics a, int a2, Component a3) {
        KindleSliderUI a4;
        int a5 = a4.yPositionForValue(a2) - a3.getPreferredSize().height / 2;
        Icon a6 = ((JLabel)a3).getIcon();
        if (a6 != null) {
            a6.paintIcon(a4.slider, a, 0, a5);
        }
        if (((JLabel)a3).getText() != null) {
            a.setColor(a4.slider.isEnabled() ? a4.slider.getForeground() : KindleLookAndFeel.getControlShadow());
            a.drawString(((JLabel)a3).getText(), 0, a5 + 10);
        }
    }

    public void setThumbLocation(int a, int a2) {
        KindleSliderUI a3;
        unionRect.setBounds(a3.thumbRect);
        a3.thumbRect.setLocation(a, a2);
        SwingUtilities.computeUnion(a3.thumbRect.x, a3.thumbRect.y, a3.thumbRect.width, a3.thumbRect.height, unionRect);
        a3.slider.repaint(KindleSliderUI.unionRect.x, KindleSliderUI.unionRect.y, KindleSliderUI.unionRect.width, KindleSliderUI.unionRect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int a) {
        KindleSliderUI a2;
        JSlider jSlider = a2.slider;
        synchronized (jSlider) {
            int a3 = a2.slider.getValue();
            int a4 = (a2.slider.getMaximum() - a2.slider.getMinimum()) / 10;
            if (a4 <= 0 && a2.slider.getMaximum() > a2.slider.getMinimum()) {
                a4 = 1;
            }
            int a5 = a4 * (a > 0 ? 1 : -1);
            a2.slider.setValue(a3 + a5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int a) {
        KindleSliderUI a2;
        JSlider jSlider = a2.slider;
        synchronized (jSlider) {
            int a3 = a2.slider.getValue();
            int a4 = 1 * (a > 0 ? 1 : -1);
            a2.slider.setValue(a3 + a4);
        }
    }

    protected int xPositionForValue(int a) {
        int a2;
        KindleSliderUI a3;
        int a4 = a3.slider.getMinimum();
        int a5 = a3.slider.getMaximum();
        int a6 = a3.trackRect.width;
        double a7 = (double)a5 - (double)a4;
        double a8 = (double)a6 / a7;
        int a9 = a3.trackRect.x;
        int a10 = a3.trackRect.x + (a3.trackRect.width - 1);
        if (!a3.drawInverted()) {
            a2 = a9;
            a2 = (int)((long)a2 + Math.round(a8 * ((double)a - (double)a4)));
        } else {
            a2 = a10;
            a2 = (int)((long)a2 - Math.round(a8 * ((double)a - (double)a4)));
        }
        a2 = Math.max(a9, a2);
        a2 = Math.min(a10, a2);
        return a2;
    }

    protected int yPositionForValue(int a) {
        int a2;
        KindleSliderUI a3;
        int a4 = a3.slider.getMinimum();
        int a5 = a3.slider.getMaximum();
        int a6 = a3.trackRect.height;
        double a7 = (double)a5 - (double)a4;
        double a8 = (double)a6 / a7;
        int a9 = a3.trackRect.y;
        int a10 = a3.trackRect.y + (a3.trackRect.height - 1);
        if (!a3.drawInverted()) {
            a2 = a9;
            a2 = (int)((long)a2 + Math.round(a8 * ((double)a5 - (double)a)));
        } else {
            a2 = a9;
            a2 = (int)((long)a2 + Math.round(a8 * ((double)a - (double)a4)));
        }
        a2 = Math.max(a9, a2);
        a2 = Math.min(a10, a2);
        return a2;
    }

    public int valueForYPosition(int a) {
        int a2;
        KindleSliderUI a3;
        int a4 = a3.slider.getMinimum();
        int a5 = a3.slider.getMaximum();
        int a6 = a3.trackRect.height;
        int a7 = a3.trackRect.y;
        int a8 = a3.trackRect.y + (a3.trackRect.height - 1);
        if (a <= a7) {
            a2 = a3.drawInverted() ? a4 : a5;
        } else if (a >= a8) {
            a2 = a3.drawInverted() ? a5 : a4;
        } else {
            int a9 = a - a7;
            double a10 = ((double)a5 - (double)a4) / (double)a6;
            int a11 = (int)Math.round((double)a9 * a10);
            a2 = a3.drawInverted() ? a4 + a11 : a5 - a11;
        }
        return a2;
    }

    public int valueForXPosition(int a) {
        int a2;
        KindleSliderUI a3;
        int a4 = a3.slider.getMinimum();
        int a5 = a3.slider.getMaximum();
        int a6 = a3.trackRect.width;
        int a7 = a3.trackRect.x;
        int a8 = a3.trackRect.x + (a3.trackRect.width - 1);
        if (a <= a7) {
            a2 = a3.drawInverted() ? a5 : a4;
        } else if (a >= a8) {
            a2 = a3.drawInverted() ? a4 : a5;
        } else {
            int a9 = a - a7;
            double a10 = ((double)a5 - (double)a4) / (double)a6;
            int a11 = (int)Math.round((double)a9 * a10);
            a2 = a3.drawInverted() ? a5 - a11 : a4 + a11;
        }
        return a2;
    }

    static {
        thumbJumpOnPress = false;
        PREFERRED_HORIZONTAL_SIZE = new Dimension(200, 21);
        PREFERRED_VERTICAL_SIZE = new Dimension(21, 200);
        MINIMUM_HORIZONTAL_SIZE = new Dimension(36, 21);
        MINIMUM_VERTICAL_SIZE = new Dimension(21, 36);
        unionRect = new Rectangle();
    }

    static class RightScroller
    extends AbstractAction {
        int dir;
        boolean block;

        public RightScroller(int a, boolean a2) {
            RightScroller a3;
            a3.dir = a;
            a3.block = a2;
        }

        public void actionPerformed(ActionEvent a) {
            ((JSlider)a.getSource()).transferFocus();
        }
    }

    static class UpScroller
    extends AbstractAction {
        int dir;
        boolean block;

        public UpScroller(int a, boolean a2) {
            UpScroller a3;
            a3.dir = a;
            a3.block = a2;
        }

        public void actionPerformed(ActionEvent a) {
            UpScroller a2;
            JSlider a3 = (JSlider)a.getSource();
            if (a2.dir == -1 || a2.dir == 1) {
                int a4 = a2.dir;
                KindleSliderUI a5 = (KindleSliderUI)AJComponent.accessor.getComponentUI((JComponent)a3);
                if (a3.getInverted()) {
                    int n = a4 = a2.dir == -1 ? 1 : -1;
                }
                if (a2.block) {
                    a5.scrollByBlock(a4);
                } else {
                    a5.scrollByUnit(a4);
                }
            } else if (a3.getInverted()) {
                if (a2.dir == -2) {
                    a3.setValue(a3.getMaximum());
                } else if (a2.dir == 2) {
                    a3.setValue(a3.getMinimum());
                }
            } else if (a2.dir == -2) {
                a3.setValue(a3.getMinimum());
            } else if (a2.dir == 2) {
                a3.setValue(a3.getMaximum());
            }
        }
    }

    static class LeftScroller
    extends AbstractAction {
        int dir;
        boolean block;

        public LeftScroller(int a, boolean a2) {
            LeftScroller a3;
            a3.dir = a;
            a3.block = a2;
        }

        public void actionPerformed(ActionEvent a) {
            ((JSlider)a.getSource()).transferFocusBackward();
        }
    }

    static class DownScroller
    extends AbstractAction {
        int dir;
        boolean block;

        public DownScroller(int a, boolean a2) {
            DownScroller a3;
            a3.dir = a;
            a3.block = a2;
        }

        public void actionPerformed(ActionEvent a) {
            DownScroller a2;
            JSlider a3 = (JSlider)a.getSource();
            if (a2.dir == -1 || a2.dir == 1) {
                int a4 = a2.dir;
                KindleSliderUI a5 = (KindleSliderUI)AJComponent.accessor.getComponentUI((JComponent)a3);
                if (a3.getInverted()) {
                    int n = a4 = a2.dir == -1 ? 1 : -1;
                }
                if (a2.block) {
                    a5.scrollByBlock(a4);
                } else {
                    a5.scrollByUnit(a4);
                }
            } else if (a3.getInverted()) {
                if (a2.dir == -2) {
                    a3.setValue(a3.getMaximum());
                } else if (a2.dir == 2) {
                    a3.setValue(a3.getMinimum());
                }
            } else if (a2.dir == -2) {
                a3.setValue(a3.getMinimum());
            } else if (a2.dir == 2) {
                a3.setValue(a3.getMaximum());
            }
        }
    }

    public class ComponentHandler
    extends ComponentAdapter {
        public ComponentHandler() {
            ComponentHandler a;
        }

        public void componentResized(ComponentEvent a) {
            ComponentHandler a2;
            a2.KindleSliderUI.this.calculateGeometry();
            a2.KindleSliderUI.this.slider.repaint();
        }
    }

    public class ScrollListener
    implements ActionListener {
        int direction;
        boolean useBlockIncrement;

        public ScrollListener() {
            ScrollListener a;
            a.direction = 1;
            a.direction = 1;
            a.useBlockIncrement = true;
        }

        public ScrollListener(int a, boolean a2) {
            ScrollListener a3;
            a3.direction = 1;
            a3.direction = a;
            a3.useBlockIncrement = a2;
        }

        public void setDirection(int a) {
            a.direction = a;
        }

        public void setScrollByBlock(boolean a) {
            a.useBlockIncrement = a;
        }

        public void actionPerformed(ActionEvent a) {
            ScrollListener a2;
            if (a2.useBlockIncrement) {
                a2.KindleSliderUI.this.scrollByBlock(a2.direction);
            } else {
                a2.KindleSliderUI.this.scrollByUnit(a2.direction);
            }
            if (!a2.KindleSliderUI.this.trackListener.shouldScroll(a2.direction)) {
                ((Timer)a.getSource()).stop();
            }
        }
    }

    public class TrackListener
    extends MouseInputAdapter {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        public TrackListener() {
            TrackListener a;
        }

        public void mouseReleased(MouseEvent a) {
            TrackListener a2;
            if (!a2.KindleSliderUI.this.slider.isEnabled()) {
                return;
            }
            a2.offset = 0;
            a2.KindleSliderUI.this.scrollTimer.stop();
            if (a2.KindleSliderUI.this.slider.getSnapToTicks()) {
                a2.KindleSliderUI.this.isDragging = false;
                a2.KindleSliderUI.this.slider.setValueIsAdjusting(false);
            } else {
                a2.KindleSliderUI.this.slider.setValueIsAdjusting(false);
                a2.KindleSliderUI.this.isDragging = false;
            }
            a2.KindleSliderUI.this.slider.repaint();
        }

        /*
         * Enabled aggressive block sorting
         */
        public void mousePressed(MouseEvent a) {
            int a2;
            TrackListener a3;
            if (!a3.KindleSliderUI.this.slider.isEnabled()) {
                return;
            }
            a3.currentMouseX = a.getX();
            a3.currentMouseY = a.getY();
            if (a3.KindleSliderUI.this.slider.isRequestFocusEnabled()) {
                a3.KindleSliderUI.this.slider.requestFocus();
            }
            if (thumbJumpOnPress) {
                a3.KindleSliderUI.this.isDragging = true;
                return;
            }
            if (a3.KindleSliderUI.this.thumbRect.contains(a3.currentMouseX, a3.currentMouseY)) {
                switch (a3.KindleSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        a3.offset = a3.currentMouseY - a3.KindleSliderUI.this.thumbRect.y;
                        break;
                    }
                    case 0: {
                        a3.offset = a3.currentMouseX - a3.KindleSliderUI.this.thumbRect.x;
                        break;
                    }
                }
                a3.KindleSliderUI.this.isDragging = true;
                return;
            }
            a3.KindleSliderUI.this.isDragging = false;
            a3.KindleSliderUI.this.slider.setValueIsAdjusting(true);
            Dimension a4 = a3.KindleSliderUI.this.slider.getSize();
            int a5 = 1;
            switch (a3.KindleSliderUI.this.slider.getOrientation()) {
                case 1: {
                    if (a3.KindleSliderUI.this.thumbRect.isEmpty()) {
                        a2 = a4.height / 2;
                        if (!a3.KindleSliderUI.this.drawInverted()) {
                            a5 = a3.currentMouseY < a2 ? 1 : -1;
                            break;
                        }
                        a5 = a3.currentMouseY < a2 ? -1 : 1;
                        break;
                    }
                    a2 = a3.KindleSliderUI.this.thumbRect.y;
                    if (!a3.KindleSliderUI.this.drawInverted()) {
                        a5 = a3.currentMouseY < a2 ? 1 : -1;
                        break;
                    }
                    a5 = a3.currentMouseY < a2 ? -1 : 1;
                    break;
                }
                case 0: {
                    if (a3.KindleSliderUI.this.thumbRect.isEmpty()) {
                        a2 = a4.width / 2;
                        if (!a3.KindleSliderUI.this.drawInverted()) {
                            a5 = a3.currentMouseX < a2 ? -1 : 1;
                            break;
                        }
                        a5 = a3.currentMouseX < a2 ? 1 : -1;
                        break;
                    }
                    a2 = a3.KindleSliderUI.this.thumbRect.x;
                    if (!a3.KindleSliderUI.this.drawInverted()) {
                        a5 = a3.currentMouseX < a2 ? -1 : 1;
                        break;
                    }
                    a5 = a3.currentMouseX < a2 ? 1 : -1;
                    break;
                }
            }
            int n = a2 = a3.KindleSliderUI.this.slider.getClientProperty("classic.look") != null ? 1 : 0;
            if (a2 == 0) {
                a3.KindleSliderUI.this.scrollToClickLocation(new Point(a3.currentMouseX, a3.currentMouseY));
                return;
            }
            a3.KindleSliderUI.this.scrollDueToClickInTrack(a5);
            if (!a3.KindleSliderUI.this.thumbRect.contains(a3.currentMouseX, a3.currentMouseY) && a3.shouldScroll(a5)) {
                a3.KindleSliderUI.this.scrollTimer.stop();
                a3.KindleSliderUI.this.scrollListener.setDirection(a5);
                a3.KindleSliderUI.this.scrollTimer.start();
            }
        }

        public boolean shouldScroll(int a) {
            TrackListener a2;
            Rectangle a3 = a2.KindleSliderUI.this.thumbRect;
            if (a2.KindleSliderUI.this.slider.getOrientation() == 1 ? ((a2.KindleSliderUI.this.drawInverted() ? a < 0 : a > 0) ? a3.y + a3.height <= a2.currentMouseY : a3.y >= a2.currentMouseY) : ((a2.KindleSliderUI.this.drawInverted() ? a < 0 : a > 0) ? a3.x + a3.width >= a2.currentMouseX : a3.x <= a2.currentMouseX)) {
                return false;
            }
            if (a > 0 && a2.KindleSliderUI.this.slider.getValue() + a2.KindleSliderUI.this.slider.getExtent() >= a2.KindleSliderUI.this.slider.getMaximum()) {
                return false;
            }
            return a >= 0 || a2.KindleSliderUI.this.slider.getValue() > a2.KindleSliderUI.this.slider.getMinimum();
        }

        /*
         * Enabled aggressive block sorting
         */
        public void mouseDragged(MouseEvent a) {
            TrackListener a2;
            int a3 = 0;
            if (!a2.KindleSliderUI.this.slider.isEnabled()) {
                return;
            }
            a2.currentMouseX = a.getX();
            a2.currentMouseY = a.getY();
            if (!a2.KindleSliderUI.this.isDragging) {
                return;
            }
            a2.KindleSliderUI.this.slider.setValueIsAdjusting(true);
            switch (a2.KindleSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int a4 = a2.KindleSliderUI.this.thumbRect.height / 2;
                    int a5 = a.getY() - a2.offset;
                    int a6 = a2.KindleSliderUI.this.trackRect.y;
                    int a7 = a2.KindleSliderUI.this.trackRect.y + (a2.KindleSliderUI.this.trackRect.height - 1);
                    int a8 = a2.KindleSliderUI.this.yPositionForValue(a2.KindleSliderUI.this.slider.getMaximum() - a2.KindleSliderUI.this.slider.getExtent());
                    if (a2.KindleSliderUI.this.drawInverted()) {
                        a7 = a8;
                    } else {
                        a6 = a8;
                    }
                    a5 = Math.max(a5, a6 - a4);
                    a5 = Math.min(a5, a7 - a4);
                    a2.KindleSliderUI.this.setThumbLocation(a2.KindleSliderUI.this.thumbRect.x, a5);
                    a3 = a5 + a4;
                    a2.KindleSliderUI.this.slider.setValue(a2.KindleSliderUI.this.valueForYPosition(a3));
                    return;
                }
                case 0: {
                    int a9 = a2.KindleSliderUI.this.thumbRect.width / 2;
                    int a10 = a.getX() - a2.offset;
                    int a11 = a2.KindleSliderUI.this.trackRect.x;
                    int a12 = a2.KindleSliderUI.this.trackRect.x + (a2.KindleSliderUI.this.trackRect.width - 1);
                    int a13 = a2.KindleSliderUI.this.xPositionForValue(a2.KindleSliderUI.this.slider.getMaximum() - a2.KindleSliderUI.this.slider.getExtent());
                    if (a2.KindleSliderUI.this.drawInverted()) {
                        a11 = a13;
                    } else {
                        a12 = a13;
                    }
                    a10 = Math.max(a10, a11 - a9);
                    a10 = Math.min(a10, a12 - a9);
                    a2.KindleSliderUI.this.setThumbLocation(a10, a2.KindleSliderUI.this.thumbRect.y);
                    a3 = a10 + a9;
                    a2.KindleSliderUI.this.slider.setValue(a2.KindleSliderUI.this.valueForXPosition(a3));
                    return;
                }
            }
        }

        public void mouseMoved(MouseEvent a) {
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public ChangeHandler() {
            ChangeHandler a;
        }

        public void stateChanged(ChangeEvent a) {
            ChangeHandler a2;
            if (!a2.KindleSliderUI.this.isDragging) {
                a2.KindleSliderUI.this.calculateThumbLocation();
                a2.KindleSliderUI.this.slider.repaint();
            }
        }
    }

    public class MicroPropertyChangeListener
    implements PropertyChangeListener {
        public MicroPropertyChangeListener() {
            MicroPropertyChangeListener a;
        }

        public void propertyChange(PropertyChangeEvent a) {
            MicroPropertyChangeListener a2;
            String a3 = a.getPropertyName();
            if (a3.equals("JSlider.isFilled")) {
                a2.KindleSliderUI.this.filledSlider = a.getNewValue() != null ? (Boolean)a.getNewValue() : false;
            } else if (a3.equals("orientation") || a3.equals("inverted") || a3.equals("labelTable") || a3.equals("majorTickSpacing") || a3.equals("minorTickSpacing") || a3.equals("paintTicks") || a3.equals("paintTrack") || a3.equals("paintLabels")) {
                a2.KindleSliderUI.this.calculateGeometry();
                a2.KindleSliderUI.this.slider.repaint();
            } else if (a3.equals("model")) {
                ((BoundedRangeModel)a.getOldValue()).removeChangeListener(a2.KindleSliderUI.this.changeListener);
                ((BoundedRangeModel)a.getNewValue()).addChangeListener(a2.KindleSliderUI.this.changeListener);
                a2.KindleSliderUI.this.calculateThumbLocation();
                a2.KindleSliderUI.this.slider.repaint();
            }
        }
    }
}

