/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing.plaf.kindle;

import com.amazon.agui.swing.ScrollArrowButton;
import com.amazon.agui.swing.event.GestureDispatcher;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SwingUtilities2;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ActionMapUIResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.microedition.plaf.ScrollBarUI;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;

public class KindleScrollBarUI
extends ComponentUI
implements ScrollBarUI,
LayoutManager,
SwingConstants,
ScrollPaneConstants {
    protected static final int NO_HIGHLIGHT = 0;
    protected static final int DECREASE_HIGHLIGHT = 1;
    protected static final int INCREASE_HIGHLIGHT = 2;
    private static final int POSITIVE_SCROLL = 1;
    private static final int NEGATIVE_SCROLL = -1;
    private static final int MIN_SCROLL = 2;
    private static final int MAX_SCROLL = 3;
    protected JScrollBar scrollbar;
    protected FocusListener focusListener;
    protected ModelListener modelListener;
    protected ActionListener nextListener;
    protected ActionListener prevListener;
    protected GestureDispatcher gestureListener;
    protected PropertyChangeListener propertyChangeListener;
    protected AbstractButton scrollPrev;
    protected AbstractButton scrollNext;
    protected int scrollBarWidth;
    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    public static final String LINKED_SB_PROP = "JScrollBar.linkedWith";
    public static final String FORWARD_TO_PROP = "JScrollBar.forwardTo";
    public static final String WILL_SHOW_PROP = "JScrollBar.willShow";
    public static final String ORIENTATION_PROP = "orientation";
    protected static final int MINIMUM_SB_WIDTH = 5;
    protected JScrollBar linkedScrollBar = null;
    protected Dimension minimumThumbSize;
    protected Dimension maximumThumbSize;
    protected int trackHighlight;
    protected Rectangle thumbRect;
    protected Rectangle trackRect;
    protected Insets trackInsets;
    private static Color shadowColor;
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    protected Color thumbLightShadowColor;
    protected Color thumbDarkShadowColor;
    protected Color trackColor;
    protected Color trackHighlightColor;
    protected Color borderDisabledColor;
    protected TrackListener trackListener;
    private boolean useCachedValue = false;
    private int scrollBarValue;

    public KindleScrollBarUI() {
        KindleScrollBarUI a;
    }

    protected void installDefaults() {
        KindleScrollBarUI a;
        a.scrollBarWidth = UIManager.getInt((Object)"ScrollBar.width");
        if (a.scrollBarWidth <= 0) {
            a.scrollBarWidth = 5;
        }
        a.minimumThumbSize = (Dimension)UIManager.get((Object)"ScrollBar.minimumThumbSize");
        a.maximumThumbSize = (Dimension)UIManager.get((Object)"ScrollBar.maximumThumbSize");
        a.trackHighlight = 0;
        a.trackInsets = (Insets)UIManager.get((Object)"ScrollBar.trackInsets");
        a.scrollbar.setLayout(a);
        a.scrollbar.setEnabled(a.scrollbar.isEnabled());
        a.scrollbar.setOpaque(true);
        a.configureScrollBarColors();
        LookAndFeel.installBorder((JComponent)a.scrollbar, (String)"ScrollBar.border");
        a.scrollBarValue = a.scrollbar.getValue();
        a.buildActionMap(a.scrollbar.getActionMap(), a.scrollbar.getOrientation());
    }

    protected void configureScrollBarColors() {
        KindleScrollBarUI a;
        LookAndFeel.installColors((JComponent)a.scrollbar, (String)"ScrollBar.background", (String)"ScrollBar.foreground");
        thumbHighlightColor = UIManager.getColor((Object)"ScrollBar.thumbHighlight");
        a.thumbLightShadowColor = UIManager.getColor((Object)"ScrollBar.thumbShadow");
        a.thumbDarkShadowColor = UIManager.getColor((Object)"ScrollBar.thumbDarkShadow");
        thumbColor = UIManager.getColor((Object)"ScrollBar.thumb");
        a.trackColor = UIManager.getColor((Object)"ScrollBar.track");
        a.trackHighlightColor = UIManager.getColor((Object)"ScrollBar.trackHighlight");
        a.borderDisabledColor = UIManager.getColor((Object)"ScrollBar.disabledColor");
        shadowColor = UIManager.getColor((Object)"ScrollBar.shadow");
        highlightColor = UIManager.getColor((Object)"ScrollBar.highlight");
        darkShadowColor = UIManager.getColor((Object)"ScrollBar.darkShadow");
        thumbShadow = UIManager.getColor((Object)"ScrollBar.thumbShadow");
    }

    private void buildActionMap(ActionMap a, int a2) {
        KindleScrollBarUI a3;
        if (a2 == 1) {
            a.remove("west");
            a.remove("east");
            a.put("north", a3.new ScrollAction(1));
            a.put("south", a3.new ScrollAction(-1));
        } else {
            a.remove("north");
            a.remove("south");
            a.put("west", a3.new ScrollAction(1));
            a.put("east", a3.new ScrollAction(-1));
        }
    }

    protected void uninstallDefaults() {
        KindleScrollBarUI a;
        LookAndFeel.uninstallBorder((JComponent)a.scrollbar);
    }

    protected void installListeners() {
        KindleScrollBarUI a;
        a.focusListener = a.createFocusListener();
        a.trackListener = a.createTrackListener();
        a.modelListener = a.createModelListener();
        a.propertyChangeListener = a.createPropertyChangeListener();
        a.gestureListener = a.createGestureListener();
        a.scrollbar.addFocusListener(a.focusListener);
        a.scrollbar.addPropertyChangeListener(a.propertyChangeListener);
        a.scrollbar.addMouseListener(a.gestureListener);
        a.scrollbar.addMouseListener(a.trackListener);
        a.scrollbar.getModel().addChangeListener(a.modelListener);
    }

    protected void uninstallListeners() {
        KindleScrollBarUI a;
        a.scrollbar.removeFocusListener(a.focusListener);
        a.scrollbar.removePropertyChangeListener(a.propertyChangeListener);
        a.scrollbar.removeMouseListener(a.gestureListener);
        a.scrollbar.removeMouseListener(a.trackListener);
        a.scrollbar.getModel().removeChangeListener(a.modelListener);
    }

    protected FocusListener createFocusListener() {
        KindleScrollBarUI a;
        return a.new sbFocusListener();
    }

    protected TrackListener createTrackListener() {
        KindleScrollBarUI a;
        return a.new TrackListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        KindleScrollBarUI a;
        return a.new ScrollBarListener();
    }

    protected GestureDispatcher createGestureListener() {
        KindleScrollBarUI a;
        Object a2 = a.scrollbar.getClientProperty(FORWARD_TO_PROP);
        return new GestureDispatcher(a2 instanceof JComponent ? (JComponent)a2 : null){
            {
                1 a2;
                super(a);
            }

            public void mouseClicked(MouseEvent a) {
                Object a2;
                1 a3;
                if (a.isConsumed() || !a3.KindleScrollBarUI.this.scrollbar.isEnabled()) {
                    return;
                }
                super.mouseClicked(a);
                if (a3.KindleScrollBarUI.this.scrollbar.getOrientation() == 1 && (a2 = a3.KindleScrollBarUI.this.scrollbar.getClientProperty(KindleScrollBarUI.LINKED_SB_PROP)) instanceof JComponent) {
                    JComponent a4 = (JComponent)a3.KindleScrollBarUI.this.scrollbar.getParent();
                    JComponent a5 = (JComponent)a2;
                    Point a6 = SwingUtilities.convertPoint((Component)a.getSource(), a.getPoint(), a4);
                    final Component a7 = SwingUtilities.getDeepestComponentAt(a5, a6.x, a6.y);
                    if (a7 instanceof AbstractButton) {
                        a7.requestFocusInWindow();
                        SwingUtilities.invokeLater(new Runnable(){
                            {
                                1 a;
                            }

                            public void run() {
                                1 a;
                                ((AbstractButton)a.a7).doClick();
                            }
                        });
                        a.consume();
                    }
                }
            }
        };
    }

    public Dimension getPreferredSize(JComponent a) {
        KindleScrollBarUI a2;
        return new Dimension(a2.scrollBarWidth, a2.scrollBarWidth);
    }

    public void installUI(JComponent a) {
        KindleScrollBarUI a2;
        a2.scrollbar = (JScrollBar)a;
        a2.thumbRect = new Rectangle(0, 0, 0, 0);
        a2.trackRect = new Rectangle(0, 0, 0, 0);
        a2.installDefaults();
        a2.installComponents();
        a2.installListeners();
    }

    public void uninstallUI(JComponent a) {
        KindleScrollBarUI a2;
        a2.scrollbar = (JScrollBar)a;
        a2.uninstallListeners();
        a2.uninstallComponents();
        a2.uninstallDefaults();
        a.remove(a2.scrollPrev);
        a.remove(a2.scrollNext);
        a.setLayout(null);
        a2.thumbRect = null;
        a2.trackRect = null;
        a2.scrollbar = null;
        a2.linkedScrollBar = null;
        a2.scrollPrev = null;
        a2.scrollNext = null;
    }

    protected void installComponents() {
        KindleScrollBarUI a;
        if (a.scrollbar.getOrientation() == 1) {
            a.scrollPrev = new ScrollArrowButton(1);
            a.scrollNext = new ScrollArrowButton(5);
        } else if (SwingUtilities2.isLeftToRight((Component)a.scrollbar)) {
            a.scrollPrev = new ScrollArrowButton(7);
            a.scrollNext = new ScrollArrowButton(3);
        } else {
            a.scrollPrev = new ScrollArrowButton(3);
            a.scrollNext = new ScrollArrowButton(7);
        }
        Color a2 = UIManager.getColor((Object)"ScrollBar.button");
        a.scrollNext.setBackground(a2);
        a.scrollPrev.setBackground(a2);
        a.scrollNext.setOpaque(false);
        a.scrollPrev.setOpaque(false);
        a.enableScrollBars();
        a.scrollbar.add(a.scrollPrev);
        a.scrollbar.add(a.scrollNext);
        a.nextListener = a.createButtonListener(1);
        a.prevListener = a.createButtonListener(-1);
        a.scrollNext.addActionListener(a.nextListener);
        a.scrollPrev.addActionListener(a.prevListener);
    }

    protected void uninstallComponents() {
        KindleScrollBarUI a;
        a.scrollNext.removeActionListener(a.nextListener);
        a.scrollPrev.removeActionListener(a.prevListener);
        a.nextListener = null;
        a.prevListener = null;
        a.scrollbar.removeAll();
        a.scrollNext = null;
        a.scrollPrev = null;
    }

    private ActionMap getActionMap() {
        KindleScrollBarUI a;
        ActionMap a2 = (ActionMap)UIManager.get((Object)"ScrollBar.actionMap");
        if (a2 == null && (a2 = a.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put((Object)"ScrollBar.actionMap", (Object)a2);
        }
        return a2;
    }

    private ActionMap createActionMap() {
        return new ActionMapUIResource();
    }

    protected ActionListener createButtonListener(final int a) {
        KindleScrollBarUI a2;
        return new ActionListener(){
            final int mDir;
            {
                2 a2;
                a2.mDir = a2.a;
            }

            public void actionPerformed(ActionEvent a3) {
                2 a2;
                a2.KindleScrollBarUI.this.scrollByBlock(a2.mDir);
            }
        };
    }

    protected ModelListener createModelListener() {
        KindleScrollBarUI a;
        return a.new ModelListener();
    }

    public void update(Graphics a, JComponent a2) {
        KindleScrollBarUI a3;
        if (a2.isOpaque()) {
            Graphics2D a4 = (Graphics2D)a;
            a4.setBackground(a2.getBackground());
            a4.clearRect(a3.trackRect.x, a3.trackRect.y, a3.trackRect.width, a3.trackRect.height);
        }
        a3.paint(a, a2);
    }

    public void paint(Graphics a, JComponent a2) {
        KindleScrollBarUI a3;
        int a4 = a3.scrollbar.getOrientation();
        a3.paintScrollBarTrackIcon(a, a2, a4);
        a3.paintScrollBarThumbIcon(a, a2, a4);
    }

    private void paintScrollBarTrackIcon(Graphics a, JComponent a2, int a3) {
        KindleScrollBarUI a4;
        a.translate(a4.trackRect.x, a4.trackRect.y);
        a.setColor(a4.trackColor);
        if (a3 == 1) {
            int a5 = a4.trackRect.width / 3;
            int a6 = a5 / 2 + 1;
            a.fillRoundRect(a5, a4.trackInsets.top, a5, a4.trackRect.height - a4.trackInsets.top - a4.trackInsets.bottom, a6, a6);
        } else {
            int a7 = a4.trackRect.height / 3;
            int a8 = a7 / 2 + 1;
            a.fillRoundRect(a4.trackInsets.left, a7, a4.trackRect.width - a4.trackInsets.left - a4.trackInsets.right, a7, a8, a8);
        }
        a.translate(-a4.trackRect.x, -a4.trackRect.y);
    }

    private void paintScrollBarThumbIcon(Graphics a, JComponent a2, int a3) {
        KindleScrollBarUI a4;
        a.translate(a4.thumbRect.x, a4.thumbRect.y);
        a.setColor(a2.isEnabled() ? thumbColor : a4.borderDisabledColor);
        if (a3 == 1) {
            int a5 = a4.trackRect.width / 3;
            int a6 = a5 / 2 + 1;
            a.fillRoundRect(a5, 0, a5, a4.thumbRect.height - 1, a6, a6);
        } else {
            int a7 = a4.trackRect.height / 3;
            int a8 = a7 / 2 + 1;
            a.fillRoundRect(0, a7, a4.thumbRect.width - 1, a7, a8, a8);
        }
        a.translate(-a4.thumbRect.x, -a4.thumbRect.y);
    }

    public Dimension getMinimumSize(JComponent a) {
        KindleScrollBarUI a2;
        return a2.getPreferredSize(a);
    }

    public Dimension getMaximumSize(JComponent a) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected Dimension getMaximumThumbSize() {
        KindleScrollBarUI a;
        return a.maximumThumbSize;
    }

    protected Dimension getMinimumThumbSize() {
        KindleScrollBarUI a;
        return a.minimumThumbSize;
    }

    protected void setThumbBounds(int a, int a2, int a3, int a4) {
        KindleScrollBarUI a5;
        if (a5.thumbRect.x == a && a5.thumbRect.y == a2 && a5.thumbRect.width == a3 && a5.thumbRect.height == a4) {
            return;
        }
        int a6 = Math.min(a, a5.thumbRect.x);
        int a7 = Math.min(a2, a5.thumbRect.y);
        int a8 = Math.max(a + a3, a5.thumbRect.x + a5.thumbRect.width);
        int a9 = Math.max(a2 + a4, a5.thumbRect.y + a5.thumbRect.height);
        a5.thumbRect.setBounds(a, a2, a3, a4);
        a5.scrollbar.repaint(a6, a7, a8 - a6 + 1, a9 - a7 + 1);
    }

    public void addLayoutComponent(String a, Component a2) {
    }

    public void removeLayoutComponent(Component a) {
    }

    public Dimension preferredLayoutSize(Container a) {
        KindleScrollBarUI a2;
        return a2.getPreferredSize((JComponent)a);
    }

    public Dimension minimumLayoutSize(Container a) {
        KindleScrollBarUI a2;
        return a2.getMinimumSize((JComponent)a);
    }

    private boolean showOpposite(JScrollBar a) {
        Object a2;
        boolean a3 = false;
        Object a4 = a.getClientProperty(LINKED_SB_PROP);
        if (a4 instanceof JComponent && (a2 = ((JComponent)a4).getClientProperty(WILL_SHOW_PROP)) instanceof Boolean) {
            a3 = (Boolean)a2;
        }
        return a3;
    }

    protected void layoutVScrollbar(JScrollBar a) {
        int a2;
        KindleScrollBarUI a3;
        Dimension a4 = a.getSize();
        Insets a5 = a.getInsets();
        Dimension a6 = a3.scrollPrev.getPreferredSize();
        Rectangle a7 = new Rectangle(0, 0, a4.width + a5.left + a5.right, a4.height + a5.top - a6.height);
        boolean a8 = SwingUtilities2.isLeftToRight((Component)a);
        boolean a9 = a3.showOpposite(a);
        int a10 = a7.y + a7.height;
        int a11 = 0;
        Border a12 = a3.scrollPrev.getBorder();
        if (a12 != null) {
            Insets a13 = a12.getBorderInsets(a3.scrollPrev);
            a11 = a13.left + a13.right;
        }
        if (!a9) {
            a2 = a7.width / 2 + a11;
            int a14 = a7.width - a2 + a11;
            if (a8) {
                a3.scrollPrev.setBounds(-a5.left, a10, a2, a6.height);
                a3.scrollNext.setBounds(a2 - a11 - a5.left, a10, a14, a6.height);
            } else {
                a3.scrollPrev.setBounds(a2 - a11 - a5.left, a10, a2, a6.height);
                a3.scrollNext.setBounds(-a5.left, a10, a14, a6.height);
            }
        } else {
            a2 = a7.width / 4 + a11;
            if (a8) {
                a3.scrollPrev.setBounds(-a5.left, a10, a2, a6.height);
                a3.scrollNext.setBounds(a2 - a11 - a5.left, a10, a2, a6.height);
            } else {
                a3.scrollPrev.setBounds((a2 - a11) * 3 - a5.left, a10, a2, a6.height);
                a3.scrollNext.setBounds((a2 - a11) * 2 - a5.left, a10, a2, a6.height);
            }
        }
        a7 = new Rectangle(a5.left, a5.top, a4.width - (a5.left + a5.right), a4.height - (a5.top + a5.bottom) - a6.height);
        if (a8) {
            a7.x = a7.x + a7.width - a3.scrollBarWidth;
        }
        a7.width = a3.scrollBarWidth;
        if (a9) {
            a7.height -= a3.scrollBarWidth;
        }
        a3.trackRect.setBounds(a7);
        float a15 = a.getMaximum();
        float a16 = a.getMinimum();
        float a17 = a.getVisibleAmount();
        float a18 = a15 - a16;
        float a19 = a3.getValue(a);
        int a20 = a7.height - a3.trackInsets.top - a3.trackInsets.bottom;
        int a21 = a18 <= 0.0f ? a3.getMaximumThumbSize().height : (int)((float)a20 * (a17 / a18));
        a21 = Math.max(a21, a3.getMinimumThumbSize().height);
        a21 = Math.min(a21, a3.getMaximumThumbSize().height);
        int a22 = a18 <= 0.0f ? a3.getMaximumThumbSize().width : a3.scrollBarWidth;
        a22 = Math.max(a22, a3.getMinimumThumbSize().width);
        a22 = Math.min(a22, a3.getMaximumThumbSize().width);
        int a23 = a7.height - a3.trackInsets.bottom - a21 + 1;
        if (a19 < a15 - (float)a.getVisibleAmount()) {
            float a24 = a20 - a21;
            a23 = (int)(0.5f + a24 * ((a19 - a16) / (a18 - a17)));
            a23 += a5.top + a3.trackInsets.top;
        }
        if (a21 >= a7.height) {
            a3.setThumbBounds(0, 0, 0, 0);
        } else {
            if (a23 + a21 > a7.y + a7.height - a3.trackInsets.top) {
                a23 = a7.y + a7.height - a3.trackInsets.top - a21;
            }
            if (a23 < a7.y + a3.trackInsets.top) {
                a23 = a7.y + a3.trackInsets.top;
            }
            int a25 = a7.x;
            if (a22 >= a3.scrollBarWidth) {
                a22 = a3.scrollBarWidth;
            } else {
                a25 += (a3.scrollBarWidth - a22) / 2;
            }
            a3.setThumbBounds(a25, a23, a22, a21);
        }
    }

    private int getValue(JScrollBar a) {
        KindleScrollBarUI a2;
        return a2.useCachedValue ? a2.scrollBarValue : a.getValue();
    }

    protected void layoutHScrollbar(JScrollBar a) {
        int a2;
        int a3;
        int a4;
        KindleScrollBarUI a5;
        Dimension a6 = a.getSize();
        Insets a7 = a.getInsets();
        Dimension a8 = a5.scrollPrev.getPreferredSize();
        Rectangle a9 = new Rectangle(0, 0, a6.width + a7.left + a7.right, a6.height + a7.top - a8.height);
        boolean a10 = SwingUtilities2.isLeftToRight((Component)a);
        boolean a11 = a5.showOpposite(a);
        int a12 = a9.y + a9.height;
        int a13 = 0;
        Border a14 = a5.scrollPrev.getBorder();
        if (a14 != null) {
            Insets a15 = a14.getBorderInsets(a5.scrollPrev);
            a13 = a15.left + a15.right;
        }
        if (!a11) {
            a4 = a9.width / 2 + a13;
            a3 = a9.width - a4 + a13;
            if (a10) {
                a5.scrollPrev.setBounds(-a7.left, a12, a4, a8.height);
                a5.scrollNext.setBounds(a4 - a13 - a7.left, a12, a3, a8.height);
            } else {
                a5.scrollPrev.setBounds(a4 - a13 - a7.left, a12, a4, a8.height);
                a5.scrollNext.setBounds(-a7.left, a12, a3, a8.height);
            }
        } else {
            a4 = a9.width / 4 + a13;
            a3 = a9.width - a4 * 3 + a13 * 3;
            if (a10) {
                a5.scrollPrev.setBounds((a4 - a13) * 2 - a7.left, a12, a4, a8.height);
                a5.scrollNext.setBounds((a4 - a13) * 3 - a7.left, a12, a3, a8.height);
            } else {
                a5.scrollPrev.setBounds(a4 - a13 - a7.left, a12, a4, a8.height);
                a5.scrollNext.setBounds(-a7.left, a12, a3, a8.height);
            }
        }
        a9 = new Rectangle(a7.left, a7.top, a6.width - (a7.left + a7.right), a6.height - (a7.top + a7.bottom) - a8.height);
        new Rectangle(a7.left, a7.top, a6.width - (a7.left + a7.right), a6.height - (a7.top + a7.bottom) - a8.height).y = a12 - a5.scrollBarWidth;
        a9.height = a5.scrollBarWidth;
        if (a11) {
            a9.width -= a5.scrollBarWidth;
            if (!a10) {
                a9.x += a5.scrollBarWidth;
            }
        }
        a5.trackRect.setBounds(a9);
        float a16 = a.getMaximum();
        float a17 = a.getMinimum();
        float a18 = a.getVisibleAmount();
        float a19 = a16 - a17;
        float a20 = a5.getValue(a);
        int a21 = a19 <= 0.0f ? a5.getMaximumThumbSize().height : a5.scrollBarWidth;
        a21 = Math.max(a21, a5.getMinimumThumbSize().height);
        a21 = Math.min(a21, a5.getMaximumThumbSize().height);
        int a22 = a9.width - a5.trackInsets.left - a5.trackInsets.right;
        int a23 = a19 <= 0.0f ? a5.getMaximumThumbSize().width : (int)((float)a22 * (a18 / a19));
        a23 = Math.max(a23, a5.getMinimumThumbSize().width);
        a23 = Math.min(a23, a5.getMaximumThumbSize().width);
        int n = a2 = a10 ? a9.x + a9.width - a5.trackInsets.right - a23 + 1 : a9.x + a5.trackInsets.left;
        if (a20 < a16 - (float)a.getVisibleAmount()) {
            float a24 = a22 - a23;
            a2 = a10 ? (int)(0.5f + a24 * ((a20 - a17) / (a19 - a18))) : (int)(0.5f + a24 * ((a16 - a18 - a20) / (a19 - a18)));
            a2 += a7.left + a5.trackInsets.left;
        }
        if (a23 >= a9.width) {
            a5.setThumbBounds(0, 0, 0, 0);
        } else {
            if (a2 + a23 > a9.x + a9.width - a5.trackInsets.right) {
                a2 = a9.x + a9.width - a5.trackInsets.right - a23;
            }
            if (a2 < a9.x + a5.trackInsets.left) {
                a2 = a9.x + a5.trackInsets.left;
            }
            int a25 = a9.y;
            if (a21 >= a5.scrollBarWidth) {
                a21 = a5.scrollBarWidth;
            } else {
                a25 += (a5.scrollBarWidth - a21) / 2;
            }
            a5.setThumbBounds(a2, a25, a23, a21);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void layoutContainer(Container a) {
        JScrollBar a2 = (JScrollBar)a;
        Dimension a3 = a2.getSize();
        if (a3.width <= 0) return;
        if (a3.height <= 0) return;
        switch (a2.getOrientation()) {
            case 1: {
                KindleScrollBarUI a4;
                a4.layoutVScrollbar(a2);
                return;
            }
            case 0: {
                KindleScrollBarUI a4;
                a4.layoutHScrollbar(a2);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void scrollByBlock(int a) {
        KindleScrollBarUI a2;
        KindleScrollBarUI kindleScrollBarUI = a2;
        synchronized (kindleScrollBarUI) {
            Component a3;
            int a4 = a2.scrollbar.getValue();
            int a5 = a2.scrollbar.getBlockIncrement(a) * a;
            int a6 = Math.min(a4 + a5, a2.scrollbar.getMaximum() - a2.scrollbar.getMinimum());
            JViewport a7 = (JViewport)a2.scrollbar.getClientProperty(FORWARD_TO_PROP);
            if (a7 != null && (a3 = a7.getView()) instanceof JComponent) {
                JComponent a8 = (JComponent)a3;
                Border a9 = a8.getBorder();
                Rectangle a10 = a8.getBounds();
                if (a2.scrollbar.getOrientation() == 1) {
                    if (a9 != null && a9.getBorderInsets((Component)a8).top >= a6) {
                        a6 = a2.scrollbar.getMinimum();
                    }
                } else {
                    boolean a11 = SwingUtilities2.isLeftToRight((Component)a2.scrollbar);
                    if (a11) {
                        if (a9 != null && a9.getBorderInsets((Component)a8).left >= a6) {
                            a6 = a2.scrollbar.getMinimum();
                        }
                        if (a9 != null && a10.x + a10.width - a9.getBorderInsets((Component)a8).right <= a6) {
                            a6 = a2.scrollbar.getMaximum() - a2.scrollbar.getMinimum();
                        }
                    } else {
                        if (a9 != null && a9.getBorderInsets((Component)a8).right <= a6) {
                            a6 = a2.scrollbar.getMinimum();
                        }
                        if (a9 != null && a10.x + a9.getBorderInsets((Component)a8).left >= a6) {
                            a6 = a2.scrollbar.getMaximum() - a2.scrollbar.getMinimum();
                        }
                    }
                }
            }
            a2.scrollbar.setValue(a6);
            a2.scrollBarValue = a6;
            a2.enableScrollBars();
        }
    }

    private void enableScrollBars() {
        KindleScrollBarUI a;
        a.scrollPrev.setEnabled(a.scrollbar.isEnabled() && a.scrollBarValue > a.scrollbar.getMinimum());
        a.scrollPrev.repaint();
        a.scrollNext.setEnabled(a.scrollbar.isEnabled() && a.scrollBarValue + a.scrollbar.getVisibleAmount() < a.scrollbar.getMaximum() - a.scrollbar.getMinimum());
        a.scrollNext.repaint();
    }

    public static ComponentUI createUI(JComponent a) {
        return new KindleScrollBarUI();
    }

    protected class TrackListener
    extends MouseAdapter {
        protected transient int currentMouseX;
        protected transient int currentMouseY;
        private transient int direction = 1;

        protected TrackListener() {
            TrackListener a;
        }

        public void mouseReleased(MouseEvent a) {
            TrackListener a2;
            if (SwingUtilities.isRightMouseButton(a) || SwingUtilities.isMiddleMouseButton(a)) {
                return;
            }
            if (!a2.KindleScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!a2.KindleScrollBarUI.this.trackRect.contains(a.getPoint())) {
                return;
            }
            a2.KindleScrollBarUI.this.scrollbar.repaint(a2.KindleScrollBarUI.this.trackRect.x, a2.KindleScrollBarUI.this.trackRect.y, a2.KindleScrollBarUI.this.trackRect.width, a2.KindleScrollBarUI.this.trackRect.height);
            a2.KindleScrollBarUI.this.trackHighlight = 0;
            a2.KindleScrollBarUI.this.useCachedValue = true;
            a2.KindleScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void mousePressed(MouseEvent a) {
            TrackListener a2;
            if (SwingUtilities.isRightMouseButton(a) || SwingUtilities.isMiddleMouseButton(a)) {
                return;
            }
            if (!a2.KindleScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!a2.KindleScrollBarUI.this.trackRect.contains(a.getPoint())) {
                return;
            }
            if (!a2.KindleScrollBarUI.this.scrollbar.hasFocus() && a2.KindleScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                a2.KindleScrollBarUI.this.scrollbar.requestFocus();
            }
            a2.KindleScrollBarUI.this.useCachedValue = true;
            a2.KindleScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
            a2.currentMouseX = a.getX();
            a2.currentMouseY = a.getY();
            if (a2.KindleScrollBarUI.this.thumbRect.contains(a2.currentMouseX, a2.currentMouseY)) {
                return;
            }
            Dimension a3 = a2.KindleScrollBarUI.this.scrollbar.getSize();
            a2.direction = 1;
            switch (a2.KindleScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (a2.KindleScrollBarUI.this.thumbRect.isEmpty()) {
                        int a4 = a3.height / 2;
                        a2.direction = a2.currentMouseY < a4 ? -1 : 1;
                        break;
                    }
                    int a5 = a2.KindleScrollBarUI.this.thumbRect.y;
                    a2.direction = a2.currentMouseY < a5 ? -1 : 1;
                    break;
                }
                case 0: {
                    if (a2.KindleScrollBarUI.this.thumbRect.isEmpty()) {
                        int a6 = a3.width / 2;
                        a2.direction = a2.currentMouseX < a6 ? -1 : 1;
                    } else {
                        int a7 = a2.KindleScrollBarUI.this.thumbRect.x;
                        int n = a2.direction = a2.currentMouseX < a7 ? -1 : 1;
                    }
                    if (SwingUtilities2.isLeftToRight((Component)a2.KindleScrollBarUI.this.scrollbar)) break;
                    a2.direction = -a2.direction;
                    break;
                }
            }
            a2.KindleScrollBarUI.this.scrollByBlock(a2.direction);
        }
    }

    private class ScrollAction
    extends AbstractAction {
        private int dir;

        ScrollAction(int a) {
            ScrollAction a2;
            a2.dir = a;
        }

        public void actionPerformed(ActionEvent a) {
            ScrollAction a2;
            if (a2.dir == -1 || a2.dir == 1) {
                a2.KindleScrollBarUI.this.scrollByBlock(a2.dir);
            } else if (a2.dir == 2) {
                a2.KindleScrollBarUI.this.scrollBarValue = a2.KindleScrollBarUI.this.scrollbar.getMinimum();
                a2.KindleScrollBarUI.this.scrollbar.setValue(a2.KindleScrollBarUI.this.scrollBarValue);
            } else if (a2.dir == 3) {
                a2.KindleScrollBarUI.this.scrollBarValue = a2.KindleScrollBarUI.this.scrollbar.getMaximum();
                a2.KindleScrollBarUI.this.scrollbar.setValue(a2.KindleScrollBarUI.this.scrollBarValue);
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public PropertyChangeHandler() {
            PropertyChangeHandler a;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent a) {
            String a2 = a.getPropertyName();
            if ("model".equals(a2)) {
                PropertyChangeHandler a3;
                KindleScrollBarUI kindleScrollBarUI = a3.KindleScrollBarUI.this;
                synchronized (kindleScrollBarUI) {
                    BoundedRangeModel a4 = (BoundedRangeModel)a.getOldValue();
                    BoundedRangeModel a5 = (BoundedRangeModel)a.getNewValue();
                    a4.removeChangeListener(a3.KindleScrollBarUI.this.modelListener);
                    a5.addChangeListener(a3.KindleScrollBarUI.this.modelListener);
                    a3.KindleScrollBarUI.this.enableScrollBars();
                    a3.KindleScrollBarUI.this.scrollbar.repaint();
                    a3.KindleScrollBarUI.this.scrollbar.revalidate();
                }
            }
        }
    }

    protected class ModelListener
    implements ChangeListener {
        protected ModelListener() {
            ModelListener a;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent a) {
            ModelListener a2;
            KindleScrollBarUI kindleScrollBarUI = a2.KindleScrollBarUI.this;
            synchronized (kindleScrollBarUI) {
                if (!a2.KindleScrollBarUI.this.useCachedValue) {
                    a2.KindleScrollBarUI.this.scrollBarValue = a2.KindleScrollBarUI.this.scrollbar.getValue();
                }
                a2.KindleScrollBarUI.this.layoutContainer(a2.KindleScrollBarUI.this.scrollbar);
                a2.KindleScrollBarUI.this.useCachedValue = false;
                a2.KindleScrollBarUI.this.enableScrollBars();
            }
        }
    }

    class ScrollBarListener
    extends PropertyChangeHandler {
        ScrollBarListener() {
            ScrollBarListener a;
        }

        public void propertyChange(PropertyChangeEvent a) {
            ScrollBarListener a2;
            String a3 = a.getPropertyName();
            if (a3.equals(KindleScrollBarUI.FREE_STANDING_PROP)) {
                a2.handlePropertyChange(a.getNewValue());
            } else if (a3.equals(KindleScrollBarUI.LINKED_SB_PROP)) {
                a2.handleLinkPropertyChange(a.getNewValue());
            } else if (a3.equals(KindleScrollBarUI.FORWARD_TO_PROP)) {
                a2.handleForwardToPropChange(a.getOldValue(), a.getNewValue());
            } else if (a3.equals(KindleScrollBarUI.ORIENTATION_PROP)) {
                a2.handleOrientationPropChange(a.getOldValue(), a.getNewValue());
            } else {
                super.propertyChange(a);
            }
        }

        public void handleOrientationPropChange(Object a, Object a2) {
            if (a != a2) {
                ScrollBarListener a3;
                ActionMap a4 = a3.KindleScrollBarUI.this.scrollbar.getActionMap();
                a3.KindleScrollBarUI.this.buildActionMap(a4, a3.KindleScrollBarUI.this.scrollbar.getOrientation());
                SwingUtilities.invokeLater(new Runnable(){
                    {
                        1 a;
                    }

                    public void run() {
                        1 a;
                        KindleScrollBarUI.this.installComponents();
                        KindleScrollBarUI.this.layoutContainer(((ScrollBarListener)a.ScrollBarListener.this).KindleScrollBarUI.this.scrollbar);
                    }
                });
            }
        }

        public void handleForwardToPropChange(Object a, Object a2) {
            ScrollBarListener a3;
            JComponent a4 = null;
            JComponent a5 = null;
            if (a instanceof JComponent) {
                a4 = (JComponent)a;
            }
            if (a2 instanceof JComponent) {
                a5 = (JComponent)a2;
            }
            if (a4 != null) {
                a3.KindleScrollBarUI.this.gestureListener.setForwardToComponent(null);
            }
            if (a5 != null) {
                a3.KindleScrollBarUI.this.gestureListener.setForwardToComponent(a5);
            }
        }

        public void handlePropertyChange(Object a) {
        }

        public void handleLinkPropertyChange(Object a) {
            ScrollBarListener a2;
            a2.KindleScrollBarUI.this.linkedScrollBar = a != null ? (JScrollBar)a : null;
            a2.KindleScrollBarUI.this.scrollbar.invalidate();
            a2.KindleScrollBarUI.this.scrollbar.repaint();
        }
    }

    class sbFocusListener
    implements FocusListener {
        sbFocusListener() {
            sbFocusListener a;
        }

        public void focusLost(FocusEvent a) {
            ((JComponent)a.getSource()).repaint();
        }

        public void focusGained(FocusEvent a) {
            ((JComponent)a.getSource()).repaint();
        }
    }
}

