/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing.plaf.kindle;

import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.UIManager;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.microedition.plaf.ProgressBarUI;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;

public class KindleProgressBarUI
extends ComponentUI
implements ProgressBarUI {
    private static final Dimension PREFERRED_INNER_HORIZONTAL = new Dimension(146, 12);
    private static final Dimension PREFERRED_INNER_VERTICAL = new Dimension(12, 146);
    private static final Dimension PREFERRED_INNER_HORIZONTAL_CLASSIC = new Dimension(146, 22);
    private static final Dimension PREFERRED_INNER_VERTICAL_CLASSIC = new Dimension(22, 146);
    private int cachedPercent;
    private int cellLength;
    private int cellSpacing;
    private Color selectionForeground;
    private Color selectionBackground;
    private boolean isIndeterminate = false;
    private Animator animator;
    private PropertyChangeListener propertyListener;
    protected JProgressBar progressBar;
    protected ChangeListener changeListener;
    private Rectangle innards;
    private Rectangle box;
    private int animationIndex = 0;
    protected int numFrames;
    private int repaintInterval;
    private int cycleTime;
    private static boolean ADJUSTTIMER = true;
    private static boolean LOGSTATS = false;
    private long startTime = 0L;
    private long lastLoopTime = 0L;
    private int numLoops = 0;
    public Rectangle boxRect;
    private Rectangle nextPaintRect;
    private int cellArcHeight;
    private int cellHeight;
    protected Rectangle componentInnards;
    private Rectangle oldComponentInnards;
    protected double delta = 0.0;
    protected int maxPosition = 0;

    public KindleProgressBarUI() {
        KindleProgressBarUI a;
    }

    public static ComponentUI createUI(JComponent a) {
        return new KindleProgressBarUI();
    }

    private void paintDeterminateKindle(Graphics a, JComponent a2) {
        KindleProgressBarUI a3;
        Insets a4 = a3.progressBar.getInsets();
        int a5 = a3.progressBar.getWidth() - (a4.right + a4.left);
        int a6 = a3.progressBar.getHeight() - (a4.top + a4.bottom);
        int a7 = KindleProgressBarUI.getAmountFull(a3.progressBar, a4, a5, a6);
        if (a3.progressBar.getOrientation() == 0) {
            int a8 = a4.top + a6 / 2 - a3.cellHeight / 2;
            a.setColor(a3.progressBar.getBackground());
            a.fillRoundRect(a4.left, a8, a5, a3.cellHeight, a3.cellArcHeight, a3.cellArcHeight);
            a.setColor(a3.progressBar.getForeground());
            a.drawRoundRect(a4.left, a8, a5, a3.cellHeight, a3.cellArcHeight, a3.cellArcHeight);
            a.fillRoundRect(a4.left, a8, a7, a3.cellHeight, a3.cellArcHeight, a3.cellArcHeight);
        } else {
            int a9 = a4.left + a5 / 2 - a3.cellHeight / 2;
            a.setColor(a3.progressBar.getBackground());
            a.fillRoundRect(a9, a4.top, a3.cellHeight, a6, a3.cellArcHeight, a3.cellArcHeight);
            a.setColor(a3.progressBar.getForeground());
            a.drawRoundRect(a9, a4.top, a3.cellHeight, a6, a3.cellArcHeight, a3.cellArcHeight);
            a.fillRoundRect(a9, a4.top, a3.cellHeight, a6 - a7, a3.cellArcHeight, a3.cellArcHeight);
        }
    }

    public void paintDeterminate(Graphics a, JComponent a2) {
        boolean a3;
        boolean bl = a3 = a2.getClientProperty("classic.look") != null;
        if (a3) {
            KindleProgressBarUI a4;
            a4.paintDeterminateKindle(a, a2);
            return;
        }
        JProgressBar a5 = (JProgressBar)a2;
        Insets a6 = a5.getInsets();
        int a7 = a5.getWidth() - (a6.right + a6.left);
        int a8 = a5.getHeight() - (a6.top + a6.bottom);
        int a9 = UIManager.getInt((Object)"ProgressBar.cellLength");
        int a10 = UIManager.getInt((Object)"ProgressBar.cellSpacing");
        int a11 = KindleProgressBarUI.getAmountFull(a5, a6, a7, a8);
        int a12 = a9 - 1;
        a.setColor(a5.getForeground());
        if (a5.getOrientation() == 0) {
            if (a10 <= 0) {
                a.fillRect(a6.left, a6.top + (a8 - a9 >> 1) + 1, a7, a12);
                if (a11 > 0) {
                    a.fillRect(a6.left, a6.top + (a8 - a9 >> 1), a11, a9);
                }
            } else {
                Graphics2D a13 = (Graphics2D)a;
                a13.setColor(a5.getForeground());
                AlphaComposite a14 = AlphaComposite.getInstance(2, 1.0f);
                a13.setComposite(a14);
                float[] a15 = new float[]{a12, a10 + a9 - a12};
                a13.setStroke(new BasicStroke(a12, 0, 0, 1.0f, a15, 0.0f));
                Line2D.Float a16 = new Line2D.Float(a6.left, a6.top + (a8 - a9 >> 1) + 1, a7, a6.top + (a8 - a9 >> 1) + 1);
                a13.draw(a16);
                float[] a17 = new float[]{a9, a10};
                a13.setStroke(new BasicStroke(a9, 0, 0, 1.0f, a17, 0.0f));
                if (a11 >= a9) {
                    int a18 = a11;
                    if (a18 % (a9 + a10) != 0) {
                        a18 = a18 + a9 + a10;
                        a18 -= a18 % (a9 + a10);
                    }
                    a16 = new Line2D.Float(a6.left, a6.top + (a8 - a9 >> 1) + 1, a18, a6.top + (a8 - a9 >> 1) + 1);
                    a13.draw(a16);
                }
            }
        } else if (a10 <= 0) {
            a.fillRect(a6.left + (a7 - a9 >> 1) + 1, a6.top, a12, a8);
            if (a11 > 0) {
                a.fillRect(a6.left + (a7 - a9 >> 1), a6.top, a12, a11);
            }
        } else {
            Graphics2D a19 = (Graphics2D)a;
            a19.setColor(a5.getForeground());
            AlphaComposite a20 = AlphaComposite.getInstance(2, 1.0f);
            a19.setComposite(a20);
            float[] a21 = new float[]{a12, a10 + a9 - a12};
            a19.setStroke(new BasicStroke(a12, 0, 0, 1.0f, a21, 0.0f));
            Line2D.Float a22 = new Line2D.Float(a6.left + (a7 - a9 >> 1) + 1, a6.top, a6.left + (a7 - a9 >> 1) + 1, a8);
            a19.draw(a22);
            float[] a23 = new float[]{a9, a10};
            a19.setStroke(new BasicStroke(a9, 0, 0, 1.0f, a23, 0.0f));
            if (a11 >= a9) {
                int a24 = a11;
                if (a24 % (a9 + a10) != 0) {
                    a24 = a24 + a9 + a10;
                    a24 -= a24 % (a9 + a10);
                }
                a22 = new Line2D.Float(a6.left + (a7 - a9 >> 1) + 1, a6.top, a6.left + (a7 - a9 >> 1) + 1, a24);
                a19.draw(a22);
            }
        }
    }

    public void paintIndeterminate(Graphics a, JComponent a2) {
        KindleProgressBarUI a3;
        a3.paintDeterminate(a, a2);
    }

    private static int getAmountFull(JProgressBar a, Insets a2, int a3, int a4) {
        int a5 = 0;
        BoundedRangeModel a6 = a.getModel();
        if (a6.getMaximum() > a6.getMinimum()) {
            int a7 = a.getOrientation() == 0 ? a3 : a4;
            a5 = (int)Math.round((double)a7 * a.getPercentComplete());
        }
        return a5;
    }

    public void installUI(JComponent a) {
        KindleProgressBarUI a2;
        a2.progressBar = (JProgressBar)a;
        a2.installDefaults();
        a2.installListeners();
    }

    public void uninstallUI(JComponent a) {
        KindleProgressBarUI a2;
        a2.uninstallDefaults();
        a2.uninstallListeners();
        a2.stopAnimationTimer();
        a2.progressBar = null;
    }

    protected void installDefaults() {
        KindleProgressBarUI a;
        a.progressBar.setOpaque(true);
        LookAndFeel.installBorder((JComponent)a.progressBar, (String)"ProgressBar.border");
        LookAndFeel.installColorsAndFont((JComponent)a.progressBar, (String)"ProgressBar.background", (String)"ProgressBar.foreground", (String)"ProgressBar.font");
        a.cellLength = UIManager.getInt((Object)"ProgressBar.cellLength");
        a.cellSpacing = UIManager.getInt((Object)"ProgressBar.cellSpacing");
        a.cellArcHeight = UIManager.getInt((Object)"ProgressBar.cellArcHeight");
        a.cellHeight = UIManager.getInt((Object)"ProgressBar.cellHeight");
        a.selectionForeground = UIManager.getColor((Object)"ProgressBar.selectionForeground");
        a.selectionBackground = UIManager.getColor((Object)"ProgressBar.selectionBackground");
    }

    protected void uninstallDefaults() {
        KindleProgressBarUI a;
        LookAndFeel.uninstallBorder((JComponent)a.progressBar);
    }

    protected void installListeners() {
        KindleProgressBarUI a;
        a.changeListener = a.new ChangeHandler();
        a.progressBar.addChangeListener(a.changeListener);
        a.propertyListener = a.new PropertyChangeHandler();
        a.progressBar.addPropertyChangeListener(a.propertyListener);
    }

    protected void startAnimationTimer() {
        KindleProgressBarUI a;
        if (a.animator == null) {
            a.animator = a.new Animator();
        }
        a.animator.start(a.getRepaintInterval());
    }

    protected void stopAnimationTimer() {
        KindleProgressBarUI a;
        if (a.animator != null) {
            a.animator.stop();
        }
    }

    protected void uninstallListeners() {
        KindleProgressBarUI a;
        a.progressBar.removeChangeListener(a.changeListener);
        a.progressBar.removePropertyChangeListener(a.propertyListener);
    }

    protected Dimension getPreferredInnerHorizontal() {
        return PREFERRED_INNER_HORIZONTAL;
    }

    protected Dimension getPreferredInnerVertical() {
        return PREFERRED_INNER_VERTICAL;
    }

    protected Dimension getPreferredInnerHorizontal(boolean a) {
        KindleProgressBarUI a2;
        if (a) {
            return PREFERRED_INNER_HORIZONTAL_CLASSIC;
        }
        return a2.getPreferredInnerHorizontal();
    }

    protected Dimension getPreferredInnerVertical(boolean a) {
        KindleProgressBarUI a2;
        if (a) {
            return PREFERRED_INNER_VERTICAL_CLASSIC;
        }
        return a2.getPreferredInnerVertical();
    }

    protected Color getSelectionForeground() {
        KindleProgressBarUI a;
        return a.selectionForeground;
    }

    protected Color getSelectionBackground() {
        KindleProgressBarUI a;
        return a.selectionBackground;
    }

    private int getCachedPercent() {
        KindleProgressBarUI a;
        return a.cachedPercent;
    }

    private void setCachedPercent(int a) {
        a.cachedPercent = a;
    }

    protected int getCellLength() {
        KindleProgressBarUI a;
        if (a.progressBar.isStringPainted()) {
            return 1;
        }
        return a.cellLength;
    }

    protected void setCellLength(int a) {
        a.cellLength = a;
    }

    protected int getCellSpacing() {
        KindleProgressBarUI a;
        if (a.progressBar.isStringPainted()) {
            return 0;
        }
        return a.cellSpacing;
    }

    protected void setCellSpacing(int a) {
        a.cellSpacing = a;
    }

    protected int getAmountFull(Insets a, int a2, int a3) {
        KindleProgressBarUI a4;
        int a5 = 0;
        BoundedRangeModel a6 = a4.progressBar.getModel();
        if (a6.getMaximum() - a6.getMinimum() != 0) {
            a5 = a4.progressBar.getOrientation() == 0 ? (int)Math.round((double)a2 * a4.progressBar.getPercentComplete()) : (int)Math.round((double)a3 * a4.progressBar.getPercentComplete());
        }
        return a5;
    }

    public void paint(Graphics a, JComponent a2) {
        KindleProgressBarUI a3;
        if (a3.isIndeterminate) {
            a3.paintIndeterminate(a, a2);
        } else {
            a3.paintDeterminate(a, a2);
        }
    }

    protected Rectangle getBox(Rectangle a) {
        KindleProgressBarUI a2;
        int a3 = a2.getAnimationIndex();
        int a4 = a2.numFrames / 2;
        if (a2.sizeChanged() || a2.delta == 0.0 || (double)a2.maxPosition == 0.0) {
            a2.updateSizes();
        }
        if ((a = a2.getGenericBox(a)) == null) {
            return null;
        }
        if (a4 <= 0) {
            return null;
        }
        if (a2.progressBar.getOrientation() == 0) {
            a.x = a3 < a4 ? a2.componentInnards.x + (int)Math.round(a2.delta * (double)a3) : a2.maxPosition - (int)Math.round(a2.delta * (double)(a3 - a4));
        } else {
            a.y = a3 < a4 ? a2.componentInnards.y + (int)Math.round(a2.delta * (double)a3) : a2.maxPosition - (int)Math.round(a2.delta * (double)(a3 - a4));
        }
        return a;
    }

    protected void updateSizes() {
        KindleProgressBarUI a;
        int a2 = 0;
        if (a.progressBar.getOrientation() == 0) {
            a2 = a.getBoxLength(a.componentInnards.width, a.componentInnards.height);
            a.maxPosition = a.componentInnards.x + a.componentInnards.width - a2;
        } else {
            a2 = a.getBoxLength(a.componentInnards.height, a.componentInnards.width);
            a.maxPosition = a.componentInnards.y + a.componentInnards.height - a2;
        }
        a.delta = 2.0 * (double)a.maxPosition / (double)a.numFrames;
    }

    protected Rectangle getGenericBox(Rectangle a) {
        KindleProgressBarUI a2;
        if (a == null) {
            a = new Rectangle();
        }
        if (a2.progressBar.getOrientation() == 0) {
            a.width = a2.getBoxLength(a2.componentInnards.width, a2.componentInnards.height);
            if (a.width < 0) {
                a = null;
            } else {
                a.height = a2.componentInnards.height;
                a.y = a2.componentInnards.y;
            }
        } else {
            a.height = a2.getBoxLength(a2.componentInnards.height, a2.componentInnards.width);
            if (a.height < 0) {
                a = null;
            } else {
                a.width = a2.componentInnards.width;
                a.x = a2.componentInnards.x;
            }
        }
        return a;
    }

    private int getBoxLength(int a, int a2) {
        return (int)Math.round((double)a / 6.0);
    }

    protected void paintString(Graphics a, int a2, int a3, int a4, int a5, int a6, Insets a7) {
        KindleProgressBarUI a8;
        if (a8.progressBar.getOrientation() == 0) {
            a8.paintString(a, a2, a3, a4, a5, a2, a6, a7);
        } else {
            a8.paintString(a, a2, a3, a4, a5, a3 + a5 - a6, a6, a7);
        }
    }

    protected void paintString(Graphics a, int a2, int a3, int a4, int a5, int a6, int a7, Insets a8) {
        KindleProgressBarUI a9;
        if (!(a instanceof Graphics2D)) {
            return;
        }
        Graphics2D a10 = (Graphics2D)a;
        String a11 = a9.progressBar.getString();
        a10.setFont(a9.progressBar.getFont());
        Point a12 = a9.getStringPlacement(a10, a11, a2, a3, a4, a5);
        Rectangle a13 = a10.getClipBounds();
        a10.setColor(a9.getSelectionBackground());
        Composite a14 = a10.getComposite();
        a10.setComposite(AlphaComposite.SrcOver);
        if (a9.progressBar.getOrientation() == 0) {
            a10.drawString(a11, a12.x, a12.y);
            a10.setColor(a9.getSelectionForeground());
            a10.clipRect(a6, a3, a7, a5);
            a.drawString(a11, a12.x, a12.y);
        } else {
            AffineTransform a15 = a10.getTransform();
            AffineTransform a16 = new AffineTransform(a15);
            a16.rotate(1.5707963267948966, a12.x, a12.y);
            a10.setTransform(a16);
            a10.drawString(a11, a12.x, a12.y);
            a10.setTransform(a15);
            a10.setColor(a9.getSelectionForeground());
            a10.clipRect(a2, a6, a4, a7);
            a10.setTransform(a16);
            a10.drawString(a11, a12.x, a12.y);
            a10.setTransform(a15);
        }
        a10.setComposite(a14);
        a10.setClip(a13);
    }

    protected Point getStringPlacement(Graphics a, String a2, int a3, int a4, int a5, int a6) {
        KindleProgressBarUI a7;
        FontMetrics a8 = a7.progressBar.getFontMetrics(a7.progressBar.getFont());
        int a9 = a8.stringWidth(a2);
        if (a7.progressBar.getOrientation() == 0) {
            return new Point(a3 + Math.round(a5 / 2 - a9 / 2), a4 + (a6 + a8.getAscent() - a8.getLeading() - a8.getDescent()) / 2);
        }
        return new Point(a3 + (a5 - a8.getAscent() + a8.getLeading() + a8.getDescent()) / 2, a4 + Math.round(a6 / 2 - a9 / 2));
    }

    public Dimension getPreferredSize(JComponent a) {
        Dimension a2;
        boolean a3;
        KindleProgressBarUI a4;
        Insets a5 = a4.progressBar.getInsets();
        FontMetrics a6 = a4.progressBar.getFontMetrics(a4.progressBar.getFont());
        boolean bl = a3 = a.getClientProperty("classic.look") != null;
        if (a4.progressBar.getOrientation() == 0) {
            a2 = new Dimension(a4.getPreferredInnerHorizontal(a3));
            if (a4.progressBar.isStringPainted()) {
                int a7;
                String a8 = a4.progressBar.getString();
                int a9 = a6.stringWidth(a8);
                if (a9 > a2.width) {
                    a2.width = a9;
                }
                if ((a7 = a6.getHeight() + a6.getDescent()) > a2.height) {
                    a2.height = a7;
                }
            }
        } else {
            a2 = new Dimension(a4.getPreferredInnerVertical(a3));
            if (a4.progressBar.isStringPainted()) {
                int a10;
                String a11 = a4.progressBar.getString();
                int a12 = a6.getHeight() + a6.getDescent();
                if (a12 > a2.width) {
                    a2.width = a12;
                }
                if ((a10 = a6.stringWidth(a11)) > a2.height) {
                    a2.height = a10;
                }
            }
        }
        a2.width += a5.left + a5.right;
        a2.height += a5.top + a5.bottom;
        return a2;
    }

    public Dimension getMinimumSize(JComponent a) {
        boolean a2;
        KindleProgressBarUI a3;
        Dimension a4 = a3.getPreferredSize(a3.progressBar);
        boolean bl = a2 = a.getClientProperty("classic.look") != null;
        if (a3.progressBar.getOrientation() == 0) {
            a4.width = 10;
            if (a2) {
                a4.width += a3.cellArcHeight;
            }
        } else {
            a4.height = 10;
            if (a2) {
                a4.height += a3.cellArcHeight;
            }
        }
        return a4;
    }

    public Dimension getMaximumSize(JComponent a) {
        KindleProgressBarUI a2;
        Dimension a3 = a2.getPreferredSize(a2.progressBar);
        if (a2.progressBar.getOrientation() == 0) {
            a3.width = Short.MAX_VALUE;
        } else {
            a3.height = Short.MAX_VALUE;
        }
        return a3;
    }

    protected int getAnimationIndex() {
        KindleProgressBarUI a;
        return a.animationIndex;
    }

    protected void setAnimationIndex(int a) {
        KindleProgressBarUI a2;
        if (a2.animationIndex != a) {
            if (a2.sizeChanged()) {
                a2.animationIndex = a;
                a2.maxPosition = 0;
                a2.delta = 0.0;
                a2.progressBar.repaint();
                return;
            }
            a2.nextPaintRect = a2.getBox(a2.nextPaintRect);
            a2.animationIndex = a;
            if (a2.nextPaintRect != null) {
                a2.boxRect = a2.getBox(a2.boxRect);
                if (a2.boxRect != null) {
                    a2.nextPaintRect.add(a2.boxRect);
                }
            }
        } else {
            return;
        }
        if (a2.nextPaintRect != null) {
            a2.progressBar.repaint(a2.nextPaintRect);
        } else {
            a2.progressBar.repaint();
        }
    }

    protected boolean sizeChanged() {
        KindleProgressBarUI a;
        if (a.oldComponentInnards == null || a.componentInnards == null) {
            return true;
        }
        a.oldComponentInnards.setRect(a.componentInnards);
        a.componentInnards = SwingUtilities.calculateInnerArea(a.progressBar, a.componentInnards);
        return !a.oldComponentInnards.equals(a.componentInnards);
    }

    protected void incrementAnimationIndex() {
        KindleProgressBarUI a;
        int a2 = a.getAnimationIndex() + 1;
        if (a2 < a.numFrames) {
            a.setAnimationIndex(a2);
        } else {
            a.setAnimationIndex(0);
            if (LOGSTATS) {
                ++a.numLoops;
                long a3 = System.currentTimeMillis();
                System.out.println("Loop #" + a.numLoops + ": " + (a3 - a.lastLoopTime) + " (" + (a3 - a.startTime) + " total)");
                a.lastLoopTime = a3;
            }
        }
    }

    private int getRepaintInterval() {
        KindleProgressBarUI a;
        return a.repaintInterval;
    }

    private int initRepaintInterval() {
        KindleProgressBarUI a;
        a.repaintInterval = UIManager.getInt((Object)"ProgressBar.repaintInterval");
        return a.repaintInterval;
    }

    private int getCycleTime() {
        KindleProgressBarUI a;
        return a.cycleTime;
    }

    private int initCycleTime() {
        KindleProgressBarUI a;
        a.cycleTime = UIManager.getInt((Object)"ProgressBar.cycleTime");
        return a.cycleTime;
    }

    private void initIndeterminateDefaults() {
        KindleProgressBarUI a;
        a.initRepaintInterval();
        a.initCycleTime();
        if (a.repaintInterval <= 0) {
            a.repaintInterval = 100;
        }
        if (a.repaintInterval > a.cycleTime) {
            a.cycleTime = a.repaintInterval * 20;
        } else {
            int a2 = (int)Math.ceil((double)a.cycleTime / ((double)a.repaintInterval * 2.0));
            a.cycleTime = a.repaintInterval * a2 * 2;
        }
    }

    private void initIndeterminateValues() {
        KindleProgressBarUI a;
        if (LOGSTATS) {
            a.startTime = a.lastLoopTime = System.currentTimeMillis();
            a.numLoops = 0;
        }
        a.initIndeterminateDefaults();
        a.numFrames = 45;
        a.initAnimationIndex();
        a.boxRect = new Rectangle();
        a.nextPaintRect = new Rectangle();
        a.componentInnards = new Rectangle();
        a.oldComponentInnards = new Rectangle();
    }

    private void cleanUpIndeterminateValues() {
        a.repaintInterval = 0;
        a.cycleTime = 0;
        a.animationIndex = 0;
        a.numFrames = 0;
        a.maxPosition = 0;
        a.delta = 0.0;
        a.nextPaintRect = null;
        a.boxRect = null;
        a.oldComponentInnards = null;
        a.componentInnards = null;
        if (LOGSTATS) {
            KindleProgressBarUI a;
            a.numLoops = 0;
            a.startTime = a.lastLoopTime = (long)0;
        }
    }

    private void initAnimationIndex() {
        KindleProgressBarUI a;
        if (a.progressBar.getOrientation() == 0) {
            a.setAnimationIndex(0);
        } else {
            a.setAnimationIndex(a.numFrames / 2);
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public ChangeHandler() {
            ChangeHandler a;
        }

        public void stateChanged(ChangeEvent a) {
            int a2;
            ChangeHandler a3;
            BoundedRangeModel a4 = a3.KindleProgressBarUI.this.progressBar.getModel();
            int a5 = a4.getMaximum() - a4.getMinimum();
            int a6 = a5 > 0 ? (int)(100L * (long)a4.getValue() / (long)a5) : 0;
            if (a6 != (a2 = a3.KindleProgressBarUI.this.getCachedPercent())) {
                a3.KindleProgressBarUI.this.setCachedPercent(a6);
                a3.KindleProgressBarUI.this.progressBar.repaint();
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
            PropertyChangeHandler a;
        }

        public void propertyChange(PropertyChangeEvent a) {
            String a2 = a.getPropertyName();
            if ("indeterminate".equals(a2)) {
                PropertyChangeHandler a3;
                a3.KindleProgressBarUI.this.isIndeterminate = a3.KindleProgressBarUI.this.progressBar.isIndeterminate();
                if (a3.KindleProgressBarUI.this.isIndeterminate) {
                    a3.KindleProgressBarUI.this.initIndeterminateValues();
                    a3.KindleProgressBarUI.this.startAnimationTimer();
                } else {
                    a3.KindleProgressBarUI.this.stopAnimationTimer();
                    a3.KindleProgressBarUI.this.cleanUpIndeterminateValues();
                }
                a3.KindleProgressBarUI.this.progressBar.repaint();
            }
        }
    }

    private class Animator
    implements ActionListener {
        private Timer timer;
        private long previousDelay;
        private int interval;
        private long lastCall;
        private int MINIMUM_DELAY = 5;

        private Animator() {
            Animator a;
        }

        private void start(int a) {
            Animator a2;
            a2.previousDelay = a;
            a2.lastCall = 0L;
            if (a2.timer == null) {
                a2.timer = new Timer(a, a2);
            } else {
                a2.timer.setDelay(a);
            }
            if (ADJUSTTIMER) {
                a2.timer.setRepeats(false);
                a2.timer.setCoalesce(false);
            }
            a2.timer.start();
        }

        private void stop() {
            Animator a;
            a.timer.stop();
        }

        public void actionPerformed(ActionEvent a) {
            Animator a2;
            if (ADJUSTTIMER) {
                long a3 = System.currentTimeMillis();
                if (a2.lastCall > 0L) {
                    int a4 = (int)(a2.previousDelay - a3 + a2.lastCall + (long)a2.KindleProgressBarUI.this.getRepaintInterval());
                    if (a4 < a2.MINIMUM_DELAY) {
                        a4 = a2.MINIMUM_DELAY;
                    }
                    a2.timer.setInitialDelay(a4);
                    a2.previousDelay = a4;
                }
                a2.timer.start();
                a2.lastCall = a3;
            }
            a2.KindleProgressBarUI.this.incrementAnimationIndex();
        }
    }
}

