/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing.plaf.kindle;

import com.amazon.agui.swing.event.GestureDispatcher;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SunCellRendererPane;
import com.sun.java.swing.SwingUtilities2;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ActionMapUIResource;
import com.sun.java.swing.plaf.UIResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.microedition.plaf.ListUI;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class KindleListUI
extends ComponentUI
implements ListUI {
    private static final int HIDDEN_ROW_NONE = -1;
    protected JList list = null;
    protected SunCellRendererPane rendererPane;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    protected ListSelectionListener listSelectionListener;
    protected ListDataListener listDataListener;
    protected PropertyChangeListener propertyChangeListener;
    protected int[] cellHeights = null;
    protected int cellHeight = -1;
    protected int cellWidth = -1;
    protected int updateLayoutStateNeeded = 1;
    private boolean leftToRight;
    private int listHeight;
    private int listWidth;
    private int layoutOrientation;
    private int columnCount;
    private int preferredHeight;
    private int rowsPerColumn;
    private Color separatorColor;
    private int hiddenRow = -1;
    protected static final int modelChanged = 1;
    protected static final int selectionModelChanged = 2;
    protected static final int fontChanged = 4;
    protected static final int fixedCellWidthChanged = 8;
    protected static final int fixedCellHeightChanged = 16;
    protected static final int prototypeCellValueChanged = 32;
    protected static final int cellRendererChanged = 64;
    private static final int layoutOrientationChanged = 128;
    private static final int heightChanged = 256;
    private static final int widthChanged = 512;

    public KindleListUI() {
        KindleListUI a;
    }

    protected void paintCell(Graphics a, int a2, Rectangle a3, ListCellRenderer a4, ListModel a5, ListSelectionModel a6, int a7) {
        KindleListUI a8;
        Object a9 = a5.getElementAt(a2);
        boolean a10 = a8.list.hasFocus() && a2 == a7;
        boolean a11 = a6.isSelectedIndex(a2);
        Component a12 = a4.getListCellRendererComponent(a8.list, a9, a2, a11, a10);
        int a13 = a3.x;
        int a14 = a3.y;
        int a15 = a3.width;
        int a16 = a3.height;
        a8.rendererPane.paintComponent(a, a12, (Container)a8.list, a13, a14, a15, a16, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void paint(Graphics a, JComponent a2) {
        int a3;
        int a4;
        int a5;
        int a6;
        KindleListUI a7;
        switch (a7.layoutOrientation) {
            case 1: {
                if (a7.list.getHeight() == a7.listHeight) break;
                a7.updateLayoutStateNeeded |= 0x100;
                a7.redrawList();
                break;
            }
            case 2: {
                if (a7.list.getWidth() == a7.listWidth) break;
                a7.updateLayoutStateNeeded |= 0x200;
                a7.redrawList();
                break;
            }
        }
        a7.maybeUpdateLayoutState();
        ListCellRenderer a8 = a7.list.getCellRenderer();
        ListModel a9 = a7.list.getModel();
        ListSelectionModel a10 = a7.list.getSelectionModel();
        if (a8 == null || (a6 = a9.getSize()) == 0) {
            return;
        }
        Rectangle a11 = a.getClipBounds();
        int a12 = a7.getSeparatorStyle();
        if (SwingUtilities2.isLeftToRight((Component)a2)) {
            a5 = a7.convertLocationToColumn(a11.x, a11.y);
            a4 = a7.convertLocationToColumn(a11.x + a11.width - 1, a11.y);
        } else {
            a5 = a7.convertLocationToColumn(a11.x + a11.width - 1, a11.y);
            a4 = a7.convertLocationToColumn(a11.x, a11.y);
        }
        int a13 = a11.y + a11.height + a7.list.getInsets().top;
        int a14 = a7.list.getLeadSelectionIndex();
        int a15 = a7.layoutOrientation == 2 ? a7.columnCount : 1;
        a7.hiddenRow = -1;
        int n = a3 = a5;
        while (n <= a4) {
            int a16 = a7.convertLocationToRowInColumn(a11.y, a3);
            int a17 = a7.getRowCount(a3);
            int a18 = a7.getModelIndex(a3, a16);
            Rectangle a19 = a7.getCellBounds(a7.list, a18, a18);
            if (a19 == null) {
                return;
            }
            boolean a20 = a12 != 0 && a7.columnCount == 1;
            int n2 = a16;
            int n3 = a17;
            while (n2 < n3 && a19.y < a13 && a18 < a6) {
                if (a7.layoutOrientation == 0 && a19.y + a19.height > a13) {
                    a7.hiddenRow = a16;
                    break;
                }
                a19.height = a7.getHeight(a3, a16);
                a.setClip(a19.x, a19.y, a19.width, a19.height);
                a.clipRect(a11.x, a11.y, a11.width, a11.height);
                a7.paintCell(a, a18, a19, a8, a9, a10, a14);
                if (a20) {
                    if (a19.y < a11.y + a19.height - 1 && (a18 != 0 || a12 == 1)) {
                        a7.drawSeparatorLine(a, a19.x, a19.y, a19.x + a19.width, a19.y);
                    }
                    if (a18 < a6 - 1 || a12 == 1) {
                        int a21 = a19.y + a19.height - 1;
                        a7.drawSeparatorLine(a, a19.x, a21, a19.x + a19.width, a21);
                    }
                }
                a19.y += a19.height;
                a18 += a15;
                n2 = ++a16;
                n3 = a17;
            }
            n = ++a3;
        }
        return;
    }

    private void drawSeparatorLine(Graphics a, int a2, int a3, int a4, int a5) {
        KindleListUI a6;
        a.setColor(a6.separatorColor);
        a.drawLine(a2, a3, a4, a5);
    }

    public Dimension getPreferredSize(JComponent a) {
        Rectangle a2;
        KindleListUI a3;
        a3.maybeUpdateLayoutState();
        int a4 = a3.list.getModel().getSize() - 1;
        if (a4 < 0) {
            return new Dimension(0, 0);
        }
        Insets a5 = a3.list.getInsets();
        int a6 = a3.cellWidth * a3.columnCount + a5.left + a5.right;
        int a7 = a3.layoutOrientation != 0 ? a3.preferredHeight : ((a2 = a3.getCellBounds(a3.list, a4)) != null ? a2.y + a2.height + a5.bottom : 0);
        return new Dimension(a6, a7);
    }

    public Dimension getMinimumSize(JComponent a) {
        KindleListUI a2;
        return a2.getPreferredSize(a);
    }

    public Dimension getMaximumSize(JComponent a) {
        KindleListUI a2;
        return a2.getPreferredSize(a);
    }

    protected void selectPreviousIndex() {
        KindleListUI a;
        int a2 = a.list.getSelectedIndex();
        if (a2 > 0) {
            a.list.ensureIndexIsVisible(--a2);
            a.list.setSelectedIndex(a2);
        }
    }

    protected void selectNextIndex() {
        KindleListUI a;
        int a2 = a.list.getSelectedIndex();
        if (a2 + 1 < a.list.getModel().getSize()) {
            a.list.ensureIndexIsVisible(++a2);
            a.list.setSelectedIndex(a2);
        }
    }

    ActionMap getActionMap() {
        KindleListUI a;
        String a2 = a.leftToRight ? "List.actionMapLTR" : "List.actionMapRTL";
        ActionMap a3 = (ActionMap)UIManager.get((Object)a2);
        if (a3 == null && (a3 = a.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put((Object)a2, (Object)a3);
        }
        return a3;
    }

    ActionMap createActionMap() {
        return new ActionMapUIResource();
    }

    protected void installListeners() {
        ListSelectionModel a;
        KindleListUI a2;
        a2.focusListener = a2.createFocusListener();
        a2.mouseInputListener = a2.createMouseInputListener();
        a2.propertyChangeListener = a2.createPropertyChangeListener();
        a2.listSelectionListener = a2.createListSelectionListener();
        a2.listDataListener = a2.createListDataListener();
        a2.list.addFocusListener(a2.focusListener);
        a2.list.addMouseListener(a2.mouseInputListener);
        a2.list.addMouseMotionListener(a2.mouseInputListener);
        a2.list.addPropertyChangeListener(a2.propertyChangeListener);
        ActionMap a3 = a2.getActionMap();
        a2.list.setActionMap(a3);
        ListModel a4 = a2.list.getModel();
        if (a4 != null) {
            a4.addListDataListener(a2.listDataListener);
        }
        if ((a = a2.list.getSelectionModel()) != null) {
            a.addListSelectionListener(a2.listSelectionListener);
        }
    }

    protected void uninstallListeners() {
        ListSelectionModel a;
        KindleListUI a2;
        a2.list.removeFocusListener(a2.focusListener);
        a2.list.removeMouseListener(a2.mouseInputListener);
        a2.list.removeMouseMotionListener(a2.mouseInputListener);
        a2.list.removePropertyChangeListener(a2.propertyChangeListener);
        ListModel a3 = a2.list.getModel();
        if (a3 != null) {
            a3.removeListDataListener(a2.listDataListener);
        }
        if ((a = a2.list.getSelectionModel()) != null) {
            a.removeListSelectionListener(a2.listSelectionListener);
        }
        a2.focusListener = null;
        a2.mouseInputListener = null;
        a2.listSelectionListener = null;
        a2.listDataListener = null;
        a2.propertyChangeListener = null;
    }

    protected void installDefaults() {
        Color a;
        Color a2;
        KindleListUI a3;
        a3.columnCount = 1;
        a3.list.setLayout(null);
        LookAndFeel.installBorder((JComponent)a3.list, (String)"List.border");
        LookAndFeel.installColorsAndFont((JComponent)a3.list, (String)"List.background", (String)"List.foreground", (String)"List.font");
        if (a3.list.getCellRenderer() == null) {
            a3.list.setCellRenderer((ListCellRenderer)UIManager.get((Object)"List.cellRenderer"));
        }
        if ((a2 = a3.list.getSelectionBackground()) == null || a2 instanceof UIResource) {
            a3.list.setSelectionBackground(UIManager.getColor((Object)"List.selectionBackground"));
        }
        if ((a = a3.list.getSelectionForeground()) == null || a instanceof UIResource) {
            a3.list.setSelectionForeground(UIManager.getColor((Object)"List.selectionForeground"));
        }
        a3.leftToRight = SwingUtilities2.isLeftToRight((Component)a3.list);
        a3.separatorColor = (Color)ResourceBundle.getBundle("com.amazon.agui.swing.resources.ComponentResources").getObject("separator.color");
        a3.list.putClientProperty("separator.style", new Integer(0));
    }

    protected void uninstallDefaults() {
        KindleListUI a;
        LookAndFeel.uninstallBorder((JComponent)a.list);
        if (a.list.getFont() instanceof UIResource) {
            a.list.setFont(null);
        }
        if (a.list.getForeground() instanceof UIResource) {
            a.list.setForeground(null);
        }
        if (a.list.getBackground() instanceof UIResource) {
            a.list.setBackground(null);
        }
        if (a.list.getSelectionBackground() instanceof UIResource) {
            a.list.setSelectionBackground(null);
        }
        if (a.list.getSelectionForeground() instanceof UIResource) {
            a.list.setSelectionForeground(null);
        }
        if (a.list.getCellRenderer() instanceof UIResource) {
            a.list.setCellRenderer(null);
        }
    }

    public void installUI(JComponent a) {
        KindleListUI a2;
        a2.list = (JList)a;
        a2.layoutOrientation = a2.list.getLayoutOrientation();
        a2.rendererPane = new SunCellRendererPane();
        a2.list.add((Component)a2.rendererPane);
        a2.installDefaults();
        a2.installListeners();
    }

    public void uninstallUI(JComponent a) {
        KindleListUI a2;
        a2.uninstallListeners();
        a2.uninstallDefaults();
        a2.cellHeight = -1;
        a2.cellWidth = -1;
        a2.cellHeights = null;
        a2.listHeight = -1;
        a2.listWidth = -1;
        a2.list.remove((Component)a2.rendererPane);
        a2.rendererPane = null;
        a2.list = null;
    }

    public static ComponentUI createUI(JComponent a) {
        return new KindleListUI();
    }

    public int locationToIndex(JList a, Point a2) {
        KindleListUI a3;
        a3.maybeUpdateLayoutState();
        return a3.convertLocationToModel(a2.x, a2.y);
    }

    public Point indexToLocation(JList a, int a2) {
        KindleListUI a3;
        a3.maybeUpdateLayoutState();
        Rectangle a4 = a3.getCellBounds(a, a2, a2);
        if (a4 != null) {
            return new Point(a4.x, a4.y);
        }
        return null;
    }

    public Rectangle getCellBounds(JList a, int a2, int a3) {
        KindleListUI a4;
        a4.maybeUpdateLayoutState();
        int a5 = Math.min(a2, a3);
        int a6 = Math.max(a2, a3);
        if (a5 >= a.getModel().getSize()) {
            return null;
        }
        Rectangle a7 = a4.getCellBounds(a, a5);
        if (a7 == null) {
            return null;
        }
        if (a5 == a6) {
            return a7;
        }
        Rectangle a8 = a4.getCellBounds(a, a6);
        if (a8 != null) {
            a7.add(a8);
        }
        return a7;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Rectangle getCellBounds(JList a, int a2) {
        int a3;
        int a4;
        KindleListUI a5;
        a5.maybeUpdateLayoutState();
        int a6 = a5.convertModelToRow(a2);
        int a7 = a5.convertModelToColumn(a2);
        if (a6 == -1) return null;
        if (a7 == -1) {
            return null;
        }
        Insets a8 = a.getInsets();
        int a9 = a5.cellWidth;
        int a10 = a8.top;
        switch (a5.layoutOrientation) {
            case 1: 
            case 2: {
                a4 = SwingUtilities2.isLeftToRight((Component)a) ? a8.left + a7 * a5.cellWidth : a.getWidth() - a8.right - (a7 + 1) * a5.cellWidth;
                a3 = a5.cellHeight;
                return new Rectangle(a4, a10 += a5.cellHeight * a6, a9, a3);
            }
        }
        a4 = a8.left;
        if (a5.cellHeights == null) {
            a10 += a5.cellHeight * a6;
        } else if (a6 >= a5.cellHeights.length) {
            a10 = 0;
        } else {
            int a11;
            int n = a11 = 0;
            while (n < a6) {
                a10 += a5.cellHeights[a11];
                n = ++a11;
            }
        }
        a9 = a.getWidth() - (a8.left + a8.right);
        a3 = a5.getRowHeight(a2);
        return new Rectangle(a4, a10, a9, a3);
    }

    protected int getRowHeight(int a) {
        KindleListUI a2;
        return a2.getHeight(0, a);
    }

    protected int convertYToRow(int a) {
        KindleListUI a2;
        return a2.convertLocationToRow(0, a, false);
    }

    protected int convertRowToY(int a) {
        KindleListUI a2;
        if (a2.getRowCount(0) >= a || a < 0) {
            return -1;
        }
        return a2.getCellBounds((JList)a2.list, (int)a, (int)a).y;
    }

    private int getHeight(int a, int a2) {
        KindleListUI a3;
        if (a < 0 || a > a3.columnCount || a2 < 0) {
            return -1;
        }
        if (a3.layoutOrientation != 0) {
            return a3.cellHeight;
        }
        if (a2 >= a3.list.getModel().getSize()) {
            return -1;
        }
        return a3.cellHeights == null ? a3.cellHeight : (a2 < a3.cellHeights.length ? a3.cellHeights[a2] : -1);
    }

    private int convertLocationToRow(int a, int a2, boolean a3) {
        int a4;
        KindleListUI a5;
        int a6 = a5.list.getModel().getSize();
        if (a6 <= 0) {
            return -1;
        }
        Insets a7 = a5.list.getInsets();
        if (a5.cellHeights == null) {
            int a8;
            int n = a8 = a5.cellHeight == 0 ? 0 : (a2 - a7.top) / a5.cellHeight;
            if (a3) {
                if (a8 < 0) {
                    a8 = 0;
                } else if (a8 >= a6) {
                    a8 = a6 - 1;
                }
            }
            return a8;
        }
        if (a6 > a5.cellHeights.length) {
            return -1;
        }
        int a9 = a7.top;
        int a10 = 0;
        if (a3 && a2 < a9) {
            return 0;
        }
        int n = a4 = 0;
        while (n < a6) {
            if (a2 >= a9 && a2 < a9 + a5.cellHeights[a4]) {
                return a10;
            }
            a9 += a5.cellHeights[a4];
            ++a10;
            n = ++a4;
        }
        return a4 - 1;
    }

    private int convertLocationToRowInColumn(int a, int a2) {
        KindleListUI a3;
        int a4 = 0;
        if (a3.layoutOrientation != 0) {
            a4 = SwingUtilities2.isLeftToRight((Component)a3.list) ? a2 * a3.cellWidth : a3.list.getWidth() - (a2 + 1) * a3.cellWidth - a3.list.getInsets().right;
        }
        return a3.convertLocationToRow(a4, a, true);
    }

    private int convertLocationToModel(int a, int a2) {
        KindleListUI a3;
        int a4 = a3.convertLocationToRow(a, a2, true);
        int a5 = a3.convertLocationToColumn(a, a2);
        if (a4 >= 0 && a5 >= 0) {
            return a3.getModelIndex(a5, a4);
        }
        return -1;
    }

    private int getRowCount(int a) {
        KindleListUI a2;
        if (a < 0 || a >= a2.columnCount) {
            return -1;
        }
        if (a2.layoutOrientation == 0 || a == 0 && a2.columnCount == 1) {
            return a2.list.getModel().getSize();
        }
        if (a >= a2.columnCount) {
            return -1;
        }
        if (a2.layoutOrientation == 1) {
            if (a < a2.columnCount - 1) {
                return a2.rowsPerColumn;
            }
            return a2.list.getModel().getSize() - (a2.columnCount - 1) * a2.rowsPerColumn;
        }
        int a3 = a2.columnCount - (a2.columnCount * a2.rowsPerColumn - a2.list.getModel().getSize());
        if (a >= a3) {
            return Math.max(0, a2.rowsPerColumn - 1);
        }
        return a2.rowsPerColumn;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getModelIndex(int a, int a2) {
        KindleListUI a3;
        switch (a3.layoutOrientation) {
            case 1: {
                return Math.min(a3.list.getModel().getSize() - 1, a3.rowsPerColumn * a + Math.min(a2, a3.rowsPerColumn - 1));
            }
            case 2: {
                return Math.min(a3.list.getModel().getSize() - 1, a2 * a3.columnCount + a);
            }
        }
        return a2;
    }

    private int convertLocationToColumn(int a, int a2) {
        KindleListUI a3;
        if (a3.cellWidth > 0) {
            if (a3.layoutOrientation == 0) {
                return 0;
            }
            Insets a4 = a3.list.getInsets();
            int a5 = SwingUtilities2.isLeftToRight((Component)a3.list) ? (a - a4.left) / a3.cellWidth : (a3.list.getWidth() - a - a4.right) / a3.cellWidth;
            if (a5 < 0) {
                return 0;
            }
            if (a5 >= a3.columnCount) {
                return a3.columnCount - 1;
            }
            return a5;
        }
        return 0;
    }

    private int convertModelToRow(int a) {
        KindleListUI a2;
        int a3 = a2.list.getModel().getSize();
        if (a < 0 || a >= a3) {
            return -1;
        }
        if (a2.layoutOrientation != 0 && a2.columnCount > 1 && a2.rowsPerColumn > 0) {
            if (a2.layoutOrientation == 1) {
                return a % a2.rowsPerColumn;
            }
            return a / a2.columnCount;
        }
        return a;
    }

    private int convertModelToColumn(int a) {
        KindleListUI a2;
        int a3 = a2.list.getModel().getSize();
        if (a < 0 || a >= a3) {
            return -1;
        }
        if (a2.layoutOrientation != 0 && a2.rowsPerColumn > 0 && a2.columnCount > 1) {
            if (a2.layoutOrientation == 1) {
                return a / a2.rowsPerColumn;
            }
            return a % a2.columnCount;
        }
        return 0;
    }

    protected void maybeUpdateLayoutState() {
        KindleListUI a;
        if (a.updateLayoutStateNeeded != 0) {
            a.updateLayoutState();
            a.updateLayoutStateNeeded = 0;
        }
    }

    protected void updateLayoutState() {
        KindleListUI a;
        int a2 = a.list.getFixedCellHeight();
        int a3 = a.list.getFixedCellWidth();
        int n = a.cellWidth = a3 != -1 ? a3 : -1;
        if (a2 != -1) {
            a.cellHeight = a2;
            a.cellHeights = null;
        } else {
            a.cellHeight = -1;
            a.cellHeights = new int[a.list.getModel().getSize()];
        }
        if (a3 == -1 || a2 == -1) {
            ListModel a4 = a.list.getModel();
            int a5 = a4.getSize();
            ListCellRenderer a6 = a.list.getCellRenderer();
            if (a6 != null) {
                int a7;
                int n2 = a7 = 0;
                while (n2 < a5) {
                    Object a8 = a4.getElementAt(a7);
                    Component a9 = a6.getListCellRendererComponent(a.list, a8, a7, false, false);
                    a.rendererPane.add(a9);
                    Dimension a10 = a9.getPreferredSize();
                    if (a3 == -1) {
                        a.cellWidth = Math.max(a10.width, a.cellWidth);
                    }
                    if (a2 == -1) {
                        a.cellHeights[a7] = a10.height;
                    }
                    n2 = ++a7;
                }
            } else {
                int a11;
                if (a.cellWidth == -1) {
                    a.cellWidth = 0;
                }
                if (a.cellHeights == null) {
                    a.cellHeights = new int[a5];
                }
                int n3 = a11 = 0;
                while (n3 < a5) {
                    a.cellHeights[a11] = 0;
                    n3 = ++a11;
                }
            }
        }
        a.columnCount = 1;
        if (a.layoutOrientation != 0) {
            a.updateHorizontalLayoutState(a3, a2);
        }
    }

    private void updateHorizontalLayoutState(int a, int a2) {
        int a3;
        KindleListUI a4;
        int a5 = a4.list.getVisibleRowCount();
        int a6 = a4.list.getModel().getSize();
        Insets a7 = a4.list.getInsets();
        a4.listHeight = a4.list.getHeight();
        a4.listWidth = a4.list.getWidth();
        if (a6 == 0) {
            a4.columnCount = 0;
            a4.rowsPerColumn = 0;
            a4.preferredHeight = a7.top + a7.bottom;
            return;
        }
        if (a2 != -1) {
            a3 = a2;
        } else {
            int a8 = 0;
            if (a4.cellHeights.length > 0) {
                int a9;
                a8 = a4.cellHeights[a4.cellHeights.length - 1];
                int n = a9 = a4.cellHeights.length - 2;
                while (n >= 0) {
                    a8 = Math.max(a8, a4.cellHeights[a9]);
                    n = --a9;
                }
            }
            a3 = a4.cellHeight = a8;
            a4.cellHeights = null;
        }
        a4.rowsPerColumn = a6;
        if (a5 > 0) {
            a4.rowsPerColumn = a5;
            a4.columnCount = Math.max(1, a6 / a4.rowsPerColumn);
            if (a6 > 0 && a6 > a4.rowsPerColumn && a6 % a4.rowsPerColumn != 0) {
                ++a4.columnCount;
            }
            if (a4.layoutOrientation == 2) {
                a4.rowsPerColumn = a6 / a4.columnCount;
                if (a6 % a4.columnCount > 0) {
                    ++a4.rowsPerColumn;
                }
            }
        } else if (a4.layoutOrientation == 1 && a3 != 0) {
            a4.rowsPerColumn = Math.max(1, (a4.listHeight - a7.top - a7.bottom) / a3);
            a4.columnCount = Math.max(1, a6 / a4.rowsPerColumn);
            if (a6 > 0 && a6 > a4.rowsPerColumn && a6 % a4.rowsPerColumn != 0) {
                ++a4.columnCount;
            }
        } else if (a4.layoutOrientation == 2 && a4.cellWidth > 0 && a4.listWidth > 0) {
            a4.columnCount = Math.max(1, (a4.listWidth - a7.left - a7.right) / a4.cellWidth);
            a4.rowsPerColumn = a6 / a4.columnCount;
            if (a6 % a4.columnCount > 0) {
                ++a4.rowsPerColumn;
            }
        }
        a4.preferredHeight = a4.rowsPerColumn * a4.cellHeight + a7.top + a7.bottom;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getSeparatorStyle() {
        KindleListUI a;
        int a2 = 0;
        Object a3 = a.list.getClientProperty("separator.style");
        if (!(a3 instanceof Integer)) return a2;
        switch ((Integer)a3) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return a2;
    }

    protected MouseInputListener createMouseInputListener() {
        KindleListUI a;
        return a.new MouseInputHandler();
    }

    protected FocusListener createFocusListener() {
        KindleListUI a;
        return a.new FocusHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        KindleListUI a;
        return a.new ListSelectionHandler();
    }

    private void redrawList() {
        KindleListUI a;
        a.list.revalidate();
        a.list.repaint();
    }

    protected ListDataListener createListDataListener() {
        KindleListUI a;
        return a.new ListDataHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        KindleListUI a;
        return a.new PropertyChangeHandler();
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public PropertyChangeHandler() {
            PropertyChangeHandler a;
        }

        public void propertyChange(PropertyChangeEvent a) {
            PropertyChangeHandler a2;
            String a3 = a.getPropertyName();
            if (a3.equals("model")) {
                ListModel a4 = (ListModel)a.getOldValue();
                ListModel a5 = (ListModel)a.getNewValue();
                if (a4 != null) {
                    a4.removeListDataListener(a2.KindleListUI.this.listDataListener);
                }
                if (a5 != null) {
                    a5.addListDataListener(a2.KindleListUI.this.listDataListener);
                }
                a2.KindleListUI.this.updateLayoutStateNeeded |= 1;
                a2.KindleListUI.this.redrawList();
            } else if (a3.equals("selectionModel")) {
                ListSelectionModel a6 = (ListSelectionModel)a.getOldValue();
                ListSelectionModel a7 = (ListSelectionModel)a.getNewValue();
                if (a6 != null) {
                    a6.removeListSelectionListener(a2.KindleListUI.this.listSelectionListener);
                }
                if (a7 != null) {
                    a7.addListSelectionListener(a2.KindleListUI.this.listSelectionListener);
                }
                a2.KindleListUI.this.updateLayoutStateNeeded |= 1;
                a2.KindleListUI.this.redrawList();
            } else if (a3.equals("cellRenderer")) {
                a2.KindleListUI.this.updateLayoutStateNeeded |= 0x40;
                a2.KindleListUI.this.redrawList();
            } else if (a3.equals("font")) {
                a2.KindleListUI.this.updateLayoutStateNeeded |= 4;
                a2.KindleListUI.this.redrawList();
            } else if (a3.equals("prototypeCellValue")) {
                a2.KindleListUI.this.updateLayoutStateNeeded |= 0x20;
                a2.KindleListUI.this.redrawList();
            } else if (a3.equals("fixedCellHeight")) {
                a2.KindleListUI.this.updateLayoutStateNeeded |= 0x10;
                a2.KindleListUI.this.redrawList();
            } else if (a3.equals("fixedCellWidth")) {
                a2.KindleListUI.this.updateLayoutStateNeeded |= 8;
                a2.KindleListUI.this.redrawList();
            } else if (a3.equals("cellRenderer")) {
                a2.KindleListUI.this.updateLayoutStateNeeded |= 0x40;
                a2.KindleListUI.this.redrawList();
            } else if (a3.equals("selectionForeground")) {
                a2.KindleListUI.this.list.repaint();
            } else if (a3.equals("selectionBackground")) {
                a2.KindleListUI.this.list.repaint();
            } else if ("layoutOrientation".equals(a3)) {
                a2.KindleListUI.this.updateLayoutStateNeeded |= 0x80;
                a2.KindleListUI.this.layoutOrientation = a2.KindleListUI.this.list.getLayoutOrientation();
                a2.KindleListUI.this.redrawList();
            } else if ("visibleRowCount".equals(a3)) {
                if (a2.KindleListUI.this.layoutOrientation != 0) {
                    a2.KindleListUI.this.updateLayoutStateNeeded |= 0x80;
                    a2.KindleListUI.this.redrawList();
                }
            } else if ("componentOrientation".equals(a3)) {
                a2.KindleListUI.this.leftToRight = SwingUtilities2.isLeftToRight((Component)a2.KindleListUI.this.list);
            }
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        public ListDataHandler() {
            ListDataHandler a;
        }

        public void intervalAdded(ListDataEvent a) {
            ListDataHandler a2;
            a2.KindleListUI.this.updateLayoutStateNeeded = 1;
            int a3 = Math.min(a.getIndex0(), a.getIndex1());
            int a4 = Math.max(a.getIndex0(), a.getIndex1());
            ListSelectionModel a5 = a2.KindleListUI.this.list.getSelectionModel();
            if (a5 != null) {
                a5.insertIndexInterval(a3, a4 - a3 + 1, true);
            }
            a2.KindleListUI.this.redrawList();
        }

        public void intervalRemoved(ListDataEvent a) {
            ListDataHandler a2;
            a2.KindleListUI.this.updateLayoutStateNeeded = 1;
            ListSelectionModel a3 = a2.KindleListUI.this.list.getSelectionModel();
            if (a3 != null) {
                a3.removeIndexInterval(a.getIndex0(), a.getIndex1());
            }
            a2.KindleListUI.this.redrawList();
        }

        public void contentsChanged(ListDataEvent a) {
            ListDataHandler a2;
            a2.KindleListUI.this.updateLayoutStateNeeded = 1;
            a2.KindleListUI.this.redrawList();
        }
    }

    public class ListSelectionHandler
    implements ListSelectionListener {
        public ListSelectionHandler() {
            ListSelectionHandler a;
        }

        public void valueChanged(ListSelectionEvent a) {
            ListSelectionHandler a2;
            a2.KindleListUI.this.maybeUpdateLayoutState();
            Rectangle a3 = a2.KindleListUI.this.getCellBounds(a2.KindleListUI.this.list, a.getFirstIndex(), a.getLastIndex());
            if (a3 != null) {
                a2.KindleListUI.this.list.repaint(a3.x, a3.y, a3.width, a3.height);
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        public FocusHandler() {
            FocusHandler a;
        }

        protected void repaintCellFocus() {
            Rectangle a;
            FocusHandler a2;
            int a3 = a2.KindleListUI.this.list.getLeadSelectionIndex();
            if (a3 != -1 && (a = a2.KindleListUI.this.getCellBounds(a2.KindleListUI.this.list, a3, a3)) != null) {
                a2.KindleListUI.this.list.repaint(a.x, a.y, a.width, a.height);
            }
        }

        public void focusGained(FocusEvent a) {
        }

        public void focusLost(FocusEvent a) {
        }
    }

    public class MouseInputHandler
    extends GestureDispatcher {
        public MouseInputHandler() {
            MouseInputHandler a;
        }

        public void mousePressed(MouseEvent a) {
            MouseInputHandler a2;
            if (a.isConsumed() || !SwingUtilities.isLeftMouseButton(a) || !a2.KindleListUI.this.list.isEnabled()) {
                super.mousePressed(a);
                return;
            }
            a2.adjustFocusAndSelection(a);
            super.mousePressed(a);
        }

        private void adjustFocusAndSelection(MouseEvent a) {
            int a2;
            MouseInputHandler a3;
            if (!SwingUtilities.isLeftMouseButton(a) || !a3.KindleListUI.this.list.isEnabled()) {
                return;
            }
            if (!a3.KindleListUI.this.list.hasFocus() && a3.KindleListUI.this.list.isRequestFocusEnabled()) {
                a3.KindleListUI.this.list.requestFocus();
            }
            if ((a2 = a3.KindleListUI.this.convertLocationToModel(a.getX(), a.getY())) != -1) {
                boolean a4 = a.getID() == 501;
                a3.KindleListUI.this.list.setValueIsAdjusting(a4);
                int a5 = a3.KindleListUI.this.list.getAnchorSelectionIndex();
                if (a.isControlDown()) {
                    if (a3.KindleListUI.this.list.isSelectedIndex(a2)) {
                        a3.KindleListUI.this.list.removeSelectionInterval(a2, a2);
                    } else {
                        a3.KindleListUI.this.list.addSelectionInterval(a2, a2);
                    }
                } else if (a.isShiftDown() && a5 != -1) {
                    a3.KindleListUI.this.list.setSelectionInterval(a5, a2);
                } else if (a3.KindleListUI.this.list.getSelectionModel().getSelectionMode() == 2) {
                    if (a3.KindleListUI.this.list.isSelectedIndex(a2)) {
                        a3.KindleListUI.this.list.removeSelectionInterval(a2, a2);
                    } else {
                        a3.KindleListUI.this.list.addSelectionInterval(a2, a2);
                    }
                } else {
                    a3.KindleListUI.this.list.setSelectionInterval(a2, a2);
                }
            }
        }
    }
}

