/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing.plaf.kindle;

import com.amazon.agui.swing.plaf.kindle.KindleLookAndFeel;
import com.amazon.agui.swing.plaf.kindle.KindleTheme;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ActionMapUIResource;
import com.sun.java.swing.plaf.ColorUIResource;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameEvent;

public class KindleInternalFrameTitlePane
extends JComponent {
    private static final Insets INSETS_0_0_0_0 = new Insets(0, 0, 0, 0);
    private static final int TITLE_PANE_GAP = 5;
    protected boolean isPalette = false;
    protected Icon paletteCloseIcon;
    protected int paletteTitleHeight;
    private static final Border EMPTY_BORDER_0_0_0_0 = new EmptyBorder(0, 0, 0, 0);
    private String selectedBackgroundKey;
    private String selectedForegroundKey;
    private String selectedShadowKey;
    private boolean wasClosable;
    int buttonsWidth = 0;
    protected JButton iconButton;
    protected JButton maxButton;
    protected JButton closeButton;
    protected JInternalFrame frame;
    protected Color selectedTitleColor;
    protected Color selectedTextColor;
    protected Color notSelectedTitleColor;
    protected Color notSelectedTextColor;
    protected Icon maxIcon;
    protected Icon minIcon;
    protected Icon iconIcon;
    protected Icon closeIcon;
    protected PropertyChangeListener propertyChangeListener;
    protected Action closeAction;
    protected Action maximizeAction;
    protected Action iconifyAction;
    protected Action restoreAction;
    protected Action moveAction;
    protected Action sizeAction;
    protected static final String CLOSE_CMD = UIManager.getString((Object)"InternalFrameTitlePane.closeButtonText");
    protected static final String ICONIFY_CMD = UIManager.getString((Object)"InternalFrameTitlePane.minimizeButtonText");
    protected static final String RESTORE_CMD = UIManager.getString((Object)"InternalFrameTitlePane.restoreButtonText");
    protected static final String MAXIMIZE_CMD = UIManager.getString((Object)"InternalFrameTitlePane.maximizeButtonText");
    protected static final String MOVE_CMD = UIManager.getString((Object)"InternalFrameTitlePane.moveButtonText");
    protected static final String SIZE_CMD = UIManager.getString((Object)"InternalFrameTitlePane.sizeButtonText");
    private String closeButtonToolTip;
    private String iconButtonToolTip;
    private String restoreButtonToolTip;
    private String maxButtonToolTip;

    public KindleInternalFrameTitlePane(JInternalFrame a) {
        KindleInternalFrameTitlePane a2;
        a2.frame = a;
        a2.installTitlePane();
    }

    public void addNotify() {
        KindleInternalFrameTitlePane a;
        super.addNotify();
        a.updateOptionPaneState();
    }

    protected void assembleSystemMenu() {
    }

    protected void addSystemMenuItems(JMenu a) {
    }

    protected void showSystemMenu() {
    }

    protected void addSubComponents() {
        KindleInternalFrameTitlePane a;
        a.add(a.iconButton);
        a.add(a.maxButton);
        a.add(a.closeButton);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        KindleInternalFrameTitlePane a;
        return a.new PropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        KindleInternalFrameTitlePane a;
        return a.new TitlePaneLayout();
    }

    public void paintPalette(Graphics a) {
        KindleInternalFrameTitlePane a2;
        int a3 = a2.getWidth();
        int a4 = a2.getHeight();
        ColorUIResource a5 = KindleLookAndFeel.getPrimaryControlDarkShadow();
        a.setColor((Color)a5);
        a.drawLine(0, a4 - 1, a3, a4 - 1);
    }

    public void paintComponent(Graphics a) {
        String a2;
        Color a3;
        Color a4;
        KindleInternalFrameTitlePane a5;
        if (a5.isPalette) {
            a5.paintPalette(a);
            return;
        }
        boolean a6 = a5.frame.isSelected();
        if (a6) {
            a4 = a5.selectedBackgroundKey != null ? UIManager.getColor((Object)a5.selectedBackgroundKey) : UIManager.getColor((Object)"InternalFrame.activeTitleBackground");
            a3 = a5.selectedShadowKey != null ? UIManager.getColor((Object)a5.selectedShadowKey) : UIManager.getColor((Object)"InternalFrame.activeTitleSeparator");
        } else {
            a4 = UIManager.getColor((Object)"InternalFrame.inactiveTitleBackground");
            a3 = UIManager.getColor((Object)"InternalFrame.inactiveTitleSeparator");
        }
        int a7 = a5.frame.getWidth();
        int a8 = a5.frame.getHeight();
        a.setColor(a4);
        a.fillRect(0, 0, a7, a8);
        if (a3 != null) {
            a.setColor(a3);
            a.drawLine(0, a8 - 1, a7, a8 - 1);
        }
        int a9 = 5;
        Icon a10 = a5.frame.getFrameIcon();
        if (a10 != null) {
            int a11 = a8 - a10.getIconHeight() >> 1;
            a10.paintIcon(a5.frame, a, a9, a11);
            a9 += a10.getIconWidth() + 5;
        }
        if ((a2 = a5.frame.getTitle()) != null && a2.length() > 0) {
            Color a12 = a6 ? (a5.selectedForegroundKey != null ? UIManager.getColor((Object)a5.selectedForegroundKey) : UIManager.getColor((Object)"InternalFrame.activeTitleForeground")) : UIManager.getColor((Object)"InternalFrame.inactiveTitleForeground");
            a.setColor(a12);
            a.setFont(a5.frame.getFont());
            FontMetrics a13 = a.getFontMetrics();
            int a14 = (a8 - a13.getHeight() >> 1) + a13.getAscent();
            int a15 = 0;
            if (a5.frame.isIconifiable()) {
                a15 = a5.iconButton.getBounds().x;
            } else if (a5.frame.isMaximizable()) {
                a15 = a5.maxButton.getBounds().x;
            } else if (a5.frame.isClosable()) {
                a15 = a5.closeButton.getBounds().x;
            }
            if (a15 == 0) {
                a15 = a5.getWidth();
            }
            int a16 = a15 - a9 - 5;
            a2 = KindleTheme.clipString(a2, a13, a16);
            Graphics2D a17 = (Graphics2D)a;
            Composite a18 = a17.getComposite();
            a17.setComposite(AlphaComposite.SrcOver);
            a.drawString(a2, a9, a14);
            a17.setComposite(a18);
        }
    }

    public void setPalette(boolean a) {
        KindleInternalFrameTitlePane a2;
        a2.isPalette = a;
        if (a2.isPalette) {
            a2.closeButton.setIcon(a2.paletteCloseIcon);
            if (a2.frame.isMaximizable()) {
                a2.remove(a2.maxButton);
            }
            if (a2.frame.isIconifiable()) {
                a2.remove(a2.iconButton);
            }
        } else {
            a2.closeButton.setIcon(a2.closeIcon);
            if (a2.frame.isMaximizable()) {
                a2.add(a2.maxButton);
            }
            if (a2.frame.isIconifiable()) {
                a2.add(a2.iconButton);
            }
        }
        a2.revalidate();
        a2.repaint();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateOptionPaneState() {
        KindleInternalFrameTitlePane a;
        int a2 = -2;
        boolean a3 = a.wasClosable;
        Object a4 = a.frame.getClientProperty("JInternalFrame.messageType");
        if (a4 == null) {
            return;
        }
        if (a4 instanceof Integer) {
            a2 = (Integer)a4;
        }
        switch (a2) {
            case 0: {
                a.selectedBackgroundKey = "OptionPane.errorDialog.titlePane.background";
                a.selectedForegroundKey = "OptionPane.errorDialog.titlePane.foreground";
                a.selectedShadowKey = "OptionPane.errorDialog.titlePane.shadow";
                a3 = false;
                break;
            }
            case 3: {
                a.selectedBackgroundKey = "OptionPane.questionDialog.titlePane.background";
                a.selectedForegroundKey = "OptionPane.questionDialog.titlePane.foreground";
                a.selectedShadowKey = "OptionPane.questionDialog.titlePane.shadow";
                a3 = false;
                break;
            }
            case 2: {
                a.selectedBackgroundKey = "OptionPane.warningDialog.titlePane.background";
                a.selectedForegroundKey = "OptionPane.warningDialog.titlePane.foreground";
                a.selectedShadowKey = "OptionPane.warningDialog.titlePane.shadow";
                a3 = false;
                break;
            }
            case -1: 
            case 1: {
                a.selectedShadowKey = null;
                a.selectedForegroundKey = null;
                a.selectedBackgroundKey = null;
                a3 = false;
                break;
            }
            default: {
                a.selectedShadowKey = null;
                a.selectedForegroundKey = null;
                a.selectedBackgroundKey = null;
            }
        }
        if (a3 != a.frame.isClosable()) {
            a.frame.setClosable(a3);
        }
    }

    protected void installTitlePane() {
        KindleInternalFrameTitlePane a;
        a.installDefaults();
        a.installListeners();
        a.createActions();
        a.enableActions();
        a.createActionMap();
        a.setLayout(a.createLayout());
        a.assembleSystemMenu();
        a.createButtons();
        a.addSubComponents();
    }

    ActionMap createActionMap() {
        return new ActionMapUIResource();
    }

    protected void createActions() {
        KindleInternalFrameTitlePane a;
        a.maximizeAction = a.new MaximizeAction();
        a.iconifyAction = a.new IconifyAction();
        a.closeAction = a.new CloseAction();
        a.restoreAction = a.new RestoreAction();
        a.moveAction = a.new MoveAction();
        a.sizeAction = a.new SizeAction();
    }

    protected void installListeners() {
        KindleInternalFrameTitlePane a;
        if (a.propertyChangeListener == null) {
            a.propertyChangeListener = a.createPropertyChangeListener();
        }
        a.frame.addPropertyChangeListener(a.propertyChangeListener);
    }

    public void uninstallListeners() {
        KindleInternalFrameTitlePane a;
        a.frame.removePropertyChangeListener(a.propertyChangeListener);
    }

    protected void installDefaults() {
        KindleInternalFrameTitlePane a;
        a.maxIcon = UIManager.getIcon((Object)"InternalFrame.maximizeIcon");
        a.minIcon = UIManager.getIcon((Object)"InternalFrame.minimizeIcon");
        a.iconIcon = UIManager.getIcon((Object)"InternalFrame.iconifyIcon");
        a.closeIcon = UIManager.getIcon((Object)"InternalFrame.closeIcon");
        a.setFont(UIManager.getFont((Object)"InternalFrame.titleFont"));
        a.paletteTitleHeight = UIManager.getInt((Object)"InternalFrame.paletteTitleHeight");
        a.paletteCloseIcon = UIManager.getIcon((Object)"InternalFrame.paletteCloseIcon");
        a.wasClosable = a.frame.isClosable();
        a.selectedBackgroundKey = null;
        a.selectedForegroundKey = null;
    }

    protected void uninstallDefaults() {
        KindleInternalFrameTitlePane a;
        if (a.wasClosable != a.frame.isClosable()) {
            a.frame.setClosable(a.wasClosable);
        }
    }

    protected void createButtons() {
        KindleInternalFrameTitlePane a;
        a.iconButton = a.new NoFocusButton();
        a.iconButton.setOpaque(false);
        a.iconButton.addActionListener(a.iconifyAction);
        if (a.iconButtonToolTip != null && a.iconButtonToolTip.length() != 0) {
            a.iconButton.setToolTipText(a.iconButtonToolTip);
        }
        a.maxButton = a.new NoFocusButton();
        a.maxButton.setOpaque(false);
        a.maxButton.addActionListener(a.maximizeAction);
        a.closeButton = a.new NoFocusButton();
        a.closeButton.setOpaque(false);
        a.closeButton.addActionListener(a.closeAction);
        if (a.closeButtonToolTip != null && a.closeButtonToolTip.length() != 0) {
            a.closeButton.setToolTipText(a.closeButtonToolTip);
        }
        a.setButtonIcons();
        Boolean a2 = a.frame.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        a.iconButton.putClientProperty("paintActive", a2);
        a.iconButton.setBorder(EMPTY_BORDER_0_0_0_0);
        a.maxButton.putClientProperty("paintActive", a2);
        a.maxButton.setBorder(EMPTY_BORDER_0_0_0_0);
        a.closeButton.putClientProperty("paintActive", a2);
        a.closeButton.setBorder(EMPTY_BORDER_0_0_0_0);
    }

    protected void setButtonIcons() {
        KindleInternalFrameTitlePane a;
        if (a.frame.isIcon()) {
            a.iconButton.setIcon(a.minIcon);
            if (a.restoreButtonToolTip != null && a.restoreButtonToolTip.length() != 0) {
                a.iconButton.setToolTipText(a.restoreButtonToolTip);
            }
            a.maxButton.setIcon(a.maxIcon);
            if (a.maxButtonToolTip != null && a.maxButtonToolTip.length() != 0) {
                a.maxButton.setToolTipText(a.maxButtonToolTip);
            }
        } else if (a.frame.isMaximum()) {
            a.iconButton.setIcon(a.iconIcon);
            a.maxButton.setIcon(a.minIcon);
            if (a.restoreButtonToolTip != null && a.restoreButtonToolTip.length() != 0) {
                a.maxButton.setToolTipText(a.restoreButtonToolTip);
            }
        } else {
            a.iconButton.setIcon(a.iconIcon);
            if (a.iconButtonToolTip != null && a.iconButtonToolTip.length() != 0) {
                a.iconButton.setToolTipText(a.iconButtonToolTip);
            }
            a.maxButton.setIcon(a.maxIcon);
            if (a.maxButtonToolTip != null && a.maxButtonToolTip.length() != 0) {
                a.maxButton.setToolTipText(a.maxButtonToolTip);
            }
        }
        a.closeButton.setIcon(a.closeIcon);
    }

    protected String getTitle(String a, FontMetrics a2, int a3) {
        if (a == null || a.equals("")) {
            return "";
        }
        int a4 = SwingUtilities.computeStringWidth(a2, a);
        String a5 = "...";
        if (a4 > a3) {
            int a6;
            int a7 = SwingUtilities.computeStringWidth(a2, a5);
            int n = a6 = 0;
            while (n < a.length() && (a7 += a2.charWidth(a.charAt(a6))) <= a3) {
                n = ++a6;
            }
            a = a.substring(0, a6) + a5;
        }
        return a;
    }

    protected void postClosingEvent(JInternalFrame a) {
        InternalFrameEvent a2 = new InternalFrameEvent(a, 25550);
        if (JInternalFrame.class.getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(a2);
                return;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        a.dispatchEvent(a2);
    }

    protected void enableActions() {
        KindleInternalFrameTitlePane a;
        a.restoreAction.setEnabled(a.frame.isMaximum() || a.frame.isIcon());
        a.maximizeAction.setEnabled(a.frame.isMaximizable() && !a.frame.isMaximum());
        a.iconifyAction.setEnabled(a.frame.isIconifiable() && !a.frame.isIcon());
        a.closeAction.setEnabled(a.frame.isClosable());
        a.sizeAction.setEnabled(false);
        a.moveAction.setEnabled(false);
    }

    public class SizeAction
    extends AbstractAction {
        public SizeAction() {
            SizeAction a;
            super(SIZE_CMD);
        }

        public void actionPerformed(ActionEvent a) {
        }
    }

    public class MoveAction
    extends AbstractAction {
        public MoveAction() {
            MoveAction a;
            super(MOVE_CMD);
        }

        public void actionPerformed(ActionEvent a) {
        }
    }

    public class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            RestoreAction a;
            super(RESTORE_CMD);
        }

        public void actionPerformed(ActionEvent a) {
            RestoreAction a2;
            if (a2.KindleInternalFrameTitlePane.this.frame.isMaximizable() && a2.KindleInternalFrameTitlePane.this.frame.isMaximum()) {
                try {
                    a2.KindleInternalFrameTitlePane.this.frame.setMaximum(false);
                }
                catch (PropertyVetoException a3) {}
            } else if (a2.KindleInternalFrameTitlePane.this.frame.isIconifiable() && a2.KindleInternalFrameTitlePane.this.frame.isIcon()) {
                try {
                    a2.KindleInternalFrameTitlePane.this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    public class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            IconifyAction a;
            super(ICONIFY_CMD);
        }

        public void actionPerformed(ActionEvent a) {
            IconifyAction a2;
            if (a2.KindleInternalFrameTitlePane.this.frame.isIconifiable()) {
                if (!a2.KindleInternalFrameTitlePane.this.frame.isIcon()) {
                    try {
                        a2.KindleInternalFrameTitlePane.this.frame.setIcon(true);
                    }
                    catch (PropertyVetoException a3) {}
                } else {
                    try {
                        a2.KindleInternalFrameTitlePane.this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            MaximizeAction a;
            super(MAXIMIZE_CMD);
        }

        public void actionPerformed(ActionEvent a) {
            MaximizeAction a2;
            if (a2.KindleInternalFrameTitlePane.this.frame.isMaximizable()) {
                if (!a2.KindleInternalFrameTitlePane.this.frame.isMaximum()) {
                    try {
                        a2.KindleInternalFrameTitlePane.this.frame.setMaximum(true);
                    }
                    catch (PropertyVetoException a3) {}
                } else {
                    try {
                        a2.KindleInternalFrameTitlePane.this.frame.setMaximum(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class CloseAction
    extends AbstractAction {
        public CloseAction() {
            CloseAction a;
            super(CLOSE_CMD);
        }

        public void actionPerformed(ActionEvent a) {
            CloseAction a2;
            if (a2.KindleInternalFrameTitlePane.this.frame.isClosable()) {
                a2.KindleInternalFrameTitlePane.this.frame.doDefaultCloseAction();
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public PropertyChangeHandler() {
            PropertyChangeHandler a;
        }

        public void propertyChange(PropertyChangeEvent a) {
            PropertyChangeHandler a2;
            String a3 = a.getPropertyName();
            if (a3.equals("selected")) {
                Boolean a4 = (Boolean)a.getNewValue();
                a2.KindleInternalFrameTitlePane.this.iconButton.putClientProperty("paintActive", a4);
                a2.KindleInternalFrameTitlePane.this.closeButton.putClientProperty("paintActive", a4);
                a2.KindleInternalFrameTitlePane.this.maxButton.putClientProperty("paintActive", a4);
                a2.KindleInternalFrameTitlePane.this.repaint();
                return;
            }
            if ("JInternalFrame.messageType".equals(a3)) {
                a2.KindleInternalFrameTitlePane.this.updateOptionPaneState();
                a2.KindleInternalFrameTitlePane.this.frame.repaint();
            }
            if ("icon".equals(a3) || "maximum".equals(a3)) {
                a2.KindleInternalFrameTitlePane.this.setButtonIcons();
                a2.KindleInternalFrameTitlePane.this.enableActions();
                return;
            }
            if (a3.equals("closable")) {
                if ((Boolean)a.getNewValue() == Boolean.TRUE) {
                    a2.KindleInternalFrameTitlePane.this.add(a2.KindleInternalFrameTitlePane.this.closeButton);
                } else {
                    a2.KindleInternalFrameTitlePane.this.remove(a2.KindleInternalFrameTitlePane.this.closeButton);
                }
            } else if (a3.equals("maximizable")) {
                if ((Boolean)a.getNewValue() == Boolean.TRUE) {
                    a2.KindleInternalFrameTitlePane.this.add(a2.KindleInternalFrameTitlePane.this.maxButton);
                } else {
                    a2.KindleInternalFrameTitlePane.this.remove(a2.KindleInternalFrameTitlePane.this.maxButton);
                }
            } else if (a3.equals("iconable")) {
                if ((Boolean)a.getNewValue() == Boolean.TRUE) {
                    a2.KindleInternalFrameTitlePane.this.add(a2.KindleInternalFrameTitlePane.this.iconButton);
                } else {
                    a2.KindleInternalFrameTitlePane.this.remove(a2.KindleInternalFrameTitlePane.this.iconButton);
                }
            }
            a2.KindleInternalFrameTitlePane.this.enableActions();
            a2.KindleInternalFrameTitlePane.this.revalidate();
            a2.KindleInternalFrameTitlePane.this.repaint();
        }
    }

    private class NoFocusButton
    extends JButton {
        public NoFocusButton() {
            NoFocusButton a;
            a.setFocusPainted(false);
            a.setMargin(INSETS_0_0_0_0);
            a.setOpaque(true);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        public TitlePaneLayout() {
            TitlePaneLayout a;
        }

        public void addLayoutComponent(String a, Component a2) {
        }

        public void removeLayoutComponent(Component a) {
        }

        public Dimension preferredLayoutSize(Container a) {
            TitlePaneLayout a2;
            return a2.minimumLayoutSize(a);
        }

        public Dimension minimumLayoutSize(Container a) {
            int a2;
            int a3;
            TitlePaneLayout a4;
            int a5 = 30;
            if (a4.KindleInternalFrameTitlePane.this.frame.isClosable()) {
                a5 += 21;
            }
            if (a4.KindleInternalFrameTitlePane.this.frame.isMaximizable()) {
                a5 += 16 + (a4.KindleInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (a4.KindleInternalFrameTitlePane.this.frame.isIconifiable()) {
                a5 += 16 + (a4.KindleInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (a4.KindleInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics a6 = a4.KindleInternalFrameTitlePane.this.getFontMetrics(a4.KindleInternalFrameTitlePane.this.getFont());
            String a7 = a4.KindleInternalFrameTitlePane.this.frame.getTitle();
            int a8 = a7 != null ? a6.stringWidth(a7) : 0;
            int n = a3 = a7 != null ? a7.length() : 0;
            a5 = a3 > 2 ? (a5 += a8 < (a2 = a6.stringWidth(a4.KindleInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...")) ? a8 : a2) : (a5 += a8);
            a2 = 0;
            if (a4.KindleInternalFrameTitlePane.this.isPalette) {
                a2 = a4.KindleInternalFrameTitlePane.this.paletteTitleHeight;
            } else {
                int a9 = a6.getHeight();
                a9 += 7;
                Icon a10 = a4.KindleInternalFrameTitlePane.this.frame.getFrameIcon();
                int a11 = 0;
                if (a10 != null) {
                    a11 = Math.min(a10.getIconHeight(), 20);
                }
                a2 = Math.max(a9, a11);
            }
            return new Dimension(a5, 30);
        }

        public void layoutContainer(Container a) {
            TitlePaneLayout a2;
            int a3;
            int a4 = a3 = a2.KindleInternalFrameTitlePane.this.getWidth();
            int a5 = 0;
            int a6 = a2.KindleInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            int a7 = a2.KindleInternalFrameTitlePane.this.closeButton.getIcon().getIconWidth();
            if (a2.KindleInternalFrameTitlePane.this.frame.isClosable()) {
                boolean a8 = false;
                if (a2.KindleInternalFrameTitlePane.this.isPalette) {
                    a2.KindleInternalFrameTitlePane.this.closeButton.setBounds(a4 += -(a7 + 2), a5, a7 + 2, a2.KindleInternalFrameTitlePane.this.getHeight() - 4);
                } else {
                    a2.KindleInternalFrameTitlePane.this.closeButton.setBounds(a4 += -a7, a5, a7, a6);
                }
            }
            if (a2.KindleInternalFrameTitlePane.this.frame.isMaximizable() && !a2.KindleInternalFrameTitlePane.this.isPalette) {
                a2.KindleInternalFrameTitlePane.this.maxButton.setBounds(a4 -= a7, a5, a7, a6);
            }
            if (a2.KindleInternalFrameTitlePane.this.frame.isIconifiable() && !a2.KindleInternalFrameTitlePane.this.isPalette) {
                a2.KindleInternalFrameTitlePane.this.iconButton.setBounds(a4 -= a7, a5, a7, a6);
            }
            a2.KindleInternalFrameTitlePane.this.buttonsWidth = a3 - a4;
        }
    }
}

