/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing.event;

import com.amazon.agui.swing.event.GestureEvent;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.sun.awt.event.MouseEvents;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class GestureDispatcher
implements MouseInputListener {
    private static final Log LOG = Log.getInstance((String)"GestureDispatcher");
    private static final LogMessage RECOGNIZED = new LogMessage("GestureRecognized", new String[]{"gesture", "id", "source"});
    private static final LogMessage ACTION_NOT_PERFORMED = new LogMessage("GestureNoAction", new String[]{"gesture", "list"});
    public static final int BUTTON_TAP = 1;
    public static final int BUTTON_TAP2 = 2;
    public static final int BUTTON_NORTH = 3;
    public static final int BUTTON_SOUTH = 4;
    public static final int BUTTON_WEST = 5;
    public static final int BUTTON_EAST = 6;
    public static final int BUTTON_SHRINK = 7;
    public static final int BUTTON_GROW = 8;
    public static final int BUTTON_HOLD = 9;
    private JComponent mForwardTo;
    private Component mLastTargetEntered;
    private boolean mReleasePending = false;

    public GestureDispatcher() {
        GestureDispatcher a;
    }

    public GestureDispatcher(JComponent a) {
        a2();
        GestureDispatcher a2;
        a2.mForwardTo = a;
    }

    public void setForwardToComponent(JComponent a) {
        a.mForwardTo = a;
    }

    public void mousePressed(MouseEvent a) {
        GestureDispatcher a2;
        if (a.isConsumed()) {
            return;
        }
        a2.forwardEvent(a);
        if (a2.mForwardTo == null && a.getButton() == 1) {
            a2.mReleasePending = true;
        }
    }

    public void mouseReleased(MouseEvent a) {
        GestureDispatcher a2;
        if (a.isConsumed()) {
            return;
        }
        a2.forwardEvent(a);
        if (a2.mForwardTo == null && a2.mReleasePending && a.getButton() == 1) {
            a2.mReleasePending = false;
            ActionMap a3 = ((JComponent)a.getSource()).getActionMap();
            if (a3 == null || a3.size() == 0) {
                return;
            }
            a2.performAction(a3, "release", a);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mouseClicked(MouseEvent a) {
        String a2;
        Serializable a3;
        GestureDispatcher a4;
        if (a.isConsumed()) {
            return;
        }
        if (!(a.getSource() instanceof JComponent)) {
            a4.forwardEvent(a);
        }
        if (Log.isDebugOn()) {
            LOG.debug("GestureDispatcher MouseClicked - Source=" + a.getSource().getClass().getName() + "...");
            a3 = ((Container)a.getSource()).getParent();
            a2 = " !!!";
            Serializable serializable = a3;
            while (serializable != null) {
                LOG.debug(a2 + a3.getClass().getName() + "...");
                a3 = ((Component)a3).getParent();
                a2 = a2 + "!";
                serializable = a3;
            }
        }
        if ((a3 = ((JComponent)a.getSource()).getActionMap()) == null || ((ActionMap)a3).size() == 0) {
            a4.forwardEvent(a);
        }
        a2 = null;
        switch (a.getButton()) {
            case 1: {
                if (a.getClickCount() == 1) {
                    a2 = "tap";
                    break;
                }
                if (a.getClickCount() != 2) break;
                a2 = "doubleTap";
                break;
            }
            case 2: {
                a2 = "tap2";
                break;
            }
            case 3: {
                a2 = "north";
                break;
            }
            case 4: {
                a2 = "south";
                break;
            }
            case 5: {
                a2 = "west";
                break;
            }
            case 6: {
                a2 = "east";
                break;
            }
            case 7: {
                a2 = "shrink";
                break;
            }
            case 8: {
                a2 = "grow";
                break;
            }
            case 9: {
                a2 = "hold";
                break;
            }
        }
        if (!a4.performAction((ActionMap)a3, a2, a)) {
            a4.forwardEvent(a);
        }
    }

    public void mouseEntered(MouseEvent a) {
        GestureDispatcher a2;
        a2.forwardEvent(a);
    }

    public void mouseExited(MouseEvent a) {
        GestureDispatcher a2;
        a2.forwardEvent(a);
    }

    public void mouseDragged(MouseEvent a) {
        GestureDispatcher a2;
        a2.forwardEvent(a);
    }

    public void mouseMoved(MouseEvent a) {
        GestureDispatcher a2;
        a2.forwardEvent(a);
    }

    private boolean performAction(ActionMap a, String a2, MouseEvent a3) {
        if (a2 != null) {
            Action a4 = a.get(a2);
            if (a4 != null && a4.isEnabled()) {
                GestureDispatcher a5;
                if (Log.isDebugOn()) {
                    LOG.debug(RECOGNIZED, new String[]{a2, "0x" + Integer.toHexString(a5.hashCode()), a3.getSource().toString()}, null);
                }
                if (a5.mLastTargetEntered != null) {
                    a5.mLastTargetEntered.dispatchEvent(MouseEvents.createMouseEvent((Component)a5.mLastTargetEntered, (int)505, (long)a3.getWhen(), (int)a3.getModifiers(), (int)a3.getX(), (int)a3.getY(), (int)a3.getClickCount(), (boolean)a3.isPopupTrigger(), (int)a3.getButton()));
                }
                a5.mReleasePending = false;
                try {
                    a4.actionPerformed(new GestureEvent(a3.getSource(), 1001, a2, a3.getWhen(), a3.getModifiers(), a3.getPoint()));
                }
                catch (Exception a6) {
                    LOG.error(Log.CATCHALL_EX, null, "Error in actionPerformed", (Throwable)a6);
                }
                a3.consume();
                return true;
            }
            if (Log.isDebugOn()) {
                LOG.debug(Log.CATCHALL_EX, null, a4 != null ? "recognized action not enabled" : "action not mapped");
                StringBuffer a7 = new StringBuffer();
                Object[] a8 = a.allKeys();
                if (a8 != null) {
                    int a9;
                    int n = a9 = 0;
                    while (n < a8.length) {
                        a7.append(a8[a9]).append('=');
                        Action a10 = a.get(a8[a9]);
                        a7.append(a10).append(',');
                        n = ++a9;
                    }
                }
                LOG.debug(ACTION_NOT_PERFORMED, new String[]{a2, "[" + a7.toString() + "]"}, null);
            }
        }
        return false;
    }

    private void forwardEvent(MouseEvent a) {
        GestureDispatcher a2;
        if (a2.mForwardTo == null) {
            return;
        }
        Point a3 = a.getPoint();
        Point a4 = SwingUtilities.convertPoint((Component)a.getSource(), a3, a2.mForwardTo);
        Component a5 = SwingUtilities.getDeepestComponentAt(a2.mForwardTo, a4.x, a4.y);
        if (a5 == null) {
            return;
        }
        int a6 = a.getID();
        if (a6 == 501) {
            if (!a5.equals(a2.mLastTargetEntered) && a2.mLastTargetEntered != null) {
                a2.mLastTargetEntered.dispatchEvent(MouseEvents.createMouseEvent((Component)a2.mLastTargetEntered, (int)505, (long)a.getWhen(), (int)a.getModifiers(), (int)a.getX(), (int)a.getY(), (int)a.getClickCount(), (boolean)a.isPopupTrigger(), (int)a.getButton()));
            }
            if (a.getButton() == 1) {
                a2.mLastTargetEntered = a5;
            }
        } else if ((a6 == 506 || a6 == 502) && a2.mLastTargetEntered != null && a.getButton() == 1) {
            a5 = a2.mLastTargetEntered;
        }
        Point a7 = SwingUtilities.convertPoint(a2.mForwardTo, a4, a5);
        a5.dispatchEvent(MouseEvents.createMouseEvent((Component)a5, (int)a.getID(), (long)a.getWhen(), (int)a.getModifiers(), (int)a7.x, (int)a7.y, (int)a.getClickCount(), (boolean)a.isPopupTrigger(), (int)a.getButton()));
        if (a6 == 502 && a.getButton() == 1) {
            a2.mLastTargetEntered = null;
        }
    }
}

