/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing;

import com.amazon.ebook.util.text.FieldBasedTimeModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;

public class TimeWidget
extends JPanel {
    private static final String STUFFER_CHAR = " ";
    private FieldBasedTimeModel fbtm;
    private TimeSpinner minuteSpinner;
    private TimeSpinner hourSpinner;
    private TimeSpinner ampmSpinner;
    private JLabel separatorLabel;
    private boolean isEnabled;

    public TimeWidget() {
        TimeWidget a;
        a.fbtm = null;
        a.ampmSpinner = null;
        a.isEnabled = true;
        a.fbtm = FieldBasedTimeModel.getInstance();
        a.initUI();
    }

    public TimeWidget(FieldBasedTimeModel a) {
        TimeWidget a2;
        a2.fbtm = null;
        a2.ampmSpinner = null;
        a2.isEnabled = true;
        a2.fbtm = a;
        a2.initUI();
    }

    public TimeWidget(Date a, Locale a2, TimeZone a3) {
        TimeWidget a4;
        a4.fbtm = null;
        a4.ampmSpinner = null;
        a4.isEnabled = true;
        a4.fbtm = FieldBasedTimeModel.getInstance((Date)a, (Locale)a2, (TimeZone)a3);
        a4.initUI();
    }

    private String padNumber(String a) {
        if (a.length() == 1) {
            return STUFFER_CHAR + a;
        }
        return a;
    }

    private SpinnerListModel getMinuteModel() {
        TimeWidget a;
        int a2;
        Object[] a3 = new String[60];
        int n = a2 = 0;
        while (n < 60) {
            a3[a2] = a.padNumber(a.fbtm.getDisplayString(12, a2));
            n = ++a2;
        }
        CyclingSpinnerListModel a22 = a.new CyclingSpinnerListModel(a3);
        int a4 = a.fbtm.get(12);
        a22.setValue(a.padNumber(a.fbtm.getDisplayString(12, a4)));
        return a22;
    }

    private SpinnerListModel getHourModel(boolean a) {
        TimeWidget a2;
        int a3;
        int a4 = a ? 24 : 12;
        Object[] a5 = new String[a4];
        int n = a3 = 0;
        while (n < a4) {
            a5[a3] = a2.padNumber(a2.fbtm.getDisplayString(11, a3));
            n = ++a3;
        }
        CyclingSpinnerListModel a22 = a2.new CyclingSpinnerListModel(a5);
        int a6 = a2.fbtm.get(11);
        a22.setValue(a2.padNumber(a2.fbtm.getDisplayString(11, a6)));
        return a22;
    }

    private void initUI() {
        Object a;
        TimeWidget a2;
        a2.hourSpinner = a2.new TimeSpinner(a2.getHourModel(a2.fbtm.get24HourMode()));
        a2.separatorLabel = new JLabel(a2.fbtm.getTimeFieldSeparator());
        a2.separatorLabel.setFont(a2.hourSpinner.getFont());
        a2.minuteSpinner = a2.new TimeSpinner(a2.getMinuteModel());
        if (!a2.fbtm.get24HourMode()) {
            a = a2.fbtm.getAmPmStrings();
            CyclingSpinnerListModel a3 = a2.new CyclingSpinnerListModel((Object[])a);
            a3.setValue(a2.fbtm.isAm() ? a[0] : a[1]);
            a2.ampmSpinner = a2.new TimeSpinner(a3);
        }
        a2.setLayout(new GridBagLayout());
        a = new GridBagConstraints();
        a.gridy = 0;
        new GridBagConstraints().gridx = 0;
        if (a2.fbtm.get24HourMode()) {
            a2.add((Component)a2.hourSpinner, a);
            ++a.gridx;
            a2.add((Component)a2.separatorLabel, a);
            ++a.gridx;
            a2.add((Component)a2.minuteSpinner, a);
        } else if (a2.fbtm.getTimeFieldOrder() == 1) {
            a2.add((Component)a2.ampmSpinner, a);
            ++a.gridx;
            a2.add(Box.createRigidArea(a2.separatorLabel.getPreferredSize()), a);
            ++a.gridx;
            a2.add((Component)a2.hourSpinner, a);
            ++a.gridx;
            a2.add((Component)a2.separatorLabel, a);
            ++a.gridx;
            a2.add((Component)a2.minuteSpinner, a);
        } else {
            a2.add((Component)a2.hourSpinner, a);
            ++a.gridx;
            a2.add((Component)a2.separatorLabel, a);
            ++a.gridx;
            a2.add((Component)a2.minuteSpinner, a);
            ++a.gridx;
            a2.add(Box.createRigidArea(a2.separatorLabel.getPreferredSize()), a);
            ++a.gridx;
            a2.add((Component)a2.ampmSpinner, a);
        }
    }

    public boolean isEnabled() {
        TimeWidget a;
        return a.isEnabled;
    }

    public void setEnabled(boolean a) {
        TimeWidget a2;
        a2.isEnabled = a;
        if (a2.ampmSpinner != null) {
            a2.ampmSpinner.setEnabled(a);
        }
        a2.minuteSpinner.setEnabled(a);
        a2.separatorLabel.setEnabled(a);
        a2.hourSpinner.setEnabled(a);
    }

    public Date getTime() {
        TimeWidget a;
        a.updateTime();
        return a.fbtm.getTime();
    }

    public FieldBasedTimeModel getModel() {
        TimeWidget a;
        a.updateTime();
        return a.fbtm;
    }

    private synchronized void updateTime() {
        TimeWidget a;
        a.fbtm.set(12, Integer.parseInt((String)a.minuteSpinner.getValue()));
        int a2 = Integer.parseInt(((String)a.hourSpinner.getValue()).trim());
        if (a.fbtm.get24HourMode()) {
            a.fbtm.set(11, a2);
        } else {
            String[] a3 = a.fbtm.getAmPmStrings();
            int a4 = ((String)a.ampmSpinner.getValue()).equals(a3[0]) ? 0 : 1;
            a.fbtm.set(9, a4);
            a.fbtm.set(11, (a4 > 0 ? 12 : 0) + a2 % 12);
        }
    }

    private class CyclingSpinnerListModel
    extends SpinnerListModel {
        Object firstValue;
        Object lastValue;

        public CyclingSpinnerListModel(Object[] a) {
            CyclingSpinnerListModel a2;
            super(a);
            a2.firstValue = a[0];
            a2.lastValue = a[a.length - 1];
        }

        public Object getNextValue() {
            CyclingSpinnerListModel a;
            Object a2 = super.getNextValue();
            if (a2 == null) {
                a2 = a.firstValue;
            }
            return a2;
        }

        public Object getPreviousValue() {
            CyclingSpinnerListModel a;
            Object a2 = super.getPreviousValue();
            if (a2 == null) {
                a2 = a.lastValue;
            }
            return a2;
        }
    }

    private class TimeSpinner
    extends JSpinner {
        TimeSpinner() {
            TimeSpinner a;
            a.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }

        TimeSpinner(SpinnerModel a) {
            a2();
            TimeSpinner a2;
            a2.setModel(a);
        }
    }
}

