/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing;

import com.amazon.agui.swing.KindleColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ProgressSpinner
extends JComponent {
    private static final String RESOURCES = "com.amazon.agui.swing.resources.ComponentResources";
    private final int NUM_PIE = 8;
    private Arc2D.Float[] arcs = new Arc2D.Float[8];
    private Shape circle;
    private int margin = 1;
    private int spinnerGap = 10;
    private boolean dirty = false;
    private int ringHeight = 10;
    private Color ballColor = KindleColor.BLACK;
    private int index = 0;
    private int repaintInterval = 1000;
    private Timer timer;

    public ProgressSpinner() {
        ProgressSpinner a;
        a.initGUI();
    }

    private void initGUI() {
        ProgressSpinner a;
        ResourceBundle a2 = ResourceBundle.getBundle(RESOURCES);
        a.setPreferredSize((Dimension)a2.getObject("SpinnerBallWidget.size"));
        a.ballColor = (Color)a2.getObject("SpinnerBallWidget.ball.color");
        a.setBackground((Color)a2.getObject("SpinnerBallWidget.background"));
        a.spinnerGap = (Integer)a2.getObject("SpinnerBallWidget.ball.gap");
        a.ringHeight = (Integer)a2.getObject("SpinnerBallWidget.ball.height");
        a.margin = (Integer)a2.getObject("SpinnerBallWidget.ball.margin");
        a.setOpaque(true);
    }

    public int getRingHeight() {
        ProgressSpinner a;
        return a.ringHeight;
    }

    public void setRingHeight(int a) {
        ProgressSpinner a2;
        a2.ringHeight = a;
        a2.revalidate();
    }

    public Color getBallColor() {
        ProgressSpinner a;
        return a.ballColor;
    }

    public void setBallColor(Color a) {
        ProgressSpinner a2;
        a2.ballColor = a;
        a2.dirty = true;
        a2.revalidate();
    }

    public void start() {
        ProgressSpinner a;
        if (a.timer == null) {
            a.timer = new Timer(a.repaintInterval, a.new RefreshAction());
        }
        a.timer.start();
    }

    public void stop() {
        ProgressSpinner a;
        a.timer.stop();
    }

    public void doLayout() {
        ProgressSpinner a;
        a.createSpinnerArcs();
        super.doLayout();
    }

    public Dimension getMaximumSize() {
        ProgressSpinner a;
        return a.getPreferredSize();
    }

    private void createSpinnerArcs() {
        ProgressSpinner a;
        int a2 = a.getWidth() - 2 * a.margin;
        if (a.getWidth() > a.getHeight()) {
            a2 = a.getHeight() - 2 * a.margin;
        }
        a.arcs[0] = new Arc2D.Float(a.margin, a.margin, a2, a2, 45 - a.spinnerGap, 45 - a.spinnerGap, 2);
        a.arcs[1] = new Arc2D.Float(a.margin, a.margin, a2, a2, 360 - a.spinnerGap, 45 - a.spinnerGap, 2);
        a.arcs[2] = new Arc2D.Float(a.margin, a.margin, a2, a2, 315 - a.spinnerGap, 45 - a.spinnerGap, 2);
        a.arcs[3] = new Arc2D.Float(a.margin, a.margin, a2, a2, 270 - a.spinnerGap, 45 - a.spinnerGap, 2);
        a.arcs[4] = new Arc2D.Float(a.margin, a.margin, a2, a2, 225 - a.spinnerGap, 45 - a.spinnerGap, 2);
        a.arcs[5] = new Arc2D.Float(a.margin, a.margin, a2, a2, 180 - a.spinnerGap, 45 - a.spinnerGap, 2);
        a.arcs[6] = new Arc2D.Float(a.margin, a.margin, a2, a2, 135 - a.spinnerGap, 45 - a.spinnerGap, 2);
        a.arcs[7] = new Arc2D.Float(a.margin, a.margin, a2, a2, 90 - a.spinnerGap, 45 - a.spinnerGap, 2);
        a.circle = new Ellipse2D.Float(a.margin + a.ringHeight, a.margin + a.ringHeight, a2 - 2 * a.ringHeight, a2 - 2 * a.ringHeight);
    }

    protected void paintComponent(Graphics a) {
        int a2;
        ProgressSpinner a3;
        Graphics2D a4 = (Graphics2D)a;
        if (a3.index == -1 || a3.dirty) {
            a.setColor(a3.getBackground());
            a.fillRect(0, 0, a3.getWidth(), a3.getHeight());
            ++a3.index;
            a3.dirty = false;
            return;
        }
        a4.setColor(a3.ballColor);
        int n = a2 = 0;
        while (n < 8) {
            a4.fill(a3.arcs[a2]);
            if (a2 == a3.index) break;
            n = ++a2;
        }
        ++a3.index;
        if (a3.index >= 8) {
            a3.index = -1;
        }
        a4.setColor(a3.getBackground());
        a4.fill(a3.circle);
    }

    public int getSpinnerGap() {
        ProgressSpinner a;
        return a.spinnerGap;
    }

    public void setSpinnerGap(int a) {
        a.spinnerGap = a;
    }

    private class RefreshAction
    extends AbstractAction {
        private RefreshAction() {
            RefreshAction a;
        }

        public void actionPerformed(ActionEvent a) {
            RefreshAction a2;
            SwingUtilities.invokeLater(new Runnable(){
                {
                    1 a;
                }

                public void run() {
                    1 a;
                    ProgressSpinner.this.repaint();
                }
            });
        }
    }
}

