/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing;

import com.amazon.agui.swing.ScrollArrowButton;
import com.amazon.agui.swing.event.GestureDispatcher;
import com.amazon.agui.swing.plaf.kindle.KindleSwingUtilities;
import com.amazon.ebook.util.log.Log;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;

public class PagingContainer
extends JPanel {
    private static final Log LOG = Log.getInstance((String)"PagingContainer");
    private static final int DEFAULT_NUM_COLUMNS = 1;
    private static final EmptyBorder EMPTY_BORDER_1_1_1_1 = new EmptyBorder(1, 1, 1, 1);
    private static final int DEFAULT_NUM_ROWS = 0;
    public static final int PAGING_STYLE_NS = 0;
    public static final int PAGING_STYLE_EW = 1;
    private static final int APPEND_COMP_AT_END = -1;
    private static final int CURRENT_PAGE_NONE = -1;
    protected List componentList = new ArrayList();
    private CardLayout cards = new CardLayout();
    private JPanel cardPanel;
    protected AbstractButton scrollPrev = null;
    protected AbstractButton scrollNext;
    protected Dimension lastDim;
    protected boolean fillHorizontal = true;
    private int pagingStyle;
    private MouseListener gestureDispatcher;
    private ComponentListener wrapperBorderListener;
    protected int numcols = 1;
    protected int numrows = 0;
    private static WrapperBorder topBottomBorder;
    protected static WrapperBorder bottomBorder;
    private static WrapperBorder emptyBorder;
    private int separatorStyle = 2;
    protected boolean dirty = false;

    public PagingContainer() {
        a(0, true, 1, 0);
        PagingContainer a;
    }

    public PagingContainer(boolean a) {
        a2(0, a, 1, 0);
        PagingContainer a2;
    }

    public PagingContainer(boolean a, int a2, int a3) {
        a4(0, a, a2, a3);
        PagingContainer a4;
    }

    public PagingContainer(int a) {
        a2(a, true, 1, 0);
        PagingContainer a2;
    }

    public PagingContainer(int a, boolean a2, int a3, int a4) {
        PagingContainer a5;
        a5.pagingStyle = a;
        a5.fillHorizontal = a2;
        a5.setColumnCount(a3);
        a5.setRowCount(a4);
        a5.setLayout(new BorderLayout());
        a5.cardPanel = new JPanel(a5.cards);
        super.add((Component)a5.cardPanel, "Center");
        a5.gestureDispatcher = new GestureDispatcher();
        a5.addMouseListener(a5.gestureDispatcher);
        a5.wrapperBorderListener = a5.new WrapperBorderListener();
        ActionMap a6 = a5.getActionMap();
        a6.put("north", new PagingAction(true));
        a6.put("south", new PagingAction(false));
        a6.put("west", new PagingAction(true));
        a6.put("east", new PagingAction(false));
        a5.setActionMap(a6);
        topBottomBorder = new WrapperBorder(1, true);
        bottomBorder = new WrapperBorder(2, true);
        emptyBorder = new WrapperBorder(0, true);
    }

    public void addNotify() {
        PagingContainer a;
        super.addNotify();
        boolean a2 = KindleSwingUtilities.isInDialog(true, a);
        topBottomBorder = new WrapperBorder(1, a2);
        bottomBorder = new WrapperBorder(2, a2);
        emptyBorder = new WrapperBorder(0, a2);
    }

    public void setColumnCount(int a) {
        PagingContainer a2;
        if (a < 1) {
            throw new IllegalArgumentException("numColumns must be 1 or greater");
        }
        int a3 = a2.numcols;
        a2.numcols = a;
        a2.firePropertyChange("numcols", a3, a2.numcols);
        a2.dirty = true;
        if (a2.isVisible() && a2.getParent() != null) {
            a2.getParent().invalidate();
            a2.revalidate();
            a2.repaint();
        }
    }

    public int getColumnCount() {
        PagingContainer a;
        return a.numcols;
    }

    public void setRowCount(int a) {
        PagingContainer a2;
        if (a < 0) {
            throw new IllegalArgumentException("numRows must be 0 or greater");
        }
        int a3 = a2.numrows;
        a2.numrows = a;
        a2.firePropertyChange("numrows", a3, a2.numrows);
        a2.dirty = true;
        if (a2.isVisible() && a2.getParent() != null) {
            a2.getParent().invalidate();
            a2.revalidate();
            a2.repaint();
        }
    }

    public int getRowCount() {
        PagingContainer a;
        return a.numrows;
    }

    public int getSeparatorStyle() {
        PagingContainer a;
        return a.separatorStyle;
    }

    public void setSeparatorStyle(int a) {
        PagingContainer a2;
        if (a != 1 && a != 3 && a != 2 && a != 0) {
            throw new IllegalArgumentException("illegal separtor style");
        }
        a2.separatorStyle = a;
        a2.dirty = true;
        if (a2.isVisible()) {
            a2.revalidate();
            if (a2.getParent() != null) {
                a2.getParent().invalidate();
            }
            a2.repaint();
        }
    }

    public Component addItem(Component a) {
        PagingContainer a2;
        return a2.addItem(a, -1);
    }

    public Component addItem(Component a, int a2) {
        PagingContainer a3;
        if (a2 > a3.getClientComponentCount() || a2 < 0 && a2 != -1) {
            throw new IllegalArgumentException("illegal component position");
        }
        if (a2 == -1) {
            a3.componentList.add(a);
        } else {
            a3.componentList.add(a2, a);
        }
        if (a instanceof JComponent) {
            a3.addGestures((JComponent)a);
        }
        a3.dirty = true;
        if (a3.isVisible() && a3.getParent() != null) {
            a3.removeScrollButtons();
            a3.revalidate();
            a3.repaint();
        }
        return a;
    }

    public void removeItem(int a) {
        PagingContainer a2;
        if (a < 0 || a >= a2.componentList.size()) {
            throw new IndexOutOfBoundsException("Index: " + a + ", Size: " + a2.componentList.size());
        }
        Component a3 = (Component)a2.componentList.remove(a);
        a3.removeComponentListener(a2.wrapperBorderListener);
        if (a3 instanceof JComponent) {
            a2.removeGestures((JComponent)a3);
        }
        a2.dirty = true;
        if (a2.isVisible() && a2.getParent() != null) {
            a2.removeScrollButtons();
            a2.revalidate();
            a2.repaint();
        }
    }

    public void removeItem(Component a) {
        PagingContainer a2;
        if (a2.componentList.remove(a)) {
            a.removeComponentListener(a2.wrapperBorderListener);
            if (a instanceof JComponent) {
                a2.removeGestures((JComponent)a);
            }
            a2.dirty = true;
        }
        if (a2.isVisible() && a2.getParent() != null) {
            a2.removeScrollButtons();
            a2.revalidate();
            a2.repaint();
        }
    }

    public void removeAllItems() {
        PagingContainer a;
        Iterator a2 = a.componentList.iterator();
        while (a2.hasNext()) {
            Component a3 = (Component)a2.next();
            a3.removeComponentListener(a.wrapperBorderListener);
            if (!(a3 instanceof JComponent)) continue;
            a.removeGestures((JComponent)a3);
        }
        a.componentList.clear();
        a.cardPanel.removeAll();
        a.dirty = true;
        if (a.isVisible() && a.getParent() != null) {
            a.removeScrollButtons();
            a.revalidate();
            a.repaint();
        }
    }

    public int getPageCount() {
        PagingContainer a;
        return a.cardPanel.getComponentCount();
    }

    public void doLayout() {
        PagingContainer a;
        if (a.lastDim == null || a.dirty || !a.getParent().getSize().equals(a.lastDim)) {
            a.paginate();
            a.dirty = false;
        }
        a.enableScrollButtons();
        super.doLayout();
    }

    public boolean isPageVisible(int a) {
        int a2;
        PagingContainer a3;
        int a4 = a3.cardPanel.getComponentCount();
        if (Log.isDebugOn()) {
            LOG.debug("ncomponents: " + a4);
        }
        if (a < -1 || a > a4) {
            throw new IllegalArgumentException("pageIndex");
        }
        if (a4 == 0) {
            return false;
        }
        JPanel a5 = (JPanel)a3.cardPanel.getComponent(a);
        int n = a2 = 0;
        while (n < a5.getComponentCount()) {
            int a6;
            JPanel a7 = (JPanel)a5.getComponent(a2);
            int n2 = a6 = 0;
            while (n2 < a7.getComponentCount()) {
                if (a7.getComponent(a6).isVisible()) {
                    return true;
                }
                n2 = ++a6;
            }
            n = ++a2;
        }
        return false;
    }

    public boolean nextVisiblePage() {
        int a;
        PagingContainer a2;
        int a3 = a2.getCurrentPage();
        if (a3 < 0) {
            return false;
        }
        int n = a = a3 + 1;
        while (n < a2.cardPanel.getComponentCount()) {
            if (a2.isPageVisible(a)) {
                return a2.setPage(a);
            }
            n = ++a;
        }
        return false;
    }

    public boolean previousVisiblePage() {
        int a;
        PagingContainer a2;
        int a3 = a2.getCurrentPage();
        if (a3 <= 0) {
            return false;
        }
        int n = a = a3 - 1;
        while (n >= 0) {
            if (a2.isPageVisible(a)) {
                return a2.setPage(a);
            }
            n = --a;
        }
        return false;
    }

    public int getCurrentPage() {
        int a;
        PagingContainer a2;
        if (a2.cardPanel == null) {
            return -1;
        }
        int a3 = a2.cardPanel.getComponentCount();
        if (Log.isDebugOn()) {
            LOG.debug("ncomponents: " + a3);
        }
        if (a3 == 0) {
            return -1;
        }
        int n = a = 0;
        while (n < a3) {
            if (a2.cardPanel.getComponent(a).isVisible()) {
                return a;
            }
            n = ++a;
        }
        return -1;
    }

    public boolean setPage(int a) {
        int a2;
        Component a3;
        PagingContainer a4;
        int a5 = a4.cardPanel.getComponentCount();
        if (Log.isDebugOn()) {
            LOG.debug("ncomponents: " + a5);
        }
        if (a < -1 || a > a5) {
            throw new IllegalArgumentException("pageIndex");
        }
        if (a5 == 0) {
            return false;
        }
        if (a < 0) {
            a = a5 - 1;
        }
        if ((a3 = a4.cardPanel.getComponent(a)).isVisible()) {
            return true;
        }
        int n = a2 = 0;
        while (n < a5) {
            Component a6 = a4.cardPanel.getComponent(a2);
            if (a6.isVisible()) {
                a6.setVisible(false);
                break;
            }
            n = ++a2;
        }
        a3.setVisible(true);
        return true;
    }

    public boolean nextPage() {
        PagingContainer a;
        return a.page(true);
    }

    public boolean previousPage() {
        PagingContainer a;
        return a.page(false);
    }

    public List getClientComponents() {
        PagingContainer a;
        return Collections.unmodifiableList(a.componentList);
    }

    public int getClientComponentCount() {
        PagingContainer a;
        return a.componentList.size();
    }

    protected void paginate() {
        Serializable a;
        Component a2;
        PagingContainer a3;
        a3.lastDim = a3.getParent().getSize();
        int a4 = a3.getSize().height;
        if (a3.showScrollButtons() && !a3.dirty) {
            a4 -= a3.scrollPrev.getPreferredSize().height + a3.scrollNext.getPreferredSize().height;
        }
        if (Log.isDebugOn()) {
            LOG.debug("maxHeight: " + a4);
        }
        int a5 = 0;
        Component a6 = null;
        int a7 = 0;
        a3.cardPanel.removeAll();
        int a8 = 0;
        if (a3.numrows > 0) {
            a8 = a4 / a3.numrows;
            if (a3.numcols == 1 && a3.separatorStyle != 0) {
                a8 -= PagingContainer.bottomBorder.getBorderInsets(null).bottom + PagingContainer.bottomBorder.getBorderInsets(null).top;
            }
        }
        Dimension a9 = null;
        Iterator a10 = a3.componentList.iterator();
        while (a10.hasNext()) {
            int a11;
            int a12;
            Serializable a13;
            a2 = (Component)a10.next();
            a = a2.getPreferredSize();
            Component a14 = null;
            if (Log.isDebugOn()) {
                LOG.debug("Processing " + (a2.getName() != null ? a2.getName() : "") + ' ' + a2);
            }
            if (a3.numrows > 0) {
                if (a9 == null) {
                    a9 = new Dimension(((Dimension)a).width, a8);
                }
                a13 = a3.new ComponentWrapper(a2, a9);
                a14 = a13;
                if (a3.numcols == 1 && a3.separatorStyle != 0) {
                    ((JComponent)a13).setBorder(bottomBorder);
                }
            } else if (a3.numcols == 1 && a3.separatorStyle != 0) {
                ComponentWrapper a15 = a3.new ComponentWrapper(a2, (Dimension)a);
                a15.setBorder(bottomBorder);
                a14 = a15;
            } else {
                a14 = a2;
            }
            if (a3.fillHorizontal && a14 instanceof JComponent) {
                a13 = a3.numrows > 0 ? a9 : a;
                ((Dimension)a13).width = a3.lastDim.width;
                ((JComponent)a14).setPreferredSize((Dimension)a13);
                if (a14 instanceof ComponentWrapper) {
                    ((Dimension)a).width = a3.lastDim.width;
                    JComponent a16 = (JComponent)a2;
                    a16.setPreferredSize((Dimension)a13);
                    a16.setMaximumSize((Dimension)a13);
                }
            }
            if ((a12 = a5 + (a11 = a3.numrows > 0 ? a9.height : ((Dimension)a).height)) <= a4 || a12 > a4 && a5 == 0) {
                if (a6 == null) {
                    a6 = a3.new InnerPage(a3.numcols, Integer.toString(++a7));
                    if (Log.isDebugOn()) {
                        LOG.debug("  Created page: " + a6.getName() + ' ' + a6);
                    }
                }
                ((InnerPage)a6).getCurrentColumn().add(a14);
                if (Log.isDebugOn()) {
                    LOG.debug("  Added to p" + a6.getName() + '-' + ((InnerPage)a6).getCurrentColumn().getName() + ' ' + a14);
                }
                a5 += a11;
                if (!Log.isDebugOn()) continue;
                LOG.debug("  currentHeight = " + a5);
                continue;
            }
            if (((InnerPage)a6).hasMoreColumns()) {
                ((InnerPage)a6).getNext().add(a14);
                if (Log.isDebugOn()) {
                    LOG.debug("  Added to p" + a6.getName() + "/" + ((InnerPage)a6).getCurrentColumn().getName() + " " + a14);
                }
                a5 = a11;
                if (!Log.isDebugOn()) continue;
                LOG.debug("  currentHeight = " + a5);
                continue;
            }
            a3.cardPanel.add(a6, a6.getName(), -1);
            a6 = a3.new InnerPage(a3.numcols, Integer.toString(++a7));
            if (Log.isDebugOn()) {
                LOG.debug("  Created page: " + a6.getName() + " " + a6);
            }
            ((InnerPage)a6).getCurrentColumn().add(a14);
            if (Log.isDebugOn()) {
                LOG.debug("  Added to p" + a6.getName() + "//" + ((InnerPage)a6).getCurrentColumn().getName() + " " + a14.getPreferredSize());
            }
            a5 = a11;
            if (!Log.isDebugOn()) continue;
            LOG.debug("  currentHeight = " + a5);
        }
        if (a6 != null) {
            a3.cardPanel.add(a6, a6.getName(), -1);
        }
        if (a3.numcols == 1 && a3.separatorStyle != 0) {
            int n = a = 0;
            while (n < a3.cardPanel.getComponentCount()) {
                a6 = (InnerPage)a3.cardPanel.getComponent(a);
                a2 = (JPanel)((Container)a6).getComponent(0);
                a = (ComponentWrapper)((Container)a2).getComponent(0);
                if (a3.separatorStyle == 1) {
                    ((JComponent)a).setBorder(topBottomBorder);
                }
                if (((Container)a2).getComponentCount() > 1 && a3.separatorStyle == 2) {
                    a = (ComponentWrapper)((Container)a2).getComponent(((Container)a2).getComponentCount() - 1);
                    ((JComponent)a).setBorder(emptyBorder);
                }
                n = ++a;
            }
        }
    }

    protected boolean page(boolean a) {
        int a2;
        PagingContainer a3;
        int a4 = a3.cardPanel.getComponentCount();
        if (Log.isDebugOn()) {
            LOG.debug("ncomponents: " + a4);
        }
        if (a4 == 0) {
            return false;
        }
        int n = a2 = 0;
        while (n < a4) {
            Component a5 = a3.cardPanel.getComponent(a2);
            if (Log.isDebugOn()) {
                LOG.debug("i = " + a2 + " --> page " + a5.getName() + " " + a5);
            }
            if (a5.isVisible()) {
                if (a) {
                    if (a2 + 1 < a4) {
                        a3.cards.next(a3.cardPanel);
                        return true;
                    }
                } else if (a2 > 0) {
                    a3.cards.previous(a3.cardPanel);
                    return true;
                }
            }
            n = ++a2;
        }
        return false;
    }

    public void setEnabled(boolean a) {
        PagingContainer a2;
        super.setEnabled(a);
        a2.enableScrollButtons();
    }

    public void setVisible(boolean a) {
        PagingContainer a2;
        if (a) {
            a2.enableScrollButtons();
        }
        super.setVisible(a);
    }

    private boolean showScrollButtons() {
        PagingContainer a;
        return a.getColumnCount() == 1 && a.pagingStyle == 0 && a.getPageCount() > 1;
    }

    private void removeScrollButtons() {
        PagingContainer a;
        if (a.scrollPrev != null) {
            super.remove(a.scrollPrev);
            super.remove(a.scrollNext);
            a.scrollPrev = null;
            a.scrollNext = null;
        }
    }

    private void enableScrollButtons() {
        PagingContainer a;
        int a2 = a.getCurrentPage();
        if (a2 < 0) {
            return;
        }
        if (a.showScrollButtons()) {
            if (a.scrollPrev == null) {
                a.scrollPrev = a.createScrollButton(1);
                a.scrollNext = a.createScrollButton(5);
                super.add((Component)a.scrollPrev, "North");
                super.add((Component)a.scrollNext, "South");
                a.paginate();
            }
        } else if (a.scrollPrev != null) {
            a.removeScrollButtons();
            a.paginate();
        }
        if (a.scrollPrev != null) {
            a.scrollPrev.setEnabled(a.isEnabled() && a2 > 0);
            a.scrollNext.setEnabled(a.isEnabled() && a2 >= 0 && a2 < a.cardPanel.getComponentCount() - 1);
        }
    }

    protected AbstractButton createScrollButton(int a) {
        PagingContainer a2;
        boolean a3 = a == 5;
        ScrollArrowButton a4 = new ScrollArrowButton(a);
        a4.setBorder(EMPTY_BORDER_1_1_1_1);
        a4.setBackground(a2.getBackground());
        a4.setOpaque(false);
        a4.setAction(new PagingAction(a3));
        return a4;
    }

    private void addGestures(JComponent a) {
        PagingContainer a2;
        a.addMouseListener(a2.gestureDispatcher);
    }

    private void removeGestures(JComponent a) {
        PagingContainer a2;
        a.removeMouseListener(a2.gestureDispatcher);
    }

    public void add(Component a, Object a2, int a3) {
        throw new RuntimeException("Not supported. Use add(Component)");
    }

    public void add(Component a, Object a2) {
        throw new RuntimeException("Not supported. Use add(Component)");
    }

    public Component add(String a, Component a2) {
        throw new RuntimeException("Not supported. Use add(Component)");
    }

    private class WrapperBorderListener
    extends ComponentAdapter {
        private WrapperBorderListener() {
            WrapperBorderListener a;
        }

        public void componentHidden(ComponentEvent a) {
            ((Component)a.getSource()).getParent().setVisible(false);
        }

        public void componentShown(ComponentEvent a) {
            ((Component)a.getSource()).getParent().setVisible(true);
        }
    }

    protected static class WrapperBorder
    extends AbstractBorder {
        private static ResourceBundle rb;
        private static Color borderColor;
        private static Insets buttonInsets;
        private Insets insets = new Insets(1, 0, 1, 0);
        private int borderStyle;

        public WrapperBorder(int a, boolean a2) {
            WrapperBorder a3;
            a3.borderStyle = a;
            rb = ResourceBundle.getBundle("com.amazon.agui.swing.resources.ComponentResources");
            borderColor = (Color)rb.getObject("separator.color");
            buttonInsets = a2 ? (Insets)rb.getObject("MenuDialog.button.insets") : (Insets)rb.getObject("separator.insets");
        }

        public Insets getBorderInsets(Component a, Insets a2) {
            WrapperBorder a3;
            a2.top = a3.insets.top;
            a2.left = a3.insets.left;
            a2.bottom = a3.insets.bottom;
            a2.right = a3.insets.right;
            return a2;
        }

        public Insets getBorderInsets(Component a) {
            WrapperBorder a2;
            return a2.insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component a, Graphics a2, int a3, int a4, int a5, int a6) {
            WrapperBorder a7;
            if (a7.borderStyle == 0) {
                return;
            }
            a2.setColor(borderColor);
            if (a7.borderStyle == 1) {
                a2.drawLine(a3 + WrapperBorder.buttonInsets.left, a4, a3 + a5 - WrapperBorder.buttonInsets.right, a4);
            }
            int a8 = a4 + a6 - a7.insets.bottom;
            a2.drawLine(a3 + WrapperBorder.buttonInsets.left, a8, a3 + a5 - WrapperBorder.buttonInsets.right, a8);
        }
    }

    static class PagingAction
    extends AbstractAction {
        private boolean forward;

        public PagingAction(boolean a) {
            PagingAction a2;
            a2.forward = a;
        }

        public void actionPerformed(ActionEvent a) {
            PagingContainer a2;
            PagingAction a3;
            if (Log.isDebugOn()) {
                LOG.debug("paging " + (a3.forward ? "forward" : "backwards") + "...");
            }
            PagingContainer pagingContainer = a2 = null;
            for (Component a4 = (Component)a.getSource(); pagingContainer == null && a4 != null; a4 = a4.getParent()) {
                if (Log.isDebugOn()) {
                    LOG.debug("c: " + a4);
                }
                if (a4 instanceof PagingContainer) {
                    a2 = (PagingContainer)a4;
                    break;
                }
                pagingContainer = a2;
            }
            if (a2 != null) {
                if (a3.forward) {
                    a2.nextVisiblePage();
                } else {
                    a2.previousVisiblePage();
                }
            }
        }
    }

    protected class InnerPage
    extends JPanel {
        private int cursor;

        protected InnerPage(int a, String a2) {
            int a3;
            InnerPage a4;
            a4.setName(a2);
            GridLayout a5 = new GridLayout(1, a);
            a4.setLayout(a5);
            int n = a3 = 0;
            while (n < a) {
                JPanel a6 = new JPanel();
                a6.setName("column " + a3);
                BoxLayout a7 = new BoxLayout(a6, 1);
                a6.setLayout(a7);
                a4.add(a6);
                n = ++a3;
            }
        }

        protected JComponent getCurrentColumn() {
            InnerPage a;
            return (JComponent)a.getComponent(a.cursor);
        }

        protected boolean hasMoreColumns() {
            InnerPage a;
            return a.cursor < a.getComponentCount() - 1;
        }

        protected JComponent getNext() {
            InnerPage a;
            if (a.hasMoreColumns()) {
                ++a.cursor;
                return a.getCurrentColumn();
            }
            return null;
        }
    }

    protected class ComponentWrapper
    extends JPanel {
        public ComponentWrapper(Component a, Dimension a2) {
            ComponentWrapper a3;
            a3.setPreferredSize(a2);
            a3.setLayout(new BoxLayout(a3, 1));
            JComponent a4 = (JComponent)a;
            a4.setAlignmentX(0.0f);
            a4.setPreferredSize(a2);
            a4.setMaximumSize(a2);
            a.addComponentListener(a3.PagingContainer.this.wrapperBorderListener);
            a3.add(a);
        }
    }
}

