/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing;

import com.amazon.agui.swing.KDialog;
import com.amazon.agui.swing.MenuDialogLookFeel;
import com.amazon.agui.swing.PagingContainer;
import com.amazon.agui.swing.plaf.kindle.KindleSwingUtilities;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class MenuDialog
extends KDialog
implements MenuDialogLookFeel {
    protected static final String RESOURCES = "com.amazon.agui.swing.resources.ComponentResources";
    private static final Log LOG = Log.getInstance((String)"MenuDialog");
    private static final LogMessage SCREEN_SIZE_UNSET = new LogMessage("ScreenSizeUnset", new String[]{"width", "height"});
    private static final LogMessage MENU_SIZE_SET = new LogMessage("MenuHeightSet", new String[]{"max", "height"});
    private static final LogMessage SHOWING_MENU = new LogMessage("ShowingMenu", new String[]{"dialogid"});
    private static final int ITEM_BORDER_HEIGHT = 2;
    protected PagingContainer menuPanel;
    private ResourceBundle bundle = ResourceBundle.getBundle("com.amazon.agui.swing.resources.ComponentResources");

    public MenuDialog(String a) {
        super(a);
        MenuDialog a2;
        a2.initUI();
    }

    public AbstractButton addActionWithIndicator(Action a) {
        MenuDialog a2;
        return a2.addActionImpl(a, true, false);
    }

    public AbstractButton addThreadActionWithIndicator(Action a) {
        MenuDialog a2;
        return a2.addActionImpl(a, true, true);
    }

    public AbstractButton addAction(Action a) {
        MenuDialog a2;
        return a2.addActionImpl(a, false, false);
    }

    public AbstractButton addThreadAction(Action a) {
        MenuDialog a2;
        return a2.addActionImpl(a, false, true);
    }

    public void reset() {
        MenuDialog a;
        a.menuPanel.removeAllItems();
    }

    private AbstractButton addActionImpl(Action a, boolean a2, boolean a3) {
        MenuDialog a4;
        if (a.getValue("Name") == null || ((String)a.getValue("Name")).length() == 0) {
            throw new IllegalArgumentException("Action.NAME must be set");
        }
        AbstractButton a5 = a4.createButton(a, a2, a3);
        a4.menuPanel.addItem(a5);
        return a5;
    }

    private void initUI() {
        MenuDialog a;
        a.setTitleBarEnabled(true);
        a.setTitle(a.bundle.getString("MenuDialog.title"));
        a.setCommandBarPosition(-1);
        Container a2 = a.getContentPane();
        a2.setLayout(new BorderLayout());
        EmptyBorder a3 = new EmptyBorder((Insets)a.bundle.getObject("MenuDialog.content.insets"));
        ((JPanel)a2).setBorder(a3);
        a.menuPanel = a.getPagingContainer();
        a2.add((Component)a.menuPanel, "Center");
        a.setDialogBounds((Rectangle)a.bundle.getObject("MenuDialog.location_size.default"));
    }

    public void postDialog(boolean a) {
        MenuDialog a2;
        LOG.info(SHOWING_MENU, new String[]{"" + a2.hashCode()}, "");
        if (a2.menuPanel.getColumnCount() == 1 && a2.menuPanel.getRowCount() == 0) {
            Dimension a3 = Toolkit.getDefaultToolkit().getScreenSize();
            if (a3.height < 10 && a3.width < 10) {
                a3 = KindleSwingUtilities.DEFAULT_KINDLE_SCREEN_SIZE;
                LOG.warning(SCREEN_SIZE_UNSET, new String[]{"" + a3.width, "" + a3.height}, "MenuDialog.postDialog called - screenSize invalid - fallback to 600x800!");
            }
            int a4 = a2.getEmptyDialogHeight();
            int a5 = a3.height - 30 - 70 - 4 - a4;
            int a6 = (Integer)a2.bundle.getObject("MenuDialog.menu_entry.height");
            int a7 = (int)Math.floor(a5 / (a6 += 2));
            if (a2.menuPanel.getClientComponentCount() <= a7) {
                Rectangle a8 = a2.getDialogBounds();
                a2.getDialogBounds().height = a4 + a2.menuPanel.getClientComponentCount() * a6;
                a2.setDialogBounds(a8);
                LOG.info(MENU_SIZE_SET, new String[]{"" + a7, "" + a8.height}, "");
            } else {
                a2.setDialogBounds((Rectangle)a2.bundle.getObject("MenuDialog.location_size.default"));
            }
        }
        super.postDialog(a);
    }

    private int getEmptyDialogHeight() {
        Object a;
        MenuDialog a2;
        int a3 = 0;
        if (a2.getBorder() != null) {
            a = a2.getBorder().getBorderInsets(a2);
            a3 += ((Insets)a).top + ((Insets)a).bottom;
        }
        if (a2.getTitle() != null) {
            a3 += a2.getTitlePanel().getPreferredSize().height;
        }
        if (a2.getContentPane() != null && (a = ((JComponent)a2.getContentPane()).getBorder()) != null) {
            Insets a4 = a.getBorderInsets(a2.getContentPane());
            a3 += a4.top + a4.bottom;
        }
        return a3;
    }

    protected PagingContainer getPagingContainer() {
        PagingContainer a = new PagingContainer();
        a.setSeparatorStyle(2);
        return a;
    }

    protected AbstractButton createButton(Action a, boolean a2, boolean a3) {
        MenuDialog a4;
        AbstractButton a5 = KindleSwingUtilities.createButton(a, super.getCloseAction(), a3);
        return a4.configureButton(a5, a2);
    }

    protected AbstractButton configureButton(AbstractButton a, boolean a2) {
        return KindleSwingUtilities.configureButton(a, a2);
    }
}

