/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing;

import com.amazon.ebook.util.lang.AbstractEnum;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.ebook.util.text.StringUtil;
import com.sun.swing.JFrameFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.text.JTextComponent;

public class KindleFrameFactory {
    public static final String LAYER_APPLICATION = "A";
    public static final String LAYER_CHROME = "C";
    public static final String LAYER_DIALOG = "D";
    public static final String ROLE_APPLICATION = "application";
    public static final String ROLE_DIALOG = "dialog";
    public static final String ROLE_NONCENTERED_DIALOG = "non-centered";
    public static final String ROLE_POPUP = "popup";
    public static final String ROLE_FOOTER = "footerBar";
    public static final String FLASH_SUPPRESS = "S";
    public static final String FLASH_FORCE = "F";
    public static final String FLASH_DEFAULT = "D";
    public static final String KEYBOARD_ALPHA = "abc";
    public static final String KEYBOARD_ALPHA_INITIAL_CAPS = "Abc";
    public static final String KEYBOARD_NUMERIC = "123";
    public static final String KEYBOARD_NUMERIC_KEYPAD = "pad";
    public static final String KEYBOARD_WEB = "web";
    public static final String ORIENTATION_PORTRAIT = "U";
    public static final String ORIENTATION_INVERTED_PORTRAIT = "D";
    public static final String ORIENTATION_LANDSCAPE_RIGHT = "R";
    public static final String ORIENTATION_LANDSCAPE_LEFT = "L";
    public static final String ORIENTATION_ANY_LANDSCAPE = "LR";
    public static final String ORIENTATION_ANY_PORTRAIT = "UD";
    public static final String KEY_PERSISTENT_CHROME = "PC";
    public static final String KEY_ORIENTATION = "O";
    public static final String KEY_DRAW_MODE = "DM";
    public static final String KEY_REFRESH_SENSITIVITY = "S";
    public static final int SENSITIVITY_NONE = -1;
    public static final String APP_ID_TEST = "test.app";
    public static final String APP_ID_PERSISTENT = "persistant.app";
    private static HashMap windows = new HashMap();
    private static WindowClosedListener WINDOW_CLOSED_LISTENER = new WindowClosedListener();
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    private static final Log LOG = Log.getInstance((String)"KindleFrameFactory");
    private static final LogMessage LOG_EWH_ERROR = new LogMessage("InvalidEwhSetting", new String[]{"frame", "id", "x", "y", "w", "h"});
    private static final LogMessage LOG_EWH_INFO = new LogMessage("EWH", new String[]{"frame", "id", "x", "y", "w", "h"});
    private static final LogMessage LOG_EWH_MISMATCHED_ID = new LogMessage("EwhIdMismatch", new String[]{"expected", "found"});
    private static final LogMessage LOG_PARAM_PARSE_ERROR = new LogMessage("InvalidParam", new String[]{"paramString", "token"});
    private static final LogMessage LOG_NONEXISTENT_ORPHAN = new LogMessage("NonExistentOrphanWindow", new String[]{"title"});
    private static final LogMessage LOG_CLEANUP_JFRAME = new LogMessage("JFrameCleanedUp", new String[]{"title"});
    private static final LogMessage LOG_NO_CLEANUP_JFRAME = new LogMessage("JFrameNotCleanedUp", new String[]{"title"});
    private static final LogMessage NULL_APPID = new LogMessage("NullAppId", new String[0]);
    private static final LogMessage NULL_WINDOW = new LogMessage("NullWindow", new String[0]);
    private static final LogMessage WINDOW_ADDED = new LogMessage("WindowAdded", new String[]{"title"});
    private static final LogMessage WINDOW_REMOVED = new LogMessage("WindowRemoved", new String[]{"title"});
    private static final LogMessage REMOVING_ALL_DIALOGS = new LogMessage("RemovingAllDialogs", new String[]{"appId"});
    private static final LogMessage REMOVING_ALL_WINDOWS = new LogMessage("RemovingAllWindows", new String[]{"appId"});
    private static final LogMessage NONEXISTENT_WINDOW = new LogMessage("WindowDNE", new String[0]);
    private static final LogMessage INVALID_APPID = new LogMessage("InvalidAppId", new String[]{"appId"});
    private static final LogMessage JFRAME_EXISTS = new LogMessage("", new String[0]);
    private static final char KEY_VALUE_SEPARATOR = ':';
    private static final char KEY_VALUE_PAIR_SEPARATOR = '_';
    private static final String KEY_VALUE_PAIR_SEPARATOR_STR = "_";
    private static final String KEY_LAYER = "L";
    private static final String KEY_ROLE = "N";
    private static final String KEY_ID = "ID";
    private static final String KEY_FLASHONSHOW = "FS";
    private static final String KEY_FLASHONHIDE = "FH";
    private static final String KEY_FLASHONUPDATE = "FU";
    private static final String KEY_ROUNDCORNERS = "RC";
    private static final String KEY_MODAL = "M";
    private static final String KEY_EXPECTKB = "RKB";
    private static final String KEY_WINHOST_ID = "EWH";
    private static final String KEY_WINHOST_X = "EWH-x";
    private static final String KEY_WINHOST_Y = "EWH-y";
    private static final String KEY_WINHOST_W = "EWH-w";
    private static final String KEY_WINHOST_H = "EWH-h";
    private static final ActionMapManager ACTION_MAP_MANAGER = new ActionMapManager();
    static /* synthetic */ Class class$com$amazon$agui$swing$KindleFrameFactory$PersistentChromeMode;

    public static JFrame createKindleFrame(String a, String a2, String a3, boolean a4, String a5, String a6, String a7, String a8, String a9, boolean a10) {
        final String a11 = KindleFrameFactory.buildWindowParams(a, a2, a3, a4, a5, a6, a7, a8, a9, a10, true);
        JFrame a12 = (JFrame)AccessController.doPrivileged(new PrivilegedAction(){
            {
                1 a;
            }

            public Object run() {
                1 a;
                return JFrameFactory.createJFrame((String)a.a11);
            }
        });
        ((JComponent)a12.getContentPane()).addContainerListener(ACTION_MAP_MANAGER);
        KindleFrameFactory.addApplicationWindow(a, a12);
        return a12;
    }

    public static JFrame createKindleFrame(String a, String a2, String a3, boolean a4, String a5, String a6, String a7, String a8, boolean a9) {
        return KindleFrameFactory.createKindleFrame(a, a2, a3, a4, a5, a6, a7, a8, null, a9);
    }

    public static JFrame createKindleFrame(String a, String a2, String a3, boolean a4, String a5, String a6, String a7, String a8) {
        return KindleFrameFactory.createKindleFrame(a, a2, a3, a4, a5, a6, a7, a8, true);
    }

    public static JFrame createKindleFrame(String a, String a2, String a3) {
        return KindleFrameFactory.createKindleFrame(a, a2, a3, false, null, null, null, null);
    }

    public static JFrame createKindleDialogFrame(String a, boolean a2, boolean a3, String a4) {
        return KindleFrameFactory.createKindleFrame(a, "D", a3 ? ROLE_DIALOG : ROLE_NONCENTERED_DIALOG, a2, a4, null, FLASH_FORCE, null, false);
    }

    public static JFrame createKindleDialogFrame(String a, boolean a2, boolean a3, String a4, boolean a5) {
        final String a6 = KindleFrameFactory.buildWindowParams(a, "D", a3 ? ROLE_DIALOG : ROLE_NONCENTERED_DIALOG, a2, a4, null, FLASH_FORCE, null, null, false, a5);
        JFrame a7 = (JFrame)AccessController.doPrivileged(new PrivilegedAction(){
            {
                2 a;
            }

            public Object run() {
                2 a;
                return JFrameFactory.createJFrame((String)a.a6);
            }
        });
        ((JComponent)a7.getContentPane()).addContainerListener(ACTION_MAP_MANAGER);
        KindleFrameFactory.addApplicationWindow(a, a7);
        return a7;
    }

    public static JFrame createKindleDialogFrame(String a, boolean a2, String a3) {
        return KindleFrameFactory.createKindleDialogFrame(a, a2, true, a3);
    }

    public static void setWindowParameters(JFrame a, String a2, String a3, String a4, boolean a5, String a6, String a7, String a8, String a9, String a10, boolean a11) {
        a.setTitle(KindleFrameFactory.buildWindowParams(a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, true));
    }

    public static void setFullScreenMode(JFrame a, boolean a2) {
        if (a2) {
            KindleFrameFactory.setWindowParameter(a, KEY_PERSISTENT_CHROME, PersistentChromeMode.NO_HEADER.name());
        } else {
            KindleFrameFactory.setWindowParameter(a, KEY_PERSISTENT_CHROME, PersistentChromeMode.TITLE_ONLY.name());
        }
    }

    public static void setAlwaysSearchMode(JFrame a, boolean a2) {
        if (a2) {
            KindleFrameFactory.setWindowParameter(a, KEY_PERSISTENT_CHROME, PersistentChromeMode.TITLE_AND_SEARCH.name());
        } else {
            KindleFrameFactory.setWindowParameter(a, KEY_PERSISTENT_CHROME, PersistentChromeMode.TITLE_ONLY.name());
        }
    }

    public static void setPersistentChromeMode(JFrame a, PersistentChromeMode a2) {
        KindleFrameFactory.setWindowParameter(a, KEY_PERSISTENT_CHROME, a2.name());
    }

    public static void setDrawMode(JFrame a, String a2) {
        KindleFrameFactory.setWindowParameter(a, KEY_DRAW_MODE, a2);
    }

    public static void setSensitivity(JFrame a, int a2) {
        if (a2 != -1) {
            KindleFrameFactory.setWindowParameter(a, "S", Integer.toString(a2));
        } else {
            KindleFrameFactory.setWindowParameter(a, "S", null);
        }
    }

    public static void setHostRegion(JFrame a, String a2, int a3, int a4, int a5, int a6) {
        if (Log.isDebugOn()) {
            LOG.debug(LOG_EWH_INFO, new String[]{a.toString(), a2, Integer.toString(a3), Integer.toString(a4), Integer.toString(a5), Integer.toString(a6)}, null);
        }
        if (a5 == 0 || a6 == 0) {
            LOG.warning(LOG_EWH_ERROR, new String[]{a.toString(), a2, Integer.toString(a3), Integer.toString(a4), Integer.toString(a5), Integer.toString(a6)}, null);
            return;
        }
        Map a7 = KindleFrameFactory.parseWindowParams(a.getTitle());
        String a8 = (String)a7.get(KEY_WINHOST_ID);
        if (a8 != null && !a8.equals(a2)) {
            LOG.error(LOG_EWH_MISMATCHED_ID, new String[]{a8, a2}, null);
            return;
        }
        a7.put(KEY_WINHOST_ID, a2);
        a7.put(KEY_WINHOST_X, Integer.toString(a3));
        a7.put(KEY_WINHOST_Y, Integer.toString(a4));
        a7.put(KEY_WINHOST_W, Integer.toString(a5));
        a7.put(KEY_WINHOST_H, Integer.toString(a6));
        a.setTitle(KindleFrameFactory.generateWindowParams(a7));
    }

    public static void setWindowParameters(JFrame a, String a2, String a3, String a4, boolean a5) {
        a.setTitle(KindleFrameFactory.buildWindowParams(a2, a3, a4, false, null, null, null, null, null, a5, true));
    }

    public static String getWindowParameter(JFrame a, String a2) {
        if (a == null || a2 == null) {
            return null;
        }
        Map a3 = KindleFrameFactory.parseWindowParams(a.getTitle());
        return (String)a3.get(a2);
    }

    public static String buildWindowParams(String a, String a2, String a3, boolean a4, String a5, String a6, String a7, String a8, String a9, boolean a10, boolean a11) {
        if (a == null || a2 == null || a3 == null) {
            throw new NullPointerException("null param");
        }
        LinkedHashMap<String, Object> a12 = new LinkedHashMap<String, Object>();
        a12.put("L", a2);
        a12.put(KEY_ROLE, a3);
        a12.put(KEY_ID, a);
        a12.put(KEY_MODAL, a4 ? VALUE_TRUE : VALUE_FALSE);
        if (a2.equals(LAYER_APPLICATION) && a3.equals(ROLE_APPLICATION)) {
            a12.put(KEY_PERSISTENT_CHROME, (Object)(a10 ? PersistentChromeMode.TITLE_AND_SEARCH : PersistentChromeMode.TITLE_ONLY));
        }
        if (a5 != null) {
            a12.put(KEY_EXPECTKB, a5);
        }
        if (a6 != null) {
            a12.put(KEY_FLASHONSHOW, a6);
        }
        if (a7 != null) {
            a12.put(KEY_FLASHONHIDE, a7);
        }
        if (a8 != null) {
            a12.put(KEY_FLASHONUPDATE, a8);
        }
        if (a9 != null) {
            a12.put(KEY_ORIENTATION, a9);
        }
        a12.put(KEY_ROUNDCORNERS, a11 ? VALUE_TRUE : VALUE_FALSE);
        return KindleFrameFactory.generateWindowParams(a12);
    }

    public static void setWindowParameter(JFrame a, String a2, String a3) {
        if (a == null) {
            return;
        }
        Map a4 = KindleFrameFactory.parseWindowParams(a.getTitle());
        if (a3 == null) {
            a4.remove(a2);
        } else {
            a4.put(a2, a3);
        }
        a.setTitle(KindleFrameFactory.generateWindowParams(a4));
    }

    public static Map parseWindowParams(String a) {
        StringTokenizer a2 = new StringTokenizer(a, KEY_VALUE_PAIR_SEPARATOR_STR);
        LinkedHashMap<String, String> a3 = new LinkedHashMap<String, String>();
        StringTokenizer stringTokenizer = a2;
        while (stringTokenizer.hasMoreTokens()) {
            String a4 = a2.nextToken();
            String[] a5 = StringUtil.split((String)a4, (char)':');
            if (a5.length != 2) {
                LOG.warning(LOG_PARAM_PARSE_ERROR, new String[]{a, a4}, null);
                stringTokenizer = a2;
                continue;
            }
            a3.put(a5[0], a5[1]);
            stringTokenizer = a2;
        }
        return a3;
    }

    private static String generateWindowParams(Map a) {
        Iterator a2;
        StringBuffer a3 = new StringBuffer();
        Iterator iterator = a2 = a.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry a4 = a2.next();
            if (a3.length() > 0) {
                a3.append('_');
            }
            a3.append(a4.getKey().toString().replace(':', '-').replace('_', '-'));
            a3.append(':');
            a3.append(a4.getValue().toString().replace(':', '-').replace('_', '-'));
            iterator = a2;
        }
        return a3.toString();
    }

    private KindleFrameFactory() {
        KindleFrameFactory a;
    }

    public static ArrayList getWindowsForApplication(String a) {
        return (ArrayList)windows.get(a);
    }

    public static boolean existingApplication(String a) {
        return windows.containsKey(a);
    }

    public static Set existingApplicationIds() {
        return windows.keySet();
    }

    private static void addApplicationWindow(String a, JFrame a2) {
        if (a == null) {
            LOG.error(NULL_APPID);
            throw new NullPointerException("The appID parameter given to addApplicationWindow is null.");
        }
        if (a2 == null) {
            LOG.error(NULL_WINDOW);
            throw new NullPointerException("The window parameter given to addApplicationWindow is null.");
        }
        if (!KindleFrameFactory.existingApplication(a)) {
            if (KindleFrameFactory.getWindowParameter(a2, KEY_ROLE).equals(ROLE_APPLICATION) && KindleFrameFactory.getWindowParameter(a2, "L").equals(LAYER_APPLICATION) || a.equals(APP_ID_TEST) || a.equals(APP_ID_PERSISTENT)) {
                windows.put(a, new ArrayList());
            } else {
                throw new IllegalArgumentException("Tried to add a jframe with a non-existing appID.");
            }
        }
        if (a.equals(APP_ID_PERSISTENT)) {
            KindleFrameFactory.cleanUpApplicationDialogs(a);
        }
        a2.addWindowListener(WINDOW_CLOSED_LISTENER);
        ((ArrayList)windows.get(a)).add(a2);
        LOG.info(WINDOW_ADDED, new String[]{a2.getTitle()}, null);
    }

    public static boolean removeApplicationWindow(JFrame a) {
        String a2 = KindleFrameFactory.getWindowParameter(a, KEY_ID);
        ArrayList a3 = (ArrayList)windows.get(a2);
        a.removeWindowListener(WINDOW_CLOSED_LISTENER);
        a.getContentPane().removeAll();
        a.getContentPane().removeContainerListener(ACTION_MAP_MANAGER);
        if (a3.contains(a)) {
            a3.remove(a);
            if (KindleFrameFactory.getWindowParameter(a, KEY_ROLE).equals(ROLE_APPLICATION) && KindleFrameFactory.getWindowParameter(a, "L").equals(LAYER_APPLICATION)) {
                KindleFrameFactory.cleanUpApplicationWindows(a2);
            }
            LOG.info(WINDOW_REMOVED, new String[]{a.getTitle()}, null);
            return true;
        }
        return false;
    }

    public static void cleanUpApplicationDialogs(String a) {
        LOG.info(REMOVING_ALL_DIALOGS, new String[]{a}, null);
        if (windows.containsKey(a)) {
            Iterator a2;
            ArrayList a3 = (ArrayList)windows.get(a);
            ArrayList<JFrame> a4 = new ArrayList<JFrame>();
            Iterator iterator = a2 = a3.iterator();
            while (iterator.hasNext()) {
                JFrame a5 = (JFrame)a2.next();
                String a6 = KindleFrameFactory.getWindowParameter(a5, KEY_ROLE);
                if (a6.equals(ROLE_DIALOG) || a6.equals(ROLE_NONCENTERED_DIALOG)) {
                    a5.removeWindowListener(WINDOW_CLOSED_LISTENER);
                    a5.dispose();
                    a4.add(a5);
                    LOG.info(LOG_CLEANUP_JFRAME, new String[]{a5.getTitle()}, null);
                    iterator = a2;
                    continue;
                }
                LOG.info(LOG_NO_CLEANUP_JFRAME, new String[]{a5.getTitle()}, null);
                iterator = a2;
            }
            a3.removeAll(a4);
        } else {
            LOG.warning(INVALID_APPID, new String[]{a}, null);
        }
    }

    public static void cleanUpApplicationWindows(String a) {
        LOG.info(REMOVING_ALL_WINDOWS, new String[]{a}, null);
        if (windows.containsKey(a)) {
            Iterator a2;
            ArrayList a3 = (ArrayList)windows.get(a);
            Iterator iterator = a2 = a3.iterator();
            while (iterator.hasNext()) {
                JFrame a4 = (JFrame)a2.next();
                a4.removeWindowListener(WINDOW_CLOSED_LISTENER);
                a4.dispose();
                LOG.info(LOG_CLEANUP_JFRAME, new String[]{a4.getTitle()}, null);
                iterator = a2;
            }
            a3.clear();
            windows.remove(a3);
        } else {
            LOG.warning(INVALID_APPID, new String[]{a}, null);
        }
    }

    private static class ActionMapManager
    implements ContainerListener {
        private ActionMapManager() {
            ActionMapManager a;
        }

        public void componentAdded(ContainerEvent a) {
            Component a2 = a.getChild();
            Container a3 = a.getContainer();
            if (a2 instanceof Container) {
                ActionMapManager a4;
                JComponent a5 = null;
                Container container = a3;
                while (container != null && !(a3 instanceof JComponent)) {
                    container = a3.getParent();
                }
                if (a3 != null) {
                    a5 = (JComponent)a3;
                }
                a4.install((Container)a2, a5);
            }
        }

        public void componentRemoved(ContainerEvent a) {
            Component a2 = a.getChild();
            if (a2 instanceof Container) {
                ActionMapManager a3;
                a3.uninstall((Container)a2);
            }
        }

        private boolean inArray(ContainerListener[] a) {
            ContainerListener[] containerListenerArray = a;
            for (int a2 = 0; containerListenerArray != null && a2 < a.length; ++a2) {
                ActionMapManager a3;
                if (a[a2] == a3) {
                    return true;
                }
                containerListenerArray = a;
            }
            return false;
        }

        private void install(Container a, JComponent a2) {
            Object a3;
            ActionMapManager a4;
            JComponent a5;
            if (a instanceof JTextComponent && (a5 = (JTextComponent)a).isEditable()) {
                return;
            }
            if (!a4.inArray(a.getContainerListeners())) {
                a.addContainerListener(a4);
            }
            a5 = a2;
            if (a instanceof JComponent) {
                if (a2 != null) {
                    a3 = a2.getActionMap();
                    ((JComponent)a).getActionMap().setParent((ActionMap)a3);
                }
                a5 = (JComponent)a;
            }
            a3 = a.getComponents();
            Object object = a3;
            for (int a6 = 0; object != null && a6 < ((Component[])a3).length; ++a6) {
                if (a3[a6] instanceof Container) {
                    a4.install((Container)a3[a6], a5);
                }
                object = a3;
            }
        }

        private void uninstall(Container a) {
            ActionMapManager a2;
            Component[] a3;
            if (a instanceof JTextComponent && (a3 = (Component[])a).isEditable()) {
                return;
            }
            a.removeContainerListener(a2);
            a3 = a.getComponents();
            Component[] componentArray = a3;
            for (int a4 = 0; componentArray != null && a4 < a3.length; ++a4) {
                if (a3[a4] instanceof Container) {
                    a2.uninstall((Container)a3[a4]);
                }
                componentArray = a3;
            }
            if (a instanceof JComponent) {
                ((JComponent)a).getActionMap().setParent(null);
            }
        }
    }

    private static class WindowClosedListener
    extends WindowAdapter {
        private WindowClosedListener() {
            WindowClosedListener a;
        }

        public void windowClosed(WindowEvent a) {
            if (!KindleFrameFactory.removeApplicationWindow((JFrame)a.getSource())) {
                LOG.warning(LOG_NONEXISTENT_ORPHAN, new String[]{((JFrame)a.getSource()).getTitle()}, null);
            }
        }
    }

    public static class PersistentChromeMode
    extends AbstractEnum {
        public static final PersistentChromeMode TITLE_AND_SEARCH = new PersistentChromeMode("TS");
        public static final PersistentChromeMode TITLE_ONLY = new PersistentChromeMode("T");
        public static final PersistentChromeMode NO_HEADER = new PersistentChromeMode("N");

        private PersistentChromeMode(String a) {
            super(a);
            PersistentChromeMode a2;
        }

        public static PersistentChromeMode[] values() {
            return (PersistentChromeMode[])PersistentChromeMode.values0((Class)(class$com$amazon$agui$swing$KindleFrameFactory$PersistentChromeMode == null ? (class$com$amazon$agui$swing$KindleFrameFactory$PersistentChromeMode = KindleFrameFactory.class$("com.amazon.agui.swing.KindleFrameFactory$PersistentChromeMode")) : class$com$amazon$agui$swing$KindleFrameFactory$PersistentChromeMode), (AbstractEnum[])new PersistentChromeMode[PersistentChromeMode.count((Class)(class$com$amazon$agui$swing$KindleFrameFactory$PersistentChromeMode == null ? (class$com$amazon$agui$swing$KindleFrameFactory$PersistentChromeMode = KindleFrameFactory.class$("com.amazon.agui.swing.KindleFrameFactory$PersistentChromeMode")) : class$com$amazon$agui$swing$KindleFrameFactory$PersistentChromeMode))]);
        }

        public static PersistentChromeMode valueOf(String a) {
            return (PersistentChromeMode)PersistentChromeMode.valueOf0((Class)(class$com$amazon$agui$swing$KindleFrameFactory$PersistentChromeMode == null ? (class$com$amazon$agui$swing$KindleFrameFactory$PersistentChromeMode = KindleFrameFactory.class$("com.amazon.agui.swing.KindleFrameFactory$PersistentChromeMode")) : class$com$amazon$agui$swing$KindleFrameFactory$PersistentChromeMode), (String)a);
        }
    }
}

