/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing;

import com.amazon.agui.swing.CommandBar;
import com.amazon.agui.swing.KindleFrameFactory;
import com.amazon.agui.swing.plaf.kindle.KindleIconFactory;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.sun.awt.event.MouseEvents;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class KDialog
extends JPanel {
    private static final Log LOG = Log.getInstance((String)"KDialog");
    private static final LogMessage SHOWING_DIALOG = new LogMessage("ShowingDialog", new String[]{"kdialogid", "frameid", "frametitle"});
    private static final LogMessage DISMISSING_DIALOG = new LogMessage("DismissingDialog", new String[]{"frameid"});
    private static final LogMessage JFRAME_EXISTS = new LogMessage("JframeExistsAlready", new String[0]);
    private static final LogMessage NULL_APPID = new LogMessage("NullAppId", new String[0]);
    private static final LogMessage INVALID_APPID = new LogMessage("InvalidAppId", new String[]{"appid"});
    private static final LogMessage APPID_SET = new LogMessage("AppIdSet", new String[]{"appid"});
    private static final LogMessage NON_UI_THREAD = new LogMessage("NotInUIThread", new String[]{"classname"});
    private static final String RESOURCES = "com.amazon.agui.swing.resources.ComponentResources";
    public static final String WINDOW_MANAGER_MODAL_FLAG = "M";
    private static final Insets INSETS_0_0_0_0 = new Insets(0, 0, 0, 0);
    public static final int COMMAND_BAR_DISABLED = -1;
    public static final int COMMAND_BAR_ON_TOP = 1;
    public static final int COMMAND_BAR_ON_BOTTOM = 2;
    public static final int HEADER_HEIGHT = 30;
    public static final int CHROME_HEIGHT = 70;
    public static final int BORDER_HEIGHT = 4;
    public static final int AESTHETIC_HEIGHT = 4;
    protected String appId = null;
    private int commandBarPosition = -1;
    private JPanel main;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private CommandBar commandBar;
    private JButton closeIconButton;
    private Container contentPane;
    private JFrame jframe;
    private Action closeAction;
    private CloseDialogListener closeDialogListener = null;
    private boolean modal = true;
    private boolean autoBorders = true;
    private String keyboardInit = null;
    protected Rectangle dialogBounds;
    private boolean centered = true;
    private boolean contentAddedToJFrame;
    private ResourceBundle bundle;
    protected Color titleBackground;
    protected Dimension mClosearea;
    private GlassPanelMouseListener glassPanelMouseListener;
    private boolean mGlassOn = false;

    public KDialog() {
        a((String)null);
        KDialog a;
    }

    public KDialog(String a) {
        a2(a, true);
        KDialog a2;
    }

    public KDialog(String a, boolean a2) {
        a3(a, a2, null);
        KDialog a3;
    }

    public KDialog(String a, boolean a2, String a3) {
        KDialog a4;
        a4.modal = a2;
        a4.keyboardInit = a4.validateKeyboardInit(a3);
        a4.setAppId(a);
        a4.bundle = ResourceBundle.getBundle(RESOURCES);
        a4.titleBackground = (Color)a4.bundle.getObject("KDialog.title.color.background");
        a4.mClosearea = (Dimension)a4.bundle.getObject("KDialog.closearea");
        a4.initUI();
    }

    protected void setAppId(String a) {
        KDialog a2;
        if (a2.appId != null && a2.appId.equals(a)) {
            return;
        }
        if (a2.jframe != null) {
            LOG.error(JFRAME_EXISTS);
            throw new IllegalStateException("Tried to change the appId of KDialog whose jframe already exists.");
        }
        if (a == null) {
            LOG.warning(NULL_APPID, new String[0], null);
            a2.appId = null;
            return;
        }
        if (!(KindleFrameFactory.existingApplication(a) || a.equals("test.app") || a.equals("persistant.app"))) {
            LOG.error(INVALID_APPID, new String[]{a}, null);
            throw new IllegalArgumentException("An invalid application id was given to KDialog: " + a);
        }
        LOG.info(APPID_SET, new String[]{a}, null);
        a2.appId = a;
    }

    public String getAppId() {
        KDialog a;
        return a.appId;
    }

    public void setKeyboardType(String a) {
        KDialog a2;
        a2.keyboardInit = a2.validateKeyboardInit(a);
    }

    public JFrame createFrame() {
        KDialog a;
        if (a.jframe == null) {
            if (a.appId == null) {
                LOG.error(NULL_APPID);
                throw new NullPointerException("Trying to create a KDialog JFrame with a null appId.");
            }
            a.jframe = KindleFrameFactory.createKindleDialogFrame(a.appId, a.modal, a.centered, a.keyboardInit, a.autoBorders);
            a.closeDialogListener = a.new CloseDialogListener();
            a.jframe.addWindowListener(a.closeDialogListener);
        }
        return a.jframe;
    }

    public JFrame getFrame() {
        KDialog a;
        if (a.jframe == null) {
            a.createFrame();
        }
        if (!a.contentAddedToJFrame) {
            a.jframe.getContentPane().add(a);
            a.contentAddedToJFrame = true;
        }
        return a.jframe;
    }

    public Rectangle getDialogBounds() {
        KDialog a;
        return new Rectangle(a.dialogBounds);
    }

    public void setDialogBounds(Rectangle a) {
        if (a == null) {
            throw new NullPointerException("bounds");
        }
        a.dialogBounds = a;
    }

    public void setDialogBounds(Dimension a) {
        if (a == null) {
            throw new NullPointerException("size");
        }
        a.dialogBounds.width = a.width;
        a.dialogBounds.height = a.height;
    }

    public void setAutoCenteredEnabled(boolean a) {
        a.centered = a;
    }

    public void setAutoBordersEnabled(boolean a) {
        a.autoBorders = a;
    }

    public boolean isAutoBordersEnabled() {
        KDialog a;
        return a.autoBorders;
    }

    public boolean isAutoCenteredEnabled() {
        KDialog a;
        return a.centered;
    }

    public void postDialog() {
        KDialog a;
        a.postDialog(false);
    }

    public void postDialog(String a) {
        KDialog a2;
        a2.postDialog(a, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void postDialog(boolean a) {
        KDialog a2;
        LOG.info(SHOWING_DIALOG, new String[]{"" + a2.hashCode(), a2.jframe != null ? "" + a2.jframe.hashCode() : "jframe_hashcode_unavailable", a2.jframe != null ? a2.jframe.getTitle() : "jframe_title_unavailable"}, a2.getTitle() == null ? "" : a2.getTitle());
        if (!EventQueue.isDispatchThread() && Log.isDebugOn()) {
            LOG.debug(NON_UI_THREAD, new String[]{a2.getClass().getName()}, "", (Throwable)new Exception());
        }
        if (a) {
            if (EventQueue.isDispatchThread()) {
                a2.postDialogInternal();
                a2.dialogDispatch();
                return;
            }
            final KDialog a3 = a2;
            try {
                EventQueue.invokeAndWait(new Runnable(){
                    {
                        1 a;
                    }

                    public void run() {
                        1 a;
                        a.KDialog.this.postDialogInternal();
                    }
                });
            }
            catch (InterruptedException a4) {
                LOG.error("Post Blocking Dialog Interrupted", (Throwable)a4);
            }
            catch (InvocationTargetException a5) {
                LOG.error("Post Blocking Dialog Exception", (Throwable)a5);
            }
            EventQueue.invokeLater(new Runnable(){
                {
                    2 a;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    2 a;
                    a.KDialog.this.dialogDispatch();
                    KDialog kDialog = a.a3;
                    synchronized (kDialog) {
                        a.a3.notifyAll();
                    }
                }
            });
            KDialog kDialog = a3;
            synchronized (kDialog) {
                try {
                    while (a3.jframe != null && a3.jframe.isVisible()) {
                        a3.wait();
                    }
                }
                catch (InterruptedException a6) {
                    return;
                }
                return;
            }
        }
        if (EventQueue.isDispatchThread()) {
            a2.postDialogInternal();
            return;
        } else {
            EventQueue.invokeLater(new Runnable(){
                {
                    3 a;
                }

                public void run() {
                    3 a;
                    a.KDialog.this.postDialogInternal();
                }
            });
        }
    }

    public void postDialog(String a, boolean a2) {
        KDialog a3;
        if (a3.appId == null || !a3.appId.equals(a)) {
            if (a3.jframe != null) {
                a3.closeDialog();
            }
            a3.setAppId(a);
        }
        a3.postDialog(a2);
    }

    private void postDialogInternal() {
        KDialog a;
        JFrame a2 = a.getFrame();
        if (!a2.isVisible()) {
            a2.setBounds(a.getDialogBounds());
            a2.setVisible(true);
            if (a.isGlassOn() || a.isCloseIconButtonEnabled() && a.isTitleBarEnabled()) {
                if (a.glassPanelMouseListener == null) {
                    a.glassPanelMouseListener = a.new GlassPanelMouseListener();
                }
                a2.getGlassPane().addMouseListener(a.glassPanelMouseListener);
                a2.getGlassPane().addMouseMotionListener(a.glassPanelMouseListener);
                a2.getGlassPane().setVisible(true);
            }
        }
        a2.toFront();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void dialogDispatch() {
        EventQueue a = Toolkit.getDefaultToolkit().getSystemEventQueue();
        boolean a2 = true;
        while (a2) {
            KDialog a3;
            Serializable a4;
            block7: {
                try {
                    a4 = a.getNextEvent();
                    Object a5 = a4.getSource();
                    if (a4 instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)a4)).dispatch();
                        break block7;
                    }
                    if (a5 instanceof Component) {
                        ((Component)a5).dispatchEvent((AWTEvent)a4);
                    }
                }
                catch (Exception a6) {
                    LOG.error(Log.CATCHALL_EX, null, "Error during dialog dispatch", (Throwable)a6);
                }
            }
            a4 = a3;
            // MONITORENTER : a4
            a2 = a3.jframe != null && a3.jframe.isVisible();
            // MONITOREXIT : var3_3
        }
    }

    public void setTitle(String a) {
        KDialog a2;
        if (a == null) {
            throw new IllegalArgumentException("dialogTitle cannot be null");
        }
        a2.createTitle();
        a2.titleLabel.setText(a);
    }

    public String getTitle() {
        KDialog a;
        return a.titleLabel != null ? a.titleLabel.getText() : null;
    }

    public void setTitleBarEnabled(boolean a) {
        KDialog a2;
        if (a) {
            if (a2.commandBarPosition == 1) {
                a2.main.remove(a2.commandBar);
                a2.commandBarPosition = -1;
            }
            a2.createTitle();
            a2.main.add((Component)a2.titlePanel, "North");
        } else if (a2.titlePanel != null) {
            a2.main.remove(a2.titlePanel);
        }
    }

    public boolean isTitleBarEnabled() {
        KDialog a;
        int a2;
        int n = a2 = 0;
        while (n < a.main.getComponentCount()) {
            if (a.main.getComponent(a2) == a.titlePanel) {
                return true;
            }
            n = ++a2;
        }
        return false;
    }

    public void setCommandBarPosition(int a) {
        KDialog a2;
        if (a != -1 && a != 1 && a != 2) {
            throw new IllegalArgumentException("position can not be " + a);
        }
        if (a2.commandBarPosition == a) {
            return;
        }
        if (a == -1) {
            a2.main.remove(a2.commandBar);
            a2.commandBarPosition = -1;
            return;
        }
        if (a == 2) {
            a2.commandBar.setBorder((Border)a2.bundle.getObject("CommandBar.dialog.border"));
            a2.main.add((Component)a2.commandBar, "South");
            a2.commandBarPosition = 2;
            return;
        }
        a2.setTitleBarEnabled(false);
        a2.commandBar.setBorder((Border)a2.bundle.getObject("CommandBar.dialog.border.top"));
        a2.main.add((Component)a2.commandBar, "North");
        a2.commandBarPosition = 1;
    }

    public int getCommandBarPosition() {
        KDialog a;
        return a.commandBarPosition;
    }

    public Container getContentPane() {
        KDialog a;
        return a.contentPane;
    }

    public Action getCloseAction() {
        KDialog a;
        if (a.closeAction == null) {
            a.closeAction = a.new CloseAction();
        }
        return a.closeAction;
    }

    public CommandBar getCommandBar() {
        KDialog a;
        return a.commandBar;
    }

    public JPanel getTitlePanel() {
        KDialog a;
        return a.titlePanel;
    }

    public void paint(Graphics a) {
        KDialog a2;
        super.paint(a);
        Border a3 = a2.getBorder();
        if (a3 != null) {
            Dimension a4 = a2.getSize();
            a3.paintBorder(a2, a, 0, 0, a4.width, a4.height);
        }
    }

    private void initUI() {
        KDialog a;
        a.setLayout(new BorderLayout());
        a.main = new JPanel(new BorderLayout());
        a.main.setBorder(null);
        a.add((Component)a.main, "Center");
        a.commandBar = new CommandBar();
        a.commandBar.setStyle(2);
        a.commandBar.setBackground((Color)a.bundle.getObject("KDialog.CommandBar.background"));
        a.setCommandBarPosition(2);
        a.contentPane = new JPanel();
        ((JPanel)a.contentPane).setBorder(null);
        a.main.add((Component)a.contentPane, "Center");
        a.dialogBounds = (Rectangle)a.bundle.getObject("KDialog.location_size.default");
    }

    private void createTitle() {
        KDialog a;
        if (a.titlePanel == null) {
            a.titlePanel = a.new TitlePanel(new BorderLayout(), (Color)a.bundle.getObject("KDialog.title.color.line"));
            a.titlePanel.setPreferredSize(new Dimension(a.titlePanel.getPreferredSize().width, (Integer)a.bundle.getObject("KDialog.title.height")));
            a.titlePanel.setBackground(a.titleBackground);
            a.titlePanel.setBorder((Border)a.bundle.getObject("KDialog.title.border"));
            a.titleLabel = new JLabel();
            a.titleLabel.setForeground((Color)a.bundle.getObject("KDialog.title.color.foreground"));
            a.titleLabel.setFont((Font)a.bundle.getObject("KDialog.title.font"));
            a.titlePanel.add((Component)a.titleLabel, "West");
            a.titlePanel.add((Component)a.getCloseIconButton(), "East");
        }
    }

    private JButton getCloseIconButton() {
        KDialog a;
        if (a.closeIconButton == null) {
            a.closeIconButton = new JButton(a.getCloseAction());
            a.closeIconButton.setIcon(KindleIconFactory.getCloseIcon());
            a.closeIconButton.setText(null);
            a.closeIconButton.setBorder(null);
            a.closeIconButton.setBackground((Color)a.bundle.getObject("KDialog.title.color.background"));
            a.closeIconButton.setForeground((Color)a.bundle.getObject("KDialog.title.color.background"));
        }
        return a.closeIconButton;
    }

    public void setCloseIconButtonEnabled(boolean a) {
        KDialog a2;
        a2.getCloseIconButton().setVisible(a);
    }

    public boolean isCloseIconButtonEnabled() {
        KDialog a;
        if (a.closeIconButton == null) {
            return false;
        }
        return a.getCloseIconButton().isVisible();
    }

    private String validateKeyboardInit(String a) {
        if (a == null || "abc".equals(a) || "Abc".equals(a) || "123".equals(a) || "web".equals(a) || "pad".equals(a)) {
            return a;
        }
        throw new IllegalArgumentException("invalid keyboard init value: " + a);
    }

    public void closeDialog() {
        KDialog a;
        if (EventQueue.isDispatchThread()) {
            a.closeDialogInternal();
        } else {
            EventQueue.invokeLater(new Runnable(){
                {
                    4 a;
                }

                public void run() {
                    4 a;
                    a.KDialog.this.closeDialogInternal();
                }
            });
        }
    }

    private void closeDialogInternal() {
        KDialog a;
        if (a.jframe != null) {
            LOG.info(DISMISSING_DIALOG, new String[]{"" + a.jframe.hashCode()}, null);
            if (a.closeDialogListener != null) {
                a.jframe.removeWindowListener(a.closeDialogListener);
            }
            if (a.glassPanelMouseListener != null) {
                a.jframe.getGlassPane().removeMouseListener(a.glassPanelMouseListener);
                a.jframe.getGlassPane().removeMouseMotionListener(a.glassPanelMouseListener);
            }
            a.jframe.getContentPane().removeAll();
            a.jframe.dispose();
            a.jframe = null;
            a.contentAddedToJFrame = false;
        }
    }

    JButton getCloseButton() {
        KDialog a;
        return a.getCloseIconButton();
    }

    String getKeyboardType() {
        KDialog a;
        return a.keyboardInit;
    }

    JFrame getRawJFrame() {
        KDialog a;
        return a.jframe;
    }

    public boolean isGlassOn() {
        KDialog a;
        return a.mGlassOn;
    }

    public void setGlassOn(boolean a) {
        a.mGlassOn = a;
    }

    class GlassPanelMouseListener
    extends MouseInputAdapter {
        GlassPanelMouseListener() {
            GlassPanelMouseListener a;
        }

        public void mouseClicked(MouseEvent a) {
            GlassPanelMouseListener a2;
            Component a3 = a2.KDialog.this.getFrame().getGlassPane();
            Point a4 = a.getPoint();
            Point a5 = SwingUtilities.convertPoint(a3, a4, a2.KDialog.this.getFrame());
            if (a2.KDialog.this.getFrame().getWidth() - a5.x < a2.KDialog.this.mClosearea.width && a5.y < a2.KDialog.this.mClosearea.height) {
                Action a6 = a2.KDialog.this.getCloseAction();
                if (a6 != null) {
                    a6.actionPerformed(new ActionEvent(a.getSource(), a.getID(), null));
                } else {
                    a2.KDialog.this.closeDialog();
                }
            } else {
                a2.redispatchMouseEvent(a);
            }
        }

        public void mouseMoved(MouseEvent a) {
            GlassPanelMouseListener a2;
            a2.redispatchMouseEvent(a);
        }

        public void mouseDragged(MouseEvent a) {
            GlassPanelMouseListener a2;
            a2.redispatchMouseEvent(a);
        }

        public void mouseEntered(MouseEvent a) {
            GlassPanelMouseListener a2;
            a2.redispatchMouseEvent(a);
        }

        public void mouseExited(MouseEvent a) {
            GlassPanelMouseListener a2;
            a2.redispatchMouseEvent(a);
        }

        public void mousePressed(MouseEvent a) {
            GlassPanelMouseListener a2;
            a2.redispatchMouseEvent(a);
        }

        public void mouseReleased(MouseEvent a) {
            GlassPanelMouseListener a2;
            a2.redispatchMouseEvent(a);
        }

        private void redispatchMouseEvent(MouseEvent a) {
            Component a2;
            GlassPanelMouseListener a3;
            Component a4 = a3.KDialog.this.getFrame().getGlassPane();
            Point a5 = a.getPoint();
            Container a6 = a3.KDialog.this.getFrame().getContentPane();
            Point a7 = SwingUtilities.convertPoint(a4, a5, a6);
            if (a7.y >= 0 && (a2 = SwingUtilities.getDeepestComponentAt(a6, a7.x, a7.y)) != null) {
                Point a8 = SwingUtilities.convertPoint(a4, a5, a2);
                a2.dispatchEvent(MouseEvents.createMouseEvent((Component)a2, (int)a.getID(), (long)a.getWhen(), (int)a.getModifiers(), (int)a8.x, (int)a8.y, (int)a.getClickCount(), (boolean)a.isPopupTrigger(), (int)a.getButton()));
            }
        }
    }

    private class TitlePanel
    extends JPanel {
        Color lineColor;

        public TitlePanel(LayoutManager a, Color a2) {
            TitlePanel a3;
            super(a);
            a3.lineColor = a2;
        }
    }

    protected class CloseDialogListener
    extends WindowAdapter {
        protected CloseDialogListener() {
            CloseDialogListener a;
        }

        public void windowClosed(WindowEvent a) {
            CloseDialogListener a2;
            a2.KDialog.this.closeDialog();
        }
    }

    protected class CloseAction
    extends AbstractAction {
        public CloseAction() {
            CloseAction a;
            a.putValue("Name", a.KDialog.this.bundle.getString("KDialog.close_button.text"));
        }

        public void actionPerformed(ActionEvent a) {
            CloseAction a2;
            a2.KDialog.this.closeDialog();
        }
    }
}

