/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing;

import com.amazon.agui.swing.FixedGridLayout;
import com.amazon.agui.swing.IndexedListModel;
import com.amazon.agui.swing.IndexedListRendererFactory;
import com.amazon.agui.swing.IndexedModelScrollable;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class InteractiveList
extends JComponent
implements IndexedModelScrollable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getInstance((String)"InteractiveList");
    private static final LogMessage UPDATE_VIEWS = new LogMessage("called updateViews");
    private static final int DEFAULT_NUM_COLUMNS_PORTRAIT = 1;
    private static final int DEFAULT_NUM_ROWS_PORTRAIT = 8;
    private static final int DEFAULT_NUM_COLUMNS_LANDSCAPE = 1;
    private static final int DEFAULT_NUM_ROWS_LANDSCAPE = 4;
    private IndexedListModel mModel;
    private IndexedListRendererFactory mFactory;
    private ArrayList mRenderers;
    private ModelListener mModelListener;
    private int mNumColumnsPortrait;
    private int mNumRowsPortrait;
    private int mNumColumnsLandscape;
    private int mNumRowsLandscape;
    private FixedGridLayout gl;
    private int mVisibleColumnCount;
    private int mVisibleRowCount;
    private int separatorStyle;
    private Color separtorColor;

    public InteractiveList() {
        a(1, 8, 1, 4);
        InteractiveList a;
    }

    public InteractiveList(int a, int a2, int a3, int a4) {
        InteractiveList a5;
        a5.mModelListener = a5.new ModelListener();
        a5.mVisibleColumnCount = 1;
        a5.separatorStyle = 0;
        a5.mNumColumnsPortrait = a;
        a5.mNumRowsPortrait = a2;
        a5.mNumColumnsLandscape = a3;
        a5.mNumRowsLandscape = a4;
        a5.setOpaque(true);
        a5.gl = new FixedGridLayout(a5.mNumRowsPortrait, a5.mNumColumnsPortrait);
        a5.setLayout(a5.gl);
        a5.setVisibleColumnCount(a5.mNumColumnsPortrait);
        a5.setVisibleRowCount(a5.mNumRowsPortrait);
        a5.separtorColor = (Color)ResourceBundle.getBundle("com.amazon.agui.swing.resources.ComponentResources").getObject("separator.color");
    }

    public InteractiveList(IndexedListModel a) {
        a2();
        InteractiveList a2;
        if (a == null) {
            throw new NullPointerException("model");
        }
        a2.setModel(a);
    }

    public JComponent getRenderer(int a) {
        InteractiveList a2;
        if (a2.mRenderers != null && a >= 0 && a2.mRenderers.size() > a) {
            return (JComponent)a2.mRenderers.get(a);
        }
        return null;
    }

    public IndexedListModel getModel() {
        InteractiveList a;
        return a.mModel;
    }

    public void setModel(IndexedListModel a) {
        InteractiveList a2;
        if (Log.isDebugOn()) {
            LOG.debug("Entering setModel().. model=" + a);
        }
        IndexedListModel a3 = a2.mModel;
        if (a2.mModel != null) {
            a2.mModel.removeListDataListener(a2.mModelListener);
        }
        a2.mModel = a;
        if (a2.mModel != null) {
            a2.mModel.addListDataListener(a2.mModelListener);
        }
        a2.firePropertyChange("model", a3, a2.mModel);
        a2.clear();
        a2.createViewers();
    }

    public void setRendererFactory(IndexedListRendererFactory a) {
        InteractiveList a2;
        if (Log.isDebugOn()) {
            LOG.debug("Entering setRendererFactory()... " + a);
        }
        if (a == null) {
            throw new NullPointerException("factory");
        }
        IndexedListRendererFactory a3 = a2.mFactory;
        a2.mFactory = null;
        a2.clear();
        a2.mFactory = a;
        a2.firePropertyChange("factory", a3, a2.mFactory);
        a2.createViewers();
        if (Log.isDebugOn()) {
            LOG.debug("Exiting setRendererFactory()...");
        }
    }

    public IndexedListRendererFactory getRendererFactory() {
        InteractiveList a;
        return a.mFactory;
    }

    public int getVisibleColumnCount() {
        InteractiveList a;
        return a.mVisibleColumnCount;
    }

    public void setVisibleColumnCount(int a) {
        InteractiveList a2;
        if (a < 0) {
            throw new IllegalArgumentException("columnCount cannot be negative");
        }
        if (a != a2.mVisibleColumnCount) {
            int a3 = a2.mVisibleColumnCount;
            a2.mVisibleColumnCount = a;
            a2.gl = new FixedGridLayout(a2.getVisibleRowCount(), a);
            a2.setLayout(a2.gl);
            a2.firePropertyChange("visibleColumnCount", a3, a);
        }
        a2.clear();
        a2.createViewers();
    }

    public int getVisibleRowCount() {
        InteractiveList a;
        return a.mVisibleRowCount;
    }

    public void setVisibleRowCount(int a) {
        InteractiveList a2;
        if (a < 0) {
            throw new IllegalArgumentException("rowCount cannot be negative");
        }
        if (a != a2.mVisibleRowCount) {
            int a3 = a2.mVisibleRowCount;
            a2.mVisibleRowCount = a;
            a2.gl = new FixedGridLayout(a, a2.getVisibleColumnCount());
            a2.setLayout(a2.gl);
            a2.firePropertyChange("visibleRowCount", a3, a);
        }
        a2.clear();
        a2.createViewers();
    }

    public int getSeparatorStyle() {
        InteractiveList a;
        return a.separatorStyle;
    }

    public void setSeparatorStyle(int a) {
        InteractiveList a2;
        if (a != 1 && a != 2 && a != 0) {
            throw new IllegalArgumentException("illegal separtor style");
        }
        a2.separatorStyle = a;
        a2.clear();
        a2.createViewers();
    }

    public IndexedListModel getIndexedModel() {
        InteractiveList a;
        return a.getModel();
    }

    public int getPageIncrement(int a, int a2) {
        InteractiveList a3;
        if (Log.isDebugOn()) {
            LOG.debug("Entering getPageIncrement() topLeftCursor=" + a + ", direction=" + a2);
        }
        if (a3.mModel == null || !a3.isVisible()) {
            return 0;
        }
        int a4 = a3.mModel.getSize();
        if (a4 == 0) {
            return 0;
        }
        int a5 = 0;
        a5 = a2 < 0 ? Math.min(a, a3.getPageItemCount()) : (a2 > 0 ? Math.min(a4 - a, a3.getPageItemCount()) : 0);
        if (a5 < 0) {
            LOG.info("getPageIncrement() topLeftCursor=" + a + ", direction=" + a2 + " --> " + a5);
            a5 = 0;
        }
        if (Log.isDebugOn()) {
            LOG.debug("getPageIncrement() topLeftCursor=" + a + ", direction=" + a2 + " --> " + a5);
        }
        return a5;
    }

    public int getPageItemCount() {
        InteractiveList a;
        return a.mVisibleRowCount * a.mVisibleColumnCount;
    }

    public int getCurrentPageItemCount() {
        InteractiveList a;
        return a.getPageIncrement(a.getModel().getCursor(), 1);
    }

    public void updateView(final int a) {
        InteractiveList a2;
        if (a < 0 || a >= a2.getModel().getSize()) {
            if (Log.isDebugOn()) {
                LOG.debug("invalid offset:" + a);
            }
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){
            {
                1 a2;
            }

            public void run() {
                1 a2;
                a2.InteractiveList.this.realUpdateView(a2.a);
            }
        });
    }

    private void realUpdateView(int a) {
        InteractiveList a2;
        if (a2.getModel() == null) {
            if (Log.isDebugOn()) {
                LOG.debug("model is null");
            }
            return;
        }
        if (a2.mRenderers == null) {
            if (Log.isDebugOn()) {
                LOG.debug("mRenderers is null");
            }
            return;
        }
        Object a3 = a2.getModel().getElementAt(a2.getModel().getCursor() + a);
        if (a3 == null) {
            if (Log.isDebugOn()) {
                LOG.debug("No element at:" + a);
            }
            return;
        }
        if (a < 0 || a >= a2.mRenderers.size()) {
            if (Log.isDebugOn()) {
                LOG.debug("No renderer found at offset:" + a);
            }
            return;
        }
        JComponent a4 = (JComponent)a2.mRenderers.get(a);
        a2.mFactory.updateRenderer(a4, a2.getModel(), a);
        a2.mFactory.updateRenderer(a4, a3);
        a4.repaint();
    }

    public void updateViews() {
        InteractiveList a;
        SwingUtilities.invokeLater(new Runnable(){
            {
                2 a;
            }

            public void run() {
                2 a;
                a.InteractiveList.this.realUpdateViews();
            }
        });
    }

    private void realUpdateViews() {
        int a;
        InteractiveList a2;
        if (a2.getModel() == null) {
            if (Log.isDebugOn()) {
                LOG.debug("model is null");
            }
            return;
        }
        if (a2.mRenderers == null) {
            if (Log.isDebugOn()) {
                LOG.debug("mRenderers is null");
            }
            return;
        }
        if (a2.mFactory == null) {
            if (Log.isDebugOn()) {
                LOG.debug("factory is null");
            }
            return;
        }
        int a3 = a2.getPageItemCount();
        if (Log.isDebugOn()) {
            LOG.debug("renderers: " + a2.mRenderers.size());
            LOG.debug("page increment: " + a3);
            LOG.debug("model size: " + a2.getModel().getSize());
            LOG.debug("cursor: " + a2.getModel().getCursor());
        }
        boolean a4 = false;
        int n = a = 0;
        while (n < a3) {
            JComponent a5;
            if (Log.isDebugOn()) {
                LOG.debug("processing " + a);
                LOG.debug("mRenderers size " + a2.mRenderers.size());
            }
            if (a2.getModel().getCursor() + a == a2.getModel().getSize() && a2.mRenderers.size() > a) {
                int a6;
                if (Log.isDebugOn()) {
                    LOG.debug("removing unnecessary renderers starting at " + a);
                }
                int n2 = a6 = a;
                while (n2 < a3) {
                    if (Log.isDebugOn()) {
                        LOG.debug("processing " + a6);
                        LOG.debug("mRenderers size " + a2.mRenderers.size());
                    }
                    if (a <= a2.mRenderers.size() - 1) {
                        a2.mRenderers.remove(a);
                    }
                    n2 = ++a6;
                }
                a4 = true;
                break;
            }
            if (a2.getModel().getCursor() + a >= a2.getModel().getSize()) break;
            Object a7 = a2.getModel().getElementAt(a2.getModel().getCursor() + a);
            if (a >= a2.mRenderers.size()) {
                a5 = a2.createRendererInFactory(a, a7);
                a2.mRenderers.add(a, a5);
                a4 = true;
            }
            if (a2.mFactory.needsDifferentRenderer((JComponent)a2.mRenderers.get(a), a2.getModel(), a) || a2.mFactory.needsDifferentRenderer((JComponent)a2.mRenderers.get(a), a7)) {
                if (Log.isDebugOn()) {
                    LOG.debug("replacing renderer");
                }
                a4 = true;
                a5 = a2.createRendererInFactory(a, a7);
                a2.mRenderers.remove(a);
                a2.mRenderers.add(a, a5);
            } else {
                if (Log.isDebugOn()) {
                    LOG.debug("keeping existing renderer");
                }
                a4 = true;
                a2.mFactory.updateRenderer((JComponent)a2.mRenderers.get(a), a2.getModel(), a);
                a2.mFactory.updateRenderer((JComponent)a2.mRenderers.get(a), a7);
            }
            n = ++a;
        }
        if (a4) {
            a2.removeAll();
            a2.revalidate();
            a2.repaint();
            Iterator a8 = a2.mRenderers.iterator();
            while (a8.hasNext()) {
                JComponent a9 = (JComponent)a8.next();
                a2.add(a9);
                if (!Log.isDebugOn()) continue;
                LOG.debug("refreshing viewer: " + a9);
            }
            a2.revalidate();
            a2.repaint();
        }
    }

    private void createViewers() {
        Object a;
        int a2;
        InteractiveList a3;
        if (Log.isDebugOn()) {
            LOG.debug("Entering InteractiveList.createViewers()");
        }
        if (a3.getModel() == null) {
            if (Log.isDebugOn()) {
                LOG.debug("model is null");
            }
            return;
        }
        if (a3.mFactory == null) {
            if (Log.isDebugOn()) {
                LOG.debug("factory is null");
            }
            return;
        }
        int a4 = a3.getCurrentPageItemCount();
        if (a3.mRenderers == null) {
            a3.mRenderers = new ArrayList(a4);
        }
        if (Log.isDebugOn()) {
            LOG.debug("renderers: " + a3.mRenderers.size());
            LOG.debug("page increment: " + a4);
            LOG.debug("model size: " + a3.getModel().getSize());
            LOG.debug("cursor: " + a3.getModel().getCursor());
        }
        int n = a2 = 0;
        while (n < a4) {
            try {
                a = a3.getModel().getElementAt(a3.getModel().getCursor() + a2);
                JComponent a5 = a3.createRendererInFactory(a2, a);
                a3.mRenderers.add(a2, a5);
            }
            catch (IndexOutOfBoundsException a6) {
                LOG.error(Log.CATCHALL_EX, null, "", (Throwable)a6);
            }
            n = ++a2;
        }
        Iterator a22 = a3.mRenderers.iterator();
        while (a22.hasNext()) {
            a = (JComponent)a22.next();
            a3.add((Component)a);
            if (!Log.isDebugOn()) continue;
            LOG.debug("added viewer: " + a);
        }
    }

    private JComponent createRendererInFactory(int a, Object a2) {
        InteractiveList a3;
        JComponent a4 = a3.mFactory.createRendererFor(a3.getModel(), a);
        if (a4 == null) {
            a4 = a3.mFactory.createRendererFor(a2);
        }
        if (a4 == null) {
            throw new IllegalStateException("no renderers defined for content");
        }
        return a4;
    }

    private void clear() {
        InteractiveList a;
        a.removeAll();
        if (a.mRenderers != null) {
            a.mRenderers.clear();
        }
        if (a.isVisible()) {
            a.revalidate();
            a.repaint();
        }
    }

    public void paint(Graphics a) {
        InteractiveList a2;
        super.paint(a);
        if (a2.separatorStyle == 0 || a2.gl.getColumns() > 1) {
            return;
        }
        a.setColor(a2.separtorColor);
        Insets a3 = a2.getInsets();
        int a4 = a2.getWidth() - (a3.left + a3.right);
        int a5 = a2.getHeight() - (a3.top + a3.bottom);
        a5 = (a5 - (a2.gl.getRows() - 1) * a2.gl.getVgap() - (a2.gl.getRows() + 1) * FixedGridLayout.SEPARATOR_GAP) / a2.gl.getRows();
        int a6 = 0;
        int a7 = a3.top;
        int n = a6;
        while (n <= a2.gl.getRows()) {
            if (a6 == 0) {
                if (a2.separatorStyle == 1) {
                    a.drawLine(a3.left, a7, a3.left + a4, a7);
                }
            } else if (a6 == a2.gl.getRows()) {
                if (a2.separatorStyle == 1) {
                    a.drawLine(a3.left, a7, a3.left + a4, a7);
                }
            } else if (a6 <= a2.mRenderers.size()) {
                a.drawLine(a3.left, a7, a3.left + a4, a7);
            }
            a7 += a5 + a2.gl.getVgap() + FixedGridLayout.SEPARATOR_GAP;
            n = ++a6;
        }
    }

    List getRenderers() {
        InteractiveList a;
        return Collections.unmodifiableList(a.mRenderers);
    }

    private class ModelListener
    implements ListDataListener {
        private ModelListener() {
            ModelListener a;
        }

        public void contentsChanged(ListDataEvent a) {
            ModelListener a2;
            if (Log.isDebugOn()) {
                LOG.debug("changed " + a);
            }
            if (a2.InteractiveList.this.isVisible()) {
                a2.InteractiveList.this.updateViews();
            }
        }

        public void intervalAdded(ListDataEvent a) {
            ModelListener a2;
            if (Log.isDebugOn()) {
                LOG.debug("added " + a);
            }
            if (a.getIndex1() < a2.InteractiveList.this.mModel.getCursor() || a.getIndex0() > a2.InteractiveList.this.mModel.getCursor() + a2.InteractiveList.this.getCurrentPageItemCount()) {
                return;
            }
            if (a2.InteractiveList.this.isVisible()) {
                a2.InteractiveList.this.updateViews();
            }
        }

        public void intervalRemoved(ListDataEvent a) {
            ModelListener a2;
            if (Log.isDebugOn()) {
                LOG.debug("removed " + a);
            }
            if (a.getIndex1() < a2.InteractiveList.this.mModel.getCursor() || a.getIndex0() > a2.InteractiveList.this.mModel.getCursor() + a2.InteractiveList.this.getCurrentPageItemCount()) {
                return;
            }
            if (a2.InteractiveList.this.isVisible()) {
                a2.InteractiveList.this.updateViews();
            }
        }
    }
}

