/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing;

import com.amazon.agui.swing.ButtonActionDialog;
import com.amazon.agui.swing.LimitedStyledDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class InputDialog
extends ButtonActionDialog {
    private static final String RESOURCES = "com.amazon.agui.swing.resources.ComponentResources";
    public static final int CANCEL_UPDATE_OPTIONS = 0;
    public static final int CANCEL_SAVE_OPTIONS = 1;
    public static final int DEFAULT_INPUT_ROWS = 1;
    public static final int DISABLE_NEVER = 0;
    public static final int DISABLE_IF_EMPTY = 1;
    public static final int DISABLE_IF_EQUAL = 2;
    public static final int DISABLE_IF_EMPTY_OR_EQUAL = 3;
    private int buttonDisablePolicy;
    private JLabel descriptionLabel;
    private int descriptionRows;
    private JTextArea inputTextArea;
    private JScrollPane scrollPane;
    private String initText;
    private int descriptionTextGap;
    private Box.Filler filler;
    private int rows;
    private DocumentListener documentListener;

    public InputDialog() {
        a(null, 1, "abc");
        InputDialog a;
    }

    public InputDialog(String a) {
        a2(a, 1, "abc");
        InputDialog a2;
    }

    public InputDialog(String a, int a2) {
        a3(a, a2, "abc");
        InputDialog a3;
    }

    public InputDialog(String a, int a2, String a3) {
        super(a, a3);
        InputDialog a4;
        a4.rows = a2;
        a4.initUI();
    }

    private void initUI() {
        InputDialog a;
        ResourceBundle a2 = ResourceBundle.getBundle(RESOURCES);
        a.setCloseIconButtonEnabled(false);
        a.descriptionTextGap = (Integer)a2.getObject("InputDialog.description_input_gap");
        Integer a3 = (Integer)a2.getObject("InputDialog.description.rows");
        a.descriptionRows = a3;
        float a4 = ((Float)a2.getObject("InputDialog.description_input_alignmentX")).floatValue();
        a.descriptionLabel = new JLabel();
        a.descriptionLabel.setFont((Font)a2.getObject("InputDialog.description.font"));
        a.descriptionLabel.setAlignmentX(a4);
        a.descriptionLabel.putClientProperty("maxRows", a3);
        a.inputTextArea = new JTextArea(a.rows, (Integer)a2.getObject("InputDialog.input.length"));
        a.inputTextArea.setDocument((Document)((Object)new LimitedStyledDocument(a.inputTextArea)));
        a.inputTextArea.setEditable(true);
        a.inputTextArea.setFont((Font)a2.getObject("InputDialog.input.font"));
        a.inputTextArea.setBackground((Color)a2.getObject("InputDialog.input.background.color"));
        a.inputTextArea.setWrapStyleWord(true);
        if (a.rows > 1) {
            a.inputTextArea.setLineWrap(true);
        } else {
            a.inputTextArea.setLineWrap(false);
        }
        a.descriptionLabel.putClientProperty("columnWidth", a2.getObject("InputDialog.description.column.width"));
        int a5 = a.inputTextArea.getPreferredSize().width;
        a.descriptionLabel.putClientProperty("maxColumns", new Integer(a5));
        a.scrollPane = new JScrollPane(a.inputTextArea);
        a.scrollPane.setHorizontalScrollBarPolicy(31);
        a.scrollPane.setVerticalScrollBarPolicy(21);
        Insets a6 = (Insets)a2.getObject("InputDialog.input.insets");
        a.scrollPane.setViewportBorder(BorderFactory.createEmptyBorder(a6.top, a6.left, a6.bottom, a6.right));
        a.scrollPane.setAlignmentX(a4);
        JPanel a7 = new JPanel();
        a7.setLayout(new BoxLayout(a7, 1));
        a7.add(a.descriptionLabel);
        a.filler = (Box.Filler)Box.createVerticalStrut(0);
        a.filler.setAlignmentX(a4);
        a7.add(a.filler);
        a7.add(a.scrollPane);
        a.getContentPane().setLayout(new GridBagLayout());
        a.getContentPane().add((Component)a7, new GridBagConstraints());
        Rectangle a8 = a.calculateBounds();
        a.setDialogBounds(a8);
    }

    private Rectangle calculateBounds() {
        InputDialog a;
        ResourceBundle a2 = ResourceBundle.getBundle(RESOURCES);
        Rectangle a3 = (Rectangle)a2.getObject("InputDialog.bounds.min");
        Rectangle a4 = new Rectangle(a3);
        Insets a5 = a.scrollPane.getBorder().getBorderInsets(a.scrollPane);
        a4.height += a5.top + a5.bottom;
        a5 = a.scrollPane.getViewportBorder().getBorderInsets(a.scrollPane.getViewport());
        a4.height += a5.top + a5.bottom;
        FontMetrics a6 = Toolkit.getDefaultToolkit().getFontMetrics(a.inputTextArea.getFont());
        int a7 = a6.getHeight();
        a.inputTextArea.setMaximumSize(new Dimension(Integer.MAX_VALUE, a7 * a.rows));
        a4.height += a.inputTextArea.getMaximumSize().height;
        a4.height += a.filler.getPreferredSize().height;
        Rectangle a8 = (Rectangle)a2.getObject("InputDialog.bounds.max");
        Dimension a9 = a.descriptionLabel.getPreferredSize();
        if (a4.height + a9.height <= a8.height) {
            a4.height += a9.height;
            return a4;
        }
        a6 = Toolkit.getDefaultToolkit().getFontMetrics(a.descriptionLabel.getFont());
        a7 = a6.getHeight();
        int a10 = (a8.height - a4.height) / a7;
        if (a10 <= 0) {
            a10 = 1;
        }
        a.descriptionLabel.putClientProperty("maxRows", new Integer(a10));
        a4.height += a.descriptionLabel.getPreferredSize().height;
        return a4;
    }

    public void addButton(Action a) {
        InputDialog a2;
        if (a == null) {
            throw new NullPointerException("action");
        }
        if (a2.getCommandBar().getComponentCount() > 0 && a2.disableButtons()) {
            a.setEnabled(false);
        }
        super.addButton(a);
    }

    public void setDescription(String a) {
        Dimension a2;
        Dimension a3;
        InputDialog a4;
        if (a != null && a.length() > 0) {
            a3 = new Dimension(0, a4.descriptionTextGap);
            a2 = new Dimension(Short.MAX_VALUE, a4.descriptionTextGap);
        } else {
            a3 = new Dimension(0, 0);
            a2 = new Dimension(Short.MAX_VALUE, 0);
        }
        a4.filler.changeShape(a3, a3, a2);
        a4.descriptionLabel.setText(a);
        Rectangle a5 = a4.calculateBounds();
        a4.setDialogBounds(a5);
    }

    public String getDescription() {
        InputDialog a;
        return a.descriptionLabel.getText();
    }

    public void setDescriptionFont(Font a) {
        InputDialog a2;
        if (a == null) {
            throw new NullPointerException("font");
        }
        if (!a2.descriptionLabel.getFont().equals(a)) {
            a2.descriptionLabel.setFont(a);
            int a3 = a2.inputTextArea.getPreferredSize().width;
            a2.descriptionLabel.putClientProperty("maxColumns", new Integer(a3));
            a2.descriptionLabel.putClientProperty("maxRows", new Integer(a2.descriptionRows));
            Rectangle a4 = a2.calculateBounds();
            a2.setDialogBounds(a4);
        }
    }

    public Font getDescriptionFont() {
        InputDialog a;
        return a.descriptionLabel.getFont();
    }

    public void setDescriptionRows(int a) {
        InputDialog a2;
        if (a < 0) {
            throw new IllegalArgumentException("rows");
        }
        a2.descriptionRows = a;
        a2.descriptionLabel.putClientProperty("maxRows", new Integer(a));
        Rectangle a3 = a2.calculateBounds();
        a2.setDialogBounds(a3);
    }

    public int getDescriptionRows() {
        InputDialog a;
        return a.descriptionRows;
    }

    public JTextArea getTextArea() {
        InputDialog a;
        return a.inputTextArea;
    }

    public void setInputText(String a) {
        InputDialog a2;
        a2.initText = a;
        a2.inputTextArea.setText(a);
        a2.inputTextArea.validate();
        if (a != null && a.length() > 0) {
            a2.inputTextArea.selectAll();
        }
    }

    public String getInputText() {
        InputDialog a;
        return a.inputTextArea.getText();
    }

    public void setButtonDisablePolicy(int a) {
        InputDialog a2;
        if (a < 0 || a > 3) {
            throw new IllegalArgumentException("policy");
        }
        if (a2.buttonDisablePolicy == a) {
            return;
        }
        a2.buttonDisablePolicy = a;
        a2.updateButtons();
        if (a != 0) {
            if (a2.documentListener == null) {
                a2.documentListener = new DocumentListener(){
                    {
                        1 a;
                    }

                    public void insertUpdate(DocumentEvent a) {
                        1 a2;
                        a2.InputDialog.this.updateButtons();
                    }

                    public void removeUpdate(DocumentEvent a) {
                        1 a2;
                        a2.InputDialog.this.updateButtons();
                    }

                    public void changedUpdate(DocumentEvent a) {
                        1 a2;
                        a2.InputDialog.this.updateButtons();
                    }
                };
                a2.inputTextArea.getDocument().addDocumentListener(a2.documentListener);
            }
        } else if (a2.documentListener != null) {
            a2.inputTextArea.getDocument().removeDocumentListener(a2.documentListener);
            a2.documentListener = null;
        }
    }

    public int getButtonDisablePolicy() {
        InputDialog a;
        return a.buttonDisablePolicy;
    }

    private void updateButtons() {
        int a;
        InputDialog a2;
        boolean a3 = !a2.disableButtons();
        Component[] a4 = a2.getCommandBar().getComponents();
        int n = a = 1;
        while (n < a4.length) {
            if (a4[a].isEnabled() != a3) {
                a4[a].setEnabled(a3);
            }
            n = ++a;
        }
    }

    private boolean disableButtons() {
        InputDialog a;
        String a2 = a.getInputText();
        boolean a3 = (a.buttonDisablePolicy & 1) != 0 && a2.length() == 0;
        boolean a4 = (a.buttonDisablePolicy & 2) != 0 && a2.length() > 0 && a2.equals(a.initText);
        return a3 || a4;
    }

    public static String showDialog(String a, String a2, String a3, int a4, String[] a5, int a6, int a7, String a8) {
        int a9;
        int a10;
        if (a4 < 0) {
            throw new IllegalArgumentException("maxDescriptionRows cannot be negative");
        }
        if (a5 == null) {
            throw new NullPointerException("options cannot be null");
        }
        if (a6 < 0 || a6 > 3) {
            throw new IllegalArgumentException("buttonDisablePolicy must be on of the predefined values");
        }
        if (a7 < 1) {
            throw new IllegalArgumentException("rows must be greater than zero");
        }
        InputDialog a11 = new InputDialog(a, a7);
        if (a2 != null) {
            a11.setTitleBarEnabled(true);
            a11.setTitle(a2);
        } else {
            a11.setTitleBarEnabled(false);
        }
        a11.setDescription(a3);
        a11.setDescriptionRows(a4);
        if (a5.length > 1) {
            a11.getCommandBar().setButtonWidthPreserved(false);
            a11.getCommandBar().setButtonPreferredSize(null);
        }
        ButtonActionDialog.ButtonReference a12 = new ButtonActionDialog.ButtonReference();
        int n = a10 = 0;
        while (n < a5.length) {
            a11.addButton(new ButtonActionDialog.ButtonAction(a5[a10], a12));
            n = ++a10;
        }
        a11.setInputText(a8);
        a11.setButtonDisablePolicy(a6);
        a11.postDialog(true);
        a10 = 0;
        int n2 = a9 = 0;
        while (n2 < a5.length) {
            String a13 = a12.pressedButtonName;
            if (a13 != null && a5[a9] != null && a13.equals(a5[a9])) {
                a10 = a9;
                break;
            }
            n2 = ++a9;
        }
        return a10 > 0 ? a11.getInputText() : null;
    }

    public static String showDialog(String a, String a2, String a3, int a4, String[] a5, int a6, String a7) {
        return InputDialog.showDialog(a, a2, a3, a4, a5, 0, a6, a7);
    }

    public static String showDialog(String a, String a2, String a3, String[] a4, int a5, int a6, String a7) {
        return InputDialog.showDialog(a, a2, a3, a3 != null ? 1 : 0, a4, a5, a6, a7);
    }

    public static String showDialog(String a, String a2, String a3, String[] a4, int a5, String a6) {
        return InputDialog.showDialog(a, a2, a3, a4, 0, a5, a6);
    }

    public static String showDialog(String a, String a2, String[] a3, int a4, String a5) {
        return InputDialog.showDialog(a, a2, null, a3, a4, a5);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String showDialog(String a, String a2, String a3, int a4, int a5, int a6, int a7, String a8) {
        ResourceBundle a9 = ResourceBundle.getBundle(RESOURCES);
        switch (a5) {
            case 0: {
                String[] a10 = new String[]{(String)a9.getObject("dialog.button.cancel.name"), (String)a9.getObject("dialog.button.update.name")};
                return InputDialog.showDialog(a, a2, a3, a4, a10, a6, a7, a8);
            }
            case 1: {
                String[] a11 = new String[]{(String)a9.getObject("dialog.button.cancel.name"), (String)a9.getObject("dialog.button.save.name")};
                return InputDialog.showDialog(a, a2, a3, a4, a11, a6, a7, a8);
            }
        }
        throw new IllegalArgumentException("Unknown optionType");
    }

    public static String showDialog(String a, String a2, String a3, int a4, int a5, int a6, String a7) {
        return InputDialog.showDialog(a, a2, a3, a4, a5, 0, a6, a7);
    }

    public static String showDialog(String a, String a2, String a3, int a4, int a5, String a6) {
        return InputDialog.showDialog(a, a2, a3, a3 != null ? 1 : 0, a4, a5, a6);
    }

    public static String showDialog(String a, String a2, int a3, int a4, String a5) {
        return InputDialog.showDialog(a, a2, null, a3, a4, a5);
    }
}

