/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing;

import com.amazon.agui.swing.IndexedListModel;
import com.amazon.agui.swing.IndexedModelScrollable;
import com.amazon.agui.swing.ListCursorChangeEvent;
import com.amazon.agui.swing.ListCursorChangeListener;
import com.amazon.agui.swing.event.GestureDispatcher;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;

public class IndexedModelScrollPane
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getInstance((String)"IndexedModelScrollPane");
    private static final LogMessage CURSOR_CHANGED = new LogMessage("CursorChangedEvent");
    private JComponent mChild;
    private CursorChangeListener mCCListener;
    private GestureDispatcher mMouseListener;
    private ModelPropertyChangeListener mPropertyChangeListener;
    private transient IndexedModelScrollable mChildScrollable;

    public IndexedModelScrollPane() {
        IndexedModelScrollPane a;
        a.mCCListener = a.new CursorChangeListener();
        a.mMouseListener = new GestureDispatcher();
        a.mPropertyChangeListener = a.new ModelPropertyChangeListener();
        a.setLayout(new BorderLayout());
        a.mChild = null;
        ActionMap a2 = a.getActionMap();
        a2.put("north", new VerticalScroller(true));
        a2.put("south", new VerticalScroller(false));
        a2.put("west", new VerticalScroller(true));
        a2.put("east", new VerticalScroller(false));
        a.setActionMap(a2);
    }

    public void setChild(JComponent a) {
        IndexedModelScrollPane a2;
        if (a != null && !(a instanceof IndexedModelScrollable)) {
            throw new IllegalArgumentException("setChild");
        }
        if (a2.mChild != null) {
            a2.mChild.removePropertyChangeListener(a2.mPropertyChangeListener);
            a2.mChild.removeMouseListener(a2.mMouseListener);
            if (a2.mChildScrollable.getIndexedModel() != null) {
                a2.mChildScrollable.getIndexedModel().removeCursorChangeListener(a2.mCCListener);
            }
            a2.remove(a2.mChild);
        }
        a2.mChild = a;
        a2.mChildScrollable = null;
        if (a2.mChild != null) {
            a2.mChildScrollable = (IndexedModelScrollable)((Object)a2.mChild);
            a2.mChild.addMouseListener(a2.mMouseListener);
            a2.mChild.addPropertyChangeListener(a2.mPropertyChangeListener);
            if (a2.mChildScrollable.getIndexedModel() != null) {
                a2.mChildScrollable.getIndexedModel().addCursorChangeListener(a2.mCCListener);
            }
            a2.add((Component)a2.mChild, "Center");
        }
    }

    public JComponent getChild() {
        IndexedModelScrollPane a;
        return a.mChild;
    }

    public void ensureIndexIsVisible(int a) {
        IndexedModelScrollPane a2;
        if (a2.mChild == null) {
            return;
        }
        if (a2.mChildScrollable.getIndexedModel() == null) {
            return;
        }
        IndexedListModel a3 = a2.mChildScrollable.getIndexedModel();
        int a4 = a3.getSize();
        if (a < 0 || a >= a4) {
            throw new IllegalArgumentException("ensureIndexIsVisible");
        }
        int a5 = a3.getCursor();
        int a6 = a2.mChildScrollable.getPageItemCount();
        if (a < a5) {
            a5 = a;
        } else if (a >= a5 + a6) {
            a5 += a - (a5 + a6) + 1;
        } else {
            return;
        }
        a3.setCursor(a5);
        a2.repaint();
    }

    public void ensureIndexIsFirst(int a) {
        IndexedModelScrollPane a2;
        IndexedListModel a3 = a2.mChildScrollable.getIndexedModel();
        if (a3 == null) {
            return;
        }
        int a4 = a3.getSize();
        if (a < 0 || a >= a4) {
            throw new IllegalArgumentException("ensureIndexIsVisible");
        }
        if (a != a3.getCursor()) {
            a3.setCursor(a);
            a2.repaint();
        }
    }

    public void page(boolean a) {
        IndexedModelScrollPane a2;
        if (Log.isDebugOn()) {
            LOG.debug("Entering IndexedModelScrollPane.page()...");
        }
        if (a2.mChildScrollable != null && a2.mChildScrollable.getIndexedModel() != null) {
            if (a2.isScrollable(a)) {
                int a3 = a ? 1 : -1;
                IndexedListModel a4 = a2.mChildScrollable.getIndexedModel();
                int a5 = a2.mChildScrollable.getPageIncrement(a4.getCursor(), a3);
                a2.scrollBy(a3 * a5);
            }
        } else {
            return;
        }
        if (Log.isDebugOn()) {
            LOG.debug("Exiting IndexedModelScrollPane.page()...");
        }
    }

    protected void scrollBy(int a) {
        IndexedModelScrollPane a2;
        IndexedListModel a3;
        if (Log.isDebugOn()) {
            LOG.debug("Entering IndexedModelScrollPane.scrollBy() " + a);
        }
        if ((a3 = a2.mChildScrollable.getIndexedModel()) == null) {
            return;
        }
        int a4 = a3.getSize();
        int a5 = a3.getCursor() + a;
        if (a5 < 0) {
            a5 = 0;
        } else if (a5 >= a4) {
            return;
        }
        a3.setCursor(a5);
        a2.repaint();
        if (Log.isDebugOn()) {
            LOG.debug("Exiting IndexedModelScrollPane.scrollBy() " + a);
        }
    }

    public boolean isScrollable(boolean a) {
        IndexedModelScrollPane a2;
        if (a2.mChildScrollable != null && a2.isVisible() && a2.mChildScrollable.getIndexedModel() != null) {
            IndexedListModel a3 = a2.mChildScrollable.getIndexedModel();
            int a4 = a3.getSize();
            int a5 = a3.getCursor();
            if (!a) {
                return a5 > 0;
            }
            return a5 + a2.mChildScrollable.getPageIncrement(a5, 1) < a4;
        }
        return false;
    }

    private static class VerticalScroller
    extends AbstractAction {
        private boolean dir;

        VerticalScroller(boolean a) {
            VerticalScroller a2;
            a2.dir = a;
        }

        public void actionPerformed(ActionEvent a) {
            IndexedModelScrollPane a2;
            IndexedModelScrollPane indexedModelScrollPane = a2 = null;
            for (Component a3 = (Component)a.getSource(); indexedModelScrollPane == null && a3 != null; a3 = a3.getParent()) {
                if (a3 instanceof IndexedModelScrollPane) {
                    a2 = (IndexedModelScrollPane)a3;
                    break;
                }
                indexedModelScrollPane = a2;
            }
            if (a2 != null) {
                VerticalScroller a4;
                a2.page(a4.dir);
            }
        }
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private ModelPropertyChangeListener() {
            ModelPropertyChangeListener a;
        }

        public void propertyChange(PropertyChangeEvent a) {
            if (a.getPropertyName().equals("model")) {
                ModelPropertyChangeListener a2;
                IndexedListModel a3 = (IndexedListModel)a.getOldValue();
                IndexedListModel a4 = (IndexedListModel)a.getNewValue();
                if (Log.isDebugOn()) {
                    LOG.debug("property model old: " + a3 + ", new: " + a4);
                }
                if (a3 != null) {
                    a3.removeCursorChangeListener(a2.IndexedModelScrollPane.this.mCCListener);
                }
                if (a4 != null) {
                    a4.addCursorChangeListener(a2.IndexedModelScrollPane.this.mCCListener);
                }
            }
        }
    }

    private class CursorChangeListener
    implements ListCursorChangeListener {
        private CursorChangeListener() {
            CursorChangeListener a;
        }

        public void cursorChanged(ListCursorChangeEvent a) {
            CursorChangeListener a2;
            if (Log.isDebugOn()) {
                LOG.debug("cursor: " + a.getNewCursor() + ", old cursor: " + a.getOldCursor());
            }
            a2.IndexedModelScrollPane.this.mChildScrollable.updateViews();
        }
    }
}

