/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing;

import com.amazon.agui.swing.event.GestureDispatcher;
import com.amazon.agui.swing.event.GestureEvent;
import com.amazon.ebook.util.text.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JPanel;

public class HeaderBar
extends JPanel {
    private static final String RESOURCES = "com.amazon.agui.swing.resources.ComponentResources";
    private static final int TEXT_NONE = -1;
    public static final int TEXT_PRIMARY = 0;
    public static final int TEXT_SECONDARY = 1;
    public static final int TEXT_END = 2;
    public static final int TEXT_SUB_PRIMARY = 3;
    private String mTextPrimary;
    private String mTextSubPrimary;
    private String mTextSecondary;
    private String mTextEnd;
    private Font mTextFont;
    private FontMetrics mFontMetrics;
    private int mBarHeight;
    private Insets mMargins;
    private int mSeparatorGap;
    private int mGap;
    private int mBaseline;
    private String mSeparatorString;
    private final ArrayList mListeners = new ArrayList();
    private MessageFormat mFormat;

    public HeaderBar() {
        a(null, null, null, null);
        HeaderBar a;
    }

    public HeaderBar(String a, String a2, String a3) {
        a4(a, null, a2, a3);
        HeaderBar a4;
    }

    public HeaderBar(String a, String a2, String a3, String a4) {
        HeaderBar a5;
        a5.mTextPrimary = a;
        a5.mTextSubPrimary = a2;
        a5.mTextSecondary = a3;
        a5.mTextEnd = a4;
        a5.initGUI();
    }

    private void initGUI() {
        HeaderBar a;
        ResourceBundle a2 = ResourceBundle.getBundle(RESOURCES);
        a.mBarHeight = (Integer)a2.getObject("HeaderBar.height");
        a.mSeparatorGap = (Integer)a2.getObject("HeaderBar.separatorgap");
        a.mGap = (Integer)a2.getObject("HeaderBar.gap");
        a.mBaseline = (Integer)a2.getObject("HeaderBar.baseline");
        a.mSeparatorString = a2.getString("HeaderBar.separator");
        a.setBackground((Color)a2.getObject("HeaderBar.background"));
        a.setForeground((Color)a2.getObject("HeaderBar.foreground"));
        a.mTextFont = (Font)a2.getObject("HeaderBar.text.font");
        a.mFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(a.mTextFont);
        a.mMargins = (Insets)a2.getObject("HeaderBar.margins");
        a.mFormat = new MessageFormat(a2.getString("HeaderBar.primary.format"));
        a.setOpaque(true);
        a.addMouseListener(new GestureDispatcher());
        ActionMap a3 = new ActionMap();
        a3.put("tap", a.new TapAction());
        a.setActionMap(a3);
    }

    public synchronized void addHeaderListener(HeaderListener a) {
        HeaderBar a2;
        if (a != null && !a2.mListeners.contains(a)) {
            a2.mListeners.add(a);
        }
    }

    public synchronized void removeHeaderListener(HeaderListener a) {
        HeaderBar a2;
        a2.mListeners.remove(a);
    }

    private synchronized void fireOnTapText(int a) {
        HeaderBar a2;
        Iterator a3;
        Iterator iterator = a3 = a2.mListeners.iterator();
        while (iterator.hasNext()) {
            ((HeaderListener)a3.next()).onTapText(a);
            iterator = a3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setText(int a, String a2) {
        HeaderBar a3;
        switch (a) {
            case 0: {
                a3.mTextPrimary = a2;
                break;
            }
            case 3: {
                a3.mTextSubPrimary = a2;
                break;
            }
            case 1: {
                a3.mTextSecondary = a2;
                break;
            }
            case 2: {
                a3.mTextEnd = a2;
                break;
            }
            default: {
                return;
            }
        }
        if (a3.isShowing()) {
            a3.revalidate();
            a3.repaint();
        }
    }

    public void setText(String a, String a2, String a3) {
        HeaderBar a4;
        a4.setText(a, null, a2, a3);
    }

    public void setText(String a, String a2, String a3, String a4) {
        HeaderBar a5;
        a5.mTextPrimary = a;
        a5.mTextSubPrimary = a2;
        a5.mTextSecondary = a3;
        a5.mTextEnd = a4;
        if (a5.isShowing()) {
            a5.revalidate();
            a5.repaint();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getText(int a) {
        switch (a) {
            case 0: {
                HeaderBar a2;
                return a2.mTextPrimary;
            }
            case 1: {
                HeaderBar a2;
                return a2.mTextSecondary;
            }
            case 2: {
                HeaderBar a2;
                return a2.mTextEnd;
            }
            case 3: {
                HeaderBar a2;
                return a2.mTextSubPrimary;
            }
        }
        return null;
    }

    public Dimension getPreferredSize() {
        HeaderBar a;
        Dimension a2 = new Dimension();
        Insets a3 = a.getInsets();
        if (a3 != null) {
            a2.width = a3.left + a3.right;
            a2.height = a3.top + a3.bottom;
        }
        a2.height += a.mBarHeight;
        a2.width += a.mMargins.left + a.mMargins.right;
        a2.height += a.mMargins.top + a.mMargins.bottom;
        a2.width += a.mSeparatorGap * 2 + a.mGap;
        int a4 = 0;
        if (a.mTextPrimary != null && a.mTextPrimary.length() > 0) {
            a4 = a.mFontMetrics.stringWidth(StringUtil.isEmpty((String)a.mTextSubPrimary) ? a.mTextPrimary : a.mFormat.format(new Object[]{a.mTextPrimary, a.mTextSubPrimary}).trim());
        }
        if (a.mTextSecondary != null && a.mTextSecondary.length() > 0) {
            a4 += a.mFontMetrics.stringWidth(a.mTextSecondary);
        }
        if (a.mTextEnd != null && a.mTextEnd.length() > 0) {
            a4 += a.mFontMetrics.stringWidth(a.mTextEnd);
        }
        int a5 = Toolkit.getDefaultToolkit().getScreenSize().width;
        a2.width += a4;
        if (a2.width > a5) {
            a2.width = a5;
        }
        return a2;
    }

    private int getTextContainingPoint(Point a) {
        int a2;
        HeaderBar a3;
        Insets a4 = a3.getInsets();
        int a5 = a3.mTextEnd != null && a3.mTextEnd.length() > 0 ? a3.mFontMetrics.stringWidth(a3.mTextEnd) : 0;
        int a6 = a3.mTextSecondary != null && a3.mTextSecondary.length() > 0 ? a3.mFontMetrics.stringWidth(a3.mTextSecondary) : 0;
        int a7 = 0;
        if (a5 > 0 && a.x >= (a2 = a3.getSize().width - a3.mMargins.right - a4.right - a5) && a.x <= a2 + a5) {
            return 2;
        }
        String a8 = a3.getTruncatedPrimaryString(a3.getSize().width - a5);
        a7 = a8 != null && a8.length() > 0 ? a3.mFontMetrics.stringWidth(a8) : 0;
        a2 = a3.mMargins.left + a4.left;
        if (a7 > 0) {
            if (a.x >= a2 && a.x <= a2 + a7) {
                return 0;
            }
            int a9 = a3.mSeparatorString != null && a3.mSeparatorString.length() > 0 ? a3.mFontMetrics.stringWidth(a3.mSeparatorString) + a3.mSeparatorGap * 2 : 0;
            a2 = a2 + a7 + a9;
        }
        if (a6 > 0 && a.x >= a2 && a.x <= a2 + a6) {
            return 1;
        }
        return -1;
    }

    protected void paintComponent(Graphics a) {
        int a2;
        String a3;
        HeaderBar a4;
        Insets a5 = a4.getInsets();
        Dimension a6 = a4.getSize();
        if (a4.isOpaque()) {
            a.setColor(a4.getBackground());
            a.fillRect(0, 0, a6.width, a6.height);
        }
        a.setFont(a4.mTextFont);
        a.setColor(a4.getForeground());
        int a7 = a6.width - a4.mMargins.right - a5.right;
        if (a4.mTextEnd != null && a4.mTextEnd.length() > 0) {
            a.drawString(a4.mTextEnd, a7 -= a4.mFontMetrics.stringWidth(a4.mTextEnd), a4.mBaseline);
        }
        if ((a3 = a4.getTruncatedPrimaryString(a7 - (a2 = a5.left + a4.mMargins.left))) != null) {
            a.drawString(a3, a2, a4.mBaseline);
            if (a4.mTextSecondary != null && a4.mTextSecondary.length() > 0) {
                a.drawString(a4.mSeparatorString, a2 += a4.mFontMetrics.stringWidth(a3) + a4.mSeparatorGap, a4.mBaseline);
                a.drawString(a4.mTextSecondary, a2 += a4.mFontMetrics.stringWidth(a4.mSeparatorString) + a4.mSeparatorGap, a4.mBaseline);
            }
        } else if (a4.mTextSecondary != null && a4.mTextSecondary.length() > 0) {
            a.drawString(a4.mTextSecondary, a2, a4.mBaseline);
        }
    }

    private String getTruncatedPrimaryString(int a) {
        HeaderBar a2;
        if (a < 0) {
            return null;
        }
        if (a2.mTextPrimary != null && a2.mTextPrimary.length() > 0) {
            if (a2.mTextSecondary != null && a2.mTextSecondary.length() > 0) {
                a -= a2.mFontMetrics.stringWidth(a2.mTextSecondary);
                a -= a2.mFontMetrics.stringWidth(a2.mSeparatorString);
                a -= a2.mGap + 2 * a2.mSeparatorGap;
            } else {
                a -= a2.mGap;
            }
            if (a2.mTextSubPrimary != null && a2.mTextSubPrimary.length() > 0) {
                if (a2.mFontMetrics.stringWidth(a2.mTextSubPrimary) > a) {
                    return StringUtil.shortenText((FontMetrics)a2.mFontMetrics, (String)a2.mTextPrimary, (int)a);
                }
                a = a - a2.mFontMetrics.stringWidth(a2.mFormat.format(new Object[]{a2.mTextPrimary, a2.mTextSubPrimary})) + a2.mFontMetrics.stringWidth(a2.mTextPrimary);
                return a2.mFormat.format(new Object[]{StringUtil.shortenText((FontMetrics)a2.mFontMetrics, (String)a2.mTextPrimary, (int)a), a2.mTextSubPrimary});
            }
            return StringUtil.shortenText((FontMetrics)a2.mFontMetrics, (String)a2.mTextPrimary, (int)a);
        }
        return null;
    }

    public static interface HeaderListener {
        public void onTapText(int var1);
    }

    private class TapAction
    extends AbstractAction {
        private TapAction() {
            TapAction a;
        }

        public void actionPerformed(ActionEvent a) {
            GestureEvent a2;
            int a3;
            TapAction a4;
            if (a4.HeaderBar.this.mListeners.isEmpty()) {
                return;
            }
            if (a instanceof GestureEvent && (a3 = a4.HeaderBar.this.getTextContainingPoint((a2 = (GestureEvent)a).getLocation())) != -1) {
                a4.HeaderBar.this.fireOnTapText(a3);
            }
        }
    }
}

