/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing;

import com.amazon.ebook.util.text.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;

public class Header
extends JComponent {
    private static final String RESOURCES = "com.amazon.agui.swing.resources.ComponentResources";
    private String text;
    private Integer number;
    private Font textFont;
    private Font numberFont;
    private Color separatorColor;
    private Insets margins;
    private int gap;
    private MessageFormat format;

    public Header() {
        Header a;
        ResourceBundle a2 = ResourceBundle.getBundle(RESOURCES);
        a.textFont = (Font)a2.getObject("Header.text.font");
        a.numberFont = (Font)a2.getObject("Header.number.font");
        a.margins = (Insets)a2.getObject("Header.margins");
        a.gap = (Integer)a2.getObject("Header.gap");
        a.setBackground((Color)a2.getObject("Header.background"));
        a.setForeground((Color)a2.getObject("Header.foreground"));
        a.separatorColor = (Color)a2.getObject("Header.separator.color");
        a.format = new MessageFormat(a2.getString("Header.number.template"));
        a.setOpaque(true);
    }

    public Header(String a) {
        a2();
        Header a2;
        a2.text = a;
    }

    public Header(String a, Integer a2) {
        a3(a);
        Header a3;
        a3.number = a2;
    }

    public String getText() {
        Header a;
        return a.text;
    }

    public void setText(String a) {
        Header a2;
        a2.text = a;
        if (a2.isVisible()) {
            a2.revalidate();
            a2.repaint();
        }
    }

    public Integer getNumber() {
        Header a;
        return a.number;
    }

    public void setNumber(Integer a) {
        Header a2;
        a2.number = a;
        if (a2.isVisible()) {
            a2.revalidate();
            a2.repaint();
        }
    }

    public Font getTextFont() {
        Header a;
        return a.textFont;
    }

    public void setTextFont(Font a) {
        Header a2;
        if (a == null) {
            throw new NullPointerException("font");
        }
        a2.textFont = a;
        if (a2.isVisible()) {
            a2.revalidate();
            a2.repaint();
        }
    }

    public Font getNumberFont() {
        Header a;
        return a.numberFont;
    }

    public void setNumberFont(Font a) {
        Header a2;
        if (a == null) {
            throw new NullPointerException("font");
        }
        a2.numberFont = a;
        if (a2.isVisible()) {
            a2.revalidate();
            a2.repaint();
        }
    }

    public Insets getMargins() {
        Header a;
        return new Insets(a.margins.top, a.margins.left, a.margins.bottom, a.margins.right);
    }

    public void setMargins(Insets a) {
        Header a2;
        if (a == null) {
            throw new NullPointerException("margins");
        }
        a2.margins = new Insets(a.top, a.left, a.bottom, a.right);
        if (a2.isVisible()) {
            a2.revalidate();
            a2.repaint();
        }
    }

    public int getGap() {
        Header a;
        return a.gap;
    }

    public void setGap(int a) {
        Header a2;
        if (a < 0) {
            throw new IllegalArgumentException("gap");
        }
        a2.gap = a;
        if (a2.isVisible()) {
            a2.revalidate();
            a2.repaint();
        }
    }

    public Color getSeparatorColor() {
        Header a;
        return a.separatorColor;
    }

    public void setSeparatorColor(Color a) {
        Header a2;
        if (a == null) {
            throw new NullPointerException("color");
        }
        a2.separatorColor = a;
        if (a2.isVisible()) {
            a2.revalidate();
            a2.repaint();
        }
    }

    public Dimension getPreferredSize() {
        Header a;
        Dimension a2 = new Dimension();
        Insets a3 = a.getInsets();
        if (a3 != null) {
            a2.width += a3.left + a3.right;
            a2.height += a3.top + a3.bottom;
        }
        ++a2.height;
        a2.width += a.margins.left + a.margins.right;
        a2.height += a.margins.top + a.margins.bottom;
        Toolkit a4 = Toolkit.getDefaultToolkit();
        int a5 = 0;
        int a6 = 0;
        if (a.text != null && a.text.length() > 0) {
            FontMetrics a7 = a4.getFontMetrics(a.textFont);
            a5 = a7.stringWidth(a.text);
            a6 = a7.getHeight();
        }
        int a8 = 0;
        if (a.number != null) {
            FontMetrics a9 = a4.getFontMetrics(a.numberFont);
            if (a.text != null && a.text.length() > 0) {
                a5 += a.gap;
            }
            a5 += a9.stringWidth(a.format.format(new Object[]{a.number}));
            a8 = a9.getHeight();
        }
        int a10 = Toolkit.getDefaultToolkit().getScreenSize().width;
        a2.height += Math.max(a6, a8);
        a2.width += a5;
        if (a2.width > a10) {
            a2.width = a10;
        }
        return a2;
    }

    protected void paintComponent(Graphics a) {
        Serializable a2;
        Header a3;
        BoundedText a4 = new BoundedText();
        new BoundedText().text = a3.text;
        BoundedText a5 = new BoundedText();
        if (a3.number != null) {
            a5.text = a3.format.format(new Object[]{a3.number});
        }
        Bounds a6 = new Bounds();
        a3.calculateRectangles(a, a3, a4, a5, a6);
        if (a3.isOpaque()) {
            a2 = a3.getSize();
            a.setColor(a3.getBackground());
            a.fillRect(0, 0, ((Dimension)a2).width, ((Dimension)a2).height);
        }
        if (a4.text != null && a4.text.length() > 0) {
            a.setFont(a3.textFont);
            a2 = a.getFontMetrics();
            a.setColor(a3.getForeground());
            a.drawString(a4.text, a4.x, a4.y + ((FontMetrics)a2).getAscent());
        }
        if (a5.text != null && a5.text.length() > 0) {
            a.setFont(a3.numberFont);
            a2 = a.getFontMetrics();
            a.setColor(a3.getForeground());
            a.drawString(a5.text, a5.x, a5.y + ((FontMetrics)a2).getAscent());
        }
        a.setColor(a3.separatorColor);
        a.drawLine(a6.x, a6.y, a6.x + a6.width - 1, a6.y);
    }

    private void calculateRectangles(Graphics a, JComponent a2, BoundedText a3, BoundedText a4, Bounds a5) {
        Header a6 = (Header)a2;
        Bounds a7 = new Bounds();
        new Bounds().width = a2.getWidth();
        a7.height = a2.getHeight();
        Insets a8 = a2.getInsets();
        if (a8 != null) {
            a7.x += a8.left;
            a7.y += a8.top;
            a7.height -= a8.top + a8.bottom;
            a7.width -= a8.left + a8.right;
        }
        a5.x = a7.x;
        a5.y = a7.y + a7.height - 1;
        a5.width = a7.width;
        --a7.height;
        a8 = a6.getMargins();
        a7.x += a8.left;
        a7.y += a8.top;
        a7.height -= a8.top + a8.bottom;
        a7.width -= a8.left + a8.right;
        int a9 = 0;
        int a10 = 0;
        FontMetrics a11 = a.getFontMetrics(a6.getTextFont());
        if (a3.text != null && a3.text.length() > 0) {
            a3.x = a7.x;
            a3.y = a7.y;
            a3.width = a7.width;
            a3.height = a11.getHeight();
            a9 = a11.getAscent();
            a10 = a11.stringWidth(a3.text);
        }
        int a12 = a7.width;
        if (a4.text != null && a4.text.length() > 0) {
            a11 = a.getFontMetrics(a6.getNumberFont());
            a4.height = a11.getHeight();
            int a13 = a11.stringWidth(a4.text);
            if (a3.text != null && a3.text.length() > 0) {
                int a14 = a11.getAscent();
                int a15 = a6.getGap();
                if (a10 + a15 + a13 > a12) {
                    StringUtil.AttributedText a16 = new StringUtil.AttributedText(a3.text, a.getFontMetrics(a6.getTextFont()));
                    StringUtil.AttributedText a17 = new StringUtil.AttributedText(a4.text, a.getFontMetrics(a6.getNumberFont()));
                    StringUtil.shortenTwoTexts((StringUtil.AttributedText)a16, (StringUtil.AttributedText)a17, (int)(a12 - a15));
                    a3.text = a16.text;
                    a10 = a16.width;
                    a4.text = a17.text;
                    a13 = a17.width;
                }
                a3.width = a10;
                a4.width = a13;
                a4.x = a7.x;
                a4.x += a10 + a15;
                if (a3.height >= a4.height) {
                    a4.y = a3.y + a9 - a14;
                } else {
                    a4.y = a7.y;
                    a3.y = a4.y + a14 - a9;
                }
            } else {
                if (a13 > a12) {
                    a4.text = StringUtil.shortenText((FontMetrics)a11, (String)a4.text, (int)a12);
                    a13 = a11.stringWidth(a4.text);
                }
                a4.x = a7.x;
                a4.y = a7.y;
                a4.width = a13;
            }
        } else if (a3.text != null && a3.text.length() > 0) {
            if (a10 > a12) {
                a3.text = StringUtil.shortenText((FontMetrics)a11, (String)a3.text, (int)a12);
                a3.width = a12;
            } else {
                a3.width = a10;
            }
        }
    }

    protected static class BoundedText
    extends Bounds {
        public String text;

        protected BoundedText() {
            BoundedText a;
        }
    }

    protected static class Bounds {
        public int x;
        public int y;
        public int width;
        public int height;

        protected Bounds() {
            Bounds a;
        }
    }
}

