/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing;

import com.amazon.agui.swing.KindleFrameFactory;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ExternalWindowHost
extends JComponent {
    private static final Log LOG = Log.getInstance((String)"ExternalWindowHost");
    private static final LogMessage ERROR_PARENT_NOT_JFRAME = new LogMessage("ParentNotJFrame");
    private static final int ROUNDED_EDGES_PADDING = 0;
    private String id;
    private String lbl;
    private final List notificationListeners;

    public ExternalWindowHost(String a) {
        a2(a, Log.isDebugOn() ? "EWH:" + a + " waiting for EWC client to load..." : "");
        ExternalWindowHost a2;
    }

    public ExternalWindowHost(String a, String a2) {
        ExternalWindowHost a3;
        a3.id = a;
        a3.lbl = a2;
        a3.notificationListeners = new LinkedList();
        a3.addComponentListener(a3.new EWHComponentListener());
    }

    public synchronized void addNotifyEventListener(NotificationListener a) {
        ExternalWindowHost a2;
        a2.notificationListeners.add(a);
    }

    public synchronized void addNotify() {
        ListIterator a;
        ExternalWindowHost a2;
        super.addNotify();
        a2.updateHostRegion();
        ListIterator listIterator = a = a2.notificationListeners.listIterator();
        while (listIterator.hasNext()) {
            ((NotificationListener)a.next()).onAddNotify();
            listIterator = a;
        }
    }

    public synchronized void removeNotify() {
        ListIterator a;
        ExternalWindowHost a2;
        super.removeNotify();
        ListIterator listIterator = a = a2.notificationListeners.listIterator();
        while (listIterator.hasNext()) {
            ((NotificationListener)a.next()).onRemoveNotify();
            listIterator = a;
        }
    }

    protected void paintComponent(Graphics a) {
        ExternalWindowHost a2;
        super.paintComponent(a);
        a.drawString(a2.lbl, 15, 25);
    }

    protected void updateHostRegion() {
        ExternalWindowHost a;
        Window a2 = SwingUtilities.getWindowAncestor(a);
        if (a2 instanceof JFrame) {
            JFrame a3 = (JFrame)a2;
            Rectangle a4 = SwingUtilities.convertRectangle(a, a.getBounds(), a2);
            KindleFrameFactory.setHostRegion(a3, a.id, a4.x, a4.y, a4.width, a4.height - 0);
        } else {
            LOG.error(ERROR_PARENT_NOT_JFRAME);
        }
    }

    public static interface NotificationListener {
        public void onAddNotify();

        public void onRemoveNotify();
    }

    private class EWHComponentListener
    extends ComponentAdapter {
        private EWHComponentListener() {
            EWHComponentListener a;
        }

        public void componentResized(ComponentEvent a) {
            EWHComponentListener a2;
            a2.ExternalWindowHost.this.updateHostRegion();
        }
    }
}

