/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.agui.swing;

import com.amazon.agui.swing.AbstractContentItemView;
import com.amazon.agui.swing.BlackWhiteFilter;
import com.amazon.agui.swing.ButtonStateModel;
import com.amazon.agui.swing.ComplexStateModel;
import com.amazon.agui.swing.ContentItemModel;
import com.amazon.agui.swing.SimpleContentItemModel;
import com.amazon.agui.swing.StateModel;
import com.amazon.agui.swing.event.GestureDispatcher;
import com.amazon.agui.swing.plaf.kindle.KindleIconFactory;
import com.amazon.agui.swing.plaf.kindle.KindleSwingUtilities;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.ebook.util.text.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ContentItemView
extends AbstractContentItemView {
    private static final long serialVersionUID = -3299500662096605823L;
    private static final Log LOG = Log.getInstance((String)"ContentItemView");
    private static final LogMessage PAINT_TIME = new LogMessage("PaintTime", new String[]{"elapsed", "anti-alias"});
    private static final String RESOURCES = "com.amazon.agui.swing.resources.ComponentResources";
    private static final String[] FONT_RESOURCE_TAGS = new String[]{"small", "medium", "large"};
    private static final int DISARM_DELAY = (Integer)ResourceBundle.getBundle("com.amazon.agui.swing.resources.ComponentResources").getObject("ContentItemView.disarm_delay");
    private ContentItemModel mModel;
    private View mView;
    private JProgressBar mProgress;
    private int mPrimSecMargin;
    private int mPrimTerMargin;
    private int mPrimSecGap;
    private int mProgGap;
    private int mIconGap;
    private int mTagGap;
    private int mTagVerticalGap;
    private int mProgTerGap;
    private int mTagIconGap;
    private int mIconPrimGap;
    private int mTerPrimGap;
    private Font mPrimaryFont;
    private Font mSecondaryFont;
    private Font mTertiaryFont;
    private Font mTagFont;
    private Font mTagCoverviewFont;
    private int mMaxPrimaryWidth;
    protected int mMaxSecondaryWidth;
    private int mMaxTertiaryWidth;
    private int mScreenWidthDivisorSmall = 1;
    private int mScreenWidthDivisorLarge = 1;
    private int mCheckboxWidth;
    private int mCheckboxTopgap;
    private FontMetrics mFMPrimaryFont;
    private FontMetrics mFMSecondaryFont;
    private FontMetrics mFMTertiaryFont;
    private FontMetrics mFMTagFont;
    private FontMetrics mFMCoverviewTagFont;
    private boolean paintProgress = true;
    private boolean isXorForced = false;
    private Color mDisabledBackgroundColor;
    private Color mDisabledForegroundColor;
    private int mMaxTagWidth;
    private int mFilterThreshold;
    private ChangeListener mChangeListener;
    private boolean showXOR = false;
    private Timer disarmTimer;

    public ContentItemView() {
        a(null);
        ContentItemView a;
    }

    public ContentItemView(ContentItemModel a) {
        ContentItemView a2;
        a2.setOpaque(true);
        a2.createView(a);
        if (a != null) {
            StateModel a3 = a.getStateModel();
            if (a3 instanceof ButtonStateModel) {
                a2.setListeners(a3);
            } else if (a3 instanceof ComplexStateModel && (a3 = ((ComplexStateModel)a3).get(ButtonStateModel.class)) != null) {
                a2.setListeners(a3);
            }
        }
    }

    public void enableXOR(boolean a) {
        ContentItemView a2;
        a2.enableXOR(a, false);
    }

    public void enableXOR(boolean a, boolean a2) {
        if (!a2 && Boolean.getBoolean("buttons.noxor")) {
            return;
        }
        a.showXOR = a;
        if (a2) {
            a.isXorForced = a;
        }
    }

    private void createView(ContentItemModel a) {
        ContentItemView a2;
        ResourceBundle a3 = ResourceBundle.getBundle(RESOURCES);
        a2.mPrimSecMargin = (Integer)a3.getObject("ContentItemView.primary_secondary_margin");
        a2.mPrimTerMargin = (Integer)a3.getObject("ContentItemView.primary_tertiary_margin");
        a2.mPrimSecGap = (Integer)a3.getObject("ContentItemView.primary_secondary_gap");
        a2.mProgGap = (Integer)a3.getObject("ContentItemView.progress_gap");
        a2.mIconGap = (Integer)a3.getObject("ContentItemView.image_gap");
        a2.mTagGap = (Integer)a3.getObject("ContentItemView.tag_gap");
        a2.mTagVerticalGap = (Integer)a3.getObject("ContentItemView.tag_vertical_gap");
        a2.mProgTerGap = (Integer)a3.getObject("ContentItemView.progress_tertiary_gap");
        a2.mTagIconGap = (Integer)a3.getObject("ContentItemView.tag_icon_gap");
        a2.mIconPrimGap = (Integer)a3.getObject("ContentItemView.image_primary_gap");
        a2.mTerPrimGap = (Integer)a3.getObject("ContentItemView.tertiary_primary_gap");
        a2.mMaxTertiaryWidth = (Integer)a3.getObject("ContentItemView.max_tertiary_width");
        a2.setBackground((Color)a3.getObject("Component.color.background"));
        a2.setForeground((Color)a3.getObject("Component.color.foreground"));
        a2.mDisabledBackgroundColor = (Color)a3.getObject("Component.color.disabled.background");
        a2.mDisabledForegroundColor = (Color)a3.getObject("Component.color.disabled.foreground");
        a2.mMaxPrimaryWidth = (Integer)a3.getObject("ContentItemView.max_primary_width");
        a2.mMaxSecondaryWidth = (Integer)a3.getObject("ContentItemView.max_secondary_width");
        a2.mScreenWidthDivisorSmall = (Integer)a3.getObject("ContentItemView.screen_width_divisor.small");
        a2.mScreenWidthDivisorLarge = (Integer)a3.getObject("ContentItemView.screen_width_divisor.large");
        a2.mFilterThreshold = (Integer)a3.getObject("ContentItemView.image.filter.threshold");
        a2.mMaxTagWidth = (Integer)a3.getObject("ContentItemView.max_tag_width");
        a2.mCheckboxWidth = (Integer)a3.getObject("ContentItemView.checkbox.width");
        a2.mCheckboxTopgap = (Integer)a3.getObject("ContentItemView.checkbox.topgap");
        a2.mModel = a == null ? new SimpleContentItemModel("", "", null, null, -1, 0) : a;
        a2.setRelSize(1);
        a2.mProgress = new JProgressBar();
        a2.mProgress.setOpaque(false);
        a2.setAlignmentY(0.0f);
        a2.setFocusable(true);
        a2.addMouseListener(new GestureDispatcher());
    }

    private void setListeners(StateModel a) {
        ContentItemView a2;
        ButtonStateModel a3 = (ButtonStateModel)a;
        if (a2.mChangeListener == null) {
            a2.mChangeListener = a2.new StateChangeListener();
        }
        a3.addChangeListener(a2.mChangeListener);
    }

    public ContentItemModel getDataModel() {
        ContentItemView a;
        return a.mModel;
    }

    public void setDataModel(ContentItemModel a) {
        ComplexStateModel a2;
        StateModel a3;
        ContentItemView a4;
        if (a == null) {
            throw new IllegalArgumentException("model");
        }
        if (a4.getDataModel() != null) {
            a3 = a4.getDataModel().getStateModel();
            if (a3 instanceof ButtonStateModel) {
                a4.removeListeners(a3);
            } else if (a3 instanceof ComplexStateModel && (a3 = (a2 = (ComplexStateModel)a3).get(ButtonStateModel.class)) != null) {
                a4.removeListeners(a3);
            }
        }
        if ((a3 = a.getStateModel()) instanceof ButtonStateModel) {
            a4.setListeners(a3);
        } else if (a3 instanceof ComplexStateModel && (a3 = (a2 = (ComplexStateModel)a3).get(ButtonStateModel.class)) != null) {
            a4.setListeners(a3);
        }
        a4.setDataModelBasic(a);
    }

    private void removeListeners(StateModel a) {
        ContentItemView a2;
        ButtonStateModel a3 = (ButtonStateModel)a;
        if (a3.isPressed() || a3.isArmed()) {
            a3.setPressed(false);
            a3.setArmed(false);
        }
        a3.removeChangeListener(a2.mChangeListener);
    }

    private void setDataModelBasic(ContentItemModel a) {
        ContentItemView a2;
        if (a == null) {
            throw new IllegalArgumentException("model");
        }
        ContentItemModel a3 = a2.mModel;
        a2.mModel = a;
        a2.firePropertyChange("model", a3, a2.mModel);
    }

    public ButtonStateModel getButtonStateModel() {
        ContentItemView a;
        if (a.getDataModel() != null) {
            StateModel a2 = a.getDataModel().getStateModel();
            if (a2 instanceof ButtonStateModel) {
                return (ButtonStateModel)a2;
            }
            if (a2 instanceof ComplexStateModel && (a2 = ((ComplexStateModel)a2).get(ButtonStateModel.class)) != null) {
                return (ButtonStateModel)a2;
            }
        }
        return null;
    }

    public void setButtonStateModel(ButtonStateModel a) {
        ContentItemView a2;
        ButtonStateModel a3 = a2.getButtonStateModel();
        a2.getDataModel().setStateModel(a);
        if (a3 != null) {
            a2.removeListeners(a3);
        }
        if (a != null) {
            a2.setListeners(a);
        }
        a2.firePropertyChange("buttonModel", a3, a);
    }

    public void setRelSize(int a) {
        ContentItemView a2;
        super.setRelSize(a);
        ResourceBundle a3 = ResourceBundle.getBundle(RESOURCES);
        String a4 = FONT_RESOURCE_TAGS[a];
        if (a2.getViewStyle() == 5) {
            a2.setPrimaryFont((Font)a3.getObject("ContentItemView.primary_font_collection." + a4));
        } else {
            a2.setPrimaryFont((Font)a3.getObject("ContentItemView.primary_font." + a4));
        }
        a2.setSecondaryFont((Font)a3.getObject("ContentItemView.secondary_font." + a4));
        a2.setTertiaryFont((Font)a3.getObject("ContentItemView.tertiary_font." + a4));
        a2.setTagFont((Font)a3.getObject("ContentItemView.tag_font." + a4));
        a2.setTagCoverviewFont((Font)a3.getObject("ContentItemView.tag_font_cover." + a4));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setViewStyle(int a) {
        ContentItemView a2;
        super.setViewStyle(a);
        ResourceBundle a3 = ResourceBundle.getBundle(RESOURCES);
        String a4 = FONT_RESOURCE_TAGS[a2.getRelSize()];
        switch (a) {
            case 3: {
                a2.setPrimaryFont((Font)a3.getObject("ContentItemView.primary_font." + a4));
                a2.mView = new ImageTextView();
                return;
            }
            case 12: {
                a2.setPrimaryFont((Font)a3.getObject("ContentItemView.primary_font_collection." + a4));
                a2.mView = new ImageTextView();
                return;
            }
            case 5: {
                a2.setPrimaryFont((Font)a3.getObject("ContentItemView.primary_font_collection." + a4));
                a2.setTertiaryFont((Font)a3.getObject("ContentItemView.tertiary_font_collection." + a4));
                a2.setPrimaryTertiaryMargin((Integer)a3.getObject("ContentItemView.primary_tertiary_margin_collection"));
                a2.mView = new FullWideView();
                ((FullWideView)a2.mView).setConcatenatePrimaryAndTertiary(true);
                return;
            }
            case 14: {
                a2.setPrimaryFont((Font)a3.getObject("ContentItemView.primary_font_collection." + a4));
                a2.setTertiaryFont((Font)a3.getObject("ContentItemView.tertiary_font_collection." + a4));
                a2.setPrimaryTertiaryMargin((Integer)a3.getObject("ContentItemView.primary_tertiary_margin_collection"));
                a2.mView = new FullWideView(true);
                ((FullWideView)a2.mView).setConcatenatePrimaryAndTertiary(true);
                return;
            }
            case 2: {
                a2.mView = new FullWideView();
                return;
            }
            case 10: {
                a2.mView = new FullWideView(true);
                return;
            }
            case 4: {
                a2.mView = new SearchSummaryView();
                ((SearchSummaryView)a2.mView).setPaintTags(false);
                return;
            }
            case 9: {
                a2.mView = new SearchSummaryView();
                SearchSummaryView a5 = (SearchSummaryView)a2.mView;
                a5.setPaintTags(false);
                a5.setPaintProgress(false);
                return;
            }
            case 11: {
                a3 = ResourceBundle.getBundle(RESOURCES);
                a4 = FONT_RESOURCE_TAGS[a2.getRelSize()];
                a2.setPrimaryFont((Font)a3.getObject("ContentItemView.primary_font_collection." + a4));
                a2.setTertiaryFont((Font)a3.getObject("ContentItemView.tertiary_font_collection." + a4));
                a2.mView = new SearchSummaryView();
                return;
            }
            case 1: {
                a2.mView = new FullNarrowView();
                return;
            }
            case 0: {
                a2.mView = new FullImageView();
                return;
            }
            case 6: {
                a2.mView = new FullWideView();
                FullWideView a6 = (FullWideView)a2.mView;
                a6.setPaintProgress(false);
                return;
            }
            case 7: {
                a2.mView = new ImageTextView(1);
                return;
            }
            case 8: {
                a2.mView = new FullWideView();
                ((FullWideView)a2.mView).setPaintProgress(false);
                return;
            }
            case 13: {
                a2.mView = new FullWideView(true);
                ((FullWideView)a2.mView).setPaintProgress(false);
                return;
            }
        }
    }

    public Dimension getPreferredSize() {
        ContentItemView a;
        return a.mView.getPreferredSize(a);
    }

    public boolean isProgressPainted() {
        ContentItemView a;
        return a.paintProgress;
    }

    public void setProgressPainted(boolean a) {
        ContentItemView a2;
        if (a2.paintProgress != a) {
            boolean a3 = a2.paintProgress;
            a2.paintProgress = a;
            a2.firePropertyChange("paintProgress", a3, a);
        }
    }

    public int getMaxPrimaryWidth() {
        ContentItemView a;
        return a.mMaxPrimaryWidth;
    }

    public void setMaxPrimaryWidth(int a) {
        ContentItemView a2;
        if (a < 0) {
            throw new IllegalArgumentException("width");
        }
        int a3 = a2.mMaxPrimaryWidth;
        a2.mMaxPrimaryWidth = a;
        a2.firePropertyChange("maxPrimaryWidth", a3, a);
    }

    public int getPrimarySecondaryGap() {
        ContentItemView a;
        return a.mPrimSecGap;
    }

    public void setPrimarySecondaryGap(int a) {
        ContentItemView a2;
        if (a < 0) {
            throw new IllegalArgumentException("gap");
        }
        int a3 = a2.mPrimSecGap;
        a2.mPrimSecGap = a;
        a2.firePropertyChange("primarySecondaryGap", a3, a);
    }

    public int getPrimarySecondaryMargin() {
        ContentItemView a;
        return a.mPrimSecMargin;
    }

    public void setPrimarySecondaryMargin(int a) {
        ContentItemView a2;
        if (a < 0) {
            throw new IllegalArgumentException("margin");
        }
        int a3 = a2.mPrimSecMargin;
        a2.mPrimSecMargin = a;
        a2.firePropertyChange("primarySecondaryMargin", a3, a);
    }

    public int getPrimaryTertiaryMargin() {
        ContentItemView a;
        return a.mPrimTerMargin;
    }

    public void setPrimaryTertiaryMargin(int a) {
        ContentItemView a2;
        if (a < 0) {
            throw new IllegalArgumentException("margin");
        }
        int a3 = a2.mPrimTerMargin;
        a2.mPrimTerMargin = a;
        a2.firePropertyChange("primaryTertiaryMargin", a3, a);
    }

    public int getProgressBarGap() {
        ContentItemView a;
        return a.mProgGap;
    }

    public void setProgressBarGap(int a) {
        ContentItemView a2;
        if (a < 0) {
            throw new IllegalArgumentException("gap");
        }
        int a3 = a2.mProgGap;
        a2.mProgGap = a;
        a2.firePropertyChange("progressBarGap", a3, a);
    }

    public int getProgressBarTertiaryGap() {
        ContentItemView a;
        return a.mProgTerGap;
    }

    public void setProgressBarTertiaryGap(int a) {
        ContentItemView a2;
        if (a < 0) {
            throw new IllegalArgumentException("gap");
        }
        int a3 = a2.mProgTerGap;
        a2.mProgTerGap = a;
        a2.firePropertyChange("progressBarTertiaryGap", a3, a);
    }

    public int getTagIconGap() {
        ContentItemView a;
        return a.mTagIconGap;
    }

    public void setTagIconGap(int a) {
        ContentItemView a2;
        if (a < 0) {
            throw new IllegalArgumentException("gap");
        }
        int a3 = a2.mTagIconGap;
        a2.mTagIconGap = a;
        a2.firePropertyChange("tagIconGap", a3, a);
    }

    public int getIconPrimaryGap() {
        ContentItemView a;
        return a.mIconPrimGap;
    }

    public void setIconPrimaryGap(int a) {
        ContentItemView a2;
        if (a < 0) {
            throw new IllegalArgumentException("gap");
        }
        int a3 = a2.mIconPrimGap;
        a2.mIconPrimGap = a;
        a2.firePropertyChange("iconPrimaryGap", a3, a);
    }

    public int getIconGap() {
        ContentItemView a;
        return a.mIconGap;
    }

    public void setIconGap(int a) {
        ContentItemView a2;
        if (a < 0) {
            throw new IllegalArgumentException("gap");
        }
        int a3 = a2.mIconGap;
        a2.mIconGap = a;
        a2.firePropertyChange("iconGap", a3, a);
    }

    public int getTagGap() {
        ContentItemView a;
        return a.mTagGap;
    }

    public void setTagGap(int a) {
        ContentItemView a2;
        if (a < 0) {
            throw new IllegalArgumentException("gap");
        }
        int a3 = a2.mTagGap;
        a2.mTagGap = a;
        a2.firePropertyChange("tagGap", a3, a2.mTagGap);
    }

    public int getTagVerticalGap() {
        ContentItemView a;
        return a.mTagVerticalGap;
    }

    public void setTagVerticalGap(int a) {
        ContentItemView a2;
        if (a < 0) {
            throw new IllegalArgumentException("gap");
        }
        int a3 = a2.mTagVerticalGap;
        a2.mTagVerticalGap = a;
        a2.firePropertyChange("tagVerticalGap", a3, a2.mTagVerticalGap);
    }

    public int getTertiaryPrimaryGap() {
        ContentItemView a;
        return a.mTerPrimGap;
    }

    public void setTertiaryPrimaryGap(int a) {
        ContentItemView a2;
        if (a < 0) {
            throw new IllegalArgumentException("gap");
        }
        int a3 = a2.mTerPrimGap;
        a2.mTerPrimGap = a;
        a2.firePropertyChange("tertiaryPrimaryGap", a3, a);
    }

    public int getMaxTertiaryWidth() {
        ContentItemView a;
        return a.mMaxTertiaryWidth;
    }

    public void setMaxTertiaryWidth(int a) {
        ContentItemView a2;
        if (a < 0) {
            throw new IllegalArgumentException("width");
        }
        int a3 = a2.mMaxTertiaryWidth;
        a2.mMaxTertiaryWidth = a;
        a2.firePropertyChange("maxTertiaryWidth", a3, a);
    }

    public Font getPrimaryFont() {
        ContentItemView a;
        return a.mPrimaryFont;
    }

    public void setPrimaryFont(Font a) {
        ContentItemView a2;
        if (a == null) {
            throw new NullPointerException("primaryFont");
        }
        Font a3 = a2.mPrimaryFont;
        a2.mPrimaryFont = a;
        a2.mFMPrimaryFont = Toolkit.getDefaultToolkit().getFontMetrics(a2.mPrimaryFont);
        a2.firePropertyChange("primaryFont", a3, a);
    }

    public Font getSecondaryFont() {
        ContentItemView a;
        return a.mSecondaryFont;
    }

    public void setSecondaryFont(Font a) {
        ContentItemView a2;
        if (a == null) {
            throw new NullPointerException("secondaryFont");
        }
        Font a3 = a2.mSecondaryFont;
        a2.mSecondaryFont = a;
        a2.mFMSecondaryFont = Toolkit.getDefaultToolkit().getFontMetrics(a2.mSecondaryFont);
        a2.firePropertyChange("secondaryFont", a3, a);
    }

    public Font getTertiaryFont() {
        ContentItemView a;
        return a.mTertiaryFont;
    }

    public void setTertiaryFont(Font a) {
        ContentItemView a2;
        if (a == null) {
            throw new NullPointerException("tertiaryFont");
        }
        Font a3 = a2.mTertiaryFont;
        a2.mTertiaryFont = a;
        a2.mFMTertiaryFont = Toolkit.getDefaultToolkit().getFontMetrics(a2.mTertiaryFont);
        a2.firePropertyChange("tertiaryFont", a3, a);
    }

    public Font getTagFont() {
        ContentItemView a;
        return a.mTagFont;
    }

    public void setTagFont(Font a) {
        ContentItemView a2;
        if (a == null) {
            throw new NullPointerException("tagFont");
        }
        Font a3 = a2.mTagFont;
        a2.mTagFont = a;
        a2.mFMTagFont = Toolkit.getDefaultToolkit().getFontMetrics(a2.mTagFont);
        a2.firePropertyChange("tagFont", a3, a);
    }

    public Font getTagCoverivewFont() {
        ContentItemView a;
        return a.mTagCoverviewFont;
    }

    public void setTagCoverviewFont(Font a) {
        ContentItemView a2;
        if (a == null) {
            throw new NullPointerException("tagCoverviewFont");
        }
        Font a3 = a2.mTagCoverviewFont;
        a2.mTagCoverviewFont = a;
        a2.mFMCoverviewTagFont = Toolkit.getDefaultToolkit().getFontMetrics(a2.mTagCoverviewFont);
        a2.firePropertyChange("tagCoverviewFont", a3, a);
    }

    public boolean isSelected() {
        ContentItemView a;
        ButtonStateModel a2 = a.getButtonStateModel();
        return a2 != null && a2.isSelected();
    }

    public void setSelected(boolean a) {
        ContentItemView a2;
        ButtonStateModel a3 = a2.getButtonStateModel();
        if (a3 != null) {
            a3.setSelected(a);
        }
    }

    public void setEnabled(boolean a) {
        ContentItemView a2;
        super.setEnabled(a);
        ButtonStateModel a3 = a2.getButtonStateModel();
        if (a3 != null) {
            a3.setEnabled(a);
        }
    }

    private boolean isPressedAndArmed() {
        ContentItemView a;
        ButtonStateModel a2 = a.getButtonStateModel();
        return a2 != null && a2.isPressed() && a2.isArmed();
    }

    public void doHighlightImmediately(boolean a) {
        Object a2;
        ContentItemView a3;
        a3.enableXOR(a, true);
        if (a3.isShowing() && (a2 = a3.getGraphics()) != null) {
            a3.paintComponent((Graphics)a2);
            Toolkit.getDefaultToolkit().sync();
            ((Graphics)a2).dispose();
        }
        if (a) {
            a2 = a3.new DisarmAction(a3.getButtonStateModel());
            a3.disarmTimer = new Timer(DISARM_DELAY, (ActionListener)a2);
            a3.disarmTimer.setRepeats(false);
            a3.disarmTimer.start();
        } else if (a3.disarmTimer != null) {
            a3.disarmTimer.stop();
            a3.disarmTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics a) {
        ContentItemView a2;
        long a3 = System.currentTimeMillis();
        ButtonStateModel a4 = a2.getButtonStateModel();
        boolean a5 = a4 != null && a4.isPressed() && a4.isArmed();
        boolean a6 = a4 != null && a4.isSelected();
        boolean a7 = a5 || a6 || a2.isXorForced;
        boolean a8 = a2.showXOR && a7;
        try {
            ((Graphics2D)a).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, a8 ? RenderingHints.VALUE_TEXT_ANTIALIAS_OFF : RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            a2.mProgress.setForeground(a8 ? a2.getBackground() : a2.getForeground());
            a2.mProgress.setVisible(!a8);
            Dimension a9 = a2.getSize();
            if (a2.isOpaque()) {
                if (a8) {
                    a.setColor(a2.getForeground());
                } else {
                    a.setColor(a2.isEnabled() ? a2.getBackground() : a2.mDisabledBackgroundColor);
                }
                a.fillRect(0, 0, a9.width, a9.height);
            }
            if (a8) {
                a.setColor(a2.getBackground());
            } else {
                a.setColor(a2.isEnabled() ? a2.getForeground() : a2.mDisabledForegroundColor);
            }
            a2.mView.paint(a, a2);
        }
        catch (Exception a10) {
            try {
                LOG.error(Log.CATCHALL_EX, null, "Error during paint", (Throwable)a10);
            }
            catch (Throwable throwable) {
                if (Log.isDebugOn()) {
                    LOG.debug(PAINT_TIME, new String[]{Long.toString(System.currentTimeMillis() - a3), a8 ? "OFF" : "ON"}, null);
                }
                throw throwable;
            }
            if (Log.isDebugOn()) {
                LOG.debug(PAINT_TIME, new String[]{Long.toString(System.currentTimeMillis() - a3), a8 ? "OFF" : "ON"}, null);
            }
        }
        if (Log.isDebugOn()) {
            LOG.debug(PAINT_TIME, new String[]{Long.toString(System.currentTimeMillis() - a3), a8 ? "OFF" : "ON"}, null);
        }
    }

    protected Icon getImage() {
        ContentItemView a;
        return a.mModel.getImage();
    }

    protected String getSecondaryText() {
        ContentItemView a;
        return a.mModel.getDisplayText(1, 1);
    }

    private JProgressBar getProgressBar() {
        ContentItemView a;
        return a.mProgress;
    }

    private int getScreenWidthDivisorSmall() {
        ContentItemView a;
        return a.mScreenWidthDivisorSmall;
    }

    private int getScreenWidthDivisorLarge() {
        ContentItemView a;
        return a.mScreenWidthDivisorLarge;
    }

    private class DisarmAction
    implements ActionListener {
        private ButtonStateModel model;

        DisarmAction(ButtonStateModel a) {
            DisarmAction a2;
            a2.model = a;
        }

        public void actionPerformed(ActionEvent a) {
            DisarmAction a2;
            if (a2.model != null) {
                a2.model.setPressed(false);
                a2.model.setArmed(false);
                SwingUtilities.invokeLater(new Runnable(){
                    {
                        1 a;
                    }

                    public void run() {
                        1 a;
                        ContentItemView.this.doHighlightImmediately(false);
                    }
                });
            }
        }
    }

    private class StateChangeListener
    implements ChangeListener {
        private StateChangeListener() {
            StateChangeListener a;
        }

        public void stateChanged(ChangeEvent a) {
            StateChangeListener a2;
            ButtonStateModel a3 = (ButtonStateModel)a.getSource();
            if (ContentItemView.super.isEnabled() != a3.isEnabled()) {
                ContentItemView.super.setEnabled(a3.isEnabled());
            }
            a2.ContentItemView.this.repaint();
        }
    }

    private static class FullImageView
    extends AbstractView {
        private FullImageView() {
            FullImageView a;
        }

        public Dimension getPreferredSize(JComponent a) {
            int a2;
            FullImageView a3;
            ContentItemView a4 = (ContentItemView)a;
            ContentItemModel a5 = a4.getDataModel();
            Dimension a6 = super.getPreferredSize(a);
            Icon a7 = a4.getImage();
            if (a7 != null) {
                a6.width += a7.getIconWidth() + a4.getIconGap();
                a6.height += a7.getIconHeight();
            }
            Toolkit a8 = Toolkit.getDefaultToolkit();
            int a9 = 0;
            List a10 = a5.getLocalizedTags();
            if (a10 != null && a10.size() > 0) {
                a9 = a4.mFMTagFont.getHeight();
            }
            int a11 = 0;
            String a12 = a5.getDisplayText(0, 0);
            if (a12 != null && a12.length() > 0) {
                a11 = a4.mFMPrimaryFont.getHeight() + a4.getTagGap();
            }
            int a13 = 0;
            String a14 = a4.getSecondaryText();
            if (a14 != null && a14.length() > 0) {
                a13 = a4.mFMSecondaryFont.getHeight() + a4.getPrimarySecondaryGap();
            }
            int a15 = 0;
            if (a4.isProgressPainted() && a5.getProgress() >= 0.0f) {
                a15 = ((ContentItemView)a4).getProgressBar().getPreferredSize().height + a4.getProgressBarGap();
            }
            int a16 = 0;
            String a17 = a5.getDisplayText(2, 0);
            if (a17 != null && a17.length() > 0) {
                a16 = a4.mFMPrimaryFont.getHeight() + a4.getProgressBarTertiaryGap();
            }
            int a18 = a9 + a11 + a13 + a16 + a15;
            if (a7 != null) {
                a2 = a7.getIconHeight();
                if (a2 < a18) {
                    a6.height += a18 - a2;
                }
            } else {
                a6.height += a18;
            }
            a2 = Toolkit.getDefaultToolkit().getScreenSize().width;
            a6.width += a2 / a4.getScreenWidthDivisorLarge();
            return a6;
        }

        public void paint(Graphics a, JComponent a2) {
            FullImageView a3;
            ContentItemView a4 = (ContentItemView)a2;
            ContentItemModel a5 = a4.getDataModel();
            AbstractView.BoundedText a6 = new AbstractView.BoundedText();
            new AbstractView.BoundedText().text = a5.getDisplayText(0, 0);
            AbstractView.BoundedText a7 = new AbstractView.BoundedText();
            new AbstractView.BoundedText().text = a4.getSecondaryText();
            AbstractView.BoundedText a8 = new AbstractView.BoundedText();
            new AbstractView.BoundedText().text = a5.getDisplayText(2, 0);
            List a9 = a5.getLocalizedTags();
            AbstractView.BoundedText a10 = new AbstractView.BoundedText();
            int a11 = a5.getRelativeLength();
            AbstractView.Bounds a12 = new AbstractView.Bounds();
            AbstractView.BoundedIcon a13 = new AbstractView.BoundedIcon();
            Icon a14 = a4.getImage();
            if (a4.showXOR && a4.isPressedAndArmed() && !a4.isSelected() && a14 != null && a14 instanceof ImageIcon) {
                a14 = new ImageIcon(BlackWhiteFilter.createBlackWhiteImage(((ImageIcon)a14).getImage(), a4.mFilterThreshold));
            }
            a13.icon = a14;
            a3.calculateRectangles(a, a2, a6, a7, a8, a9, a10, a11, a12, a13);
            if (a14 != null) {
                a14.paintIcon(a2, a, a13.x, a13.y);
            }
            a3.paintTags(a, a2, a9, a10);
            if (a6.text != null && a6.text.length() > 0) {
                a.setFont(a4.getPrimaryFont());
                a.drawString(a6.text, a6.x, a6.y + a4.mFMPrimaryFont.getAscent());
            }
            if (a8.text != null && a8.text.length() > 0) {
                a.setFont(a4.getPrimaryFont());
                String a15 = a4.mFMPrimaryFont.stringWidth(a8.text) > a8.width ? StringUtil.shortenText((FontMetrics)a4.mFMPrimaryFont, (String)a8.text, (int)a8.width) : a8.text;
                a.drawString(a15, a8.x, a8.y + a4.mFMPrimaryFont.getAscent());
            }
            if (a7.text != null && a7.text.length() > 0) {
                a.setFont(a4.getSecondaryFont());
                a.drawString(a7.text, a7.x, a7.y + a4.mFMSecondaryFont.getAscent());
            }
            if (a4.mProgress.isVisible()) {
                a3.paintProgress(a, a2, a12);
            }
        }

        private void calculateRectangles(Graphics a, JComponent a2, AbstractView.BoundedText a3, AbstractView.BoundedText a4, AbstractView.BoundedText a5, List a6, AbstractView.BoundedText a7, int a8, AbstractView.Bounds a9, AbstractView.BoundedIcon a10) {
            int a11;
            FullImageView a12;
            ContentItemView a13 = (ContentItemView)a2;
            a8 = Math.max(0, Math.min(2000000, a8));
            Rectangle a14 = a12.getBareBoundsRectangle(a2);
            if (a10 != null) {
                a10.x = a14.x;
                a10.y = a14.y;
                a10.height = a10.icon.getIconHeight();
                a10.width = a10.icon.getIconWidth();
            }
            int a15 = a10.width + a13.getIconGap();
            a14.x += a15;
            a14.width -= a15;
            if (a6 != null && a6.size() > 0) {
                a7.x = a14.x;
                a7.y = a14.y;
                a7.width = a14.width;
                a7.height = a13.mFMTagFont.getHeight();
                a15 = a7.height + a13.getTagGap();
                a14.y += a15;
                a14.height -= a15;
            }
            int a16 = 0;
            if (a3.text != null && a3.text.length() > 0) {
                a3.x = a14.x;
                a3.y = a14.y;
                a3.width = a14.width;
                a3.height = a13.mFMPrimaryFont.getHeight();
                a16 = a13.mFMPrimaryFont.stringWidth(a3.text);
            }
            int a17 = Math.min(a14.width, a16);
            int a18 = a3.height;
            a14.y += a3.height;
            a14.height -= a3.height;
            a18 = 0;
            if (a4.text != null && a4.text.length() > 0) {
                a11 = a13.getPrimarySecondaryGap();
                a14.y += a11;
                a14.height -= a11;
                a4.x = a14.x;
                a4.y = a14.y;
                a4.width = a14.width;
                a18 = a4.height = a13.mFMSecondaryFont.getHeight();
            }
            a14.y += a18;
            a14.height -= a18;
            if (a13.isProgressPainted() && a13.getDataModel().getProgress() >= 0.0f) {
                a11 = a13.getProgressBarGap();
                a14.y += a11;
                a14.height -= a11;
                a9.x = a14.x;
                a9.y = a14.y;
                a9.width = KindleSwingUtilities.getProgessBarLength(a8, a17);
                a9.height = ((ContentItemView)a13).getProgressBar().getPreferredSize().height;
            }
            if (a5.text != null && a5.text.length() > 0) {
                a5.width = a13.mFMPrimaryFont.stringWidth(a5.text);
                a5.height = a3.height;
                a5.x = a14.x;
                a5.y = a14.y + a9.height + a13.getProgressBarTertiaryGap();
            }
        }
    }

    private static class FullNarrowView
    extends AbstractView {
        private FullNarrowView() {
            FullNarrowView a;
        }

        public Dimension getPreferredSize(JComponent a) {
            FullNarrowView a2;
            ContentItemView a3 = (ContentItemView)a;
            ContentItemModel a4 = a3.getDataModel();
            Dimension a5 = super.getPreferredSize(a);
            Toolkit a6 = Toolkit.getDefaultToolkit();
            int a7 = 0;
            List a8 = null;
            if (null != null && a8.size() > 0) {
                a7 = a3.mFMTagFont.getHeight();
            }
            int a9 = 0;
            String a10 = a4.getDisplayText(0, 0);
            if (a10 != null && a10.length() > 0) {
                a9 = a3.mFMPrimaryFont.getHeight() + a3.getTagGap();
            }
            int a11 = 0;
            String a12 = a3.getSecondaryText();
            if (a12 != null && a12.length() > 0) {
                a11 = a3.mFMSecondaryFont.getHeight() + a3.getPrimarySecondaryGap();
            }
            int a13 = 0;
            if (a3.isProgressPainted() && a4.getProgress() >= 0.0f) {
                a13 = ((ContentItemView)a3).getProgressBar().getPreferredSize().height + a3.getProgressBarGap();
            }
            a5.height += a7 + a9 + a11 + a13;
            int a14 = Toolkit.getDefaultToolkit().getScreenSize().width;
            a5.width += a14 / a3.getScreenWidthDivisorSmall();
            return a5;
        }

        public void paint(Graphics a, JComponent a2) {
            FullNarrowView a3;
            ContentItemView a4 = (ContentItemView)a2;
            ContentItemModel a5 = a4.getDataModel();
            AbstractView.BoundedText a6 = new AbstractView.BoundedText();
            new AbstractView.BoundedText().text = a5.getDisplayText(0, 0);
            AbstractView.BoundedText a7 = new AbstractView.BoundedText();
            new AbstractView.BoundedText().text = a4.getSecondaryText();
            List a8 = null;
            AbstractView.BoundedText a9 = new AbstractView.BoundedText();
            int a10 = a5.getRelativeLength();
            AbstractView.Bounds a11 = new AbstractView.Bounds();
            a3.calculateRectangles(a, a2, a6, a7, a8, a9, a10, a11);
            a3.paintTags(a, a2, a8, a9);
            a3.paintPrimary(a, a2, a6);
            if (a7.text != null && a7.text.length() > 0) {
                a.setFont(a4.getSecondaryFont());
                a.drawString(a7.text, a7.x, a7.y + a4.mFMSecondaryFont.getAscent());
            }
            if (a4.mProgress.isVisible()) {
                a3.paintProgress(a, a2, a11);
            }
        }

        private void calculateRectangles(Graphics a, JComponent a2, AbstractView.BoundedText a3, AbstractView.BoundedText a4, List a5, AbstractView.BoundedText a6, int a7, AbstractView.Bounds a8) {
            int a9;
            int a10;
            FullNarrowView a11;
            ContentItemView a12 = (ContentItemView)a2;
            ContentItemModel a13 = a12.getDataModel();
            a7 = Math.max(0, Math.min(2000000, a7));
            Rectangle a14 = a11.getBareBoundsRectangle(a2);
            if (a5 != null && a5.size() > 0) {
                a6.x = a14.x;
                a6.y = a14.y;
                a6.width = a14.width;
                a6.height = a12.mFMTagFont.getHeight();
                a10 = a6.height + a12.getTagGap();
                a14.y += a10;
                a14.height -= a10;
            }
            a10 = 0;
            if (a3.text != null && a3.text.length() > 0) {
                a3.x = a14.x;
                a3.y = a14.y;
                a3.width = a14.width;
                a3.height = a12.mFMPrimaryFont.getHeight();
                a10 = a12.mFMPrimaryFont.stringWidth(a3.text);
            }
            int a15 = Math.min(a14.width, a10);
            a14.y += a3.height;
            a14.height -= a3.height;
            int a16 = 0;
            if (a4.text != null && a4.text.length() > 0) {
                a9 = a12.getPrimarySecondaryGap();
                a14.y += a9;
                a14.height -= a9;
                a4.x = a14.x;
                a4.y = a14.y;
                a4.width = a14.width;
                a16 = a4.height = a12.mFMSecondaryFont.getHeight();
            }
            a14.y += a16;
            a14.height -= a16;
            if (a12.isProgressPainted() && a13.getProgress() >= 0.0f) {
                a9 = a12.getProgressBarGap();
                a14.y += a9;
                a14.height -= a9;
                a8.x = a14.x;
                a8.y = a14.y;
                a8.width = KindleSwingUtilities.getProgessBarLength(a7, a15);
                a8.height = ((ContentItemView)a12).getProgressBar().getPreferredSize().height;
            }
        }
    }

    private static class SearchSummaryView
    extends AbstractView {
        private boolean paintTags = true;
        private boolean paintProgress = true;

        private SearchSummaryView() {
            SearchSummaryView a;
        }

        public void setPaintTags(boolean a) {
            a.paintTags = a;
        }

        public void setPaintProgress(boolean a) {
            a.paintProgress = a;
        }

        public Dimension getPreferredSize(JComponent a) {
            SearchSummaryView a2;
            ContentItemView a3 = (ContentItemView)a;
            ContentItemModel a4 = a3.getDataModel();
            Dimension a5 = super.getPreferredSize(a);
            Toolkit a6 = Toolkit.getDefaultToolkit();
            int a7 = 0;
            List a8 = a4.getLocalizedTags();
            if (a2.paintTags && a8 != null && a8.size() > 0) {
                a7 = a3.mFMTagFont.getHeight();
            }
            int a9 = 0;
            String a10 = a4.getDisplayText(0, 0);
            if (a10 != null && a10.length() > 0) {
                a9 = a3.mFMPrimaryFont.getHeight() + a3.getTagGap();
            }
            int a11 = 0;
            String a12 = a3.getSecondaryText();
            if (a12 != null && a12.length() > 0) {
                a11 = a3.mFMSecondaryFont.getHeight() + a3.getPrimarySecondaryGap();
            }
            int a13 = 0;
            if (a2.paintProgress && a3.isProgressPainted() && a4.getProgress() >= 0.0f) {
                a13 = ((ContentItemView)a3).getProgressBar().getPreferredSize().height + a3.getProgressBarGap();
            }
            int a14 = 0;
            String a15 = a4.getDisplayText(2, 0);
            if (a15 != null && a15.length() > 0) {
                a14 = a3.mFMPrimaryFont.getHeight() + a3.getProgressBarTertiaryGap();
            }
            a5.height += a7 + a9 + a13;
            int a16 = Toolkit.getDefaultToolkit().getScreenSize().width;
            a5.width += a16 / a3.getScreenWidthDivisorSmall();
            a5.width += a3.getMaxTertiaryWidth() + a3.getTertiaryPrimaryGap();
            return a5;
        }

        public void paint(Graphics a, JComponent a2) {
            SearchSummaryView a3;
            ContentItemView a4 = (ContentItemView)a2;
            ContentItemModel a5 = a4.getDataModel();
            AbstractView.BoundedText a6 = new AbstractView.BoundedText();
            new AbstractView.BoundedText().text = a5.getDisplayText(0, 0);
            AbstractView.BoundedText a7 = new AbstractView.BoundedText();
            new AbstractView.BoundedText().text = a4.getSecondaryText();
            AbstractView.BoundedText a8 = new AbstractView.BoundedText();
            new AbstractView.BoundedText().text = a5.getDisplayText(2, 0);
            List a9 = a5.getLocalizedTags();
            AbstractView.BoundedText a10 = new AbstractView.BoundedText();
            int a11 = a5.getRelativeLength();
            AbstractView.Bounds a12 = new AbstractView.Bounds();
            a3.calculateRectangles(a, a2, a6, a7, a8, a9, a10, a11, a12);
            if (a3.paintTags) {
                a3.paintTags(a, a2, a9, a10);
            }
            a3.paintPrimary(a, a2, a6);
            a3.paintTertiary(a, a2, a8);
            a3.paintSecondary(a, a2, a7);
            if (a3.paintProgress && a4.mProgress.isVisible()) {
                a3.paintProgress(a, a2, a12);
            }
        }

        private void calculateRectangles(Graphics a, JComponent a2, AbstractView.BoundedText a3, AbstractView.BoundedText a4, AbstractView.BoundedText a5, List a6, AbstractView.BoundedText a7, int a8, AbstractView.Bounds a9) {
            int a10;
            SearchSummaryView a11;
            ContentItemView a12 = (ContentItemView)a2;
            ContentItemModel a13 = a12.getDataModel();
            a8 = Math.max(0, Math.min(2000000, a8));
            Rectangle a14 = a11.getBareBoundsRectangle(a2);
            if (a11.paintTags && a6 != null && a6.size() > 0) {
                a7.x = a14.x;
                a7.y = a14.y;
                a7.width = a14.width;
                a7.height = a12.mFMTagFont.getHeight();
                int a15 = a7.height + a12.getTagGap();
                a14.y += a15;
                a14.height -= a15;
            }
            int a16 = 0;
            if (a3.text != null && a3.text.length() > 0) {
                a3.x = a14.x;
                a3.y = a14.y;
                a3.width = a14.width;
                a3.height = a12.mFMPrimaryFont.getHeight();
                a16 = a12.mFMPrimaryFont.stringWidth(a3.text);
            }
            int a17 = Math.min(a14.width, a16);
            int a18 = a3.height;
            int a19 = a12.mFMPrimaryFont.getAscent();
            int a20 = a14.width - a12.getMaxTertiaryWidth() - a12.getTertiaryPrimaryGap();
            if (a20 > 0) {
                if (a4.text != null && a4.text.length() > 0) {
                    a4.height = a12.mFMSecondaryFont.getHeight();
                    a10 = a12.mFMSecondaryFont.stringWidth(a4.text);
                    if (a3.text != null && a3.text.length() > 0) {
                        int a21 = a12.mFMSecondaryFont.getAscent();
                        int a22 = a12.getPrimarySecondaryMargin();
                        if (a16 + a22 + a10 > a20) {
                            String a23 = a4.text;
                            int a24 = Math.min(a20 - a22, a12.mMaxSecondaryWidth);
                            a4.text = StringUtil.shortenText((FontMetrics)a12.mFMSecondaryFont, (String)a23, (int)a24);
                            a10 = a12.mFMSecondaryFont.stringWidth(a4.text);
                            a24 = a20 - a22 - a10;
                            a3.text = StringUtil.shortenText((FontMetrics)a12.mFMPrimaryFont, (String)a3.text, (int)a24);
                            a16 = a12.mFMPrimaryFont.stringWidth(a3.text);
                            if (a16 + a22 + a10 < a20) {
                                a24 = a20 - a16 - a22;
                                a4.text = StringUtil.shortenText((FontMetrics)a12.mFMSecondaryFont, (String)a23, (int)a24);
                                a10 = a12.mFMSecondaryFont.stringWidth(a4.text);
                            }
                        }
                        a3.width = a16;
                        a4.width = a10;
                        a4.height = a3.height;
                        a4.x = a14.x + a20 - a10;
                        a4.y = a14.y + a19 - a21;
                    } else {
                        if (a10 > a20) {
                            a4.text = StringUtil.shortenText((FontMetrics)a12.mFMSecondaryFont, (String)a4.text, (int)a20);
                            a10 = a12.mFMSecondaryFont.stringWidth(a4.text);
                        }
                        a4.x = a14.x + a20 - a10;
                        a4.y = a14.y;
                        a4.width = a10;
                        a18 = a4.height;
                    }
                } else {
                    a3.width = Math.min(a16, a20);
                }
            }
            if (a5.text != null && a5.text.length() > 0) {
                a20 = a12.getMaxTertiaryWidth();
                a10 = a12.mFMTertiaryFont.stringWidth(a5.text);
                if (a10 > a20) {
                    a10 = a20;
                }
                a5.x = a20 - a10;
                a5.y = a3.y + a19 - a12.mFMTertiaryFont.getAscent();
                a5.width = a10;
                a5.height = a12.mFMTertiaryFont.getHeight();
            }
            a14.y += a18;
            a14.height -= a18;
            if (a11.paintProgress && a12.isProgressPainted() && a13.getProgress() >= 0.0f) {
                a10 = a12.getProgressBarGap();
                a14.y += a10;
                a14.height -= a10;
                a9.x = a14.x;
                a9.y = a14.y;
                a9.width = KindleSwingUtilities.getProgessBarLength(a8, a14.width - a12.getMaxTertiaryWidth() - a12.getTertiaryPrimaryGap());
                a9.height = ((ContentItemView)a12).getProgressBar().getPreferredSize().height;
            }
            a10 = a12.getMaxTertiaryWidth() + a12.getTertiaryPrimaryGap();
            a7.x += a10;
            a3.x += a10;
            a4.x += a10;
            a9.x += a10;
        }
    }

    private static class FullWideView
    extends AbstractView {
        private boolean concatenatePrimaryAndTertiary;
        private boolean paintTags = true;
        private boolean paintProgress = true;
        private boolean paintCheckbox = false;
        private int maxTagLines;

        public FullWideView() {
            a(false);
            FullWideView a;
        }

        public FullWideView(boolean a) {
            FullWideView a2;
            ResourceBundle a3 = ResourceBundle.getBundle(ContentItemView.RESOURCES);
            a2.maxTagLines = (Integer)a3.getObject("ContentItemView.max_tag_lines");
            a2.paintCheckbox = a;
        }

        public void setConcatenatePrimaryAndTertiary(boolean a) {
            a.concatenatePrimaryAndTertiary = a;
        }

        public void setPaintTags(boolean a) {
            a.paintTags = a;
        }

        public void setPaintProgress(boolean a) {
            a.paintProgress = a;
        }

        public Dimension getPreferredSize(JComponent a) {
            int a2;
            FullWideView a3;
            ContentItemView a4 = (ContentItemView)a;
            ContentItemModel a5 = a4.getDataModel();
            Dimension a6 = super.getPreferredSize(a);
            Toolkit a7 = Toolkit.getDefaultToolkit();
            int a8 = 0;
            String a9 = a5.getDisplayText(0, 0);
            if (a9 != null && a9.length() > 0) {
                a8 = a4.mFMPrimaryFont.getHeight();
            }
            int a10 = a8;
            String a11 = a5.getDisplayText(2, 0);
            if (a11 != null && a11.length() > 0) {
                a10 = Math.max(a8, a4.mFMTertiaryFont.getHeight());
            } else {
                String a12 = a4.getSecondaryText();
                if (a12 != null && a12.length() > 0) {
                    a10 = Math.max(a8, a4.mFMSecondaryFont.getHeight());
                }
            }
            int a13 = 0;
            if (a3.paintProgress && a4.isProgressPainted() && a5.getProgress() >= 0.0f) {
                a13 = ((ContentItemView)a4).getProgressBar().getPreferredSize().height + a4.getProgressBarGap();
            }
            int a14 = a10 + a13;
            a6.height += a14;
            List a15 = a5.getLocalizedTags();
            if (a3.paintTags && a15 != null && a15.size() > 0 && (a2 = a4.mFMTagFont.getHeight() * Math.min(a15.size(), a3.maxTagLines)) > a14) {
                a6.height += a2 - a14;
            }
            a2 = Toolkit.getDefaultToolkit().getScreenSize().width;
            a6.width += a2 / a4.getScreenWidthDivisorSmall();
            return a6;
        }

        public void paint(Graphics a, JComponent a2) {
            int a3;
            FullWideView a4;
            ContentItemView a5 = (ContentItemView)a2;
            ContentItemModel a6 = a5.getDataModel();
            AbstractView.BoundedText a7 = new AbstractView.BoundedText();
            new AbstractView.BoundedText().text = a6.getDisplayText(0, 0);
            AbstractView.BoundedText a8 = new AbstractView.BoundedText();
            new AbstractView.BoundedText().text = a5.getSecondaryText();
            AbstractView.BoundedText a9 = new AbstractView.BoundedText();
            new AbstractView.BoundedText().text = a6.getDisplayText(2, 0);
            List a10 = a6.getLocalizedTags();
            AbstractView.BoundedText a11 = new AbstractView.BoundedText();
            AbstractView.BoundedText[] a12 = new AbstractView.BoundedText[a4.maxTagLines];
            int n = a3 = 0;
            while (n < a12.length) {
                a12[a3] = new AbstractView.BoundedText();
                n = ++a3;
            }
            a3 = a6.getRelativeLength();
            AbstractView.Bounds a13 = new AbstractView.Bounds();
            a4.calculateRectangles(a, a2, a7, a8, a9, a10, a11, a12, a3, a13);
            if (a4.paintTags && a10 != null && a10.size() > 0) {
                int a14;
                a.setFont(a5.getTagFont());
                int n2 = a14 = 0;
                AbstractView.BoundedText[] boundedTextArray = a12;
                while (n2 < boundedTextArray.length && a12[a14].text != null) {
                    a.drawString(a12[a14].text, a12[a14].x, a12[a14].y + a5.mFMTagFont.getAscent());
                    n2 = ++a14;
                    boundedTextArray = a12;
                }
            }
            if (a7.text != null && a7.text.length() > 0) {
                a.setFont(a5.getPrimaryFont());
                a.drawString(a7.text, a7.x, a7.y + a5.mFMPrimaryFont.getAscent());
            }
            if (a9.text != null && a9.text.length() > 0) {
                a.setFont(a5.getTertiaryFont());
                a.drawString(a9.text, a9.x, a9.y + a5.mFMTertiaryFont.getAscent());
            } else if (a8.text != null && a8.text.length() > 0) {
                a.setFont(a5.getSecondaryFont());
                a.drawString(a8.text, a8.x, a8.y + a5.mFMSecondaryFont.getAscent());
            }
            if (a4.paintProgress && a5.mProgress.isVisible()) {
                a4.paintProgress(a, a2, a13);
            }
            if (a4.paintCheckbox) {
                KindleIconFactory.getListViewCheckBoxIcon().paintIcon(a2, a, a4.getBareBoundsRectangle((JComponent)a2).width - a5.mCheckboxWidth, a5.mCheckboxTopgap);
            }
        }

        private void calculateRectangles(Graphics a, JComponent a2, AbstractView.BoundedText a3, AbstractView.BoundedText a4, AbstractView.BoundedText a5, List a6, AbstractView.BoundedText a7, AbstractView.BoundedText[] a8, int a9, AbstractView.Bounds a10) {
            int a11;
            int a12;
            int a13;
            int a14;
            int a15;
            int a16;
            FullWideView a17;
            ContentItemView a18 = (ContentItemView)a2;
            a9 = Math.max(0, Math.min(2000000, a9));
            Rectangle a19 = a17.getBareBoundsRectangle(a2);
            if (a17.paintTags && a6 != null && a6.size() > 0) {
                a16 = Math.min(a6.size(), a8.length);
                a7.x = a19.x;
                a7.y = a19.y;
                a15 = a18.mFMTagFont.getHeight();
                a7.height = a15 * a16;
                a7.width = a18.mMaxTagWidth;
                int n = a14 = 0;
                while (n < a16) {
                    String a20 = (String)a6.get(a14);
                    if (a14 < a16 - 1) {
                        ResourceBundle a21 = ResourceBundle.getBundle(ContentItemView.RESOURCES);
                        StringBuffer a22 = new StringBuffer(a20);
                        a20 = a22.append(a21.getString("ContentItemView.tag_separator")).toString();
                    }
                    a13 = a18.mFMTagFont.stringWidth(a20);
                    a12 = a14 == 0 ? a7.y : a8[a14 - 1].y + a15;
                    a8[a14].x = a7.x;
                    a8[a14].y = a12;
                    a8[a14].width = a18.mMaxTagWidth;
                    a8[a14].height = a15;
                    if (a13 < a18.mMaxTagWidth) {
                        a8[a14].text = a20;
                        a11 = a18.mMaxTagWidth - a13;
                        a8[a14].x += a11;
                        a8[a14].width -= a11;
                    } else if (a13 > a18.mMaxTagWidth) {
                        a20 = StringUtil.shortenText((FontMetrics)a18.mFMTagFont, (String)a20, (int)a18.mMaxTagWidth);
                        a13 = a18.mFMTagFont.stringWidth(a20);
                        a8[a14].text = a20;
                        if (a13 < a18.mMaxTagWidth) {
                            a11 = a18.mMaxTagWidth - a13;
                            a8[a14].x += a11;
                            a8[a14].width -= a11;
                        }
                    } else {
                        a8[a14].text = a20;
                    }
                    n = ++a14;
                }
            }
            if (a17.paintTags) {
                a16 = a18.mMaxTagWidth + a18.getTagVerticalGap();
                a19.x += a16;
                a19.width -= a16;
            }
            a16 = 0;
            a15 = 0;
            if (a3.text != null && a3.text.length() > 0) {
                a3.x = a19.x;
                a3.y = a19.y;
                a3.width = a19.width;
                a3.height = a18.mFMPrimaryFont.getHeight();
                a16 = a18.mFMPrimaryFont.getAscent();
                a15 = a18.mFMPrimaryFont.stringWidth(a3.text);
            }
            a14 = Math.min(a19.width, a15);
            int a23 = a3.height;
            a13 = a19.width;
            if (a17.paintCheckbox) {
                a13 -= a18.mCheckboxWidth;
                a14 -= a18.mCheckboxWidth;
            }
            if (a5.text != null && a5.text.length() > 0) {
                a5.height = a18.mFMTertiaryFont.getHeight();
                a12 = a18.mFMTertiaryFont.stringWidth(a5.text);
                if (a3.text != null && a3.text.length() > 0) {
                    int a24;
                    a11 = a18.mFMTertiaryFont.getAscent();
                    int n = a24 = a17.concatenatePrimaryAndTertiary ? a18.getPrimaryTertiaryMargin() : a18.getPrimarySecondaryMargin();
                    if (a15 + a24 + a12 > a13) {
                        StringUtil.AttributedText a25 = new StringUtil.AttributedText(a3.text, a18.mFMPrimaryFont);
                        StringUtil.AttributedText a26 = new StringUtil.AttributedText(a5.text, a18.mFMTertiaryFont);
                        StringUtil.shortenTwoTexts((StringUtil.AttributedText)a25, (StringUtil.AttributedText)a26, (int)(a13 - a24));
                        a3.text = a25.text;
                        a15 = a25.width;
                        a5.text = a26.text;
                        a12 = a26.width;
                    }
                    a3.width = a15;
                    a5.width = a12;
                    a5.x = a19.x;
                    a5.x = a5.x + (a17.concatenatePrimaryAndTertiary ? a15 + a24 : a13 - a12);
                    if (a3.height >= a5.height) {
                        a5.y = a3.y + a16 - a11;
                    } else {
                        a5.y = a19.y;
                        a3.y = a5.y + a11 - a16;
                        a23 = a5.height;
                    }
                } else {
                    if (a12 > a13) {
                        a5.text = StringUtil.shortenText((FontMetrics)a18.mFMTertiaryFont, (String)a5.text, (int)a13);
                        a12 = a18.mFMTertiaryFont.stringWidth(a5.text);
                    }
                    a5.x = a19.x + a19.width - a12;
                    a5.y = a19.y;
                    a5.width = a12;
                    a23 = a5.height;
                }
            } else if (a4.text != null && a4.text.length() > 0) {
                a4.height = a18.mFMSecondaryFont.getHeight();
                a12 = a18.mFMSecondaryFont.stringWidth(a4.text);
                if (a3.text != null && a3.text.length() > 0) {
                    a11 = a18.mFMSecondaryFont.getAscent();
                    int a27 = a18.getPrimarySecondaryMargin();
                    if (a15 + a27 + a12 > a13) {
                        String a28 = a4.text;
                        int a29 = Math.min(a13 - a27, a18.mMaxSecondaryWidth);
                        a4.text = StringUtil.shortenText((FontMetrics)a18.mFMSecondaryFont, (String)a28, (int)a29);
                        a12 = a18.mFMSecondaryFont.stringWidth(a4.text);
                        a29 = a13 - a27 - a12;
                        a3.text = StringUtil.shortenText((FontMetrics)a18.mFMPrimaryFont, (String)a3.text, (int)a29);
                        a15 = a18.mFMPrimaryFont.stringWidth(a3.text);
                        if (a15 + a27 + a12 < a13) {
                            a29 = a13 - a15 - a27;
                            a4.text = StringUtil.shortenText((FontMetrics)a18.mFMSecondaryFont, (String)a28, (int)a29);
                            a12 = a18.mFMSecondaryFont.stringWidth(a4.text);
                        }
                    }
                    a3.width = a15;
                    a4.width = a12;
                    a4.x = a19.x + a13 - a12;
                    if (a3.height >= a4.height) {
                        a4.y = a3.y + a16 - a11;
                    } else {
                        a4.y = a19.y;
                        a3.y = a4.y + a11 - a16;
                        a23 = a4.height;
                    }
                } else {
                    if (a12 > a13) {
                        a4.text = StringUtil.shortenText((FontMetrics)a18.mFMSecondaryFont, (String)a4.text, (int)a13);
                        a12 = a18.mFMSecondaryFont.stringWidth(a4.text);
                    }
                    a4.x = a19.x + a19.width - a12;
                    a4.y = a19.y;
                    a4.width = a12;
                    a23 = a4.height;
                }
            } else if (a3.text != null && a3.text.length() > 0) {
                if (a15 > a13) {
                    a3.text = StringUtil.shortenText((FontMetrics)a18.mFMPrimaryFont, (String)a3.text, (int)a13);
                    a3.width = a13;
                } else {
                    a3.width = a15;
                }
            }
            a19.y += a23;
            a19.height -= a23;
            if (a17.paintProgress && a18.isProgressPainted() && a18.getDataModel().getProgress() >= 0.0f) {
                a12 = a18.getProgressBarGap();
                a19.y += a12;
                a19.height -= a12;
                a10.x = a19.x;
                a10.y = a19.y;
                a10.width = KindleSwingUtilities.getProgessBarLength(a9, a13);
                a10.height = ((ContentItemView)a18).getProgressBar().getPreferredSize().height;
            }
        }
    }

    private static class ImageTextView
    extends AbstractView {
        private int mMaxPrimaryLines;

        public ImageTextView() {
            ImageTextView a;
            ResourceBundle a2 = ResourceBundle.getBundle(ContentItemView.RESOURCES);
            a.mMaxPrimaryLines = (Integer)a2.getObject("ContentItemView.max_primary_lines");
        }

        public ImageTextView(int a) {
            ImageTextView a2;
            a2.mMaxPrimaryLines = a;
        }

        public Dimension getPreferredSize(JComponent a) {
            int a2;
            Dimension a3;
            block12: {
                int a4;
                int a5;
                block14: {
                    int a6;
                    int a7;
                    ImageTextView a8;
                    ContentItemView a9;
                    block13: {
                        int a10;
                        int a11;
                        int a12;
                        block15: {
                            List a13;
                            a9 = (ContentItemView)a;
                            ContentItemModel a14 = a9.getDataModel();
                            a3 = super.getPreferredSize(a);
                            a5 = 0;
                            Icon a15 = a9.getImage();
                            if (a15 != null) {
                                a5 = a15.getIconWidth();
                                a3.width += a15.getIconWidth();
                                a3.height += a15.getIconHeight();
                            }
                            a7 = a9.getMaxPrimaryWidth();
                            a3.height += a9.mFMCoverviewTagFont.getHeight() + a9.getTagIconGap();
                            a2 = 0;
                            List a16 = a14.getLocalizedTags();
                            if (a16 != null && a16.size() > 0) {
                                String a17 = a8.getTagText(a16, a9.mFMCoverviewTagFont, a7);
                                int a18 = a9.mFMCoverviewTagFont.stringWidth(a17);
                                if (a18 > a5) {
                                    a2 = a18 - a5;
                                }
                            }
                            if (a8.mMaxPrimaryLines <= 0) {
                                a3.width += a2;
                                return a3;
                            }
                            a3.height += a9.getIconPrimaryGap();
                            int a19 = a9.mFMPrimaryFont.getHeight();
                            a3.height += a19 * a8.mMaxPrimaryLines;
                            String a20 = a14.getDisplayText(0, 0);
                            if (a20 == null || a20.length() <= 0) break block12;
                            String a21 = a14.getDisplayText(2, 0);
                            a4 = 0;
                            if (a21 == null || a21.length() <= 0) break block13;
                            a12 = a9.getPrimaryTertiaryMargin();
                            a11 = a9.mFMPrimaryFont.stringWidth(a21);
                            int a22 = a7 - (a11 + a12);
                            if (a22 < 0) {
                                a22 = 0;
                            }
                            if ((a13 = a8.createLines(a, a9.mFMPrimaryFont, a7, a22)).size() <= 0) break block14;
                            int n = a10 = 0;
                            while (n < a13.size() - 1) {
                                int a23 = a9.mFMPrimaryFont.stringWidth((String)a13.get(a10));
                                if (a23 > a4) {
                                    a4 = a23;
                                }
                                n = ++a10;
                            }
                            a10 = a9.mFMPrimaryFont.stringWidth((String)a13.get(a13.size() - 1));
                            if (a13.size() >= a8.mMaxPrimaryLines || a10 + a12 + a11 <= a7) break block15;
                            if (a10 > a4) {
                                a4 = a10;
                            }
                            if (a11 > a4) {
                                a4 = a11;
                            }
                            break block14;
                        }
                        if ((a10 += a12 + a11) <= a4) break block14;
                        a4 = a10;
                        break block14;
                    }
                    List a24 = a8.createLines(a, a9.mFMPrimaryFont, a7, a7);
                    int n = a6 = 0;
                    while (n < a24.size()) {
                        int a25 = a9.mFMPrimaryFont.stringWidth((String)a24.get(a6));
                        if (a25 > a4) {
                            a4 = a25;
                        }
                        n = ++a6;
                    }
                }
                if (a4 > a5) {
                    a2 = Math.max(a2, a4 - a5);
                }
            }
            a3.width += a2;
            return a3;
        }

        public void paint(Graphics a, JComponent a2) {
            int a3;
            ImageTextView a4;
            ContentItemView a5 = (ContentItemView)a2;
            ContentItemModel a6 = a5.getDataModel();
            AbstractView.BoundedText a7 = new AbstractView.BoundedText();
            new AbstractView.BoundedText().text = a6.getDisplayText(0, 0);
            AbstractView.BoundedText[] a8 = new AbstractView.BoundedText[a4.mMaxPrimaryLines];
            int n = a3 = 0;
            while (n < a8.length) {
                a8[a3] = new AbstractView.BoundedText();
                n = ++a3;
            }
            AbstractView.BoundedText a22 = new AbstractView.BoundedText();
            new AbstractView.BoundedText().text = a6.getDisplayText(1, 0);
            AbstractView.BoundedText a9 = new AbstractView.BoundedText();
            new AbstractView.BoundedText().text = a6.getDisplayText(2, 0);
            List a10 = a6.getLocalizedTags();
            AbstractView.BoundedText a11 = new AbstractView.BoundedText();
            AbstractView.BoundedIcon a12 = new AbstractView.BoundedIcon();
            Icon a13 = a5.getImage();
            if (a5.showXOR && a5.isPressedAndArmed() && !a5.isSelected() && a13 != null && a13 instanceof ImageIcon) {
                a13 = new ImageIcon(BlackWhiteFilter.createBlackWhiteImage(((ImageIcon)a13).getImage(), a5.mFilterThreshold));
            }
            a12.icon = a13;
            a4.calculateRectangles(a, a2, a7, a8, a9, a10, a11, a12, a22);
            if (a13 != null) {
                a13.paintIcon(a2, a, a12.x, a12.y);
            }
            if (a10 != null && a10.size() > 0) {
                a.setFont(a5.mTagCoverviewFont);
                a.drawString(a11.text, a11.x, a11.y + a5.mFMCoverviewTagFont.getAscent());
            }
            if (a7.text != null && a7.text.length() > 0 && a8.length > 0) {
                int a14;
                a.setFont(a5.getPrimaryFont());
                int n2 = a14 = 0;
                AbstractView.BoundedText[] boundedTextArray = a8;
                while (n2 < boundedTextArray.length && a8[a14].text != null) {
                    a.drawString(a8[a14].text, a8[a14].x, a8[a14].y + a5.mFMPrimaryFont.getAscent());
                    n2 = ++a14;
                    boundedTextArray = a8;
                }
                if (a9.text != null && StringUtil.isNotEmpty((String)a9.text)) {
                    a.drawString(a9.text, a9.x, a9.y + a5.mFMPrimaryFont.getAscent());
                } else if (a22.text != null && StringUtil.isNotEmpty((String)a22.text)) {
                    a.setFont(a5.getSecondaryFont());
                    a.drawString(a22.text, a22.x, a22.y + a5.mFMSecondaryFont.getAscent());
                }
            }
        }

        private void calculateRectangles(Graphics a, JComponent a2, AbstractView.BoundedText a3, AbstractView.BoundedText[] a4, AbstractView.BoundedText a5, List a6, AbstractView.BoundedText a7, AbstractView.BoundedIcon a8, AbstractView.BoundedText a9) {
            int a10;
            int a11;
            int a12;
            int a13;
            int a14;
            int a15;
            ImageTextView a16;
            ContentItemView a17 = (ContentItemView)a2;
            Rectangle a18 = a16.getBareBoundsRectangle(a2);
            if (a8 != null) {
                a8.x = a18.x;
                a8.y = a18.y;
                a8.height = a8.icon.getIconHeight();
                a8.width = a8.icon.getIconWidth();
            }
            int a19 = a17.getMaxPrimaryWidth();
            a7.x = a8.x;
            a7.y = a8.y;
            a7.height = a17.mFMTagFont.getHeight();
            a8.y += a7.height + a17.getTagIconGap();
            if (a6 != null && a6.size() > 0) {
                a7.text = a16.getTagText(a6, a17.mFMTagFont, a19);
                a7.width = a17.mFMTagFont.stringWidth(a7.text);
            }
            a3.x = a8.x;
            a3.y = a8.y + a8.height + a17.getIconPrimaryGap();
            int a20 = a17.mFMPrimaryFont.getHeight();
            a3.height = a20 * a4.length;
            int a21 = 0;
            if (a3.text != null && a3.text.length() > 0) {
                a15 = a19;
                a14 = a17.getPrimaryTertiaryMargin();
                a13 = 0;
                if (a5.text != null && a5.text.length() > 0 && (a15 -= (a13 = a17.mFMPrimaryFont.stringWidth(a5.text)) + a14) < 0) {
                    a15 = 0;
                }
                List a22 = a16.createLines(a2, a17.mFMPrimaryFont, a19, a15);
                a21 = a22.size();
                a12 = 0;
                int n = a11 = 0;
                while (n < a21) {
                    String a23;
                    a4[a11].text = a23 = (String)a22.get(a11);
                    a4[a11].width = a10 = a17.mFMPrimaryFont.stringWidth(a23);
                    a4[a11].height = a20;
                    a4[a11].y = a11 == 0 ? a3.y : a4[a11 - 1].y + a4[a11 - 1].height;
                    if (a10 > a12) {
                        a12 = a10;
                    }
                    n = ++a11;
                }
                if (a22.size() > 0) {
                    a5.width = a13;
                    a5.height = a20;
                    a5.y = a4[a22.size() - 1].y + a4[a22.size() - 1].height;
                    if (a13 > a12) {
                        a12 = a13;
                    }
                }
                if (a9.text != null && a9.text.length() > 0 && a22.size() > 0) {
                    a9.y = a4[a22.size() - 1].y + a4[a22.size() - 1].height;
                    a9.height = a17.mFMSecondaryFont.getHeight();
                    a9.width = a17.mFMSecondaryFont.stringWidth(a9.text);
                    if (a9.width > a19) {
                        a9.text = StringUtil.shortenText((FontMetrics)a17.mFMSecondaryFont, (String)a9.text, (int)a19);
                        a9.width = a17.mFMSecondaryFont.stringWidth(a9.text);
                    }
                    if (a9.width > a12) {
                        a12 = a9.width;
                    }
                }
                a3.width = a12;
            }
            if (a7.width > 0 || a8.width > 0 || a3.width > 0 || a9.width > 0) {
                if (a8.width >= a7.width && a8.width >= a3.width) {
                    a7.x += a8.width - a7.width >> 1;
                    a3.x += a8.width - a3.width >> 1;
                } else if (a3.width >= a7.width && a3.width >= a8.width) {
                    a7.x += a3.width - a7.width >> 1;
                    a8.x += a3.width - a8.width >> 1;
                } else {
                    a8.x += a7.width - a8.width >> 1;
                    a3.x += a7.width - a3.width >> 1;
                }
                int n = a15 = 0;
                while (n < a21) {
                    a4[a15].x = a3.x + (a3.width - a4[a15].width >> 1);
                    n = ++a15;
                }
                if (a5.text != null && a5.text.length() > 0) {
                    a5.x = a3.x + (a3.width - a5.width >> 1);
                }
                if (a9.text != null && a9.text.length() > 0) {
                    a9.x = a19 - a9.width >> 1;
                }
                a15 = Math.min(a7.x, Math.min(a8.x, a3.x));
                a14 = Math.max(a7.x + a7.width, Math.max(a8.x + a8.width, a3.x + a3.width));
                a13 = a14 - a15;
                if (a13 < a18.width) {
                    int a24 = a18.width - a13 >> 1;
                    a7.x += a24;
                    a8.x += a24;
                    a3.x += a24;
                    int n2 = a12 = 0;
                    while (n2 < a21) {
                        a4[a12].x += a24;
                        n2 = ++a12;
                    }
                    a5.x += a24;
                }
                int a25 = Math.min(a7.y, Math.min(a8.y, a3.y));
                a12 = Math.max(a7.y + a7.height, Math.max(a8.y + a8.height, a3.y + a3.height * 2));
                a11 = a12 - a25;
                if (a11 < a18.height) {
                    int a26 = a18.height - a11 >> 1;
                    a7.y += a26;
                    a8.y += a26;
                    a3.y += a26;
                    int n3 = a10 = 0;
                    while (n3 < a21) {
                        a4[a10].y += a26;
                        n3 = ++a10;
                    }
                    a5.y += a26;
                    a9.y += a26;
                }
            }
        }

        private List createLines(JComponent a, FontMetrics a2, int a3, int a4) {
            ImageTextView a5;
            ContentItemModel a6 = ((ContentItemView)a).getDataModel();
            int a7 = a5.mMaxPrimaryLines;
            String a8 = a6.getDisplayText(0, 0);
            return a7 > 0 ? StringUtil.splitIntoLines((FontMetrics)a2, (String)a8, (int)a3, (int)a4, (int)a7) : new ArrayList(0);
        }
    }

    private static abstract class AbstractView
    implements View {
        protected Rectangle componentBounds = new Rectangle();

        public AbstractView() {
            AbstractView a;
        }

        public Dimension getPreferredSize(JComponent a) {
            Dimension a2 = new Dimension(0, 0);
            Insets a3 = a.getInsets();
            if (a3 != null) {
                a2.width += a3.left + a3.right;
                a2.height += a3.top + a3.bottom;
            }
            return a2;
        }

        public abstract void paint(Graphics var1, JComponent var2);

        protected Rectangle getBareBoundsRectangle(JComponent a) {
            AbstractView a2;
            Rectangle a3 = a2.componentBounds;
            a3.setBounds(0, 0, a.getWidth(), a.getHeight());
            Insets a4 = a.getInsets();
            if (a4 != null) {
                a3.x += a4.left;
                a3.y += a4.top;
                a3.height -= a4.top + a4.bottom;
                a3.width -= a4.left + a4.right;
            }
            return a3;
        }

        protected String getTagText(List a, FontMetrics a2, int a3) {
            String a4 = StringUtil.formatList((List)a, (int)0);
            if (a2.stringWidth(a4) > a3) {
                a4 = StringUtil.shortenText((FontMetrics)a2, (String)a4, (int)a3);
            }
            return a4;
        }

        protected void paintTags(Graphics a, JComponent a2, List a3, Bounds a4) {
            if (a3 != null && a3.size() > 0) {
                ContentItemView a5 = (ContentItemView)a2;
                a.setFont(a5.getTagFont());
                String a6 = StringUtil.formatList((List)a3, (int)0);
                a.drawString(a6, a4.x, a4.y + a5.mFMTagFont.getAscent());
            }
        }

        protected void paintPrimary(Graphics a, JComponent a2, BoundedText a3) {
            if (a3.text != null && a3.text.length() > 0) {
                ContentItemView a4 = (ContentItemView)a2;
                a.setFont(a4.getPrimaryFont());
                String a5 = a4.mFMPrimaryFont.stringWidth(a3.text) > a3.width ? StringUtil.shortenText((FontMetrics)a4.mFMPrimaryFont, (String)a3.text, (int)a3.width) : a3.text;
                a.drawString(a5, a3.x, a3.y + a4.mFMPrimaryFont.getAscent());
            }
        }

        protected void paintSecondary(Graphics a, JComponent a2, BoundedText a3) {
            if (a3.text != null && a3.text.length() > 0) {
                ContentItemView a4 = (ContentItemView)a2;
                a.setFont(a4.getSecondaryFont());
                String a5 = a4.mFMSecondaryFont.stringWidth(a3.text) > a3.width ? StringUtil.shortenText((FontMetrics)a4.mFMSecondaryFont, (String)a3.text, (int)a3.width) : a3.text;
                a.drawString(a5, a3.x, a3.y + a4.mFMSecondaryFont.getAscent());
            }
        }

        protected void paintTertiary(Graphics a, JComponent a2, BoundedText a3) {
            if (a3.text != null && a3.text.length() > 0) {
                ContentItemView a4 = (ContentItemView)a2;
                a.setFont(a4.getTertiaryFont());
                String a5 = a4.mFMTertiaryFont.stringWidth(a3.text) > a3.width ? StringUtil.shortenText((FontMetrics)a4.mFMTertiaryFont, (String)a3.text, (int)a3.width) : a3.text;
                a.drawString(a5, a3.x, a3.y + a4.mFMTertiaryFont.getAscent());
            }
        }

        protected void paintProgress(Graphics a, JComponent a2, Bounds a3) {
            ContentItemView a4 = (ContentItemView)a2;
            float a5 = a4.getDataModel().getProgress();
            if (a4.isProgressPainted() && a5 >= 0.0f) {
                Graphics a6 = a.create(a3.x, a3.y, a3.width, a3.height);
                JProgressBar a7 = a4.getProgressBar();
                a7.setValue((int)a5);
                a7.setSize(a3.width, a3.height);
                a7.paint(a6);
                a6.dispose();
            }
        }

        protected static class BoundedIcon
        extends Bounds {
            public Icon icon;

            protected BoundedIcon() {
                BoundedIcon a;
            }
        }

        protected static class BoundedText
        extends Bounds {
            public String text;

            protected BoundedText() {
                BoundedText a;
            }
        }

        protected static class Bounds {
            public int x;
            public int y;
            public int width;
            public int height;

            protected Bounds() {
                Bounds a;
            }
        }
    }

    private static interface View {
        public Dimension getPreferredSize(JComponent var1);

        public void paint(Graphics var1, JComponent var2);
    }
}

