/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.tts;

import com.amazon.ebook.booklet.reader.plugin.tts.TTSProvider;
import com.amazon.ebook.booklet.reader.sdk.ReaderException;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.booklet.ChromeHeaderBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TTSController
extends JPanel {
    private ReaderSDK readerSDK;
    private TTSProvider service;
    private ResourceBundle rb;
    private JSlider volumeControl;
    private TTSButton[] voiceButtons;
    private TTSButton[] rateButtons;
    private PlayButton playButton;
    static /* synthetic */ Class class$com$amazon$kindle$booklet$ChromeHeaderBar;

    public TTSController(ReaderSDK a, TTSProvider a2) throws ReaderException {
        TTSController a3;
        a3.readerSDK = a;
        a3.service = a2;
        a3.rb = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.plugin.tts.resources.TTSResources");
        int a4 = (Integer)a3.rb.getObject("tts.button.panel.margin");
        int a5 = (Integer)a3.rb.getObject("tts.button.panel.gap");
        a3.setLayout(new BoxLayout(a3, 1));
        a3.setBorder((Border)a3.rb.getObject("tts.button.panel.border"));
        JPanel a6 = a3.getTunePanel();
        if (a6 == null) {
            ReaderException a7 = new ReaderException(65575, "getTunePanel() failed");
            throw a7;
        }
        a3.add(a6);
        a3.add(new JSeparator(0));
        a3.add(Box.createVerticalStrut(a5));
        JPanel a8 = new JPanel(new BorderLayout(a4, 0));
        a3.playButton = a3.new PlayButton(true);
        a8.add((Component)a3.playButton, "West");
        JPanel a9 = new JPanel(new BorderLayout());
        a3.volumeControl = new JSlider(0, a2.getTTSMinVolume(), a2.getTTSMaxVolume(), a2.getTTSVolume());
        a3.volumeControl.addChangeListener(new ChangeListener(){
            {
                1 a;
            }

            public void stateChanged(ChangeEvent a) {
                JSlider a2 = (JSlider)a.getSource();
                if (!a2.getValueIsAdjusting()) {
                    1 a3;
                    int a4 = a2.getValue();
                    TTSProvider a5 = a3.TTSController.this.service;
                    if (a5.getTTSVolume() != a4) {
                        a5.setTTSVolume(a4);
                    }
                }
            }
        });
        a9.add((Component)a3.volumeControl, "Center");
        a9.add((Component)a3.new VolumeButton(a3.rb.getString("tts.volume.quieter.img"), -1, a3.volumeControl), "West");
        a9.add((Component)a3.new VolumeButton(a3.rb.getString("tts.volume.louder.img"), 1, a3.volumeControl), "East");
        a8.add((Component)a9, "Center");
        JButton a10 = new JButton(new AbstractAction("", new ImageIcon(a3.getClass().getResource(a3.rb.getString("tts.volume.off.img")))){
            {
                2 a3;
                super(a, a2);
            }

            public void actionPerformed(ActionEvent a) {
                2 a2;
                a2.TTSController.this.service.switchTTS(false);
                ChromeHeaderBar a3 = (ChromeHeaderBar)((BookletContext)a2.TTSController.this.readerSDK.getActiveContext()).getService(class$com$amazon$kindle$booklet$ChromeHeaderBar == null ? (class$com$amazon$kindle$booklet$ChromeHeaderBar = TTSController.class$("com.amazon.kindle.booklet.ChromeHeaderBar")) : class$com$amazon$kindle$booklet$ChromeHeaderBar);
                if (a3 != null) {
                    a3.setTransientChromeVisible(false);
                }
            }
        });
        a10.setBorder(null);
        a8.add((Component)a10, "East");
        a3.add(a8);
        a3.installDefaults(a3);
    }

    private JPanel getTunePanel() {
        TTSButton a;
        TTSController a2;
        JPanel a3 = new JPanel(new GridBagLayout());
        GridBagConstraints a4 = new GridBagConstraints();
        new GridBagConstraints().fill = 2;
        a4.weightx = 0.5;
        a4.gridx = 0;
        a4.gridy = 0;
        a3.add((Component)a2.new TTSLabel(a2.rb.getString("tts.speaking.voice.label")), a4);
        ButtonGroup a5 = new ButtonGroup();
        String[] a6 = (String[])a2.rb.getObject("tts.speaking.voice.display.list");
        int[] a7 = (int[])a2.rb.getObject("tts.speaking.voice.list");
        a2.voiceButtons = new TTSButton[a6.length];
        int a8 = 0;
        int a9 = a6.length;
        int n = a8;
        while (n < a9) {
            a = new TTSButton(a7[a8], a6[a8]){
                {
                    3 a3;
                    super(a, a2);
                }

                public void actionPerformed(ActionEvent a) {
                    3 a2;
                    a2.TTSController.this.service.setTTSVoice(a2.index);
                }
            };
            ++a4.gridx;
            a3.add((Component)a, a4);
            a5.add(a);
            a2.voiceButtons[a8] = a;
            n = ++a8;
        }
        a8 = a2.service.getTTSVoice();
        if (a8 < 0) {
            return null;
        }
        a2.voiceButtons[a8].setSelected(true);
        a4.gridx = 0;
        a4.gridy = 1;
        a3.add((Component)a2.new TTSLabel(a2.rb.getString("tts.speaking.rate.label")), a4);
        ButtonGroup a22 = new ButtonGroup();
        a = (TTSButton)a2.rb.getObject("tts.speaking.rate.display.list");
        int[] a10 = (int[])a2.rb.getObject("tts.speaking.rate.list");
        a2.rateButtons = new TTSButton[((String[])a).length];
        int a11 = 0;
        int a12 = ((String[])a).length;
        int n2 = a11;
        while (n2 < a12) {
            TTSButton a13 = new TTSButton(a10[a11], a[a11]){
                {
                    4 a3;
                    super(a, a2);
                }

                public void actionPerformed(ActionEvent a) {
                    4 a2;
                    a2.TTSController.this.service.setTTSRate(a2.index);
                }
            };
            ++a4.gridx;
            a3.add((Component)a13, a4);
            a22.add(a13);
            a2.rateButtons[a11] = a13;
            n2 = ++a11;
        }
        a11 = a2.service.getTTSRate();
        if (a11 < 0) {
            return null;
        }
        a2.rateButtons[a11 - 1].setSelected(true);
        return a3;
    }

    private void installDefaults(Component a) {
        TTSController a2;
        a.setForeground((Color)a2.rb.getObject("tts.foreground.color"));
        a.setBackground((Color)a2.rb.getObject("tts.background.color"));
        if (!(a instanceof Container)) {
            return;
        }
        Component[] a3 = ((Container)a).getComponents();
        int a4 = 0;
        int a5 = a3.length;
        int n = a4;
        while (n < a5) {
            a2.installDefaults(a3[a4]);
            n = ++a4;
        }
    }

    public void setVolume(int a) {
        TTSController a2;
        if (a2.volumeControl.getValue() != a) {
            a2.volumeControl.setValue(a);
        }
    }

    public int getVolume() {
        TTSController a;
        return a.volumeControl.getValue();
    }

    public void switchPlayButton(boolean a) {
        TTSController a2;
        a2.playButton.switchPlayButton(a);
    }

    class PlayButton
    extends JButton {
        boolean isOn;
        ImageIcon playIcon;
        ImageIcon pauseIcon;

        public PlayButton(boolean a) {
            PlayButton a2;
            a2.playIcon = new ImageIcon(a2.TTSController.this.getClass().getResource(a2.TTSController.this.rb.getString("tts.volume.play.img")));
            a2.pauseIcon = new ImageIcon(a2.TTSController.this.getClass().getResource(a2.TTSController.this.rb.getString("tts.volume.pause.img")));
            a2.setBorder(null);
            a2.addActionListener(new ActionListener(){
                {
                    1 a;
                }

                public void actionPerformed(ActionEvent a) {
                    1 a2;
                    a2.PlayButton.this.switchPlayButton(!a2.PlayButton.this.isOn);
                    if (a2.PlayButton.this.isOn) {
                        TTSController.this.service.resumeTTS();
                    } else {
                        TTSController.this.service.pauseTTS();
                    }
                }
            });
        }

        protected void switchPlayButton(boolean a) {
            PlayButton a2;
            a2.isOn = a;
            a2.setIcon(a ? a2.pauseIcon : a2.playIcon);
        }
    }

    class VolumeButton
    extends JButton
    implements ActionListener {
        int inc;
        JSlider slider;

        public VolumeButton(String a, int a2, JSlider a3) {
            VolumeButton a4;
            a4.inc = a2;
            a4.slider = a3;
            URL a5 = a4.getClass().getResource(a);
            ImageIcon a6 = new ImageIcon(a5);
            a4.setIcon(a6);
            a4.setBorder(null);
            a4.addActionListener(a4);
        }

        public void actionPerformed(ActionEvent a) {
            VolumeButton a2;
            a2.slider.setValue(a2.slider.getValue() + a2.inc);
        }
    }

    abstract class TTSButton
    extends JRadioButton
    implements ActionListener {
        protected int index;

        public TTSButton(int a, String a2) {
            TTSButton a3;
            super(a2);
            a3.index = a;
            a3.setBorder((Border)a3.TTSController.this.rb.getObject("tts.button.button.border"));
            a3.setHorizontalTextPosition(4);
            a3.setHorizontalAlignment(2);
            a3.addActionListener(a3);
        }
    }

    class TTSLabel
    extends JLabel {
        public TTSLabel(String a) {
            TTSLabel a2;
            super(a);
            a2.setBorder((Border)a2.TTSController.this.rb.getObject("tts.button.label.border"));
        }
    }
}

