/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.systemcards;

import com.amazon.agui.swing.KDialog;
import com.amazon.ebook.booklet.reader.plugin.systemcards.SystemsCardProvider;
import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.BookNavigator;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.dictionary.Dictionary;
import com.amazon.ebook.booklet.reader.sdk.ui.LinkPanel;
import com.amazon.ebook.booklet.reader.sdk.ui.SelectionCardProvider;
import com.amazon.ebook.booklet.reader.sdk.ui.html.MiddleClassTextView;
import com.amazon.ebook.booklet.reader.utils.FrameworkUtil;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.PerformanceLog;
import com.amazon.ebook.util.text.LanguageTag;
import com.amazon.ebook.util.text.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DictionaryCard
extends JPanel
implements SelectionCardProvider {
    private static final Log LOG = Log.getInstance((String)"DictionaryCard");
    private ResourceBundle rb;
    private SystemsCardProvider sysProvider;
    private LinkPanel linkPanel;
    private MiddleClassTextView definitionPane;
    private DefinitionResults results;
    private DefinitionText shortDef;
    private int currentCardIndex;

    public DictionaryCard(SystemsCardProvider a) {
        super(new GridBagLayout());
        DictionaryCard a2;
        a2.sysProvider = a;
        a2.results = a2.new DefinitionResults();
        a2.rb = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.plugin.systemcards.resources.SystemsCardsResources");
        a2.setName(a2.rb.getString("dictionarycard.name"));
        a2.definitionPane = new MiddleClassTextView(a2.sysProvider.getSDK(), null, ((Integer)a2.rb.getObject("dictionarycard.def.definition.size")).intValue(), a2.rb.getString("dictionarycard.def.definition.font"), ((Integer)a2.rb.getObject("dictionarycard.def.definition.margin.right")).intValue(), ((Integer)a2.rb.getObject("dictionarycard.def.definition.margin.left")).intValue(), ((Integer)a2.rb.getObject("dictionarycard.def.definition.margin.top")).intValue(), ((Integer)a2.rb.getObject("dictionarycard.def.definition.margin.bottom")).intValue(), ((Integer)a2.rb.getObject("dictionarycard.def.definition.line.spacing")).intValue());
        a2.linkPanel = new LinkPanel((JComponent)a2.definitionPane, (Action)a2.new OpenAction());
        a2.setLayout(new BorderLayout());
        a2.add((Component)a2.linkPanel, "Center");
        a2.shortDef = a2.new DefinitionText();
    }

    public void update(ReaderSDK a) {
        DictionaryCard a2;
        a2.definitionPane.setText("");
        BookNavigator a3 = a.getBookNavigator();
        Book a4 = a2.sysProvider.getSDK().getCurrentBook();
        String a5 = a4.getWords(a3.getSelectionStart().getStartPosition(), a3.getSelectionEnd().getEndPosition());
        a5 = a5 == null ? null : a5.trim();
        String a6 = a4.getMetadata().getContentLanguage(true);
        Dictionary[] a7 = a2.sysProvider.getSortedDictionaries();
        a2.results.update(a7, a5, a6);
    }

    public void setLocale(Locale a) {
        DictionaryCard a2;
        super.setLocale(a);
        a2.definitionPane.setLocale(a);
    }

    public int getCardCount() {
        DictionaryCard a;
        Dictionary[] a2 = a.sysProvider.getSortedDictionaries();
        return a2 == null || a2.length == 0 ? 1 : a2.length;
    }

    public String getCardTitle(int a) {
        DictionaryCard a2;
        Dictionary[] a3 = a2.sysProvider.getSortedDictionaries();
        if (a3 == null) {
            return null;
        }
        return a3[a].getDisplayName();
    }

    public boolean canBeShownAsDefaultCard(int a) {
        DictionaryCard a2;
        return a2.results.isContentLanguage(a) && a2.results.hasResults(a);
    }

    private int getFirstWordIndex(String a, String a2) {
        DictionaryCard a3;
        String a4 = a3.rb.getString("dictionarycard.def.word.joiners");
        return StringUtil.findFirstWord((String)a, (String)a4, (boolean)true, (String)a2);
    }

    public JComponent getCard(int a) {
        DictionaryCard a2;
        PerformanceLog.logStart((String)"DictionaryCard_getCard");
        Dictionary[] a3 = a2.sysProvider.getSortedDictionaries();
        a2.definitionPane.setLocale(Locale.getDefault());
        a2.definitionPane.setComponentDirection(LanguageTag.getTextDirection((String)Locale.getDefault().getDisplayLanguage()));
        if (a3 == null) {
            a2.linkPanel.setLabel(a2.rb.getString("dictionarycard.label.nodictionary"));
            a2.linkPanel.setLinkEnabled(false);
            a2.definitionPane.setText(a2.shortDef.getText("", a2.rb.getString("dictionarycard.def.nodictionary")));
            PerformanceLog.logEnd((String)"DictionaryCard_getCard");
            return a2;
        }
        PerformanceLog.logStart((String)"DictionaryCard_set_dict_locale");
        Dictionary a4 = a3[a];
        Locale a5 = null;
        String a6 = a4.getLanguageOut();
        if (a6 == null) {
            a6 = a4.getLanguageIn();
        }
        a5 = a6 == null ? Locale.getDefault() : LanguageTag.toLocale((String)a6);
        PerformanceLog.logEnd((String)"DictionaryCard_set_dict_locale");
        a2.currentCardIndex = a;
        if (a4 != null && a2.results.H != null && (a2.results.H.length() != 1 || Character.isLetterOrDigit(a2.results.H.charAt(0)))) {
            a2.linkPanel.setLabel(a4.getDisplayName());
            a2.linkPanel.setLinkEnabled(a2.results.hasResults(a) && a4.canBeOpened());
            if (!a2.results.hasResults(a)) {
                a2.definitionPane.setText(a2.shortDef.getText("", a2.rb.getString("dictionarycard.nodef")));
            } else {
                Dictionary.ResultSet a7 = a2.results.getResults(a);
                String a8 = a7.D[a7.B].B;
                int a9 = a2.getFirstWordIndex(a8, a6);
                a2.definitionPane.setLocale(a5);
                a2.definitionPane.setComponentDirection(LanguageTag.getTextDirection((String)a5.getDisplayLanguage()));
                a2.definitionPane.setText(a2.shortDef.getText(a8.substring(0, a9), a8.substring(a9, a8.length())));
            }
        } else {
            LOG.error("Selected dictionary not found in installed list!");
            a2.linkPanel.setLabel(a2.rb.getString("dictionarycard.nodef"));
            a2.linkPanel.setLinkEnabled(false);
            a2.definitionPane.setText(a2.shortDef.getText("", a2.rb.getString("dictionarycard.def.dictnotfound")));
        }
        PerformanceLog.logEnd((String)"DictionaryCard_getCard");
        return a2;
    }

    public JComponent getDefaultCard() {
        DictionaryCard a;
        Dictionary[] a2 = a.sysProvider.getSortedDictionaries();
        if (a2 == null) {
            a.linkPanel.setLabel(a.rb.getString("dictionarycard.label.nodictionary"));
            a.linkPanel.setLinkEnabled(false);
            a.definitionPane.setText(a.shortDef.getText("", a.rb.getString("dictionarycard.def.nodictionary")));
            return a;
        }
        Dictionary a3 = a2[0];
        if (a3 != null && a.isContentLanguage(a3)) {
            a.linkPanel.setLabel(a3.getDisplayName());
            a.linkPanel.setLinkEnabled(false);
            a.definitionPane.setText(a.shortDef.getText("", a.rb.getString("dictionarycard.nodef")));
        } else {
            LOG.warning("No default dictionary found for language.");
            a.linkPanel.setLabel(a.rb.getString("dictionarycard.label.nodictforlang"));
            a.linkPanel.setLinkEnabled(false);
            a.definitionPane.setText(a.shortDef.getText("", a.rb.getString("dictionarycard.def.nodictionary")));
        }
        return a;
    }

    public int getProviderPriority() {
        return 20;
    }

    private boolean isContentLanguage(Dictionary a) {
        DictionaryCard a2;
        if (a == null) {
            return false;
        }
        String a3 = a2.sysProvider.getSDK().getCurrentBook().getMetadata().getContentLanguage(true);
        return LanguageTag.filterMatches((String)a3, (String)a.getLanguageIn());
    }

    private class DefinitionText {
        private String h;
        private String A;
        private String H;
        private String b;
        private String K;
        private String B;

        public DefinitionText() {
            DefinitionText a;
            a.h = a.DictionaryCard.this.rb.getString("dictionarycard.def.markupBegin");
            a.A = a.DictionaryCard.this.rb.getString("dictionarycard.def.markupEnd");
            a.H = a.DictionaryCard.this.rb.getString("dictionarycard.word.markupBegin");
            a.b = a.DictionaryCard.this.rb.getString("dictionarycard.word.markupEnd");
            a.K = a.DictionaryCard.this.rb.getString("dictionarycard.word.allMarkupBegin");
            a.B = a.DictionaryCard.this.rb.getString("dictionarycard.word.allMarkupEnd");
        }

        public String getText(String a, String a2) {
            DefinitionText a3;
            StringBuffer a4 = new StringBuffer("<html>");
            a4.append(a3.K);
            if (a != null && a.length() != 0) {
                if (a3.H != null) {
                    a4.append(a3.H);
                }
                a4.append("<![CDATA[");
                a4.append(a);
                a4.append("]]>");
                if (a3.b != null) {
                    a4.append(a3.b);
                }
            }
            if (a2 != null && a2.length() != 0) {
                if (a3.h != null) {
                    a4.append(a3.h);
                }
                a4.append("<![CDATA[");
                a4.append(a2);
                a4.append("]]>");
                if (a3.A != null) {
                    a4.append(a3.A);
                }
            }
            a4.append(a3.B);
            a4.append("</html>");
            return a4.toString();
        }
    }

    private class DefinitionResults {
        private Dictionary[] A;
        private String H;
        private String b;
        private Dictionary.ResultSet[] K;
        private boolean[] B;

        private DefinitionResults() {
            DefinitionResults a;
        }

        public void update(Dictionary[] a, String a2, String a3) {
            DefinitionResults a4;
            a4.A = a;
            a4.H = a2;
            a4.b = a3;
            int a5 = 0;
            if (a != null) {
                a5 = a.length;
            }
            if (a4.K == null || a4.K.length != a5) {
                a4.K = new Dictionary.ResultSet[a5];
                a4.B = new boolean[a5];
            } else {
                int a6;
                int n = a6 = 0;
                while (n < a4.K.length) {
                    a4.K[a6] = null;
                    a4.B[a6] = false;
                    n = ++a6;
                }
            }
        }

        public Dictionary.ResultSet getResults(int a) {
            DefinitionResults a2;
            if (a2.K.length <= a) {
                return null;
            }
            a2.ensureAlreadyCalculated(a);
            return a2.K[a];
        }

        public boolean hasResults(int a) {
            DefinitionResults a2;
            if (a2.B.length <= a) {
                return false;
            }
            a2.ensureAlreadyCalculated(a);
            return a2.B[a];
        }

        public boolean isContentLanguage(int a) {
            DefinitionResults a2;
            if (a2.A == null || a2.A.length <= a || a < 0) {
                return false;
            }
            return a2.DictionaryCard.this.isContentLanguage(a2.A[a]);
        }

        private void ensureAlreadyCalculated(int a) {
            DefinitionResults a2;
            if (a2.K[a] == null) {
                Dictionary.ResultSet a3;
                PerformanceLog.logStart((String)"DictionaryCard_do_lookup");
                a2.K[a] = a3 = a2.A[a].lookupWord(a2.H, a2.b);
                a2.B[a] = a2.H != null && a2.H.length() > 0 && a3 != null && a3.D != null && a3.D.length != 0 && a3.D.length > a3.B && a3.D[a3.B].B != null && a3.D[a3.B].B.length() > 0 && (a3.D[a3.B].B.length() != 1 || Character.isSpaceChar(a3.D[a3.B].B.charAt(0)));
                PerformanceLog.logEnd((String)"DictionaryCard_do_lookup");
            }
        }
    }

    private class OpenAction
    extends AbstractAction {
        public OpenAction() {
            OpenAction a;
            super(a.DictionaryCard.this.rb.getString("dictionarycard.open"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent a) {
            boolean a2;
            ReaderSDK a3;
            block5: {
                OpenAction a4;
                a3 = a4.DictionaryCard.this.sysProvider.getSDK();
                FrameworkUtil.startSpinner((ReaderSDK)a3, null, (boolean)true);
                a2 = false;
                try {
                    try {
                        Dictionary[] a5 = a4.DictionaryCard.this.sysProvider.getSortedDictionaries();
                        a2 = !a4.DictionaryCard.this.results.hasResults(a4.DictionaryCard.this.currentCardIndex);
                        Dictionary.ResultSet a6 = a4.DictionaryCard.this.results.getResults(a4.DictionaryCard.this.currentCardIndex);
                        a3.getUI().getUIContext().recordHistory();
                        a3.getUI().setBookletDetailViewContext(null);
                        a3.getUI().setDefaultChromeFooter();
                        a3.switchToBook(a5[a4.DictionaryCard.this.currentCardIndex].getUniqueID(), a2 ? null : a6.D[a6.B].D);
                        ((KDialog)a3.getUI().getSelectionDialog()).getCloseAction().actionPerformed(null);
                    }
                    catch (BookException a7) {
                        LOG.warning("Failed to open dictionary from Dictionary card", (Throwable)a7);
                        Object var7_8 = null;
                        FrameworkUtil.stopSpinner((ReaderSDK)a3);
                        break block5;
                    }
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    FrameworkUtil.stopSpinner((ReaderSDK)a3);
                    throw throwable;
                }
                FrameworkUtil.stopSpinner((ReaderSDK)a3);
            }
            if (a2) {
                a3.getBookNavigator().goToStartReading();
                a3.getUI().getReaderPane().repaint();
            }
        }
    }
}

