/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.sharing.ui;

import com.amazon.agui.swing.CommandBar;
import com.amazon.agui.swing.KDialog;
import com.amazon.ebook.booklet.reader.plugin.sharing.SharingManagerImpl;
import com.amazon.ebook.booklet.reader.plugin.sharing.requests.SharingServerCaller;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.BookMetadata;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.kindle.acx.ACXUIControllerInterface;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.util.lipc.LipcException;
import com.amazon.kindle.util.lipc.LipcService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class SharingErrorDialog
extends KDialog {
    private static final Log LOG = Log.getInstance((String)"SharingErrorDialog");
    private static final LogMessage URI_CREATION_FAILED = new LogMessage("UriCreationFailed", new String[]{"target"});
    private static final LogMessage LIPC_ERROR = new LogMessage("LipcError", new String[]{"errorCode"});
    private static final String APP_MANAGER_TARGET = "com.lab126.appmgrd";
    private static final String APP_MANAGER_PROP_START_APP = "start";
    private static final String MYSN_TARGET = "com.lab126.mysn";
    private static final String MYSN_QUERY_STRING = "from_book=1";
    private static ResourceBundle rb;
    private final ReaderSDK sdk;
    private final SharingServerCaller caller;
    private final String title;
    private final String message;
    private final Action[] actions;
    private Map acxSavedState;
    static /* synthetic */ Class class$com$amazon$kindle$acx$ACXUIControllerInterface;

    public SharingErrorDialog(ReaderSDK a, SharingServerCaller a2, int a3, String a4, String a5) {
        super(a.getActiveContext() == null ? null : ((BookletContext)a.getActiveContext()).getName(), true);
        SharingErrorDialog a6;
        rb = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.plugin.sharing.resources.SharingResources");
        a6.sdk = a;
        a6.caller = a2;
        a6.actions = a6.getActions(a3);
        if (a4 == null) {
            a4 = a6.getDefaultTitle(a3);
        }
        a6.title = a6.getNonemptyStringOrNull(a4);
        if (a5 == null) {
            a5 = a6.getDefaultMessage(a3);
        }
        a6.message = a6.getNonemptyStringOrNull(a5);
    }

    public String getTitle() {
        SharingErrorDialog a;
        return a.title;
    }

    public String getMessage() {
        SharingErrorDialog a;
        return a.message;
    }

    public void setAcxSavedState(Map a) {
        a.acxSavedState = a;
    }

    public void postDialog(boolean a) {
        SharingErrorDialog a2;
        a2.init();
        super.postDialog(a);
    }

    private void init() {
        int a;
        Insets a2;
        int a3;
        SharingErrorDialog a4;
        Container a5 = a4.getContentPane();
        a5.setLayout(new BorderLayout(0, 0));
        ((JPanel)a5).setBorder((Border)rb.getObject("error.dialog.border"));
        a4.setTitleBarEnabled(a4.title != null);
        if (a4.isTitleBarEnabled()) {
            a4.setTitle(a4.title);
            a4.setCloseIconButtonEnabled(false);
        }
        JTextArea a6 = new JTextArea();
        a6.setEditable(false);
        a6.setFocusable(false);
        a6.setLineWrap(true);
        a6.setWrapStyleWord(true);
        a6.setBorder(null);
        a6.setText(a4.message);
        a5.add((Component)a6, "North");
        int a7 = a3 = ((Integer)rb.getObject("error.dialog.panel.width")).intValue();
        if (a4.getBorder() != null) {
            a2 = a4.getBorder().getBorderInsets((Component)((Object)a4));
            a7 -= a2.left + a2.right;
        }
        a2 = ((JPanel)a5).getBorder().getBorderInsets(a4.getContentPane());
        a6.setSize(a7 -= a2.left + a2.right, 1);
        a6.validate();
        CommandBar a8 = a4.getCommandBar();
        int n = a = 0;
        while (n < a4.actions.length) {
            a8.add(a4.actions[a]);
            n = ++a;
        }
        Point a22 = (Point)rb.getObject("error.dialog.panel.position");
        Dimension a9 = new Dimension(a3, a4.getPreferredSize().height);
        a4.setDialogBounds(new Rectangle(a22, a9));
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getDefaultTitle(int a) {
        switch (a) {
            case 2: {
                return rb.getString("error.dialog.authentication.error.title");
            }
            case 1: {
                return rb.getString("error.dialog.no.external.accounts.title");
            }
            case 5: {
                return rb.getString("error.dialog.server.unavailable.title");
            }
            case 3: {
                return rb.getString("error.dialog.sharing.not.supported.title");
            }
            case 7: {
                return rb.getString("error.dialog.unknown.error.title");
            }
            case 6: {
                return rb.getString("error.dialog.failure.title");
            }
            case 8: {
                return rb.getString("error.dialog.sharing.limit.reached.title");
            }
            case 0: {
                return rb.getString("error.dialog.success.title");
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getDefaultMessage(int a) {
        switch (a) {
            case 2: {
                return rb.getString("error.dialog.authentication.error.message");
            }
            case 1: {
                return rb.getString("error.dialog.no.external.accounts.message");
            }
            case 5: {
                return rb.getString("error.dialog.server.unavailable.message");
            }
            case 3: {
                return rb.getString("error.dialog.sharing.not.supported.message");
            }
            case 7: {
                return rb.getString("error.dialog.unknown.error.message");
            }
            case 6: {
                return rb.getString("error.dialog.failure.message");
            }
            case 8: {
                SharingErrorDialog a2;
                BookMetadata a3 = a2.caller.getBook().getMetadata();
                if (!a3.isPublisherLimit()) {
                    return rb.getString("error.dialog.sharing.limit.reached.message");
                }
                String a4 = a3.getPublisher();
                if (a4 != null && a4.trim().length() != 0) {
                    String a5 = rb.getString("error.dialog.sharing.limit.by.publisher.reached.message");
                    return MessageFormat.format(a5, a4);
                }
                return rb.getString("error.dialog.sharing.limit.by.publisher.reached.no.publisher.name.message");
            }
            case 0: {
                return rb.getString("error.dialog.success.message");
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Action[] getActions(int a) {
        SharingErrorDialog a2;
        switch (a) {
            case 2: {
                return new Action[]{a2.new CloseAction(rb.getString("error.dialog.cancel.button")), a2.new OpenMysnAction(rb.getString("error.dialog.manage.accounts.button"))};
            }
            case 1: {
                return new Action[]{a2.new CloseAction(rb.getString("error.dialog.cancel.button")), a2.new OpenMysnAction(rb.getString("error.dialog.register.button"))};
            }
        }
        return new Action[]{a2.new CloseAction(rb.getString("error.dialog.close.button"))};
    }

    private String getNonemptyStringOrNull(String a) {
        if (a == null) {
            return null;
        }
        if ((a = a.trim()).length() == 0) {
            return null;
        }
        return a;
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction(String a) {
            CloseAction a2;
            super(a);
        }

        public void actionPerformed(ActionEvent a) {
            CloseAction a2;
            a2.SharingErrorDialog.this.getCloseAction().actionPerformed(null);
            if (a2.SharingErrorDialog.this.acxSavedState != null) {
                ((ACXUIControllerInterface)a2.SharingErrorDialog.this.sdk.getService(class$com$amazon$kindle$acx$ACXUIControllerInterface == null ? (class$com$amazon$kindle$acx$ACXUIControllerInterface = SharingErrorDialog.class$("com.amazon.kindle.acx.ACXUIControllerInterface")) : class$com$amazon$kindle$acx$ACXUIControllerInterface)).restoreACXUI(a2.SharingErrorDialog.this.acxSavedState);
            }
        }
    }

    private class OpenMysnAction
    extends AbstractAction {
        public OpenMysnAction(String a) {
            OpenMysnAction a2;
            super(a);
        }

        public void actionPerformed(ActionEvent a) {
            OpenMysnAction a2;
            a2.SharingErrorDialog.this.getCloseAction().actionPerformed(null);
            ((SharingManagerImpl)a2.SharingErrorDialog.this.sdk.getSharingManager()).setPendingShare(a2.SharingErrorDialog.this.caller, a2.SharingErrorDialog.this.acxSavedState);
            a2.SharingErrorDialog.this.acxSavedState = null;
            try {
                URI a3 = new URI("app", SharingErrorDialog.MYSN_TARGET, null, SharingErrorDialog.MYSN_QUERY_STRING, null);
                LipcService.getInstance().getDefaultSource().getTarget(SharingErrorDialog.APP_MANAGER_TARGET).setProperty(SharingErrorDialog.APP_MANAGER_PROP_START_APP, a3.toString());
            }
            catch (URISyntaxException a4) {
                LOG.error(URI_CREATION_FAILED, new String[]{SharingErrorDialog.MYSN_TARGET}, "URI creation failed", (Throwable)a4);
            }
            catch (LipcException a5) {
                LOG.error(LIPC_ERROR, new String[]{Integer.toString(a5.getErrorCode())}, "Lipc exception", (Throwable)a5);
            }
        }
    }
}

