/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.sharing.ui;

import com.amazon.agui.swing.CommandBar;
import com.amazon.agui.swing.KDialog;
import com.amazon.ebook.booklet.reader.plugin.sharing.requests.ShareRequest;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.kindle.acx.ACXUIControllerInterface;
import com.amazon.kindle.booklet.BookletContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EnterYourMessageDialog
extends KDialog {
    private static final int MAX_NOTE_LENGTH = 100;
    private ReaderSDK sdk;
    private ShareRequest shareRequest;
    private JTextArea message;
    private JLabel counter;
    private MessageFormat counterFormat;
    private ShareAction shareButton;
    private Map acxSavedState;
    private static final Log LOG = Log.getInstance((String)"Sharing");
    private static final LogMessage TIMESTAMP = new LogMessage("sharingPerf", new String[]{"unit", "time", "event"});

    public EnterYourMessageDialog(ReaderSDK a, ShareRequest a2) {
        super(a.getActiveContext() == null ? null : ((BookletContext)a.getActiveContext()).getName(), true, "abc");
        EnterYourMessageDialog a3;
        ResourceBundle a4 = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.plugin.sharing.resources.SharingResources");
        a3.sdk = a;
        a3.shareRequest = a2;
        Container a5 = a3.getContentPane();
        a5.setLayout(new BorderLayout(0, (Integer)a4.getObject("input.dialog.panel.gap")));
        ((JPanel)a5).setBorder((Border)a4.getObject("input.dialog.border"));
        a3.setTitleBarEnabled(true);
        a3.setTitle(a2.getTitle());
        JTextArea a6 = new JTextArea();
        a6.setEditable(false);
        a6.setFocusable(false);
        a6.setLineWrap(true);
        a6.setWrapStyleWord(true);
        a6.setBorder(null);
        a6.setFont((Font)a4.getObject("input.dialog.subtitle.font"));
        a6.setText(a2.getDescription());
        a5.add((Component)a6, "North");
        String a7 = a2.getMessagePrefill();
        a7 = a7 == null ? "" : a7.trim();
        a3.message = new JTextArea();
        a3.message.setEditable(true);
        a3.message.setLineWrap(true);
        a3.message.setWrapStyleWord(true);
        a3.message.putClientProperty("maxRows", (Integer)a4.getObject("input.dialog.message.max.rows"));
        a3.message.setText(a7);
        a3.message.getDocument().addDocumentListener(a3.new MessageKeyListener());
        JScrollPane a8 = new JScrollPane(a3.message);
        a8.setBorder((Border)a4.getObject("input.dialog.message.border"));
        a8.setHorizontalScrollBarPolicy(31);
        a5.add((Component)a8, "Center");
        a3.counter = new JLabel("", 0);
        a5.add((Component)a3.counter, "South");
        a3.counterFormat = (MessageFormat)a4.getObject("input.dialog.counter.format");
        a3.setCloseIconButtonEnabled(false);
        a3.setCommandBarPosition(2);
        CommandBar a9 = a3.getCommandBar();
        a9.add((Action)a3.new CancelAction(a4.getString("input.dialog.cancel.text")));
        a3.shareButton = a3.new ShareAction(a4.getString("input.dialog.share.text"));
        a9.add((Action)a3.shareButton);
        a3.setDialogBounds((Rectangle)a4.getObject("input.dialog.panel.size"));
        a.invokeLater(new Runnable(){
            {
                1 a;
            }

            public void run() {
                1 a;
                a.EnterYourMessageDialog.this.message.setCaretPosition(a.EnterYourMessageDialog.this.message.getDocument().getLength());
            }
        });
        a3.updateView();
        LOG.perf(TIMESTAMP, new String[]{"ms", Long.toString(System.currentTimeMillis()), "EnterYourMessageDialog.ctor.end"}, null);
    }

    public void postDialog(boolean a) {
        EnterYourMessageDialog a2;
        ACXUIControllerInterface a3 = (ACXUIControllerInterface)a2.sdk.getService(ACXUIControllerInterface.class);
        a2.acxSavedState = a3.dismissACXUI();
        super.postDialog(a);
    }

    private void updateView() {
        EnterYourMessageDialog a;
        int a2 = 100 - a.message.getText().length();
        Object[] a3 = new Object[]{new Integer(a2), new Integer(Math.abs(a2))};
        a.counter.setText(a.counterFormat.format(a3));
        a.shareButton.setEnabled(a2 >= 0 && (!a.shareRequest.requiresMessageForShare() || a2 != 100));
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction(String a) {
            CancelAction a2;
            super(a);
        }

        public void actionPerformed(ActionEvent a) {
            CancelAction a2;
            a2.EnterYourMessageDialog.this.getCloseAction().actionPerformed(null);
            ((ACXUIControllerInterface)a2.EnterYourMessageDialog.this.sdk.getService(class$com$amazon$kindle$acx$ACXUIControllerInterface == null ? (class$com$amazon$kindle$acx$ACXUIControllerInterface = EnterYourMessageDialog.class$("com.amazon.kindle.acx.ACXUIControllerInterface")) : class$com$amazon$kindle$acx$ACXUIControllerInterface)).restoreACXUI(a2.EnterYourMessageDialog.this.acxSavedState);
        }
    }

    private class ShareAction
    extends AbstractAction {
        public ShareAction(String a) {
            ShareAction a2;
            super(a);
        }

        public void actionPerformed(ActionEvent a) {
            ShareAction a2;
            a2.EnterYourMessageDialog.this.getCloseAction().actionPerformed(null);
            a2.EnterYourMessageDialog.this.shareRequest.share(a2.EnterYourMessageDialog.this.message.getText(), a2.EnterYourMessageDialog.this.acxSavedState);
        }
    }

    private class MessageKeyListener
    implements DocumentListener {
        private MessageKeyListener() {
            MessageKeyListener a;
        }

        public void changedUpdate(DocumentEvent a) {
        }

        public void insertUpdate(DocumentEvent a) {
            MessageKeyListener a2;
            a2.EnterYourMessageDialog.this.updateView();
        }

        public void removeUpdate(DocumentEvent a) {
            MessageKeyListener a2;
            a2.EnterYourMessageDialog.this.updateView();
        }
    }
}

