/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.sharing.requests;

import com.amazon.ebook.booklet.pdfreader.impl.PDFPosition;
import com.amazon.ebook.booklet.reader.plugin.sharing.AmazonSocialException;
import com.amazon.ebook.booklet.reader.plugin.sharing.SharingManagerImpl;
import com.amazon.ebook.booklet.reader.plugin.sharing.requests.SharingMetadata;
import com.amazon.ebook.booklet.reader.plugin.sharing.ui.SharingUI;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.TOCException;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.BookMetadata;
import com.amazon.ebook.booklet.reader.sdk.content.ByteOffsetBasedPosition;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContents;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.pl.SystemServices;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.ebook.util.net.HTTPUtil;
import com.amazon.ebook.util.text.StringUtil;
import com.amazon.kindle.acx.ACXUIControllerInterface;
import com.amazon.kindle.apps.util.CommunicationUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.restricted.net.KindleAuthenticatedConnectionService;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SharingServerCaller
implements Runnable {
    private static final Log f = Log.getInstance((String)"SharingServerCaller");
    private static final LogMessage M = new LogMessage("UnexpectedError", new String[]{"request", "response code", "response message", "errors"});
    private static final LogMessage J = new LogMessage("UnexpectedErrorDueToException", new String[]{"request", "exception type", "exception message"});
    private static final LogMessage G = new LogMessage("BusinessRuleError", new String[]{"request", "error code", "error title", "error message"});
    private static final LogMessage a = new LogMessage("ServerUrlIsNull", new String[]{"cdeKey"});
    private static final LogMessage i = new LogMessage("TocException", null);
    private static final LogMessage E = new LogMessage("UnknownPositionClassType", null);
    private static final int C = 422;
    private static final String d = "EBOK";
    private static final String j = "NWPR";
    private static final String g = "MAGZ";
    private static final int e = 700;
    private static final int I = 1400;
    private final SharingUI F;
    private final ReaderSDK L;
    private final Book c;
    private final Position l;
    private final Position k;
    private final String m;
    private final String h;
    private Position A;
    private Map H;
    private boolean b;

    public SharingServerCaller(ReaderSDK a, Book a2, Map a3, Position a4, Position a5, String a6, String a7, Position a8) {
        SharingServerCaller a9;
        a9.F = ((SharingManagerImpl)a.getSharingManager()).getUI();
        a9.L = a;
        a9.c = a2;
        a9.l = a4;
        a9.k = a5;
        a9.m = a6;
        a9.h = a7;
        a9.A = a8;
        a9.H = a3;
        a9.b = false;
    }

    public Book getBook() {
        SharingServerCaller a;
        return a.c;
    }

    public boolean shouldExpectAcx() {
        SharingServerCaller a;
        return a.b;
    }

    public final void run() {
        SharingServerCaller a;
        try {
            a.F.startSending();
            boolean a2 = CommunicationUtils.ensureConnection((Booklet)((Booklet)a.L.getActiveBooklet()));
            a.restoreAcxState();
            if (a2) {
                a.send();
                a.F.finishSending(a, null);
            } else {
                a.F.cancelSending();
            }
        }
        catch (AmazonSocialException a3) {
            a.F.finishSending(a, a3);
        }
        catch (Exception a4) {
            f.error(J, new String[]{"run", a4.getClass().getName(), a4.getMessage()}, "Runnable.run failed", (Throwable)a4);
            a.F.finishSending(a, new AmazonSocialException(6, null, null));
        }
    }

    private void restoreAcxState() {
        SharingServerCaller a;
        if (a.H != null) {
            ACXUIControllerInterface a2 = (ACXUIControllerInterface)a.L.getService(ACXUIControllerInterface.class);
            a.b = !a.H.isEmpty();
            a2.restoreACXUI(a.H);
            a.H = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void send() throws AmazonSocialException {
        AmazonSocialException a;
        SharingServerCaller a2;
        BookMetadata a3 = a2.c.getMetadata();
        String a4 = a3.getCdeType();
        String a5 = a3.getCdeKey();
        String a6 = Integer.toString(a3.getVersion());
        String a7 = a3.getGUID();
        SharingMetadata a8 = a2.fillMetadata(a2.c, a2.l, a2.A);
        String a9 = a2.getBookText(a4);
        Position a10 = a2.m == null ? null : (a2.k != null ? a2.k : a2.A);
        Locale a11 = Locale.getDefault();
        String a12 = a11.getLanguage();
        if (a11.getCountry().length() != 0) {
            a12 = a12 + '_' + a11.getCountry();
        }
        HashMap<String, String> a13 = new HashMap<String, String>();
        a13.put("key", a2.getNonemptyStringOrNull(a5));
        a13.put("type", a2.getNonemptyStringOrNull(a4));
        a13.put("language", a2.getNonemptyStringOrNull(a12));
        a13.put("version", a2.getNonemptyStringOrNull(a6));
        a13.put("guid", a2.getNonemptyStringOrNull(a7));
        a13.put("note_text", a2.getNonemptyStringOrNull(a2.m));
        a13.put("note_location", a2.getNonemptyStringOrNull(SharingServerCaller.positionToSafeString(a10)));
        a13.put("highlight_text", a2.getNonemptyStringOrNull(a9));
        a13.put("highlight_start", a2.getNonemptyStringOrNull(SharingServerCaller.positionToSafeString(a2.l)));
        a13.put("highlight_end", a2.getNonemptyStringOrNull(SharingServerCaller.positionToSafeString(a2.k)));
        a13.put("extra", a2.getNonemptyStringOrNull(a8.exportXML()));
        URL a14 = ((SystemServices)a2.L.getService(SystemServices.class)).getURLBuilder().getUrl("cmd.share.highlight.and.note", a13);
        if (a14 == null) {
            f.error(SharingServerCaller.a, new String[]{a5}, null);
            throw new AmazonSocialException(7, null, null);
        }
        if (Log.isDebugOn()) {
            f.debug("Calling SocializerService: cdeKey" + a5 + "version:" + a6);
        }
        try {
            String a15 = a14.getQuery();
            a14 = new URL(a14.getProtocol(), a14.getHost(), a14.getPath());
            KindleAuthenticatedConnectionService a16 = (KindleAuthenticatedConnectionService)a2.L.getService(KindleAuthenticatedConnectionService.class);
            URLConnection a17 = a16.openConnection(a14);
            try {
                HTTPUtil.postRequest((URLConnection)a17, (String)a15, (HTTPUtil.ContentEncoding)HTTPUtil.ContentEncoding.NONE, null);
            }
            catch (IOException a18) {
                // empty catch block
            }
            HttpURLConnection a19 = (HttpURLConnection)a17;
            int a20 = a19.getResponseCode();
            switch (a20) {
                case 200: {
                    return;
                }
                case 422: {
                    AmazonSocialException a21 = new AmazonSocialException(7, null, "HTTP_UNPROCESSABLE_ENTITY");
                    a21.setErrorMessageData(HTTPUtil.getResponseString((InputStream)a19.getErrorStream()));
                    if (a21.getEMDCode() == 7) {
                        f.error(G, new String[]{a14.toString(), Integer.toString(a21.getEMDCode()), a21.getEMDTitle(), a21.getEMDMessage()}, "HTTPS call failed due to a violation of a business rule (HTTP code 422)");
                        a = new AmazonSocialException(7, null, null);
                        throw a;
                    }
                    f.warning(G, new String[]{a14.toString(), Integer.toString(a21.getEMDCode()), a21.getEMDTitle(), a21.getEMDMessage()}, "HTTPS call failed due to a violation of a business rule (HTTP code 422)");
                    a = a21;
                    throw a;
                }
                case 404: 
                case 502: 
                case 503: 
                case 504: {
                    f.error(M, new String[]{a14.toString(), Integer.toString(a20), a19.getResponseMessage(), HTTPUtil.getResponseString((InputStream)a19.getErrorStream())}, "HTTPS call failed due to timeout");
                    a = new AmazonSocialException(5, null, null);
                    throw a;
                }
            }
            f.error(M, new String[]{a14.toString(), Integer.toString(a20), a19.getResponseMessage(), HTTPUtil.getResponseString((InputStream)a19.getErrorStream())}, "HTTPS call failed");
            a = new AmazonSocialException(7, null, null);
            throw a;
        }
        catch (Exception a22) {
            f.error(J, new String[]{a14.toString(), a22.getClass().getName(), a22.getMessage()}, "HTTPS call failed", (Throwable)a22);
            a = new AmazonSocialException(7, null, null);
        }
        throw a;
    }

    private SharingMetadata fillMetadata(Book a, Position a2, Position a3) {
        Position a4;
        SharingServerCaller a5;
        BookMetadata a6 = a.getMetadata();
        SharingMetadata a7 = new SharingMetadata();
        a7.setStatus(a5.h);
        if (d.equalsIgnoreCase(a6.getCdeType())) {
            return a7;
        }
        a7.setBookTitle(a6.getTitle());
        a7.setPublicationDate(a6.getPublicationDate());
        if (a6.getAuthors() != null) {
            a7.setAuthors(new String[]{a6.getAuthors()});
        }
        Position position = a4 = a2 != null ? a2 : a3;
        if (a4 == null) {
            return a7;
        }
        String a8 = null;
        String a9 = null;
        String[] a10 = null;
        TableOfContents a11 = a.getTOC();
        if (a11 != null) {
            TableOfContentsEntry a12 = a11.getTOCFromPosition(a4);
            TableOfContentsEntry a13 = null;
            TableOfContentsEntry a14 = null;
            try {
                while (a12 != null) {
                    if (a13 == null && "article".equals(a12.getNodeType())) {
                        a13 = a12;
                    } else if (a14 == null && "section".equals(a12.getNodeType())) {
                        a14 = a12;
                    }
                    a12 = a11.getParent(a12);
                }
            }
            catch (TOCException a15) {
                f.error(i, null, null, (Throwable)a15);
            }
            if (a13 != null) {
                a8 = a13.getLabel();
                a10 = a13.getAuthors();
            }
            if (a14 != null) {
                a9 = a14.getLabel();
                if (a10 == null) {
                    a10 = a14.getAuthors();
                }
            }
        }
        a7.setSectionTitle(a9);
        a7.setArticleTitle(a8);
        if (a10 != null) {
            a7.setAuthors(a10);
        }
        return a7;
    }

    private String getBookText(String a) {
        SharingServerCaller a2;
        if (d.equals(a) || a2.l == null || a2.k == null) {
            return null;
        }
        String a3 = a2.c.getWords(a2.l, a2.k);
        int a4 = 1400;
        if (j.equals(a) || g.equals(a)) {
            a4 = 700;
        }
        return StringUtil.shortenTextByWords((String)a3, (int)a4, (Locale)Locale.getDefault());
    }

    private static String positionToSafeString(Position a) {
        if (a == null) {
            return null;
        }
        if (a instanceof ByteOffsetBasedPosition) {
            return Integer.toString(((ByteOffsetBasedPosition)a).getInternalOffset());
        }
        if (a instanceof PDFPosition) {
            return "0";
        }
        f.error(E, new String[]{a.getClass().getName()}, null);
        return "0";
    }

    private String getNonemptyStringOrNull(Object a) {
        if (a == null) {
            return null;
        }
        if (a.toString().trim().length() == 0) {
            return null;
        }
        return a.toString();
    }
}

