/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.sharing.clippings;

import com.amazon.ebook.booklet.reader.plugin.sharing.clippings.SocialClippingInterval;
import com.amazon.ebook.booklet.reader.plugin.sharing.clippings.SocialClippingsTree;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.BookMetadata;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SocialClippings {
    private static final Log k = Log.getInstance((String)"SocialClipping");
    private static final LogMessage m = new LogMessage("UnableToCreateDirectory", new String[]{"path"});
    private static final String h = "sc.";
    private static final String A = ".gz";
    private SocialClippingsTree H;
    private String b;
    private boolean K;
    private String B;
    private int D;

    public SocialClippings(String a) {
        SocialClippings a2;
        if (!a.endsWith(File.separator)) {
            a = a + File.separator;
        }
        a2.H = new SocialClippingsTree();
        a2.b = a;
        a2.K = false;
        File a3 = new File(a);
        if (!a3.exists() && !a3.mkdirs()) {
            k.error(m, new String[]{null}, null, null);
        }
    }

    public void setBook(Book a, List a2) {
        SocialClippings a3;
        BookMetadata a4 = a.getMetadata();
        String a5 = a4.getASIN();
        if (a5 == null || a5.length() == 0) {
            a5 = a4.getTitle();
        }
        if (Log.isDebugOn()) {
            k.debug("CDE Key: " + a4.getCdeKey());
            k.debug("CDE Type: " + a4.getCdeType());
            k.debug("Version: " + a4.getVersion());
            k.debug("GUID: " + a4.getGUID());
            k.debug("Clipping limit: " + a4.getClippingLimit() + '%');
        }
        int a6 = a.getBookLength();
        int a7 = a4.getClippingLimit();
        int a8 = a7 < 0 || a7 >= 100 ? Integer.MAX_VALUE : a6 * a7 / 100;
        a3.setBook(a5, a8);
        int a9 = a3.H.getTotalCount();
        a3.setSavingOn(false);
        int a10 = 0;
        int a11 = a2.size();
        int n = a10;
        while (n < a11) {
            Annotation a12 = (Annotation)a2.get(a10);
            if (a12.getType() == 1 || a12.getType() == 3) {
                SocialClippingInterval a13 = new SocialClippingInterval(a12);
                a3.addInterval(a13);
            }
            n = ++a10;
        }
        a3.setSavingOn(true);
        if (a9 != a3.H.getTotalCount()) {
            a3.save();
        }
    }

    protected void setBook(String a, int a2) {
        SocialClippings a3;
        a3.B = a;
        a3.D = a2;
        a3.K = true;
        if (Log.isDebugOn()) {
            k.debug("New book " + a + " with " + a2 + " max positions allowed.");
        }
        a3.load();
    }

    public boolean isLimitReached() {
        SocialClippings a;
        return a.H.getTotalCount() >= a.D;
    }

    public int getMaxPositionsAllowed() {
        SocialClippings a;
        return a.D;
    }

    public int getPositionCountLeft() {
        SocialClippings a;
        return a.D - a.H.getTotalCount();
    }

    public int getIntervalCount() {
        SocialClippings a;
        return a.H.size();
    }

    public Iterator iterator() {
        SocialClippings a;
        return a.H.iterator();
    }

    public boolean canShareInterval(SocialClippingInterval a) {
        SocialClippings a2;
        if (a2.H.getTotalCount() + a2.H.numberOfNewPositions(a) > a2.D) {
            if (Log.isDebugOn()) {
                k.debug("Interval " + a + " cannot be added");
            }
            return false;
        }
        if (Log.isDebugOn()) {
            k.debug("Interval " + a + " can be added");
        }
        return true;
    }

    public void addExtraCount(int a) {
        SocialClippings a2;
        if (a < 1) {
            return;
        }
        SocialClippingInterval a3 = a2.H.getInterval(-2);
        if (a > a2.getMaxPositionsAllowed() - a2.H.getTotalCount()) {
            a = a2.getMaxPositionsAllowed() - a2.H.getTotalCount();
        }
        if (a3 == null) {
            a2.addInterval(new SocialClippingInterval(-1 - a, -2));
        } else {
            a2.addInterval(new SocialClippingInterval(a3.getStart() - a, a3.getStart()));
        }
    }

    public int addInterval(SocialClippingInterval a) {
        SocialClippings a2;
        int a3 = a2.H.add(a, a2.D - a2.H.getTotalCount());
        if (Log.isDebugOn()) {
            k.debug("Interval " + a + " succeeded with " + a3 + " new positions");
        }
        if (a3 > 0) {
            a2.save();
        }
        return a3;
    }

    public SocialClippingInterval getInterval(int a) {
        SocialClippings a2;
        return a2.H.getInterval(a);
    }

    public void clear() {
        SocialClippings a;
        a.H.clear();
        a.save();
    }

    public void setSavingOn(boolean a) {
        a.K = a;
    }

    public String toString() {
        SocialClippings a;
        Object[] a2 = new Object[]{a.B, new Integer(a.getPositionCountLeft()), new Integer(a.D), a.H};
        return MessageFormat.format("Position Count Left: {0} Max Positions Allowed: {1} Intervals: {3}", a2);
    }

    public String getFilePath() {
        SocialClippings a;
        return a.b + h + a.B + A;
    }

    public boolean load() {
        SocialClippings a;
        a.H.clear();
        if (a.B == null) {
            k.error("SocialClipping#load: no bookID has been specified!");
        } else if (new File(a.getFilePath()).exists()) {
            try {
                DataInputStream a2 = new DataInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(a.getFilePath()))));
                a.H.fromStream(a2);
                a2.close();
                if (Log.isDebugOn()) {
                    k.debug("Loaded SocialClipping: " + a.toString());
                }
                return true;
            }
            catch (IOException a3) {
                if (Log.isDebugOn()) {
                    k.debug("SocialClipping#load: failed to open SocialClipping for BookID: " + a.B, (Throwable)a3);
                }
            }
            catch (Exception a4) {
                k.error("SocialClipping#load: failed to open SocialClipping for BookID: " + a.B, (Throwable)a4);
            }
        }
        return false;
    }

    public void save() {
        SocialClippings a;
        if (a.K) {
            if (a.B != null) {
                try {
                    DataOutputStream a2 = new DataOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(a.getFilePath()))));
                    a.H.toStream(a2);
                    a2.close();
                    if (Log.isDebugOn()) {
                        k.debug("Saved SocialClipping: " + a.toString());
                    }
                }
                catch (Exception a3) {
                    k.error("SocialClipping#save: failed to save SocialClipping for bookID: " + a.B, (Throwable)a3);
                }
            } else {
                k.error("SocialClipping#save: no bookID has been specified!");
            }
        }
    }
}

