/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.sharing;

import com.amazon.ebook.booklet.reader.plugin.sharing.AmazonSocialException;
import com.amazon.ebook.booklet.reader.plugin.sharing.SharingLipc;
import com.amazon.ebook.booklet.reader.plugin.sharing.clippings.SocialClippingInterval;
import com.amazon.ebook.booklet.reader.plugin.sharing.clippings.SocialClippings;
import com.amazon.ebook.booklet.reader.plugin.sharing.requests.AnnotationShareRequest;
import com.amazon.ebook.booklet.reader.plugin.sharing.requests.BookEventRequest;
import com.amazon.ebook.booklet.reader.plugin.sharing.requests.ShareRequest;
import com.amazon.ebook.booklet.reader.plugin.sharing.requests.SharingServerCaller;
import com.amazon.ebook.booklet.reader.plugin.sharing.ui.EnterYourMessageDialog;
import com.amazon.ebook.booklet.reader.plugin.sharing.ui.SharingUI;
import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.ReaderPlugin;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.Interval;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.SharingManager;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationManager;
import com.amazon.ebook.booklet.reader.sdk.event.AnnotationEventHandler;
import com.amazon.ebook.booklet.reader.sdk.event.EventHandler;
import com.amazon.ebook.booklet.reader.sdk.event.OpenBookHandler;
import com.amazon.ebook.booklet.reader.sdk.event.ShownBookHandler;
import com.amazon.ebook.booklet.reader.utils.FrameworkUtil;
import com.amazon.ebook.util.thread.ThreadPool;
import com.amazon.kindle.acx.ACXUIControllerInterface;
import com.amazon.kindle.apps.util.CommunicationUtils;
import com.amazon.kindle.booklet.Booklet;
import java.io.File;
import java.util.Map;

public class SharingManagerImpl
extends ReaderPlugin
implements SharingManager,
OpenBookHandler,
ShownBookHandler,
AnnotationEventHandler {
    private static final String m = "generic";
    private ReaderSDK h;
    private SharingUI A;
    private SocialClippings H;
    private SharingServerCaller b;
    private Map K;
    private SharingLipc B;

    public SharingManagerImpl() {
        SharingManagerImpl a;
    }

    public String getName() {
        return "Sharing";
    }

    public void pluginLoad(ReaderSDK a) throws BookException {
        SharingManagerImpl a2;
        a2.h = a;
        a2.A = new SharingUI(a);
        a2.H = new SocialClippings(a2.getSocialClippingsDirectory());
        a2.B = new SharingLipc(a);
        a.getRegistry().registerHandler((EventHandler)a2);
    }

    public void pluginUnload() {
        SharingManagerImpl a;
        a.h.getRegistry().deregisterHandler((EventHandler)a);
        a.A = null;
        a.H = null;
        a.B.close();
        a.B = null;
    }

    public void openBookEvent(Book a, boolean a2) {
        SharingManagerImpl a3;
        a3.H.setBook(a, a3.h.getAnnotationManager().getAllAnnotationsInBook(a));
    }

    public void shownBookEvent(Book a) {
        SharingManagerImpl a2;
        if (a2.b != null) {
            if (a.equals(a2.b.getBook())) {
                if (a2.K != null) {
                    ((ACXUIControllerInterface)a2.h.getService(ACXUIControllerInterface.class)).restoreACXUI(a2.K);
                }
                ThreadPool.getInstance().runIt((Runnable)a2.b, "SharingRunnable");
            }
            a2.b = null;
            a2.K = null;
        }
    }

    public boolean isSharingEnabled(Book a) {
        SharingManagerImpl a2;
        return a != null && !a.getMetadata().isSample() && CommunicationUtils.isRegistered((Booklet)((Booklet)a2.h.getActiveBooklet()));
    }

    public void shareBookText(Book a, Interval a2, boolean a3, boolean a4, AnnotationManager a5) {
        SharingManagerImpl a6;
        if (!a6.isSharingEnabled(a)) {
            return;
        }
        if (a6.canShareInterval(a, a2)) {
            AnnotationShareRequest a7 = new AnnotationShareRequest(a6.h, a, a2, a3, a4, a5);
            a6.postDialog(a7);
        } else {
            SharingServerCaller a8 = new SharingServerCaller(a6.h, a, null, a2.getStartPosition(), a2.getEndPosition(), null, null, null);
            AmazonSocialException a9 = new AmazonSocialException(8, null, null);
            a6.A.finishSending(a8, a9);
        }
    }

    public void shareBookEvent(Book a, String a2, Position a3, String a4) {
        SharingManagerImpl a5;
        if (!a5.isSharingEnabled(a)) {
            return;
        }
        BookEventRequest a6 = new BookEventRequest(a5.h, a, a2, a3, a4);
        a5.postDialog(a6);
    }

    public void shareMessageAboutBook(Book a, String a2) {
        SharingManagerImpl a3;
        if (!a3.isSharingEnabled(a)) {
            return;
        }
        BookEventRequest a4 = new BookEventRequest(a3.h, a, m, null, a2);
        a3.postDialog(a4);
    }

    public void addAnnotationEvent(Annotation a) {
        if (a.getType() == 1 || a.getType() == 3) {
            SharingManagerImpl a2;
            a2.H.addInterval(new SocialClippingInterval(a));
        }
    }

    public void deleteAnnotationEvent(Annotation a) {
    }

    public void updateAnnotationEvent(Annotation a) {
    }

    public boolean canShareInterval(Book a, Interval a2) {
        SharingManagerImpl a3;
        SocialClippingInterval a4 = new SocialClippingInterval(a2);
        SocialClippings a5 = a3.H;
        if (!a.equals(a3.h.getCurrentBook())) {
            a5 = new SocialClippings(a3.getSocialClippingsDirectory());
            a5.setBook(a, a3.h.getAnnotationManager().getAllAnnotationsInBook(a));
        }
        return a5.canShareInterval(a4);
    }

    public void setPendingShare(SharingServerCaller a, Map a2) {
        a.b = a;
        a.K = a2;
    }

    public SharingUI getUI() {
        SharingManagerImpl a;
        return a.A;
    }

    private void postDialog(final ShareRequest a) {
        SharingManagerImpl a2;
        a2.h.invokeLater(new Runnable(){
            {
                1 a2;
            }

            public void run() {
                1 a2;
                new EnterYourMessageDialog(a2.SharingManagerImpl.this.h, a2.a).postDialog();
            }
        });
    }

    private String getSocialClippingsDirectory() {
        return FrameworkUtil.getPreferenceDirectory() + File.separator + "social-clippings";
    }
}

