/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.sharing;

import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.Interval;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.PositionFactory;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.kindle.util.lipc.LipcException;
import com.amazon.kindle.util.lipc.LipcPropertyAdapter;
import com.amazon.kindle.util.lipc.LipcPropertyProvider;
import com.amazon.kindle.util.lipc.LipcService;
import com.amazon.kindle.util.lipc.LipcSource;
import java.io.IOException;
import java.io.InvalidObjectException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SharingLipc
extends LipcPropertyAdapter {
    private static final Log C = Log.getInstance((String)"SharingLipc");
    private static final LogMessage d = new LogMessage("InvalidJson", new String[]{"json"});
    private static final LogMessage j = new LogMessage("MissingArg", new String[]{"method", "json", "missing"});
    private static final LogMessage g = new LogMessage("MalformedArg", new String[]{"method", "json", "argName"});
    private static final String e = "com.lab126.sharing";
    private static final String I = "isSharingEnabled";
    private static final String F = "shareBookText";
    private static final String L = "shareBookEvent";
    private static final String c = "shareMessageAboutBook";
    private static final String l = "interval";
    private static final String k = "is_selection";
    private static final String m = "should_shrink_highlight";
    private static final String h = "event";
    private static final String A = "position";
    private static final String H = "message_prefill";
    private static final String b = "message_prefill";
    private final ReaderSDK K;
    private final JSONParser B;
    private LipcSource D;

    public SharingLipc(ReaderSDK a) {
        SharingLipc a2;
        a2.K = a;
        a2.B = new JSONParser();
        try {
            LipcService a3 = LipcService.getInstance();
            if (a3 != null) {
                a2.D = a3.createSource(e);
            }
        }
        catch (LipcException a4) {
            C.error(Log.LIPC_EX, new String[]{Integer.toString(a4.getErrorCode())}, "Failed to create lipc source", (Throwable)a4);
        }
        if (a2.D != null) {
            try {
                a2.D.exportIntProperty(I, (LipcPropertyProvider)a2, 1);
                a2.D.exportStringProperty(F, (LipcPropertyProvider)a2, 2);
                a2.D.exportStringProperty(L, (LipcPropertyProvider)a2, 2);
                a2.D.exportStringProperty(c, (LipcPropertyProvider)a2, 2);
            }
            catch (LipcException a5) {
                C.error(Log.LIPC_EX, new String[]{Integer.toString(a5.getErrorCode())}, "Error registering lipc properties", (Throwable)a5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SharingLipc a;
        if (a.D != null) {
            try {
                try {
                    a.D.removeExportedProperty(I);
                    a.D.removeExportedProperty(F);
                    a.D.removeExportedProperty(L);
                    a.D.removeExportedProperty(c);
                    a.D.close();
                }
                catch (LipcException a2) {
                    C.error(Log.LIPC_EX, new String[]{Integer.toString(a2.getErrorCode())}, "Error unregistering lipc properties", (Throwable)a2);
                    Object var3_2 = null;
                    a.D = null;
                }
                Object var3_1 = null;
                a.D = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                a.D = null;
                throw throwable;
            }
        }
    }

    public int getIntProperty(String a) throws LipcException {
        SharingLipc a2;
        if (I.equalsIgnoreCase(a)) {
            return a2.K.getSharingManager().isSharingEnabled(a2.K.getCurrentBook()) ? 1 : 0;
        }
        return super.getIntProperty(a);
    }

    public void setProperty(String a, String a2) throws LipcException {
        Object a3;
        SharingLipc a4;
        if (!(F.equalsIgnoreCase(a) || L.equalsIgnoreCase(a) || c.equalsIgnoreCase(a))) {
            super.setProperty(a, a2);
            return;
        }
        try {
            a3 = a4.B.parse(a2);
        }
        catch (ParseException a5) {
            C.error(d, new String[]{a2}, "Invalid JSON", (Throwable)a5);
            throw new LipcException(a5.getMessage(), 12);
        }
        if (!(a3 instanceof JSONObject)) {
            C.error(d, new String[]{a2}, "JSON not an object");
            throw new LipcException("JSON value is not an object", 12);
        }
        JSONObject a6 = (JSONObject)a3;
        try {
            if (F.equalsIgnoreCase(a)) {
                a4.shareBookText(a2, a6);
            } else if (L.equalsIgnoreCase(a)) {
                a4.shareBookEvent(a2, a6);
            } else if (c.equalsIgnoreCase(a)) {
                a4.shareGenericBookMessage(a2, a6);
            }
        }
        catch (ClassCastException a7) {
            C.error(g, new String[]{a, a2, "?"}, "One of the values was not of the expected class", (Throwable)a7);
            throw new LipcException(a7.getMessage(), 12);
        }
    }

    private void shareBookText(String a, JSONObject a2) throws LipcException {
        Interval a3;
        SharingLipc a4;
        JSONArray a5;
        if (!a2.containsKey((Object)l)) {
            C.error(j, new String[]{F, a, l}, "Missing required argument: interval");
            throw new LipcException("Missing required parameter: interval", 12);
        }
        boolean a6 = false;
        boolean a7 = false;
        if (a2.containsKey((Object)k)) {
            a6 = (Boolean)a2.get((Object)k);
        }
        if (a2.containsKey((Object)m)) {
            a7 = (Boolean)a2.get((Object)m);
        }
        if ((a5 = (JSONArray)a2.get((Object)l)).size() != 2) {
            C.error(g, new String[]{F, a, l}, "Malformed parameter: interval");
            throw new LipcException("Malformed parameter: interval", 12);
        }
        Book a8 = a4.K.getCurrentBook();
        PositionFactory a9 = a4.K.getPositionFactory(a8);
        try {
            Position a10 = a9.createInstance((String)a5.get(0), a8);
            Position a11 = a9.createInstance((String)a5.get(1), a8);
            a3 = Interval.create((Position)a10, (Position)a11);
        }
        catch (InvalidObjectException a12) {
            C.error(g, new String[]{F, a, l}, "Malformed parameter: interval", (Throwable)a12);
            throw new LipcException(a12.getMessage(), 12);
        }
        catch (IOException a13) {
            C.error(g, new String[]{F, a, l}, "Malformed parameter: interval", (Throwable)a13);
            throw new LipcException(a13.getMessage(), 12);
        }
        a4.K.getSharingManager().shareBookText(a8, a3, a6, a7, null);
    }

    private void shareBookEvent(String a, JSONObject a2) throws LipcException {
        Position a3;
        SharingLipc a4;
        if (!a2.containsKey((Object)h)) {
            C.error(j, new String[]{L, a, h}, "Missing required argument: event");
            throw new LipcException("Missing required parameter: event", 12);
        }
        if (!a2.containsKey((Object)A)) {
            C.error(j, new String[]{L, a, A}, "Missing required argument: position");
            throw new LipcException("Missing required parameter: position", 12);
        }
        Book a5 = a4.K.getCurrentBook();
        String a6 = (String)a2.get((Object)h);
        String a7 = (String)a2.get((Object)A);
        String a8 = a2.containsKey((Object)"message_prefill") ? (String)a2.get((Object)"message_prefill") : null;
        PositionFactory a9 = a4.K.getPositionFactory(a5);
        if (!("done".equalsIgnoreCase(a6) || "read".equalsIgnoreCase(a6) || "start".equalsIgnoreCase(a6))) {
            C.error(g, new String[]{L, a, h}, "Malformed parameter: event");
            throw new LipcException("Malformed parameter: event", 12);
        }
        try {
            a3 = a9.createInstance(a7, a5);
        }
        catch (InvalidObjectException a10) {
            C.error(g, new String[]{L, a, A}, "Malformed parameter: position", (Throwable)a10);
            throw new LipcException(a10.getMessage(), 12);
        }
        catch (IOException a11) {
            C.error(g, new String[]{L, a, A}, "Malformed parameter: position", (Throwable)a11);
            throw new LipcException(a11.getMessage(), 12);
        }
        a4.K.getSharingManager().shareBookEvent(a5, a6, a3, a8);
    }

    private void shareGenericBookMessage(String a, JSONObject a2) throws LipcException {
        SharingLipc a3;
        String a4 = a2.containsKey((Object)"message_prefill") ? (String)a2.get((Object)"message_prefill") : null;
        a3.K.getSharingManager().shareMessageAboutBook(a3.K.getCurrentBook(), a4);
    }
}

