/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.search;

import com.amazon.agui.swing.CommandBar;
import com.amazon.agui.swing.DefaultIndexedListModel;
import com.amazon.agui.swing.HeaderBar;
import com.amazon.agui.swing.IndexedListModel;
import com.amazon.agui.swing.IndexedListRendererFactory;
import com.amazon.agui.swing.IndexedModelScrollPane;
import com.amazon.agui.swing.InteractiveList;
import com.amazon.agui.swing.ListCursorChangeEvent;
import com.amazon.agui.swing.ListCursorChangeListener;
import com.amazon.agui.swing.event.GestureDispatcher;
import com.amazon.agui.swing.event.GestureEvent;
import com.amazon.ebook.booklet.reader.plugin.search.ContentSearchEngine;
import com.amazon.ebook.booklet.reader.plugin.search.SearchEngine;
import com.amazon.ebook.booklet.reader.plugin.search.SearchResultSelectionListener;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.ByteOffsetBasedPosition;
import com.amazon.ebook.booklet.reader.sdk.content.FontPreferences;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.PositionFactory;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderAction;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUI;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUIContext;
import com.amazon.ebook.booklet.reader.sdk.ui.html.BoldTag;
import com.amazon.ebook.booklet.reader.sdk.ui.html.MiddleClassTextView;
import com.amazon.ebook.booklet.reader.sdk.ui.html.SnippetTag;
import com.amazon.ebook.booklet.reader.sdk.util.PeriodicalsUtil;
import com.amazon.ebook.booklet.reader.utils.FrameworkUtil;
import com.amazon.ebook.booklet.reader.utils.UIUtils;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.ebook.util.net.XMLUtil;
import com.amazon.ebook.util.text.FontCache;
import com.amazon.ebook.util.text.LanguageTag;
import com.amazon.ebook.util.text.StringUtil;
import com.amazon.kindle.booklet.BookletContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class SearchResultsPane
extends ReaderUIContext {
    private static final Log LOG = Log.getInstance((String)"SearchResultsPane");
    private static final LogMessage SEARCH_RESULT_SKIPPED = new LogMessage("SearchResultSkipped", new String[]{"position"});
    private static final String SEARCH_RESULTS_PANE_RESOURCE_BUNDLE_NAME = "com.amazon.ebook.booklet.reader.plugin.search.resources.SearchResultsPaneResources";
    private static final String READER_RESOURCE_BUNDLE_NAME = "com.amazon.ebook.booklet.reader.resources.ReaderResources";
    private static final int SNIPPET_MIN_LINES = 3;
    private final ReaderSDK mReaderSDK;
    private final BookletContext mContext;
    private final ReaderUI mReaderUI;
    private final IndexedModelScrollPane mScrollPane;
    private final int mScrollPaneMaxRows;
    private final Locale mContentLocale;
    private final LanguageTag.TextDirection mContentDirection;
    private final Book mBook;
    private final String mSearch;
    private final SearchEngine mSearchEngine;
    private final SearchEngine.SearchListener mSearchListener;
    private final SearchResultSelectionListener mSearchSelector;
    private final int mStartIndex;
    private final int mMaxWordsBeforeSearchedTerms;
    private final int mMaxWordsAfterSearchedTerms;
    private final boolean mDecorateSnippet;
    private final MessageFormat mSnippetFormat;
    private final int mSnippetMarginTop;
    private final int mSnippetMarginBottom;
    private final Font mSnippetLocationFont;
    private final MessageFormat mSnippetLocationWithPage;
    private final MessageFormat mSnippetLocationWithNoPage;
    private final HeaderBar mHeader;
    private final JPanel mFooter;
    private final int mBaseLeftMargin;
    private final int mBaseRightMargin;
    private final int[] mFontSizes;
    private final int[] mLineSpacings;
    private final String mSpinnerText;
    private final boolean mUseSeparator;
    private final MessageFormat mHeaderPrimaryFormatter;
    private final String mHeaderSecondaryNotIndexed;
    private final String mHeaderSecondaryFailure;
    private final MessageFormat mHeaderEndFormatter;
    private final Border mPanelBorder;
    private final Border mScrollPaneBorder;
    private final int mFooterButtonGap;
    private final Border mFooterBorder;
    private final String mGotoDialogTitle;
    private boolean mIsNotIndexed = false;
    private boolean mQuerySuccessful = false;
    private List mMatches = null;
    private InteractiveList mList = null;
    private DefaultIndexedListModel mModel = null;
    private FontPreferences mFontPreferences = null;
    private CommandBar commandBar;

    public SearchResultsPane(ReaderSDK a, SearchEngine a2, SearchResultSelectionListener a3, Book a4, String a5, int a6) {
        super(a);
        SearchResultsPane a7;
        a7.mReaderSDK = a;
        a7.mContext = (BookletContext)a7.mReaderSDK.getActiveContext();
        a7.mReaderUI = a7.mReaderSDK.getUI();
        a7.mSearchEngine = a2;
        a7.mSearchSelector = a3;
        a7.mSearchListener = a7.new SearchResultsListener();
        a7.mBook = a4;
        a7.mSearch = a5;
        a7.mStartIndex = a6;
        String a8 = a7.mBook.getMetadata().getContentLanguage(true);
        a7.mContentLocale = LanguageTag.toLocale((String)a8);
        a7.mContentDirection = LanguageTag.getTextDirection((String)a8);
        ResourceBundle a9 = ResourceBundle.getBundle(SEARCH_RESULTS_PANE_RESOURCE_BUNDLE_NAME);
        ResourceBundle a10 = ResourceBundle.getBundle(READER_RESOURCE_BUNDLE_NAME);
        a7.mMaxWordsBeforeSearchedTerms = (Integer)a9.getObject("snippet.rewind");
        a7.mMaxWordsAfterSearchedTerms = (Integer)a9.getObject("snippet.maxwords");
        a7.mDecorateSnippet = (Boolean)a9.getObject("snippet.decorate");
        a7.mSnippetFormat = (MessageFormat)a9.getObject("snippet.format.dnt");
        a7.mSnippetMarginTop = (Integer)a9.getObject("snippet.margin.top");
        a7.mSnippetMarginBottom = (Integer)a9.getObject("snippet.margin.bottom");
        a7.mSnippetLocationFont = FontCache.getInstance().get(a9.getString("snippet.location.font.family"), 1, ((Integer)a9.getObject("snippet.location.font.size")).intValue());
        a7.mSnippetLocationWithPage = (MessageFormat)a9.getObject("snippet.location.with_page_number.format");
        a7.mSnippetLocationWithNoPage = (MessageFormat)a9.getObject("snippet.location.with_no_page_number.format");
        a7.mHeader = new HeaderBar(null, null, null);
        a7.mFooter = new JPanel(new BorderLayout());
        a7.mFontSizes = UIUtils.flatten((int[][])((int[][])a10.getObject("font.menu.size.list")));
        a7.mLineSpacings = (int[])a9.getObject("snippet.line.spacings");
        a7.mBaseLeftMargin = ((Insets)a9.getObject((String)"scrollpane.border.insets")).left + ((Insets)a9.getObject((String)"panel.border.insets")).left;
        a7.mBaseRightMargin = ((Insets)a9.getObject((String)"scrollpane.border.insets")).right + ((Insets)a9.getObject((String)"panel.border.insets")).right;
        a7.mScrollPaneMaxRows = (Integer)a9.getObject("scrollpane.max_rows");
        a7.mScrollPane = new IndexedModelScrollPane();
        a7.mSpinnerText = (String)a9.getObject("spinner.text");
        a7.mUseSeparator = (Boolean)a9.getObject("scrollpane.separator");
        a7.mHeaderPrimaryFormatter = (MessageFormat)a9.getObject("header.primary.format");
        a7.mHeaderSecondaryNotIndexed = a9.getString("header.secondary.not_indexed");
        a7.mHeaderSecondaryFailure = a9.getString("header.secondary.failure");
        a7.mHeaderEndFormatter = (MessageFormat)a9.getObject("header.end.format");
        a7.mPanelBorder = new EmptyBorder((Insets)a9.getObject("panel.border.insets"));
        a7.mScrollPaneBorder = new EmptyBorder((Insets)a9.getObject("scrollpane.border.insets"));
        a7.mFooterButtonGap = (Integer)a10.getObject("footer.button.gap");
        a7.mFooterBorder = (Border)a10.getObject("footer.border");
        a7.mGotoDialogTitle = a10.getString("goto.dialog.title");
        a7.commandBar = new CommandBar();
        a7.commandBar.setButtonWidthPreserved(false);
        a7.commandBar.setHorizontalGap(a7.mFooterButtonGap);
        a7.commandBar.setBorder(a7.mFooterBorder);
    }

    public void showSearchResults() {
        SearchResultsPane a;
        FrameworkUtil.startSpinner((ReaderSDK)a.mReaderSDK, (String)a.mSpinnerText);
        if (a.mSearchEngine instanceof ContentSearchEngine) {
            HashMap<String, String> a2 = new HashMap<String, String>();
            String a3 = "";
            if (a.mBook != null && a.mBook.getMetadata() != null) {
                a3 = a.mBook.getMetadata().getASIN();
            }
            a2.put("asin", a3);
            a2.put("path", a.mBook.getPath());
            a2.put("terms", a.mSearch);
            a.mSearchEngine.search(a2, a.mSearchListener);
        } else if (a.mSearchEngine instanceof SearchEngine) {
            a.mSearchEngine.search(null, a.mSearchListener);
        }
    }

    private String buildLocationText(Object a) throws InvalidObjectException, IOException {
        Object[] a2;
        String a3;
        SearchResultsPane a4;
        Position a5 = a4.mReaderSDK.getPositionFactory(a4.mBook).createInstance(a.toString(), a4.mBook);
        if (PeriodicalsUtil.isPeriodical((Book)a4.mBook)) {
            a3 = a4.mBook.getTOC();
            if (a3 != null && (a2 = a3.getTOCFromPosition(a5)) != null) {
                int a6 = a4.mContext.getUIContainer().getWidth() - a4.mScrollPane.getBorder().getBorderInsets((Component)a4.mScrollPane).right - a4.mScrollPane.getBorder().getBorderInsets((Component)a4.mScrollPane).left - Math.max(a4.mReaderUI.getContentRightMargin() - a4.mBaseRightMargin, a4.mBaseRightMargin) - Math.max(a4.mReaderUI.getContentLeftMargin() - a4.mBaseLeftMargin, a4.mBaseLeftMargin);
                return StringUtil.shortenText((FontMetrics)a4.getFontMetrics(a4.mSnippetLocationFont), (String)a2.getLabel(), (int)a6);
            }
            String a7 = "";
            if (a4.mBook != null && a4.mBook.getMetadata() != null) {
                a7 = a4.mBook.getMetadata().getASIN();
            }
            LOG.warning(SEARCH_RESULT_SKIPPED, new String[]{a7}, "Cannot build title text for periodical, returning default location text");
        }
        a3 = "";
        if (a5 instanceof ByteOffsetBasedPosition && a4.mReaderSDK.getPageNumberManager().isPageNumberingSupported()) {
            a2 = new Object[]{a5.getUIString(false), a4.mReaderSDK.getPageNumberManager().getPageLabelForLastPosition((ByteOffsetBasedPosition)a5)};
            a3 = a4.mSnippetLocationWithPage.format(a2);
        }
        if (a3.equals("")) {
            a3 = a4.mSnippetLocationWithNoPage.format(new Object[]{a5.getUIString(false)});
        }
        return a3;
    }

    private String serializePositions(Object[] a) {
        StringBuffer a2 = new StringBuffer();
        if (a != null && a.length > 0) {
            int a3;
            int n = a3 = 0;
            while (n < a.length) {
                if (a[a3] != null) {
                    a2.append(a[a3].toString());
                    if (a3 < a.length - 1) {
                        a2.append(',');
                    }
                }
                n = ++a3;
            }
        }
        return a2.toString();
    }

    private String buildSnippetMCV(Object[] a) {
        SearchResultsPane a2;
        String a3 = null;
        String a4 = a2.serializePositions(a);
        if (a4 != null && a4.length() > 0) {
            try {
                StringBuffer a5 = new StringBuffer();
                XMLUtil.appendEscaped((StringBuffer)a5, (String)a2.buildLocationText(a[0]));
                StringBuffer a6 = new StringBuffer();
                XMLUtil.appendEscaped((StringBuffer)a6, (String)a2.mBook.getPath());
                Object[] a7 = new Object[]{a2.mSnippetLocationFont.getFamily(), new Integer(a2.mSnippetLocationFont.getSize()), a5.toString(), a4, new Integer(a2.mMaxWordsAfterSearchedTerms).toString(), new Integer(a2.mMaxWordsBeforeSearchedTerms).toString(), new Boolean(a2.mDecorateSnippet).toString(), a6.toString()};
                a3 = a2.mSnippetFormat.format(a7);
            }
            catch (Exception a8) {
                LOG.warning(SEARCH_RESULT_SKIPPED, new String[]{a.toString()}, null, (Throwable)a8);
            }
        }
        return a3 != null ? a3 : "";
    }

    public JComponent createChromeFooter(boolean a) {
        return null;
    }

    private void showSearchResults(final int a, final List a2) {
        SearchResultsPane a3;
        a3.readerSDK.invokeLater(new Runnable(){
            {
                1 a3;
            }

            public void run() {
                1 a6;
                if (a6.a2 == null || a6.a2.isEmpty()) {
                    a6.SearchResultsPane.this.remove((Component)a6.SearchResultsPane.this.mScrollPane);
                } else {
                    SearchResultsListCursorChangeListener a22 = new SearchResultsListCursorChangeListener();
                    SearchResultsRendererFactory a3 = new SearchResultsRendererFactory();
                    int a4 = a6.SearchResultsPane.this.getScrollpaneRows();
                    int a5 = a6.a - a6.a % a4;
                    a6.SearchResultsPane.this.mModel = new DefaultIndexedListModel(a6.a2);
                    a6.SearchResultsPane.this.mModel.setCursor(a5);
                    a6.SearchResultsPane.this.mModel.addCursorChangeListener((ListCursorChangeListener)a22);
                    a6.SearchResultsPane.this.mList = new InteractiveList(1, a4, 1, a4);
                    a6.SearchResultsPane.this.mList.setModel((IndexedListModel)a6.SearchResultsPane.this.mModel);
                    a6.SearchResultsPane.this.mList.setRendererFactory((IndexedListRendererFactory)a3);
                    if (a6.SearchResultsPane.this.mUseSeparator) {
                        a6.SearchResultsPane.this.mList.setSeparatorStyle(2);
                    }
                    a6.SearchResultsPane.this.mScrollPane.setChild((JComponent)a6.SearchResultsPane.this.mList);
                }
                a6.SearchResultsPane.this.updateHeader();
                FrameworkUtil.stopSpinner((ReaderSDK)a6.SearchResultsPane.this.mReaderSDK);
                a6.SearchResultsPane.this.setVisible(true);
                a6.SearchResultsPane.this.validate();
                a6.SearchResultsPane.this.repaint();
            }
        });
    }

    private int getScrollpaneRows() {
        SearchResultsPane a;
        FontMetrics a2 = a.getFontMetrics(FontCache.getInstance().get(a.mReaderUI.getFontFamily(), 0, a.mFontSizes[a.mReaderUI.getFontSize()]));
        FontMetrics a3 = a.getFontMetrics(a.mSnippetLocationFont);
        int a4 = a2.getMaxAscent() + a2.getDescent() + a2.getLeading();
        int a5 = a3.getMaxAscent() + a3.getDescent() + a3.getLeading() + a.mLineSpacings[a.mReaderUI.getLineSpacing()] + 5 + 3 * a4 + 2 * a.mLineSpacings[a.mReaderUI.getLineSpacing()] + a.mSnippetMarginTop + a.mSnippetMarginBottom + 1;
        int a6 = a.mContext.getUIContainer().getHeight() - a.mHeader.getHeight() - a.mFooter.getHeight() - a.getBorder().getBorderInsets((Component)((Object)a)).top - a.getBorder().getBorderInsets((Component)((Object)a)).bottom - a.mScrollPane.getBorder().getBorderInsets((Component)a.mScrollPane).top - a.mScrollPane.getBorder().getBorderInsets((Component)a.mScrollPane).bottom;
        return Math.min((a6 >= 0 ? a6 : 0) / (a5 > 0 ? a5 : 1), a.mScrollPaneMaxRows);
    }

    private void updateHeader() {
        SearchResultsPane a;
        a.mHeader.setText(0, a.getPrimaryHeaderText());
        a.mHeader.setText(1, a.getSecondaryHeaderText());
        a.mHeader.setText(2, a.getEndHeaderText());
    }

    private String getPrimaryHeaderText() {
        SearchResultsPane a;
        int a2 = a.mScrollPane.getChild() != null && a.mModel != null ? a.mModel.getSize() : 0;
        Object[] a3 = new Object[]{new Integer(a2)};
        return a.mHeaderPrimaryFormatter.format(a3);
    }

    private String getSecondaryHeaderText() {
        SearchResultsPane a;
        int a2;
        int n = a2 = a.mScrollPane.getChild() != null && a.mModel != null ? a.mModel.getSize() : 0;
        if (a2 == 0 && a.mIsNotIndexed) {
            return a.mHeaderSecondaryNotIndexed;
        }
        if (!a.mQuerySuccessful) {
            return a.mHeaderSecondaryFailure;
        }
        return null;
    }

    private String getEndHeaderText() {
        SearchResultsPane a;
        int a2 = 1;
        int a3 = 1;
        if (a.mScrollPane.getChild() != null && a.mModel != null) {
            int a4 = a.mModel.getSize();
            int a5 = a.getItemsPerPage();
            if (a4 > 0 && a5 > 0) {
                a2 = a.mModel.getCursor() / a5 + 1;
                a3 = (a4 + a5 - 1) / a5;
            }
        }
        Object[] a6 = new Object[]{new Integer(a2), new Integer(a3)};
        return a.mHeaderEndFormatter.format(a6);
    }

    public int getItemsPerPage() {
        SearchResultsPane a;
        if (a.mModel == null || a.mList == null) {
            return 0;
        }
        return Math.min(Math.max(a.mList.getPageItemCount(), a.mList.getVisibleColumnCount() * a.mList.getVisibleRowCount()), a.mModel.getSize());
    }

    public void paint(Graphics a) {
        SearchResultsPane a2;
        if (a2.mFontPreferences != null && a2.mList != null && (a2.mFontPreferences.getFontFamily() != a2.mReaderUI.getFontFamily() || a2.mFontPreferences.getFontSize() != a2.mReaderUI.getFontSize() || a2.mFontPreferences.getLineSpacing() != a2.mReaderUI.getLineSpacing() || a2.mFontPreferences.getMargin().right != a2.mReaderUI.getContentRightMargin() || a2.mFontPreferences.getMargin().left != a2.mReaderUI.getContentLeftMargin())) {
            int a3 = a2.getScrollpaneRows();
            int a4 = a2.mModel.getCursor();
            int a5 = a4 - a4 % a3;
            a2.mModel.setCursor(a5);
            a2.mList.setVisibleRowCount(a3);
            a2.updateHeader();
        }
        super.paint(a);
    }

    public String getName() {
        SearchResultsPane a;
        return ((Object)((Object)a)).getClass().getName();
    }

    public Action[] getMenuActions() {
        return null;
    }

    public boolean isFullScreen() {
        return false;
    }

    public boolean isChromePersistent() {
        return true;
    }

    public boolean showFooter() {
        return false;
    }

    public void setContextLayout() {
        ReaderAction[] a;
        SearchResultsPane a2;
        a2.setFocusable(true);
        a2.requestFocusInWindow();
        a2.setVisible(false);
        GestureDispatcher a3 = new GestureDispatcher();
        a2.addMouseListener((MouseListener)a3);
        if (!a2.isChromePersistent()) {
            a = a2.getActionMap();
            a.put("tap", new AbstractAction(){
                {
                    2 a;
                }

                public void actionPerformed(ActionEvent a) {
                    2 a2;
                    FrameworkUtil.tap((ReaderSDK)a2.SearchResultsPane.this.readerSDK, (GestureEvent)((GestureEvent)a));
                }
            });
            a2.setActionMap((ActionMap)a);
        }
        a2.setLayout(new BorderLayout());
        a2.setBorder(a2.mPanelBorder);
        a2.add((Component)a2.mHeader, "North");
        a2.mScrollPane.getActionMap().setParent(a2.getActionMap());
        a2.mScrollPane.setBorder(a2.mScrollPaneBorder);
        a2.add((Component)a2.mScrollPane, "Center");
        if (a2.mReaderUI.getChromeUIContext() == null) {
            ReaderAction[] readerActionArray = new ReaderAction[2];
            a = readerActionArray;
            readerActionArray[0] = a2.mReaderUI.getFontAction();
            a[1] = a2.mReaderUI.getGotoAction(a2.mGotoDialogTitle);
        } else {
            a = a2.mReaderUI.getChromeUIContext().getChromeFooterActions();
        }
        a2.commandBar.removeAll();
        if (a != null) {
            int a4;
            int n = a4 = 0;
            while (n < a.length) {
                a2.commandBar.add((Action)a[a4]);
                n = ++a4;
            }
        }
        a2.mFooter.add((Component)a2.commandBar, "South");
        a2.add(a2.mFooter, "South");
    }

    public String getTitleBarPrimary() {
        SearchResultsPane a;
        return a.mBook.getMetadata() != null ? a.mBook.getMetadata().getTitle() : null;
    }

    public String getTitleBarSecondary() {
        return null;
    }

    public void recordHistory() {
        SearchResultsPane a;
        int a2 = a.mStartIndex;
        if (a.mModel != null) {
            a2 = a.mModel.getCursor();
        }
        a.mSearchSelector.onRecordHistory(a.mBook, a.mSearch, a.mMatches, a2);
    }

    public void switchOut() {
        SearchResultsPane a;
        a.recordHistory();
    }

    public void setChromeLayout(boolean a) {
        SearchResultsPane a2;
        if (a2.mReaderUI.getChromeUIContext() == null) {
            super.setChromeLayout(a);
        } else {
            a2.mReaderUI.getChromeUIContext().setChromeLayout(a);
        }
    }

    private class SearchResultsRendererFactory
    implements IndexedListRendererFactory {
        private SearchResultsRendererFactory() {
            SearchResultsRendererFactory a;
        }

        public JComponent createRendererFor(IndexedListModel a, int a2) {
            SearchResultsRendererFactory a3;
            int a4 = a.getCursor() + a2;
            Object[] a5 = (Object[])a.getElementAt(a4);
            MiddleClassTextView a6 = new MiddleClassTextView(a3.SearchResultsPane.this.mReaderSDK, null, a3.SearchResultsPane.this.mFontSizes[a3.SearchResultsPane.this.mReaderUI.getFontSize()], a3.SearchResultsPane.this.mReaderUI.getFontFamily(), Math.max(a3.SearchResultsPane.this.mReaderUI.getContentRightMargin() - a3.SearchResultsPane.this.mBaseRightMargin, a3.SearchResultsPane.this.mBaseRightMargin), Math.max(a3.SearchResultsPane.this.mReaderUI.getContentLeftMargin() - a3.SearchResultsPane.this.mBaseLeftMargin, a3.SearchResultsPane.this.mBaseLeftMargin), a3.SearchResultsPane.this.mSnippetMarginTop, a3.SearchResultsPane.this.mSnippetMarginBottom, a3.SearchResultsPane.this.mLineSpacings[a3.SearchResultsPane.this.mReaderUI.getLineSpacing()]);
            a6.setPageable(false);
            a6.setShowEllipses(false);
            a6.setLocale(a3.SearchResultsPane.this.mContentLocale);
            a6.setComponentDirection(a3.SearchResultsPane.this.mContentDirection);
            boolean a7 = a5 != null && a5.length > 0 && a5[0] != null;
            a6.setText(a7 ? a3.SearchResultsPane.this.buildSnippetMCV(a5) : "");
            a6.setVisible(a7);
            a6.addMouseListener((MouseListener)new GestureDispatcher());
            ActionMap a8 = new ActionMap();
            a8.put("tap", a3.new SearchResultsTapAction(a, a2));
            a6.setActionMap(a8);
            a3.SearchResultsPane.this.mFontPreferences = FontPreferences.getFontPrefsBasedOnCurrentState((ReaderUI)a3.SearchResultsPane.this.mReaderUI);
            return a6;
        }

        public JComponent createRendererFor(Object a) {
            return null;
        }

        public boolean needsDifferentRenderer(JComponent a, IndexedListModel a2, int a3) {
            return false;
        }

        public boolean needsDifferentRenderer(JComponent a, Object a2) {
            return false;
        }

        public void updateRenderer(JComponent a, IndexedListModel a2, int a3) {
            boolean a4;
            int a5 = a2.getCursor() + a3;
            Object[] a6 = (Object[])a2.getElementAt(a5);
            MiddleClassTextView a7 = (MiddleClassTextView)a;
            boolean bl = a4 = a6 != null && a6.length > 0 && a6[0] != null;
            if (a4) {
                SearchResultsRendererFactory a8;
                try {
                    int a9;
                    PositionFactory a10 = a8.SearchResultsPane.this.mReaderSDK.getPositionFactory(a8.SearchResultsPane.this.mBook);
                    Position[] a11 = new Position[a6.length];
                    int n = a9 = 0;
                    while (n < a6.length) {
                        a11[a9] = a10.createInstance(a6[a9].toString(), a8.SearchResultsPane.this.mBook);
                        n = ++a9;
                    }
                    BoldTag a22 = (BoldTag)a7.getRootTag().findTag("location");
                    SnippetTag a12 = (SnippetTag)a7.getRootTag().findTag("snippet");
                    a22.getChild(0).setText(a8.SearchResultsPane.this.buildLocationText(a6[0]));
                    a12.setPosition(a11);
                    a7.invalidateLines();
                }
                catch (Exception a13) {
                    LOG.error("failed to update html tags; falling back to re-setting html text", (Throwable)a13);
                    a7.setText(a8.SearchResultsPane.this.buildSnippetMCV(a6));
                }
            }
            a7.setVisible(a4);
        }

        public void updateRenderer(JComponent a, Object a2) {
        }

        class SearchResultsTapAction
        extends AbstractAction {
            private final IndexedListModel mListModel;
            private final int mIndexOffset;

            public SearchResultsTapAction(IndexedListModel a, int a2) {
                SearchResultsTapAction a3;
                a3.mListModel = a;
                a3.mIndexOffset = a2;
            }

            public void actionPerformed(ActionEvent a) {
                SearchResultsTapAction a2;
                int a3 = a2.mListModel.getCursor() + a2.mIndexOffset;
                SearchResultsPane.this.mSearchSelector.onRecordHistory(SearchResultsPane.this.mBook, SearchResultsPane.this.mSearch, SearchResultsPane.this.mMatches, a3);
                SearchResultsPane.this.mSearchSelector.onSearchResultSelection(SearchResultsPane.this.mBook, SearchResultsPane.this.mSearch, SearchResultsPane.this.mMatches, a3);
            }
        }
    }

    private class SearchResultsListCursorChangeListener
    implements ListCursorChangeListener {
        private SearchResultsListCursorChangeListener() {
            SearchResultsListCursorChangeListener a;
        }

        public void cursorChanged(ListCursorChangeEvent a) {
            SearchResultsListCursorChangeListener a2;
            a2.SearchResultsPane.this.updateHeader();
        }
    }

    private class SearchResultsListener
    implements SearchEngine.SearchListener {
        private SearchResultsListener() {
            SearchResultsListener a;
        }

        public void onSearchCompleted(boolean a, boolean a2, List a3) {
            SearchResultsListener a4;
            a4.SearchResultsPane.this.mIsNotIndexed = a2;
            a4.SearchResultsPane.this.mQuerySuccessful = a;
            a4.SearchResultsPane.this.mMatches = a3;
            a4.SearchResultsPane.this.showSearchResults(a4.SearchResultsPane.this.mStartIndex, a4.SearchResultsPane.this.mMatches);
        }
    }
}

