/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.publicnotes;

import com.amazon.ebook.booklet.reader.plugin.publicnotes.PublicAnnotation;
import com.amazon.ebook.booklet.reader.plugin.publicnotes.PublicHighlight;
import com.amazon.ebook.booklet.reader.plugin.publicnotes.PublicNote;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.BookMetadata;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.PositionFactory;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationManager;
import com.amazon.ebook.booklet.reader.sdk.event.OpenBookHandler;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.kindle.social.PublicNotesService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class PublicNotesProvider
implements OpenBookHandler {
    private static final Log u = Log.getInstance((String)"PublicNotesProvider");
    private static final LogMessage y = new LogMessage("FeatureDisabled", null);
    private static final LogMessage O = new LogMessage("NoSidecar", null);
    private static final LogMessage x = new LogMessage("IOException", new String[]{"method"});
    private static final LogMessage f = new LogMessage("ContentMismatch", null);
    private static final LogMessage M = new LogMessage("XmlParsingException", null);
    private static final LogMessage J = new LogMessage("InvalidTimestamp", new String[]{"timestamp"});
    private static final LogMessage G = new LogMessage("InvalidAnnotationData", new String[]{"start", "end", "type"});
    private static final LogMessage a = new LogMessage("InvalidAnnotationData", null);
    private static final LogMessage i = new LogMessage("InvalidPublisherData", new String[]{"fieldName"});
    private static final String E = ".sa";
    private static final String C = "key";
    private static final String d = "type";
    private static final String j = "version";
    private static final String g = "guid";
    private static final String e = "shared";
    private static final String I = "timestamp";
    private static final String F = "content";
    private static final String L = "cname";
    private static final String c = "cid";
    private static final String l = "annotation";
    private static final String k = "note";
    private static final String m = "start_pos";
    private static final String h = "end_pos";
    private static final String A = "created_timestamp";
    private static final String H = "modified_timestamp";
    private static final String b = "type";
    private static final DateFormat K = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss+00:00", Locale.US);
    private ReaderSDK B;

    public PublicNotesProvider(ReaderSDK a) {
        PublicNotesProvider a2;
        a2.B = a;
    }

    public void openBookEvent(Book a, boolean a2) {
        PublicNotesProvider a3;
        List a4 = a3.importAnnotations(a);
        AnnotationManager a5 = a3.B.getAnnotationManager();
        int a6 = 0;
        int a7 = a4.size();
        int n = a6;
        while (n < a7) {
            a5.importAnnotation((Annotation)a4.get(a6), a);
            n = ++a6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List importAnnotations(Book a) {
        LinkedList a21332;
        BufferedReader a2;
        String a3;
        PublicNotesProvider a4;
        if (!((PublicNotesService)a4.B.getService(PublicNotesService.class)).isEnabled()) {
            if (!Log.isDebugOn()) return Collections.EMPTY_LIST;
            u.debug(y, null, "Public Notes are disabled.  Skipping Public Notes loading.");
            return Collections.EMPTY_LIST;
        }
        try {
            a3 = a.getDataFilePath(E);
        }
        catch (IOException a5) {
            u.error(x, new String[]{"get_sidecar_path"}, "Unable to get sidecar path.", (Throwable)a5);
            return Collections.EMPTY_LIST;
        }
        File a6 = new File(a3);
        if (!a6.exists()) {
            u.info(O, null, "No Public Notes file.  Skipping Public Notes loading.");
            return Collections.EMPTY_LIST;
        }
        PositionFactory a7 = a4.B.getPositionFactory(a);
        LinkedList a8 = new LinkedList();
        KXmlParser a9 = new KXmlParser();
        Date a10 = new Date(a6.lastModified());
        Date a11 = new Date(a6.lastModified());
        try {
            a2 = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(a6)), "UTF-8"));
        }
        catch (IOException a12) {
            try {
                a2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(a6), "UTF-8"));
            }
            catch (IOException a13) {
                u.error(x, new String[]{"open_stream"}, "Unable to open sidecar stream.", (Throwable)a13);
                return Collections.EMPTY_LIST;
            }
        }
        try {
            try {
                int a21332;
                a9.setInput((Reader)a2);
                int n = a21332 = a9.getEventType();
                while (n != 1) {
                    if (a21332 == 2 && a9.getName().equals(e)) {
                        BookMetadata a14 = a.getMetadata();
                        if (!(a4.compare(a9, C, a14.getCdeKey()) && a4.compare(a9, "type", a14.getCdeType()) && a4.compare(a9, j, Integer.toString(a14.getVersion())) && a4.compare(a9, g, a14.getGUID()))) {
                            u.error(f, null, "Public Notes file is not valid for the local content");
                        } else {
                            Date a15 = a4.parseDateFromAttribute(a9, I);
                            if (a15 != null) {
                                a10 = a11 = a15;
                            }
                            boolean a16 = true;
                            PublicNotesProvider publicNotesProvider = a4;
                            while (publicNotesProvider.getNextTag(a9, F, a16)) {
                                a16 = false;
                                String a17 = a9.getAttributeValue(null, L);
                                if (null == a17 || a17.length() == 0) {
                                    u.error(i, new String[]{L}, "Publisher name is empty in Public Notes. Ignoring content from this publisher.");
                                    publicNotesProvider = a4;
                                    continue;
                                }
                                String a18 = a9.getAttributeValue(null, c);
                                if (null == a18 || a18.length() == 0) {
                                    u.error(i, new String[]{c}, "Publisher CID is empty in Public Notes. Ignoring content from this publisher.");
                                    publicNotesProvider = a4;
                                    continue;
                                }
                                a8.addAll(a4.getPublicNotesForUser(a, a9, a7, a17, a18, a10, a11));
                                publicNotesProvider = a4;
                            }
                        }
                    }
                    n = a21332 = a9.next();
                }
                a21332 = a8;
                Object var18_24 = null;
            }
            catch (XmlPullParserException a22) {
                u.error(M, null, "", (Throwable)a22);
                LinkedList linkedList = a8;
                Object var18_25 = null;
                try {
                    a2.close();
                    return linkedList;
                }
                catch (IOException a20) {
                    u.error(x, new String[]{"reader_close"}, "Unable to close sidecar stream", (Throwable)a20);
                    return a8;
                }
            }
            catch (IOException a32) {
                u.error(x, new String[]{"parser_next"}, "Unable to parse XML", (Throwable)a32);
                LinkedList linkedList = a8;
                Object var18_26 = null;
                try {}
                catch (IOException a20) {
                    u.error(x, new String[]{"reader_close"}, "Unable to close sidecar stream", (Throwable)a20);
                    return a8;
                }
                a2.close();
                return linkedList;
            }
        }
        catch (Throwable throwable) {
            Object var18_27 = null;
            try {}
            catch (IOException a20) {
                u.error(x, new String[]{"reader_close"}, "Unable to close sidecar stream", (Throwable)a20);
                return a8;
            }
            a2.close();
            throw throwable;
        }
        try {}
        catch (IOException a20) {
            u.error(x, new String[]{"reader_close"}, "Unable to close sidecar stream", (Throwable)a20);
            return a8;
        }
        a2.close();
        return a21332;
    }

    private List getPublicNotesForUser(Book a, KXmlParser a2, PositionFactory a3, String a4, String a5, Date a6, Date a7) throws NumberFormatException, XmlPullParserException, IOException {
        LinkedList<PublicAnnotation> a8 = new LinkedList<PublicAnnotation>();
        boolean a9 = true;
        block2: while (true) {
            PublicNotesProvider a10;
            PublicNotesProvider publicNotesProvider = a10;
            while (publicNotesProvider.getNextTag(a2, l, a9)) {
                a9 = false;
                String a11 = a2.getAttributeValue(null, m);
                String a12 = a2.getAttributeValue(null, h);
                String a13 = a2.getAttributeValue(null, "type");
                if (a11 == null || a12 == null || a13 == null) {
                    u.error(G, new String[]{a11, a12, a13}, "Malformed data");
                    publicNotesProvider = a10;
                    continue;
                }
                Position a14 = null;
                Position a15 = null;
                try {
                    a14 = a3.createInstance(a11, a);
                    a15 = a3.createInstance(a12, a);
                }
                catch (IOException a16) {
                    u.error(G, new String[]{a11, a12, a13}, "Malformed data");
                    continue block2;
                }
                Date a17 = a10.parseDateFromAttribute(a2, A);
                Date a18 = a10.parseDateFromAttribute(a2, H);
                if (a17 == null) {
                    a17 = a6;
                }
                if (a18 == null) {
                    a18 = a7;
                }
                if (a13.equals(k)) {
                    String a19 = a2.nextText();
                    if (a19 == null || a19.length() == 0) {
                        u.error(PublicNotesProvider.a);
                        publicNotesProvider = a10;
                        continue;
                    }
                    a8.add(new PublicNote(a14, a15, a17, a18, a5, a4, a19));
                    continue block2;
                }
                a8.add(new PublicHighlight(a14, a15, a17, a18, a5, a4));
                continue block2;
            }
            break;
        }
        return a8;
    }

    private boolean getNextTag(KXmlParser a, String a2, boolean a3) throws XmlPullParserException, IOException {
        PublicNotesProvider a4;
        if (a == null || a2 == null) {
            return false;
        }
        if (!a3 && !a4.findTagEnd(a, a2)) {
            return false;
        }
        return a4.findTagStart(a, a2);
    }

    public boolean findTagStart(KXmlParser a, String a2) throws XmlPullParserException, IOException {
        int a3;
        int n = a3 = a.getEventType();
        while (n != 1) {
            if (a3 == 2 && a2.equals(a.getName())) {
                return true;
            }
            if (a3 == 3 && !a2.equals(a.getName())) break;
            n = a.next();
        }
        return false;
    }

    private boolean findTagEnd(KXmlParser a, String a2) throws XmlPullParserException, IOException {
        int a3;
        int n = a3 = a.getEventType();
        while (n != 1) {
            if (a3 == 3 && a2.equals(a.getName())) {
                return true;
            }
            n = a.next();
        }
        return false;
    }

    private boolean compare(KXmlParser a, String a2, String a3) {
        String a4 = a.getAttributeValue(null, a2);
        if (a4 == a3) {
            return true;
        }
        if (a4 == null || a3 == null) {
            return false;
        }
        return a3.equals(a4);
    }

    private Date parseDateFromAttribute(KXmlParser a, String a2) {
        Date a3 = null;
        String a4 = a.getAttributeValue(null, a2);
        if (a4 != null) {
            ParsePosition a5 = new ParsePosition(0);
            a3 = K.parse(a4, a5);
            if (a5.getErrorIndex() != -1) {
                u.error(J, new String[]{a4}, "Invalid timestamp data");
            }
        }
        return a3;
    }

    static {
        K.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

