/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.pagenumbers;

import com.amazon.ebook.booklet.reader.plugin.pagenumbers.PageNumberData;
import com.amazon.ebook.booklet.reader.sdk.content.ByteOffsetBasedPosition;
import com.amazon.ebook.booklet.reader.sdk.content.PageNumberManager;
import com.amazon.ebook.booklet.reader.utils.NumberParser;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.PerformanceLog;
import com.amazon.ebook.util.text.StringUtil;
import com.amazon.kedu.pagelabels.PageLabelIndex;
import com.amazon.kedu.pagelabels.PageLabelIndexParseException;
import com.amazon.kedu.pagelabels.PageLabelRange;
import com.amazon.kedu.pagelabels.PageLabelRangeFormatter;
import com.amazon.kedu.pagelabels.PageLabelSeq;
import com.amazon.kedu.pagelabels.PageLabelType;
import com.amazon.kedu.pagelabels.RomanNumber;
import com.amazon.kedu.pagesidecar.BinaryPageLabelSidecarReader;
import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SidecarPageNumberProvider
implements PageNumberManager {
    static final Log c = Log.getInstance((String)"SidecarPageNumberProvider");
    public static final String l = "apnx.key";
    private static final String k = "";
    private static final int[] m = new int[0];
    private static final String h = "pageMap";
    private static final String A = "fileRevisionId";
    private static final String H = "cdeType";
    private PageNumberData b = null;
    private volatile CacheEntry K = null;
    private volatile CacheEntry B = null;
    private static final ResourceBundle D = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.plugin.pagenumbers.resources.SidecarPageNumberProviderResources");

    public SidecarPageNumberProvider() {
        SidecarPageNumberProvider a;
    }

    public SidecarPageNumberProvider(PageNumberData a) {
        a2();
        SidecarPageNumberProvider a2;
        if (a != null) {
            a2.setNewPageNumberInfo(a);
        }
    }

    public synchronized void setNewPageNumberInfo(PageNumberData a) {
        a.b = a;
        a.K = null;
        a.B = null;
    }

    public static PageNumberData initializePageNumberDataFromSidecar(String a) {
        PageNumberData a2 = new PageNumberData();
        try {
            SidecarPageNumberProvider.initializePageNumberData(a2, a);
            a2.m &= SidecarPageNumberProvider.isPagePositionsMonotonicallyIncreasing(a2.h);
        }
        catch (Exception a3) {
            c.error("Page number sidecar unavailable", (Throwable)a3);
            a2 = null;
        }
        return a2;
    }

    private static int resolveSelectedEdition() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void initializePageNumberData(PageNumberData a, String a2) {
        block12: {
            PerformanceLog.logStart((String)"APNX_initializePageNumberData");
            File a3 = new File(a2);
            BinaryPageLabelSidecarReader a4 = null;
            try {
                block11: {
                    try {
                        a4 = new BinaryPageLabelSidecarReader(a3);
                        JSONParser a5 = new JSONParser();
                        JSONObject a6 = (JSONObject)a5.parse(a4.getHeaderMetadata());
                        if (!a6.containsKey((Object)A)) {
                            throw new IOException("Page number sidecar header doesn't contain appropriate metadata (missing fileRevisionId).");
                        }
                        a.l = a6.get((Object)A).toString();
                        a.k = a6.containsKey((Object)H) ? a6.get((Object)H).toString() : "EBOK";
                        if (a4.getEditionCount() <= 0) break block11;
                        int a7 = SidecarPageNumberProvider.resolveSelectedEdition();
                        JSONObject a8 = (JSONObject)a5.parse(a4.getEditionMetadata(a7));
                        if (!a8.containsKey((Object)h)) {
                            throw new IOException("Page number sidecar edition doesn't contain appropriate metadata (missing pageMap).");
                        }
                        a.b = (String)a8.get((Object)h);
                        a.K = a4.getTotalPageCount(a7);
                        PageLabelIndex a9 = new PageLabelIndex((String)a8.get((Object)h), a4.getTotalPageCount(a7));
                        Iterator a10 = a9.getLabelSequences().iterator();
                        PageLabelSeq a11 = (PageLabelSeq)a10.next();
                        if (a11 == null) {
                            throw new IOException("Page number sidecar edition doesn't contain a valid page label index");
                        }
                        PageLabelSeq a12 = a11;
                        Iterator iterator = a10;
                        while (iterator.hasNext()) {
                            a12 = (PageLabelSeq)a10.next();
                            iterator = a10;
                        }
                        a.h = a4.getOrdinalPagePositions(a7);
                        a.D = a9;
                        a.A = a11.getStartingOrdinalPageNumber();
                        a.H = a12.getEndingOrdinalPageNumber();
                        a.B = a9.getHighestPageLabel();
                        a.m = true;
                        a.setDirty(true);
                    }
                    catch (FileNotFoundException a13) {
                        c.error("Could not read the page number sidecar", (Throwable)a13);
                        Object var13_17 = null;
                        SidecarPageNumberProvider.close(a4);
                        break block12;
                    }
                    catch (IOException a14) {
                        c.error("IOException while attempting to read the page number sidecar", (Throwable)a14);
                        Object var13_18 = null;
                        SidecarPageNumberProvider.close(a4);
                        break block12;
                    }
                    catch (ParseException a15) {
                        c.error("Could not parse JSON metadata from page number sidecar file", (Throwable)a15);
                        Object var13_19 = null;
                        SidecarPageNumberProvider.close(a4);
                        break block12;
                    }
                    catch (PageLabelIndexParseException a16) {
                        c.error("PageMap couldn't be understood from page number sidecar file", (Throwable)a16);
                        Object var13_20 = null;
                        SidecarPageNumberProvider.close(a4);
                        break block12;
                    }
                }
                Object var13_16 = null;
            }
            catch (Throwable throwable) {
                Object var13_21 = null;
                SidecarPageNumberProvider.close(a4);
                throw throwable;
            }
            SidecarPageNumberProvider.close(a4);
        }
        PerformanceLog.logEnd((String)"APNX_initializePageNumberData");
    }

    public String getFileRevisionId() {
        SidecarPageNumberProvider a;
        return a.b.l;
    }

    public String getCdeType() {
        SidecarPageNumberProvider a;
        return a.b.k;
    }

    public boolean isPageNumberingSupported() {
        SidecarPageNumberProvider a;
        return a.b.m;
    }

    public String getMaxPageLabel() {
        SidecarPageNumberProvider a;
        return a.b.B;
    }

    public boolean isPaginationNumericOnly() {
        SidecarPageNumberProvider a;
        return a.b.D.isPaginationArabicOnly();
    }

    public String getPageRangeSummary() {
        SidecarPageNumberProvider a;
        List a2 = PageLabelRangeFormatter.getPageLabelRangeSummary((PageLabelIndex)a.b.D);
        String a3 = D.getString("pagelabel.range.format");
        String a4 = D.getString("pagelabel.range.list.delimiter");
        StringBuffer a5 = new StringBuffer();
        Iterator a6 = a2.iterator();
        while (a6.hasNext()) {
            PageLabelRange a7 = (PageLabelRange)a6.next();
            Object[] a8 = new Object[]{a7.getLowerRangeLabel(), a7.getUpperRangeLabel()};
            a5.append(MessageFormat.format((String)a3, (Object[])a8));
            if (!a6.hasNext()) continue;
            a5.append(a4);
        }
        return a5.toString();
    }

    private int getInternalPosition(ByteOffsetBasedPosition a) {
        return a.getInternalOffset();
    }

    public int[] getPageBreakPositionsInSpan(ByteOffsetBasedPosition a, ByteOffsetBasedPosition a2) {
        int[] a3;
        SidecarPageNumberProvider a4;
        PerformanceLog.logStart((String)"APNX_getPageBreakPositionsInSpan");
        int a5 = a4.getInternalPosition(a);
        int a6 = a4.getInternalPosition(a2);
        int a7 = a4.findStartingOrdinalPageForFirstPosition(a5);
        int a8 = a4.findStartingOrdinalPageForLastPosition(a6);
        if (a7 >= a8) {
            a3 = m;
        } else {
            int a9;
            int n = ++a7;
            SidecarPageNumberProvider sidecarPageNumberProvider = a4;
            while (n < sidecarPageNumberProvider.b.h.length && a4.b.h[a7] < a5) {
                n = ++a7;
                sidecarPageNumberProvider = a4;
            }
            a3 = new int[a8 - (a7 - 1)];
            int n2 = a9 = 0;
            while (n2 < a3.length) {
                a3[a9] = a4.b.h[a9 + a7];
                n2 = ++a9;
            }
        }
        PerformanceLog.logEnd((String)"APNX_getPageBreakPositionsInSpan");
        return a3;
    }

    private String getFirstPageLabelForOrdinalPage(int a) {
        SidecarPageNumberProvider a2;
        if (a < 1) {
            return k;
        }
        String a3 = a2.b.D.getPageLabelTextForOrdinalPage(a);
        if (StringUtil.isEmpty((String)a3) && a2.b.h[a] == a2.b.h[a2.b.A]) {
            a3 = a2.b.D.getPageLabelTextForOrdinalPage(a2.b.A);
        }
        return a3;
    }

    private String getLastPageLabelForOrdinalPage(int a) {
        SidecarPageNumberProvider a2;
        if (a < 1) {
            return k;
        }
        int a3 = Math.min(a2.b.H, a2.b.h.length - 1);
        int n = a;
        int n2 = a3;
        while (n < n2 && a2.b.h[a] == a2.b.h[a + 1]) {
            n = ++a;
            n2 = a3;
        }
        return a2.b.D.getPageLabelTextForOrdinalPage(a);
    }

    public String getPageLabelForFirstPosition(ByteOffsetBasedPosition a) {
        SidecarPageNumberProvider a2;
        int a3 = a2.findStartingOrdinalPageForFirstPosition(a2.getInternalPosition(a));
        return a2.getFirstPageLabelForOrdinalPage(a3);
    }

    public String getPageLabelForLastPosition(ByteOffsetBasedPosition a) {
        SidecarPageNumberProvider a2;
        int a3 = a2.findStartingOrdinalPageForLastPosition(a2.getInternalPosition(a));
        return a2.getLastPageLabelForOrdinalPage(a3);
    }

    public int getPositionForPageLabel(String a) {
        SidecarPageNumberProvider a2;
        int a3 = a2.b.D.getOrdinalPageForPageLabelText(a);
        if (a3 <= 0) {
            Integer a4 = NumberParser.parseInteger((String)a);
            if (a4 != null && a4 > 0) {
                return Integer.MAX_VALUE;
            }
            if (RomanNumber.isRomanNumber((String)a)) {
                a3 = a2.b.D.getHighestOrdinalPageOfType(PageLabelType.H);
            }
        }
        if (a3 <= 0) {
            return -1;
        }
        if (a3 >= a2.b.h.length) {
            a3 = a2.b.h.length - 1;
        }
        return a2.b.h[a3];
    }

    public String[] getPageLabelPairInSpan(ByteOffsetBasedPosition a, ByteOffsetBasedPosition a2) {
        SidecarPageNumberProvider a3;
        int a4 = a3.findStartingOrdinalPageForFirstPosition(a3.getInternalPosition(a));
        int a5 = a3.findStartingOrdinalPageForLastPosition(a3.getInternalPosition(a2));
        String a6 = k;
        String a7 = k;
        if (a4 > 0) {
            int a8;
            int n = a8 = a4;
            while (n <= a5) {
                String a9;
                if (StringUtil.isEmpty((String)a6)) {
                    a6 = a3.getFirstPageLabelForOrdinalPage(a8);
                }
                if (StringUtil.isNotEmpty((String)(a9 = a3.getLastPageLabelForOrdinalPage(a8)))) {
                    a7 = a9;
                }
                n = ++a8;
            }
        }
        return new String[]{a6, a7};
    }

    private int findStartingOrdinalPageForFirstPosition(int a) {
        SidecarPageNumberProvider a2;
        CacheEntry a3 = a2.K;
        if (a3 != null && a3.B == a) {
            return a3.D;
        }
        int a4 = a2.findOrdinalPageForPosition(a, true);
        a2.K = a3 = SidecarPageNumberProvider.createCacheEntry(a, a4);
        return a4;
    }

    private int findStartingOrdinalPageForLastPosition(int a) {
        SidecarPageNumberProvider a2;
        CacheEntry a3 = a2.B;
        if (a3 != null && a3.B == a) {
            return a3.D;
        }
        int a4 = a2.findOrdinalPageForPosition(a, false);
        a2.B = a3 = SidecarPageNumberProvider.createCacheEntry(a, a4);
        return a4;
    }

    private static CacheEntry createCacheEntry(int a, int a2) {
        CacheEntry a3 = new CacheEntry();
        new CacheEntry().B = a;
        a3.D = a2;
        return a3;
    }

    private int findOrdinalPageForPosition(int a, boolean a2) {
        SidecarPageNumberProvider a3;
        return a3.findOrdinalPage(a, a3.b.h, a3.b.D, a2);
    }

    private int findOrdinalPage(int a, int[] a2, PageLabelIndex a3, boolean a4) {
        SidecarPageNumberProvider a5;
        int a6 = SidecarPageNumberProvider.findPageByPosition(a, a2);
        PageLabelSeq a7 = a3.getSeqForOrdinalPage(a6);
        PageLabelSeq a8 = null;
        boolean a9 = false;
        PageLabelSeq pageLabelSeq = a7;
        while (SidecarPageNumberProvider.isInsert(pageLabelSeq)) {
            int a10;
            if (a4) {
                a10 = a5.getLastOrdinalPageOfPreviousSeq(a7);
            } else {
                a10 = a7.getEndingOrdinalPageNumber() + 1;
                if (!a9) {
                    PageLabelSeq pageLabelSeq2 = a7;
                    while (SidecarPageNumberProvider.isInsert(pageLabelSeq2)) {
                        pageLabelSeq2 = a3.getSeqForOrdinalPage(a5.getLastOrdinalPageOfPreviousSeq(a8));
                    }
                }
            }
            a7 = a3.getSeqForOrdinalPage(a10);
            a9 = true;
            pageLabelSeq = a7;
        }
        a6 = a9 ? a5.getOrdinalPageNumber(a7, a8, a4) : SidecarPageNumberProvider.getAppropriatePageInSequence(a6, a2, true);
        return a6;
    }

    private int getLastOrdinalPageOfPreviousSeq(PageLabelSeq a) {
        return a.getStartingOrdinalPageNumber() - 1;
    }

    private static int findPageByPosition(int a, int[] a2) {
        int a3 = Arrays.binarySearch(a2, a);
        if (a3 < 0) {
            a3 = -(a3 + 1);
            --a3;
        }
        return a3;
    }

    private int getOrdinalPageNumber(PageLabelSeq a, PageLabelSeq a2, boolean a3) {
        int a4 = a == null ? (a3 || a2 == null ? -1 : a2.getEndingOrdinalPageNumber()) : (a3 ? a.getEndingOrdinalPageNumber() : a.getStartingOrdinalPageNumber());
        return a4;
    }

    private static int getAppropriatePageInSequence(int a, int[] a2, boolean a3) {
        int a4;
        int a5;
        int a6;
        if (a3) {
            a6 = 2;
            a5 = a2.length - 1;
            a4 = -1;
        } else {
            a6 = 0;
            a5 = a2.length - 2;
            a4 = 1;
        }
        int n = a;
        int n2 = a6;
        while (n >= n2 && a <= a5 && a >= 0 && a < a2.length && a2[a] == a2[a + a4]) {
            n = a + a4;
            n2 = a6;
        }
        return a;
    }

    private static boolean isInsert(PageLabelSeq a) {
        return a != null && a.getPageLabelType() == PageLabelType.K;
    }

    private static void close(BinaryPageLabelSidecarReader a) {
        if (a != null) {
            try {
                a.close();
            }
            catch (Exception a2) {
                c.error("Could not close page label sidecar reader: " + a2.getMessage(), (Throwable)a2);
            }
        }
    }

    private static boolean isPagePositionsMonotonicallyIncreasing(int[] a) {
        if (a != null) {
            int a2;
            int n = a2 = 1;
            while (n < a.length) {
                if (a[a2] < a[a2 - 1]) {
                    c.warning("Page positions going backwards detected at ordinal page " + a2);
                    return false;
                }
                n = ++a2;
            }
        }
        return true;
    }

    public PageNumberData getPageInfoData() {
        SidecarPageNumberProvider a;
        return a.b;
    }

    private static class CacheEntry {
        volatile int B;
        volatile int D;

        private CacheEntry() {
            CacheEntry a;
        }
    }
}

