/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.pagenumbers;

import com.amazon.ebook.booklet.reader.plugin.pagenumbers.BookNotFoundPageNumberProvider;
import com.amazon.ebook.booklet.reader.plugin.pagenumbers.PageNumberData;
import com.amazon.ebook.booklet.reader.plugin.pagenumbers.SidecarPageNumberProvider;
import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.ReaderPlugin;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.ByteOffsetBasedPosition;
import com.amazon.ebook.booklet.reader.sdk.content.PageNumberManager;
import com.amazon.ebook.booklet.reader.sdk.event.CloseBookHandler;
import com.amazon.ebook.booklet.reader.sdk.event.EventHandler;
import com.amazon.ebook.booklet.reader.sdk.event.OpenBookHandler;
import com.amazon.ebook.booklet.reader.sdk.util.DataStoreFactory;
import com.amazon.ebook.booklet.reader.sdk.util.DataStoreObject;
import com.amazon.ebook.booklet.reader.sdk.util.InvalidSideCarFileException;
import com.amazon.ebook.booklet.reader.sdk.util.State;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.PerformanceLog;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class PageNumberManagerImpl
extends ReaderPlugin
implements OpenBookHandler,
CloseBookHandler,
DataStoreFactory,
PageNumberManager {
    private static final Log h = Log.getInstance((String)"PageNumberPlugin");
    public static final String A = "APNX";
    public static final String H = "apnx";
    private ReaderSDK K;
    private static final PageNumberManager B = new BookNotFoundPageNumberProvider();
    private PageNumberManager D;

    public PageNumberManagerImpl() {
        PageNumberManagerImpl a;
    }

    public String getName() {
        return "page_numbers";
    }

    public void pluginLoad(ReaderSDK a) throws BookException {
        PageNumberManagerImpl a2;
        a2.K = a;
        a2.D = null;
        a.getRegistry().registerHandler((EventHandler)a2);
        a.getRegistry().addRareUpdateBookStateFactory((DataStoreFactory)a2);
    }

    public void pluginUnload() {
        PageNumberManagerImpl a;
        a.D = null;
        a.K.getRegistry().deregisterHandler((EventHandler)a);
        a.K.getRegistry().removeRareUpdateBookStateFactory((DataStoreFactory)a);
    }

    public void openBookEvent(Book a, boolean a2) {
        PageNumberManagerImpl a3;
        State a4 = null;
        PageNumberData a5 = null;
        try {
            a4 = a.getRareUpdateBookState();
            a5 = (PageNumberData)a4.get(a3.getKey());
        }
        catch (InvalidSideCarFileException a6) {
            h.error("Failed to load book sidecar file.", (Throwable)a6);
        }
        File a7 = null;
        try {
            a7 = new File(PageNumberManagerImpl.getSidecarFile(a));
        }
        catch (IOException a8) {
            h.error("Failed to find Page Numbers sidecar file", (Throwable)a8);
        }
        if (a7 != null && a7.exists()) {
            a3.D = a3.loadProvider(a);
            if (a3.D == B) {
                h.warning("loadProvider failed to get a Page Number Provider, page numbers was probably revoked.");
                return;
            }
            PageNumberData a9 = ((SidecarPageNumberProvider)a3.D).getPageInfoData();
            if (a9 != null) {
                if (a5 != null) {
                    a4.remove((DataStoreObject)a5);
                }
                a4.add((DataStoreObject)a9);
                try {
                    a4.save(true);
                    a7.delete();
                }
                catch (IOException a10) {
                    h.error("Failed to writeback new sidecar with PageNumbers, not deleting legacy file");
                }
            } else {
                a3.D = B;
            }
        } else if (a5 != null) {
            if (a3.D == null) {
                a3.D = a3.createProvider();
            }
            ((SidecarPageNumberProvider)a3.D).setNewPageNumberInfo(a5);
        }
        if (a3.D == null) {
            a3.D = B;
        }
    }

    private static String getSidecarFile(Book a) throws IOException {
        return a.getDataFilePath(".apnx");
    }

    private SidecarPageNumberProvider createProvider() {
        return new SidecarPageNumberProvider();
    }

    private PageNumberManager loadProvider(Book a) {
        PerformanceLog.logStart((String)"APNX_loadProvider");
        SidecarPageNumberProvider a2 = null;
        try {
            if (a != null) {
                PageNumberManagerImpl a3;
                File a4 = new File(PageNumberManagerImpl.getSidecarFile(a));
                String a5 = a4 == null ? null : a4.getAbsolutePath();
                PageNumberData a6 = SidecarPageNumberProvider.initializePageNumberDataFromSidecar(a5);
                SidecarPageNumberProvider a7 = a3.createProvider();
                a7.setNewPageNumberInfo(a6);
                if (a7.isPageNumberingSupported()) {
                    a2 = a7;
                }
            }
        }
        catch (Exception a8) {
            h.error("Unexpected error loading page number sidecar", (Throwable)a8);
        }
        PerformanceLog.logEnd((String)"APNX_loadProvider");
        return a2 == null ? B : a2;
    }

    public DataStoreObject getEmptyObject(Object a) {
        return new PageNumberData();
    }

    public String getKey() {
        return "apnx.key";
    }

    public HashMap getSupportedDataStoreFactories() {
        return null;
    }

    public void closeBookEvent(Book a, boolean a2) {
        a.D = null;
    }

    public String getMaxPageLabel() {
        PageNumberManagerImpl a;
        return a.D.getMaxPageLabel();
    }

    public int[] getPageBreakPositionsInSpan(ByteOffsetBasedPosition a, ByteOffsetBasedPosition a2) {
        PageNumberManagerImpl a3;
        return a3.D.getPageBreakPositionsInSpan(a, a2);
    }

    public String getPageLabelForFirstPosition(ByteOffsetBasedPosition a) {
        PageNumberManagerImpl a2;
        return a2.D.getPageLabelForFirstPosition(a);
    }

    public String getPageLabelForLastPosition(ByteOffsetBasedPosition a) {
        PageNumberManagerImpl a2;
        return a2.D.getPageLabelForLastPosition(a);
    }

    public String[] getPageLabelPairInSpan(ByteOffsetBasedPosition a, ByteOffsetBasedPosition a2) {
        PageNumberManagerImpl a3;
        return a3.D.getPageLabelPairInSpan(a, a2);
    }

    public String getPageRangeSummary() {
        PageNumberManagerImpl a;
        return a.D.getPageRangeSummary();
    }

    public int getPositionForPageLabel(String a) {
        PageNumberManagerImpl a2;
        return a2.D.getPositionForPageLabel(a);
    }

    public boolean isPageNumberingSupported() {
        PageNumberManagerImpl a;
        return a.D == null ? false : a.D.isPageNumberingSupported();
    }

    public boolean isPaginationNumericOnly() {
        PageNumberManagerImpl a;
        return a.D.isPaginationNumericOnly();
    }

    public void setSupportedDataStoreFactories(HashMap a) {
    }
}

