/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.notesandmarks;

import com.amazon.ebook.booklet.reader.plugin.notesandmarks.AnnotationDialog;
import com.amazon.ebook.booklet.reader.plugin.notesandmarks.AnnotationView;
import com.amazon.ebook.booklet.reader.plugin.notesandmarks.AnnotationViewport;
import com.amazon.ebook.booklet.reader.plugin.notesandmarks.AnnotationWordIteratorFactory;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.ByteOffsetBasedPosition;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContents;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.booklet.reader.sdk.content.Viewport;
import com.amazon.ebook.booklet.reader.sdk.content.WordIteratorFactory;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUI;
import com.amazon.ebook.booklet.reader.sdk.ui.SnippetWidget;
import com.amazon.ebook.booklet.reader.sdk.util.PeriodicalsUtil;
import com.amazon.ebook.booklet.reader.utils.TextUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;

public class AnnotationWidget
extends JComponent {
    private static final String RESOURCE_BUNDLE = "com.amazon.ebook.booklet.reader.plugin.notesandmarks.resources.AnnotationResources";
    private ReaderSDK readerSDK;
    private ReaderUI readerUI;
    private AnnotationView annotationView;
    private ResourceBundle rb;
    private Book book;
    private Annotation annotation;
    private AnnotationWordIteratorFactory wordIteratorFactory;
    private AnnotationViewport viewport;
    private SnippetWidget snippet;
    private boolean showSeparator;
    private String label;

    public AnnotationWidget(ReaderSDK a, ReaderUI a2, AnnotationView a3, ActionMap a4) {
        AnnotationWidget a5;
        a5.readerSDK = a;
        a5.readerUI = a2;
        a5.annotationView = a3;
        a5.wordIteratorFactory = new AnnotationWordIteratorFactory();
        a5.viewport = new AnnotationViewport();
        a5.rb = ResourceBundle.getBundle(RESOURCE_BUNDLE);
        ResourceBundle a6 = ResourceBundle.getBundle("com.amazon.agui.swing.resources.ComponentResources");
        a5.setLayout(new BorderLayout(0, 0));
        Color a7 = (Color)a6.getObject("ContentExcerptView.foreground");
        Color a8 = (Color)a6.getObject("ContentExcerptView.background");
        a5.setForeground(a7);
        a5.setBackground(a8);
        a4.put("tap", a5.new TapAction());
        a4.put("hold", a5.new HoldAction());
        a5.snippet = a2.createSnippetWidget((Viewport)a5.viewport, (WordIteratorFactory)a5.wordIteratorFactory);
        a5.snippet.setForeground(a7);
        a5.snippet.setBackground(a8);
        a5.snippet.setFont((Font)a6.getObject("ContentExcerptView.fragmentFont"));
        a5.snippet.setActionMap(a4);
        a5.add((Component)a5.snippet, "Center");
    }

    public void paintComponent(Graphics a) {
        Object a2;
        Object[] a3;
        AnnotationWidget a4;
        super.paintComponent(a);
        if (a4.annotation != null && PeriodicalsUtil.isPeriodical((Book)a4.book)) {
            a3 = new Object[]{a4.label, a4.annotation.getLabel()};
            a2 = MessageFormat.format(a4.rb.getString("annotation.view.name.text"), a3);
            a4.label = TextUtils.getShortText((String)a2, (FontMetrics)a4.getFontMetrics(a4.getFont()), (int)(a4.readerUI.getUIContext().getWidth() - a4.readerUI.getContentRightMargin() - a4.readerUI.getContentLeftMargin()), (int)(((String)a2).length() - a4.label.length()));
            if (a4.label != null) {
                a4.snippet.setLabel(a4.label);
            }
        }
        if (a4.showSeparator) {
            a3 = a.getColor();
            a2 = (Color)a4.rb.getObject("annotation.view.separator.color");
            int a5 = (Integer)a4.rb.getObject("annotation.view.margin");
            a.setColor((Color)a2);
            a.drawLine(a5, 0, a4.getWidth() - a5, 0);
            a.setColor((Color)a3);
        }
    }

    public void showSeparator(boolean a) {
        a.showSeparator = a;
    }

    public void setAnnotation(Book a, Annotation a2) {
        AnnotationWidget a3;
        a3.book = a;
        a3.annotation = a2;
        if (a2 == null) {
            a3.snippet.putClientProperty((Object)"annotation", null);
            a3.viewport.setAnnotation(null, null);
            a3.wordIteratorFactory.setAnnotation(null, null);
            a3.label = "";
            a3.snippet.reset();
        } else {
            Object a4;
            TableOfContents a5;
            a3.snippet.putClientProperty((Object)"annotation", (Object)a2);
            a3.viewport.setAnnotation(a, a2);
            a3.wordIteratorFactory.setAnnotation(a, a2);
            if (PeriodicalsUtil.isPeriodical((Book)a)) {
                a5 = a.getTOC();
                a4 = a2.getStartPosition();
                if (a5 != null && a4 != null) {
                    TableOfContentsEntry a6 = a5.getTOCFromPosition(a4);
                    a3.label = a6.getLabel();
                    return;
                }
            }
            a5 = a2.getStartPosition();
            a4 = a2.getLabel();
            String a7 = a5.getUIString(true);
            String a8 = null;
            if (a5 instanceof ByteOffsetBasedPosition && a3.readerSDK.getPageNumberManager().isPageNumberingSupported()) {
                a8 = a3.readerSDK.getPageNumberManager().getPageLabelForLastPosition((ByteOffsetBasedPosition)a5);
            }
            if (a8 != null && a8.length() > 0) {
                Object[] a9 = new Object[]{a7, a8, a4};
                a3.label = ((MessageFormat)a3.rb.getObject("annotation.view.location_page.message.format")).format(a9);
            } else {
                Object[] a10 = new Object[]{a7, a4};
                a3.label = ((MessageFormat)a3.rb.getObject("annotation.view.location.message.format")).format(a10);
            }
        }
        a3.snippet.setLabel(a3.label);
    }

    private class HoldAction
    extends AbstractAction {
        private HoldAction() {
            HoldAction a;
        }

        public void actionPerformed(ActionEvent a) {
            HoldAction a2;
            if (a2.AnnotationWidget.this.annotationView.closeDialog()) {
                return;
            }
            if (a2.AnnotationWidget.this.book == null || a2.AnnotationWidget.this.annotation == null) {
                return;
            }
            AnnotationDialog a3 = a2.AnnotationWidget.this.annotationView.getAnnotationDialog(a2.AnnotationWidget.this.annotation.getType());
            if (a3 == null) {
                a2.AnnotationWidget.this.annotationView.performGoTo(a2.AnnotationWidget.this.annotation);
                return;
            }
            a3.setAnnotation(a2.AnnotationWidget.this.book, a2.AnnotationWidget.this.annotation);
            a3.postDialog(a2.AnnotationWidget.this);
        }
    }

    private class TapAction
    extends AbstractAction {
        private TapAction() {
            TapAction a;
        }

        public void actionPerformed(ActionEvent a) {
            TapAction a2;
            if (a2.AnnotationWidget.this.annotationView.closeDialog()) {
                return;
            }
            if (a2.AnnotationWidget.this.book == null || a2.AnnotationWidget.this.annotation == null) {
                return;
            }
            a2.AnnotationWidget.this.annotationView.performGoTo(a2.AnnotationWidget.this.annotation);
        }
    }
}

