/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.notesandmarks;

import com.amazon.ebook.booklet.reader.plugin.notesandmarks.AnnotationView;
import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.BookNavigator;
import com.amazon.ebook.booklet.reader.sdk.ReaderPlugin;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.Viewport;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationException;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationFactory;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationManager;
import com.amazon.ebook.booklet.reader.sdk.ui.MenuInserter;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderAction;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUI;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUIContext;
import com.amazon.ebook.util.log.Log;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;

public class AnnotationViewProvider
extends ReaderPlugin
implements MenuInserter {
    private static final Log m = Log.getInstance((String)"AnnotationViewProvider");
    static final int h = 200;
    static final int A = 201;
    private ResourceBundle H;
    private ReaderSDK b;
    private ReaderUI K;
    private AnnotationView B;
    private static AnnotationViewProvider D;

    public AnnotationViewProvider() {
        AnnotationViewProvider a;
    }

    public static AnnotationViewProvider getInstance() {
        return D;
    }

    public String getName() {
        return "NotesAndMarks";
    }

    public void pluginLoad(ReaderSDK a) throws BookException {
        AnnotationViewProvider a2;
        a2.b = a;
        a2.K = a.getUI();
        a2.B = new AnnotationView(a, a2.K);
        a2.H = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.plugin.notesandmarks.resources.AnnotationResources");
        a.getRegistry().registerMenuInserter((MenuInserter)a2);
        D = a2;
    }

    public void pluginUnload() {
        AnnotationViewProvider a;
        a.b.getRegistry().deregisterMenuInserter((MenuInserter)a);
        D = null;
    }

    public ReaderUIContext getView() {
        AnnotationViewProvider a;
        return a.B;
    }

    public ReaderAction getBookmarkAction() {
        AnnotationViewProvider a;
        return a.new BookmarkAction();
    }

    public void addBookmark() {
        AnnotationViewProvider a;
        BookNavigator a2 = a.b.getBookNavigator();
        if (a2 == null) {
            return;
        }
        Viewport a3 = a2.getViewport();
        if (a3 == null) {
            return;
        }
        Position a4 = a3.getFirstElementStartPosition().convertToSerializablePosition();
        AnnotationManager a5 = a.b.getAnnotationManager();
        AnnotationFactory a6 = a5.getAnnotationFactory(0);
        try {
            Annotation a7 = a6.createAnnotation(null, a4, null);
            a5.addAnnotation(a7, a.b.getCurrentBook());
        }
        catch (AnnotationException a8) {
            m.warning("Cannot create Bookmark Annotation.");
        }
    }

    public void deleteBookmark(Annotation a) {
        AnnotationViewProvider a2;
        a2.b.getAnnotationManager().deleteAnnotation(a, a2.b.getCurrentBook());
    }

    private Annotation getPageBookmark() {
        int a;
        AnnotationViewProvider a2;
        BookNavigator a3 = a2.b.getBookNavigator();
        if (a3 == null) {
            return null;
        }
        Viewport a4 = a3.getViewport();
        if (a4 == null) {
            return null;
        }
        List a5 = a2.b.getAnnotationManager().getAnnotationsInRange(a4.getBook(), a4.getStartPosition(), a4.getEndPosition());
        int n = a = 0;
        while (n < a5.size()) {
            Annotation a6 = (Annotation)a5.get(a);
            if (a6.getType() == 0) {
                return a6;
            }
            n = ++a;
        }
        return null;
    }

    public ReaderAction[] getMenuActions() {
        AnnotationViewProvider a;
        if (a.K.getUIContext() instanceof AnnotationView) {
            return new ReaderAction[]{a.B.getFilterAction(a.H.getString("annotation.filter.menu.text"))};
        }
        Annotation a2 = a.getPageBookmark();
        ReaderAction a3 = a2 == null ? a.new AddBookmarkAction(a.H.getString("annotation.add.bookmark.menu.text")) : a.new DeleteBookmarkAction(a.H.getString("annotation.delete.bookmark.menu.text"), a2);
        return new ReaderAction[]{a3, a.B.getViewAction(a.H.getString("annotation.view.menu.text"))};
    }

    private class DeleteBookmarkAction
    extends ReaderAction {
        Annotation annotation;

        public DeleteBookmarkAction(String a, Annotation a2) {
            DeleteBookmarkAction a3;
            super(a);
            a3.annotation = a2;
        }

        public void actionPerformed(ActionEvent a) {
            DeleteBookmarkAction a2;
            a2.AnnotationViewProvider.this.deleteBookmark(a2.annotation);
            a2.AnnotationViewProvider.this.K.getReaderPane().repaint();
        }

        public int getPriority() {
            return 200;
        }

        public int getType() {
            return 8;
        }
    }

    private class AddBookmarkAction
    extends ReaderAction {
        public AddBookmarkAction(String a) {
            AddBookmarkAction a2;
            super(a);
            a2.setEnabled(a2.AnnotationViewProvider.this.b.getAnnotationManager().getSavesEnabled());
        }

        public void actionPerformed(ActionEvent a) {
            AddBookmarkAction a2;
            a2.AnnotationViewProvider.this.addBookmark();
            a2.AnnotationViewProvider.this.K.getReaderPane().repaint();
        }

        public int getPriority() {
            return 200;
        }

        public int getType() {
            return 8;
        }
    }

    private class BookmarkAction
    extends ReaderAction {
        private BookmarkAction() {
            BookmarkAction a;
        }

        private String getName() {
            BookmarkAction a;
            return a.AnnotationViewProvider.this.getPageBookmark() == null ? a.AnnotationViewProvider.this.H.getString("annotation.add.bookmark.button.text") : a.AnnotationViewProvider.this.H.getString("annotation.delete.bookmark.button.text");
        }

        public Object getValue(String a) {
            BookmarkAction a2;
            if ("Name".equals(a)) {
                return a2.getName();
            }
            return super.getValue(a);
        }

        public void actionPerformed(ActionEvent a) {
            BookmarkAction a2;
            Annotation a3 = a2.AnnotationViewProvider.this.getPageBookmark();
            if (a3 == null) {
                a2.AnnotationViewProvider.this.addBookmark();
                super.putValue("Name", (Object)a2.AnnotationViewProvider.this.H.getString("annotation.delete.bookmark.button.text"));
            } else {
                a2.AnnotationViewProvider.this.deleteBookmark(a3);
                super.putValue("Name", a2.getValue("Name"));
            }
            a2.AnnotationViewProvider.this.K.getReaderPane().repaint();
        }

        public boolean updateStatus() {
            BookmarkAction a;
            a.putValue("Name", a.getName());
            return true;
        }

        public int getPriority() {
            return 200;
        }

        public int getType() {
            return 8;
        }
    }
}

