/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.notesandmarks;

import com.amazon.agui.swing.CommandBar;
import com.amazon.agui.swing.HeaderBar;
import com.amazon.agui.swing.SingleSelectionDialog;
import com.amazon.agui.swing.event.GestureDispatcher;
import com.amazon.ebook.booklet.reader.plugin.notesandmarks.AnnotationDialog;
import com.amazon.ebook.booklet.reader.plugin.notesandmarks.AnnotationWidget;
import com.amazon.ebook.booklet.reader.plugin.notesandmarks.BookmarkDialog;
import com.amazon.ebook.booklet.reader.plugin.notesandmarks.HighlightDialog;
import com.amazon.ebook.booklet.reader.plugin.notesandmarks.NoteDialog;
import com.amazon.ebook.booklet.reader.plugin.notesandmarks.NotesAndMarksHistoryHandler;
import com.amazon.ebook.booklet.reader.plugin.notesandmarks.PublicNoteDialog;
import com.amazon.ebook.booklet.reader.sdk.BookNavigator;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationManager;
import com.amazon.ebook.booklet.reader.sdk.event.CloseBookHandler;
import com.amazon.ebook.booklet.reader.sdk.event.EventHandler;
import com.amazon.ebook.booklet.reader.sdk.history.ReaderHistoryHandler;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderAction;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUI;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUIContext;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.PerformanceLog;
import com.amazon.kindle.booklet.BookletContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class AnnotationView
extends ReaderUIContext
implements CloseBookHandler {
    private static final Log LOG = Log.getInstance((String)"AnnotationView");
    public static final int SHOW_ALL = 0;
    public static final int SHOW_USER_ALL = 1;
    public static final int SHOW_NOTES = 2;
    public static final int SHOW_BOOKMARKS = 3;
    public static final int SHOW_HIGHLIGHTS = 4;
    public static final int SHOW_PUBLIC_NOTES = 5;
    public static final int SHOW_POPULAR_HIGHLIGHTS = 6;
    private ResourceBundle rb;
    private ReaderUI readerUI;
    private NotesAndMarksHistoryHandler historyHandler;
    private Book book;
    private List annotations;
    private String headerText;
    private String[] filterTexts;
    private String[] filterButtons;
    private int[] filterIndices;
    private int filterType;
    private int annotationIndex;
    private int numberRow;
    private int numberColumn;
    private int gap;
    private int rowsLow;
    private int rowsHigh;
    private int[] rows600;
    private int[] rows800;
    private int[] rows1200;
    private HeaderBar headerBar;
    private JPanel contentPanel;
    private AnnotationDialog bookmarkDialog;
    private AnnotationDialog highlightDialog;
    private AnnotationDialog noteDialog;
    private AnnotationDialog publicNoteDialog;
    private AnnotationWidget[] widgets;
    private CommandBar commandBar;

    public AnnotationView(ReaderSDK a, ReaderUI a2) {
        super(a);
        AnnotationView a3;
        a3.readerUI = a2;
        a3.filterType = 0;
        a3.historyHandler = new NotesAndMarksHistoryHandler(a, a3);
        a.getRegistry().registerHistoryHandler((ReaderHistoryHandler)a3.historyHandler);
        a.getRegistry().registerHandler((EventHandler)a3);
        a3.setFocusable(true);
        a3.requestFocusInWindow();
        a3.addMouseListener((MouseListener)new GestureDispatcher());
        ActionMap a4 = a3.getActionMap();
        AbstractAction a5 = a3.new PreviousPageAction();
        a4.put("east", a5);
        a4.put("south", a5);
        a5 = a3.new NextPageAction();
        a4.put("west", a5);
        a4.put("north", a5);
        a3.initGUI();
    }

    private void initGUI() {
        AnnotationView a;
        a.rb = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.plugin.notesandmarks.resources.AnnotationResources");
        a.headerText = a.rb.getString("annotation.filter.text");
        a.filterTexts = (String[])a.rb.getObject("annotation.filter.list.display");
        a.filterButtons = (String[])a.rb.getObject("annotation.filter.buttons.display");
        a.filterIndices = (int[])a.rb.getObject("annotation.filter.list.index");
        a.rowsLow = (Integer)a.rb.getObject("annotation.view.rows.low");
        a.rowsHigh = (Integer)a.rb.getObject("annotation.view.rows.high");
        a.rows600 = (int[])a.rb.getObject("annotation.view.rows.600");
        a.rows800 = (int[])a.rb.getObject("annotation.view.rows.800");
        a.rows1200 = (int[])a.rb.getObject("annotation.view.rows.1200");
        a.numberRow = -1;
        a.numberColumn = (Integer)a.rb.getObject("annotation.view.column");
        a.gap = (Integer)a.rb.getObject("annotation.view.gap");
        a.setLayout(new BorderLayout());
        a.headerBar = new HeaderBar("", "", "");
        a.add((Component)a.headerBar, "North");
        a.contentPanel = new JPanel();
        a.add(a.contentPanel, "Center");
        a.commandBar = new CommandBar();
        a.commandBar.setHorizontalGap(((Integer)a.rb.getObject("annotation.commandbar.gap")).intValue());
        a.commandBar.setBorder((Border)a.rb.getObject("annotation.commandbar.border"));
        a.add((Component)a.commandBar, "South");
    }

    /*
     * Enabled aggressive block sorting
     */
    public AnnotationDialog getAnnotationDialog(int a) {
        switch (a) {
            case 0: {
                AnnotationView a2;
                if (a2.bookmarkDialog == null) {
                    a2.bookmarkDialog = new BookmarkDialog(a2.readerSDK, a2.readerUI, a2);
                }
                return a2.bookmarkDialog;
            }
            case 1: {
                AnnotationView a2;
                if (a2.highlightDialog == null) {
                    a2.highlightDialog = new HighlightDialog(a2.readerSDK, a2.readerUI, a2);
                }
                return a2.highlightDialog;
            }
            case 2: {
                AnnotationView a2;
                if (a2.noteDialog == null) {
                    a2.noteDialog = new NoteDialog(a2.readerSDK, a2.readerUI, a2);
                }
                return a2.noteDialog;
            }
            case 8: {
                AnnotationView a2;
                if (a2.publicNoteDialog == null) {
                    a2.publicNoteDialog = new PublicNoteDialog(a2.readerSDK, a2.readerUI, a2);
                }
                return a2.publicNoteDialog;
            }
        }
        return null;
    }

    public boolean closeDialog() {
        AnnotationView a;
        if (a.bookmarkDialog != null && a.bookmarkDialog.isShowing()) {
            a.bookmarkDialog.getCloseAction().actionPerformed(null);
            return true;
        }
        if (a.highlightDialog != null && a.highlightDialog.isShowing()) {
            a.highlightDialog.getCloseAction().actionPerformed(null);
            return true;
        }
        if (a.noteDialog != null && a.noteDialog.isShowing()) {
            a.noteDialog.getCloseAction().actionPerformed(null);
            return true;
        }
        if (a.publicNoteDialog != null && a.publicNoteDialog.isShowing()) {
            a.publicNoteDialog.getCloseAction().actionPerformed(null);
            return true;
        }
        return false;
    }

    public void performGoTo(Annotation a) {
        if (a != null) {
            AnnotationView a2;
            BookNavigator a3 = a2.readerSDK.getBookNavigator();
            if (a3 == null) {
                return;
            }
            a2.recordHistory();
            a3.goTo(a.getStartPosition());
            a2.readerUI.generateUserGoToEvent(false, 0);
            a2.readerUI.showBook();
            PerformanceLog.logEvent((String)"Annotation_GotoAction");
        }
    }

    public void recordHistory() {
        AnnotationView a;
        if (a.annotations == null || a.annotations.size() == 0) {
            return;
        }
        Annotation a2 = (Annotation)a.annotations.get(a.annotationIndex);
        Map a3 = a.historyHandler.createMapData(a2.hashCode(), a.annotationIndex, a2.getStartPosition(), a.filterType);
        a.readerSDK.getReaderHistoryManager().markHistory(a.historyHandler.getID(), a3);
    }

    public void annotationsUpdated() {
        AnnotationView a;
        a.annotations = a.readerSDK.getAnnotationManager().getAllAnnotationsInBook(a.book);
        if (!a.setViewLayout()) {
            a.updateAnnotations();
            a.revalidate();
            a.repaint();
        }
    }

    private boolean setViewLayout() {
        int a;
        AnnotationView a2;
        int a3 = a2.readerUI.getReaderPane().getHeight();
        int[] a4 = a3 < a2.rowsLow ? a2.rows600 : (a3 < a2.rowsHigh ? a2.rows800 : a2.rows1200);
        int a5 = a2.readerUI.getFontSize();
        if (a5 >= a4.length) {
            a5 = a4.length - 1;
        }
        int a6 = a2.numberRow;
        a2.numberRow = a4[a5];
        int a7 = a2.numberRow * a2.numberColumn;
        if (a2.widgets != null && a2.widgets.length == a7 && a2.numberRow == a6) {
            return false;
        }
        a2.contentPanel.removeAll();
        a2.contentPanel.setLayout(new GridLayout(a2.numberRow, a2.numberColumn, 0, a2.gap));
        a2.widgets = new AnnotationWidget[a7];
        int n = a = 0;
        while (n < a7) {
            ActionMap a8 = new ActionMap();
            a8.put("east", a2.new PreviousPageAction());
            a8.put("west", a2.new NextPageAction());
            a2.widgets[a] = new AnnotationWidget(a2.readerSDK, a2.readerUI, a2, a8);
            a2.contentPanel.add(a2.widgets[a]);
            n = ++a;
        }
        a2.updateAnnotations();
        a2.revalidate();
        a2.repaint();
        return true;
    }

    public void paint(Graphics a) {
        AnnotationView a2;
        if (a2.setViewLayout()) {
            return;
        }
        super.paint(a);
    }

    public void initData() {
        Object[] a;
        AnnotationView a2;
        a2.book = null;
        a2.annotations = null;
        a2.book = a2.readerSDK.getCurrentBook();
        if (a2.book == null) {
            return;
        }
        AnnotationManager a3 = a2.readerSDK.getAnnotationManager();
        if (a2.filterType == 0) {
            a2.annotations = a3.getAllAnnotationsInBook(a2.book);
        } else {
            int a4;
            a = a2.getAnnotationTypesForFilterType(a2.filterType);
            a2.annotations = new ArrayList();
            int n = a4 = 0;
            while (n < a.length) {
                List a5 = a3.getAllAnnotationsOfType(a[a4]);
                a2.annotations.addAll(a5);
                n = ++a4;
            }
        }
        Collections.sort(a2.annotations);
        a2.annotationIndex = 0;
        a = new Object[]{new Integer(a2.annotations.size())};
        a2.headerBar.setText(0, MessageFormat.format(a2.headerText, a));
        a2.headerBar.setText(1, a2.filterButtons[a2.filterType]);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int[] getAnnotationTypesForFilterType(int a) {
        switch (a) {
            case 0: {
                return new int[]{1, 2, 0, 7, 8, 5};
            }
            case 1: {
                return new int[]{1, 2, 0};
            }
            case 5: {
                return new int[]{7, 8};
            }
            case 6: {
                return new int[]{5};
            }
            case 4: {
                return new int[]{1};
            }
            case 3: {
                return new int[]{0};
            }
            case 2: {
                return new int[]{2};
            }
        }
        return new int[0];
    }

    private void updateAnnotations() {
        int a;
        AnnotationView a2;
        int a3 = a2.numberRow * a2.numberColumn;
        int a4 = (int)Math.ceil((double)a2.annotations.size() / (double)a3);
        if (a4 == 0) {
            a4 = 1;
        }
        int a5 = (int)Math.floor((double)a2.annotationIndex / (double)a3);
        a2.annotationIndex = a5 * a3;
        int a6 = a2.annotationIndex + a3;
        if (a6 > a2.annotations.size()) {
            a6 = a2.annotations.size();
        }
        int a7 = a2.annotationIndex;
        int a8 = 0;
        Annotation a9 = null;
        int n = a = 0;
        while (n < a2.numberRow) {
            int a10;
            int n2 = a10 = 0;
            while (n2 < a2.numberColumn) {
                AnnotationWidget a11 = a2.widgets[a8];
                a11.showSeparator(a9 != null);
                a9 = a7 < a6 ? (Annotation)a2.annotations.get(a7) : null;
                a11.setAnnotation(a2.book, a9);
                ++a7;
                ++a8;
                n2 = ++a10;
            }
            n = ++a;
        }
        String a22 = a2.rb.getString("annotation.info.page");
        Object[] a12 = new Object[]{new Integer(a5 + 1), new Integer(a4)};
        a2.headerBar.setText(2, MessageFormat.format(a22, a12));
    }

    public boolean removeAnnotation(Annotation a) {
        AnnotationView a2;
        if (a2.annotationIndex == a2.annotations.size() - 1 && a2.annotationIndex > 0 && ((Annotation)a2.annotations.get(a2.annotationIndex)).equals(a)) {
            int a3 = a2.annotationIndex - a2.numberRow * a2.numberColumn;
            a2.annotationIndex = a3 < 0 ? 0 : a3;
        }
        return a2.removeData(a);
    }

    public JComponent createChromeFooter(boolean a) {
        return null;
    }

    public boolean removeData(Object a) {
        AnnotationView a2;
        if (!(a instanceof Annotation)) {
            return false;
        }
        Annotation a3 = (Annotation)a;
        boolean a4 = a2.annotations.remove(a3);
        if (a4) {
            a2.setViewLayout();
            a2.updateAnnotations();
            Object[] a5 = new Object[]{new Integer(a2.annotations.size())};
            a2.headerBar.setText(0, MessageFormat.format(a2.headerText, a5));
        }
        return a4;
    }

    public void goTo(int a, int a2, Position a3, int a4) {
        AnnotationView a5;
        a5.filterType = a4;
        a5.headerBar.setText(1, a5.filterButtons[a4]);
        a5.initData();
        a5.annotationIndex = a2 < a5.annotations.size() && ((Annotation)a5.annotations.get(a2)).hashCode() == a ? a2 : a5.locateAnnotation(a, a3);
        if (!a5.setViewLayout()) {
            a5.updateAnnotations();
        }
    }

    public int locateAnnotation(int a, Position a2) {
        AnnotationView a3;
        int a4 = a3.annotations.size();
        int a5 = a3.numberRow * a3.numberColumn;
        int a6 = 0;
        int a7 = 0;
        int a8 = -1;
        int n = a6;
        while (n < a4) {
            int a9 = a6 + a5;
            if (a9 > a4) {
                a9 = a4;
            }
            int n2 = a6;
            while (n2 < a9) {
                int a10;
                Annotation a11 = (Annotation)a3.annotations.get(a10);
                if (a11.hashCode() == a) {
                    return a6;
                }
                int a12 = a11.getStartPosition().compareTo((Object)a2);
                if (a12 == 0) {
                    if (a8 == -1) {
                        a8 = a6;
                    }
                } else if (a12 > 0) {
                    return a8 != -1 ? a8 : a6;
                }
                n2 = ++a10;
            }
            a7 = a6;
            n = a6 + a5;
        }
        return a8 != -1 ? a8 : a7;
    }

    public void setChromeLayout(boolean a) {
        AnnotationView a2;
        if (a2.readerUI.getChromeUIContext() == null) {
            super.setChromeLayout(a);
        } else {
            a2.readerUI.getChromeUIContext().setChromeLayout(a);
        }
    }

    public ReaderAction getViewAction(String a) {
        AnnotationView a2;
        return a2.new ViewAction(a);
    }

    public ReaderAction getFilterAction(String a) {
        AnnotationView a2;
        return a2.new FilterMenuAction(a);
    }

    public void setContextLayout() {
        ReaderAction[] a;
        AnnotationView a2;
        if (a2.readerSDK != null && (a = (ReaderAction[])a2.readerSDK.getActiveContext()) != null) {
            a.setRefreshSensitivity(-2);
        }
        if (!a2.setViewLayout()) {
            a2.updateAnnotations();
        }
        a2.commandBar.removeAll();
        if (a2.readerUI.getChromeUIContext() == null) {
            ReaderAction[] readerActionArray = new ReaderAction[2];
            a = readerActionArray;
            readerActionArray[0] = a2.readerUI.getFontAction();
            a[1] = a2.readerUI.getGotoAction(a2.rb.getString("annotation.view.button.goto"));
        } else {
            a = a2.readerUI.getChromeUIContext().getChromeFooterActions();
        }
        if (a != null) {
            int a3;
            int n = a3 = 0;
            while (n < a.length) {
                a2.commandBar.add((Action)a[a3]);
                n = ++a3;
            }
        }
    }

    public void switchOut() {
        AnnotationView a;
        a.recordHistory();
    }

    public int availableMenuTypes() {
        return 3;
    }

    public int availableToolbarTypes() {
        return 3;
    }

    public boolean isFullScreen() {
        return false;
    }

    public boolean isChromePersistent() {
        return true;
    }

    public boolean showFooter() {
        return false;
    }

    public boolean isFontChangeable() {
        return true;
    }

    public String getName() {
        return "AnnotationView";
    }

    public void closeBookEvent(Book a, boolean a2) {
        AnnotationView a3;
        a3.book = null;
        if (a3.widgets != null) {
            int a4;
            int n = a4 = 0;
            while (n < a3.widgets.length) {
                a3.widgets[a4].setAnnotation(null, null);
                n = ++a4;
            }
        }
        if (a3.readerUI.getUIContext() instanceof AnnotationView) {
            a3.readerUI.getUIContext().recordHistory();
        }
        a3.annotations = null;
    }

    private class PreviousPageAction
    extends AbstractAction {
        private PreviousPageAction() {
            PreviousPageAction a;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformed(ActionEvent a) {
            PreviousPageAction a2;
            LOG.info("Previous Page");
            if (a2.AnnotationView.this.closeDialog()) {
                return;
            }
            int a3 = a2.AnnotationView.this.annotationIndex - a2.AnnotationView.this.numberRow * a2.AnnotationView.this.numberColumn;
            if (a3 < 0) {
                if (a2.AnnotationView.this.annotationIndex <= 0) return;
                a2.AnnotationView.this.annotationIndex = 0;
            } else {
                a2.AnnotationView.this.annotationIndex = a3;
            }
            a2.AnnotationView.this.updateAnnotations();
            a2.AnnotationView.this.readerUI.getReaderPane().repaint();
            PerformanceLog.logEvent((String)"AnnotationView_PrevPage");
        }
    }

    private class NextPageAction
    extends AbstractAction {
        private NextPageAction() {
            NextPageAction a;
        }

        public void actionPerformed(ActionEvent a) {
            NextPageAction a2;
            LOG.info("Next Page");
            if (a2.AnnotationView.this.closeDialog()) {
                return;
            }
            int a3 = a2.AnnotationView.this.annotationIndex + a2.AnnotationView.this.numberRow * a2.AnnotationView.this.numberColumn;
            if (a3 >= a2.AnnotationView.this.annotations.size()) {
                return;
            }
            a2.AnnotationView.this.annotationIndex = a3;
            a2.AnnotationView.this.updateAnnotations();
            a2.AnnotationView.this.readerUI.getReaderPane().repaint();
            PerformanceLog.logEvent((String)"AnnotationView_NextPage");
        }
    }

    class FilterAction
    extends AbstractAction {
        int type;

        public FilterAction(String a, int a2) {
            FilterAction a3;
            super(a);
            a3.type = a2;
        }

        public void actionPerformed(ActionEvent a) {
            FilterAction a2;
            a2.AnnotationView.this.filterType = a2.type;
            a2.AnnotationView.this.headerBar.setText(1, a2.AnnotationView.this.filterButtons[a2.AnnotationView.this.filterType]);
            a2.AnnotationView.this.initData();
            a2.AnnotationView.this.updateAnnotations();
            a2.AnnotationView.this.repaint();
        }
    }

    public class FilterMenuAction
    extends ReaderAction {
        public FilterMenuAction(String a) {
            FilterMenuAction a2;
            super(a);
        }

        public void actionPerformed(ActionEvent a) {
            FilterMenuAction a2;
            SingleSelectionDialog a3 = new SingleSelectionDialog(((BookletContext)a2.AnnotationView.this.readerSDK.getActiveContext()).getName());
            a3.setTitle(a2.AnnotationView.this.rb.getString("annotation.filter.title"));
            AnnotationManager a4 = a2.AnnotationView.this.readerSDK.getAnnotationManager();
            int a5 = 0;
            int a6 = a2.AnnotationView.this.filterIndices.length;
            int n = a5;
            while (n < a6) {
                int a7;
                int[] a8 = a2.AnnotationView.this.getAnnotationTypesForFilterType(a2.AnnotationView.this.filterIndices[a5]);
                int a9 = 0;
                int n2 = a7 = 0;
                while (n2 < a8.length) {
                    a9 += a4.getNumberOfAnnotationsOfTypeInBook(a8[a7], a2.AnnotationView.this.book);
                    n2 = ++a7;
                }
                String a22 = MessageFormat.format(a2.AnnotationView.this.filterTexts[a5], new Integer(a9));
                FilterAction a10 = new FilterAction(a22, a2.AnnotationView.this.filterIndices[a5]);
                a10.setEnabled(a9 > 0);
                AbstractButton a11 = a3.addAction((Action)a10);
                if (a5 == a2.AnnotationView.this.filterType) {
                    a11.setSelected(true);
                }
                n = ++a5;
            }
            a3.postDialog();
        }

        public int getPriority() {
            return 201;
        }

        public int getType() {
            return 2;
        }

        public int getSubType() {
            return 1;
        }
    }

    private class ViewAction
    extends ReaderAction {
        public ViewAction(String a) {
            ViewAction a2;
            super(a);
            a2.setEnabled(!a2.AnnotationView.this.readerSDK.getCurrentBook().getMetadata().isSample());
        }

        public void actionPerformed(ActionEvent a) {
            ViewAction a2;
            a2.AnnotationView.this.readerUI.getUIContext().recordHistory();
            a2.AnnotationView.this.initData();
            a2.AnnotationView.this.readerUI.showContent((ReaderUIContext)a2.AnnotationView.this);
            PerformanceLog.logEvent((String)"AnnotationView_show");
        }

        public int getPriority() {
            return 201;
        }

        public int getType() {
            return 4;
        }
    }
}

