/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.notesandmarks;

import com.amazon.agui.swing.CaretDialog;
import com.amazon.ebook.booklet.reader.plugin.notesandmarks.AnnotationView;
import com.amazon.ebook.booklet.reader.sdk.BookNavigator;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUI;
import com.amazon.ebook.booklet.reader.utils.UIUtils;
import com.amazon.ebook.util.log.PerformanceLog;
import com.amazon.kindle.booklet.BookletContext;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Timer;

public class AnnotationDialog
extends CaretDialog
implements WindowListener {
    protected ResourceBundle rb;
    protected ReaderSDK readerSDK;
    protected ReaderUI readerUI;
    protected AnnotationView annotationView;
    protected Annotation annotation;
    protected Dimension panelSize;
    protected int gap;
    private final long DELAY = 200L;

    public AnnotationDialog(ReaderSDK a, ReaderUI a2, AnnotationView a3) {
        super(((BookletContext)a.getActiveContext()).getName(), false);
        AnnotationDialog a4;
        a4.readerSDK = a;
        a4.readerUI = a2;
        a4.annotationView = a3;
        a4.rb = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.plugin.notesandmarks.resources.AnnotationResources");
        a4.gap = (Integer)a4.rb.getObject("annotation.view.gap");
        a4.initUI();
    }

    protected void initUI() {
        AnnotationDialog a;
        a.setAutoCenteredEnabled(false);
        a.getCommandBar().setButtonWidthPreserved(false);
    }

    public void postDialog(Container a) {
        AnnotationDialog a2;
        a2.getFrame().addWindowListener(a2);
        Rectangle a3 = a.getBounds();
        a3.height += a2.gap;
        UIUtils.setCaretDialog((CaretDialog)a2, (Dimension)a2.panelSize, (Container)a.getParent(), (Container)a.getParent(), (Rectangle)a3, (boolean)false, (boolean)true);
        super.postDialog();
        PerformanceLog.logEvent((String)"AnnotationDialog_Posted");
    }

    public void setAnnotation(Book a, Annotation a2) {
        a.annotation = a2;
    }

    public void windowActivated(WindowEvent a) {
    }

    public void windowClosed(WindowEvent a) {
        AnnotationDialog a2;
        a2.getFrame().removeWindowListener(a2);
    }

    public void windowClosing(WindowEvent a) {
    }

    public void windowDeactivated(WindowEvent a) {
        AnnotationDialog a2;
        Timer a3 = new Timer(200, a2.new CloseAnnotationDialogAction());
        a3.setRepeats(false);
        a3.start();
    }

    public void windowDeiconified(WindowEvent a) {
    }

    public void windowIconified(WindowEvent a) {
    }

    public void windowOpened(WindowEvent a) {
    }

    class CloseAnnotationDialogAction
    implements ActionListener {
        CloseAnnotationDialogAction() {
            CloseAnnotationDialogAction a;
        }

        public void actionPerformed(ActionEvent a) {
            CloseAnnotationDialogAction a2;
            a2.AnnotationDialog.this.readerSDK.invokeLater(new Runnable(){
                {
                    1 a;
                }

                public void run() {
                    1 a;
                    AnnotationDialog.this.closeDialog();
                }
            });
        }
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            DeleteAction a;
            super(a.AnnotationDialog.this.rb.getString("annotation.dialog.button.delete"));
        }

        public void actionPerformed(ActionEvent a) {
            DeleteAction a2;
            a2.AnnotationDialog.this.readerSDK.getAnnotationManager().deleteAnnotation(a2.AnnotationDialog.this.annotation, a2.AnnotationDialog.this.readerSDK.getCurrentBook());
            a2.AnnotationDialog.this.getCloseAction().actionPerformed(null);
            a2.AnnotationDialog.this.annotationView.removeAnnotation(a2.AnnotationDialog.this.annotation);
            a2.AnnotationDialog.this.readerUI.getReaderPane().repaint();
        }
    }

    class GotoAction
    extends AbstractAction {
        public GotoAction(String a) {
            GotoAction a2;
            super(a);
        }

        public void actionPerformed(ActionEvent a) {
            GotoAction a2;
            if (a2.AnnotationDialog.this.annotation == null) {
                return;
            }
            BookNavigator a3 = a2.AnnotationDialog.this.readerSDK.getBookNavigator();
            if (a3 == null) {
                return;
            }
            a2.AnnotationDialog.this.annotationView.recordHistory();
            a2.AnnotationDialog.this.getCloseAction().actionPerformed(null);
            a3.goTo(a2.AnnotationDialog.this.annotation.getStartPosition());
            a2.AnnotationDialog.this.readerUI.showBook();
            PerformanceLog.logEvent((String)"Annotation_GotoAction");
        }
    }
}

