/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.indexview;

import com.amazon.agui.swing.event.GestureDispatcher;
import com.amazon.ebook.booklet.reader.plugin.indexview.IndexHistoryHandler;
import com.amazon.ebook.booklet.reader.plugin.indexview.IndexViewController;
import com.amazon.ebook.booklet.reader.plugin.indexview.IndexWidget;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.IndexItem;
import com.amazon.ebook.booklet.reader.sdk.history.ReaderHistoryHandler;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderAction;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUI;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUIContext;
import com.amazon.ebook.util.log.Log;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class IndexView
extends ReaderUIContext {
    private static final Log LOG = Log.getInstance((String)"IndexView");
    private ResourceBundle rb;
    private ReaderUI readerUI;
    private IndexViewController controller;
    private IndexHistoryHandler historyHandler;
    private int numberRow;
    private int numberColumn;
    private int maxItems;
    private int gap;
    private int boundLow;
    private int boundHigh;
    private int rowHeight;
    private int columnsLess;
    private int columnsNormal;
    private int columnsMore;
    private IndexWidget[] widgets;
    private String searchTerm;
    private JPanel indexPanel;
    private JPanel emptyPanel;
    private Dimension keyboardDown;
    private Dimension keyboardUp;

    public IndexView(ReaderSDK a, ReaderUI a2) {
        super(a);
        IndexView a3;
        a3.readerUI = a2;
        a3.controller = new IndexViewController(a, a3);
        a3.historyHandler = new IndexHistoryHandler(a, a3);
        a.getRegistry().registerHistoryHandler((ReaderHistoryHandler)a3.historyHandler);
        a3.setFocusable(true);
        a3.requestFocusInWindow();
        a3.addMouseListener((MouseListener)new GestureDispatcher());
        ActionMap a4 = a3.getActionMap();
        AbstractAction a5 = a3.new PreviousPageAction();
        a4.put("east", a5);
        a4.put("south", a5);
        a5 = a3.new NextPageAction();
        a4.put("west", a5);
        a4.put("north", a5);
        a3.initGUI();
    }

    private void initGUI() {
        IndexView a;
        a.rb = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.plugin.indexview.resources.IndexViewResources");
        a.boundLow = (Integer)a.rb.getObject("index.view.bound.low");
        a.boundHigh = (Integer)a.rb.getObject("index.view.bound.high");
        a.rowHeight = (Integer)a.rb.getObject("index.view.row.height");
        a.columnsLess = (Integer)a.rb.getObject("index.view.columns.less");
        a.columnsNormal = (Integer)a.rb.getObject("index.view.columns.normal");
        a.columnsMore = (Integer)a.rb.getObject("index.view.columns.more");
        int a2 = (Integer)a.rb.getObject("index.view.margin.top");
        int a3 = (Integer)a.rb.getObject("index.view.margin.bottom");
        int a4 = (Integer)a.rb.getObject("index.view.margin.left");
        int a5 = (Integer)a.rb.getObject("index.view.margin.right");
        a.numberRow = -1;
        a.numberColumn = -1;
        a.maxItems = 0;
        a.gap = (Integer)a.rb.getObject("index.view.gap");
        a.keyboardDown = (Dimension)a.rb.getObject("index.view.keyboard.down");
        a.keyboardUp = (Dimension)a.rb.getObject("index.view.keyboard.up");
        a.setBorder(new EmptyBorder(a2 - a.gap, a4, a3 - a.gap, a5));
        a.setLayout(new BorderLayout());
        a.indexPanel = new JPanel();
        a.indexPanel.addComponentListener(a.new IndexPanelListener());
        a.add(a.indexPanel, "Center");
        a.emptyPanel = new JPanel();
        a.emptyPanel.setPreferredSize(a.keyboardDown);
        a.add(a.emptyPanel, "South");
    }

    public int getMaxDisplayItems() {
        IndexView a;
        return a.maxItems;
    }

    private boolean setViewLayout() {
        IndexView a;
        int a2 = a.indexPanel.getHeight() / a.rowHeight;
        int a3 = a.indexPanel.getWidth();
        int a4 = (a.indexPanel.getWidth() - (a.numberColumn - 1) * a.gap) / a.numberColumn;
        int a5 = a3 < a.boundLow ? a.columnsLess : (a3 < a.boundHigh ? a.columnsNormal : a.columnsMore);
        a.maxItems = a2 * a5;
        if (a.widgets != null && a.widgets.length == a.maxItems && a.numberRow == a2 && a.numberColumn == a5) {
            return false;
        }
        a.numberRow = a2;
        a.numberColumn = a5;
        a.indexPanel.removeAll();
        a.indexPanel.setLayout(new GridLayout(1, a.numberColumn, a.gap, 0));
        a.widgets = new IndexWidget[a.maxItems];
        Dimension a6 = new Dimension(a4, a.rowHeight);
        int a7 = 0;
        int a8 = 0;
        int n = a7;
        while (n < a.numberColumn) {
            int a9;
            JPanel a10 = new JPanel();
            a10.setLayout(new BoxLayout(a10, 1));
            int n2 = a9 = 0;
            while (n2 < a.numberRow) {
                IndexWidget a11;
                ActionMap a12 = new ActionMap();
                a12.put("east", a.new PreviousPageAction());
                a12.put("west", a.new NextPageAction());
                a.widgets[a8] = a11 = new IndexWidget(a, a6, a12);
                a10.add(a11);
                ++a8;
                n2 = ++a9;
            }
            a10.add(Box.createVerticalGlue());
            a.indexPanel.add(a10);
            n = ++a7;
        }
        a.updateData();
        return true;
    }

    public void initData() {
        IndexView a;
        a.controller.openIndex();
        a.controller.moveCursorTo(a.searchTerm);
    }

    public void recordHistory() {
        IndexView a;
        IndexItem a2 = a.controller.getIndexItemAtCursor();
        if (a2 == null) {
            return;
        }
        Map a3 = a.historyHandler.createMapData(a2.getLabel());
        a.readerSDK.getReaderHistoryManager().markHistory(a.historyHandler.getID(), a3);
    }

    public void setSearchTerm(String a) {
        a.searchTerm = a;
    }

    public String getSearchTerm() {
        IndexView a;
        return a.searchTerm;
    }

    public void moveCursor(String a) {
        IndexView a2;
        a2.searchTerm = a;
        a2.controller.moveCursorTo(a2.searchTerm);
        a2.updateData();
    }

    private void updateData() {
        int a;
        IndexView a2;
        int a3 = a2.controller.getNumberOfDisplayableRows();
        int a4 = 0;
        int n = a = 0;
        while (n < a2.numberRow) {
            int a5;
            int n2 = a5 = 0;
            while (n2 < a2.numberColumn) {
                IndexWidget a6 = a2.widgets[a4];
                if (a4 < a3) {
                    a6.setItem(a2.controller.getIndexItemAtCursor());
                    a2.controller.moveCursor(1);
                } else {
                    a6.setItem(null);
                }
                ++a4;
                n2 = ++a5;
            }
            n = ++a;
        }
        a2.controller.moveCursor(-a3);
    }

    public ReaderAction getViewAction(String a) {
        IndexView a2;
        return a2.new ViewAction(a);
    }

    public void setContextLayout() {
        IndexView a;
        if (!a.setViewLayout()) {
            a.updateData();
        }
    }

    public void close() {
        IndexView a;
        a.recordHistory();
        a.readerUI.showBook();
    }

    public void goTo(IndexItem a) {
        IndexView a2;
        a2.controller.jump(a);
        a2.close();
    }

    public void goTo() {
        IndexView a;
        a.goTo(a.controller.getIndexItemAtCursor());
    }

    public void goTo(String a) {
        IndexView a2;
        a2.searchTerm = a;
        a2.initData();
        a2.goTo();
    }

    public void switchOut() {
        IndexView a;
        a.recordHistory();
    }

    public boolean isFullScreen() {
        return false;
    }

    public boolean isChromePersistent() {
        return true;
    }

    public boolean showFooter() {
        return false;
    }

    class IndexPanelListener
    implements ComponentListener {
        IndexPanelListener() {
            IndexPanelListener a;
        }

        public void componentHidden(ComponentEvent a) {
        }

        public void componentMoved(ComponentEvent a) {
        }

        public void componentResized(ComponentEvent a) {
            IndexPanelListener a2;
            a2.IndexView.this.setViewLayout();
        }

        public void componentShown(ComponentEvent a) {
        }
    }

    private class PreviousPageAction
    extends AbstractAction {
        private PreviousPageAction() {
            PreviousPageAction a;
        }

        public void actionPerformed(ActionEvent a) {
            PreviousPageAction a2;
            LOG.info("Previous Page");
            if (a2.IndexView.this.controller.previousPage()) {
                a2.IndexView.this.updateData();
                a2.IndexView.this.readerUI.getReaderPane().repaint();
            }
        }
    }

    private class NextPageAction
    extends AbstractAction {
        private NextPageAction() {
            NextPageAction a;
        }

        public void actionPerformed(ActionEvent a) {
            NextPageAction a2;
            LOG.info("Next Page");
            if (a2.IndexView.this.controller.nextPage()) {
                a2.IndexView.this.updateData();
                a2.IndexView.this.readerUI.getReaderPane().repaint();
            }
        }
    }

    private class ViewAction
    extends ReaderAction {
        public ViewAction(String a) {
            ViewAction a2;
            super(a);
        }

        public void actionPerformed(ActionEvent a) {
            ViewAction a2;
            a2.IndexView.this.readerUI.getUIContext().recordHistory();
            a2.IndexView.this.initData();
            a2.IndexView.this.readerUI.showContent((ReaderUIContext)a2.IndexView.this);
        }

        public int getPriority() {
            return 115;
        }

        public int getType() {
            return 7;
        }
    }
}

