/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.clippings;

import com.amazon.ebook.booklet.reader.plugin.clippings.ClippingSaveException;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.ByteOffsetBasedPosition;
import com.amazon.ebook.booklet.reader.sdk.content.PageNumberManager;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.ClippingData;
import com.amazon.ebook.util.file.FileSystemUtil;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.text.StringUtil;
import com.amazon.kindle.apps.util.MetadataUtils;
import com.amazon.kindle.restricted.runtime.Const;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;

public class Clipping {
    private static final String c = "UTF-8";
    private static final String l = "\ufeff";
    private static final String k = "-";
    private static final String m = "\r\n";
    private static final String h = "==========";
    private static final String A = "clippingLimits";
    private static final Log H = Log.getInstance((String)"Clipping");
    private File b;
    private boolean K;
    private Properties B;
    private final ReaderSDK D;

    public Clipping(ReaderSDK a) {
        Clipping a2;
        a2.b = null;
        a2.K = false;
        a2.B = null;
        a2.D = a;
        a2.b = new File(Const.getInstance().getBookDirectory() + File.separatorChar + MetadataUtils.getMyClippingsFileName());
        a2.B = a2.loadClippingLimits();
    }

    Clipping(ReaderSDK a, File a2, Properties a3) {
        Clipping a4;
        a4.b = null;
        a4.K = false;
        a4.B = null;
        a4.D = a;
        a4.b = a2;
        a4.B = a3;
    }

    private final Properties loadClippingLimits() {
        Properties a = new Properties();
        BufferedInputStream a2 = null;
        FileInputStream a3 = null;
        try {
            Clipping a4;
            a3 = new FileInputStream(a4.getClippingLimitsPath());
            a2 = new BufferedInputStream(a3);
            a.load(a2);
            a2.close();
            a3.close();
        }
        catch (FileNotFoundException a5) {
            H.debug("Clipping Limits File Not Found");
        }
        catch (IOException a6) {
            H.debug("Cannot read Clipping Limits File");
        }
        return a;
    }

    private void saveClippingLimits() throws ClippingSaveException {
        BufferedOutputStream a = null;
        FileOutputStream a2 = null;
        try {
            Clipping a3;
            a2 = new FileOutputStream(a3.getClippingLimitsPath());
            a = new BufferedOutputStream(a2);
            a3.B.store(a, "Last Update: " + a3.getCurrentTime());
            a.close();
            a2.close();
        }
        catch (FileNotFoundException a4) {
            throw new ClippingSaveException("Clipping limit file not found: " + a4.getMessage());
        }
        catch (IOException a5) {
            throw new ClippingSaveException("Updating clipping limit file failed: " + a5.getMessage());
        }
    }

    private void increaseWordCountForBook(String a, int a2) {
        Clipping a3;
        int a4 = a3.getExistingCount(a);
        a3.B.setProperty(a, Integer.toString(a4 += a2));
    }

    public int getExistingCount(String a) {
        Clipping a2;
        String a3 = a2.B.getProperty(a, "0");
        int a4 = Integer.MAX_VALUE;
        try {
            a4 = Integer.parseInt(a3);
        }
        catch (NumberFormatException a5) {
            H.error("Invalid Clipping Limit data format.", (Throwable)a5);
        }
        return a4;
    }

    private String getCurrentTime() {
        Date a = new Date();
        return DateFormat.getDateTimeInstance(0, 0).format(a);
    }

    private final String getClippingLimitsPath() {
        String a = Const.getInstance().getWritablePreferencesDirectory();
        File a2 = new File(a = a + File.separator + "com.amazon.ebook.booklet.reader");
        if (!a2.exists() && !a2.mkdir()) {
            H.error("Unable to create Clipping Limit directory!");
        }
        return a + File.separator + A;
    }

    public static String getUID(Book a) {
        String a2 = a.getIdentifier();
        if (a2 == null || a2.length() == 0) {
            a2 = a.getPath();
        }
        return a2;
    }

    public String getCurrentClippingFilePath() {
        Clipping a;
        if (a.b == null) {
            return null;
        }
        return a.b.getAbsolutePath();
    }

    public void addCountToClippingLimit(String a, int a2) throws ClippingSaveException {
        Clipping a3;
        a3.increaseWordCountForBook(a, a2);
        a3.saveClippingLimits();
    }

    public void insertClipping(String a, int a2, Annotation a3) throws ClippingSaveException {
        Clipping a4;
        PageNumberManager a5 = a4.D.getPageNumberManager();
        a4.insertClipping(a, a2, a3, new Date(), a4.D.getCurrentBook(), a5);
    }

    public void insertClipping(String a, int a2, Annotation a3, Date a4, Book a5, PageNumberManager a6) throws ClippingSaveException {
        Clipping a7;
        if (a3 == null) {
            throw new IllegalArgumentException("annotation parameter cannot be null");
        }
        int a8 = a5.getMetadata().getClippingLimit();
        if (a8 < 0 || a8 > 100) {
            a8 = 100;
        }
        ClippingData a9 = a3.getClippingData(a5);
        if (a9.K != null) {
            if (a9.b > 0 && a8 != 100) {
                int a10;
                if (a8 == 0) {
                    a9.K = Clipping.formatLimitedBookContent(a5, "", 0);
                } else if (a8 < 100 && a9.b >= (a10 = a7.getAllowedClipCount(a, a2, a8))) {
                    a9.K = Clipping.formatLimitedBookContent(a5, a9.K, a10);
                    a9.b = a10;
                }
            }
        } else {
            H.error("Attempting to post null content to MyClippings");
            return;
        }
        a7.writeToFile(Clipping.buildClippingString(a5, a4, a3.getEndPosition(), a6, a9));
        if (a9.b > 0) {
            a7.addCountToClippingLimit(a, a9.b);
        }
    }

    private int getAllowedClipCount(String a, int a2, int a3) {
        Clipping a4;
        int a5 = a2 * a3 / 100;
        int a6 = a4.getExistingCount(a);
        int a7 = a5 - a6;
        if (a7 < 0) {
            a7 = 0;
        }
        if (Log.isDebugOn()) {
            H.debug("inserting Clipping - maxAllowed: " + a5 + " clippsedSoFar: " + a6);
        }
        return a7;
    }

    private static String formatLimitedBookContent(Book a, String a2, int a3) {
        String a4 = null;
        if (a.getMetadata().isPublisherLimit() && (a4 = a.getMetadata().getPublisher()) == null) {
            a4 = "";
        }
        StringBuffer a5 = new StringBuffer();
        ResourceBundle a6 = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.plugin.clippings.resources.ClippingsResources");
        if (a2 != null && a3 > 0) {
            if (a3 < a2.length()) {
                a5.append(a2.substring(0, a3));
            } else {
                a5.append(a2);
            }
            a5.append(' ');
        }
        a5.append('<');
        if (a.getMetadata().hasPassword()) {
            a5.append(a6.getString("reader.clipping.password.protected"));
        } else {
            a5.append(a6.getString("reader.clipping.reached.limit"));
            if (a4 != null) {
                a5.append(a6.getString("reader.clipping.publisher.text"));
                if (a4.length() > 0) {
                    a5.append(", ");
                    a5.append(a4);
                }
            } else {
                a5.append(a6.getString("reader.clipping.clipping.item"));
            }
        }
        a5.append('>');
        return a5.toString();
    }

    private static String buildClippingString(Book a, Date a2, Position a3, PageNumberManager a4, ClippingData a5) {
        String a6;
        Object a7;
        Object a8;
        ResourceBundle a9 = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.plugin.clippings.resources.ClippingsResources");
        StringBuffer a10 = new StringBuffer(a5.K.length() + 200);
        a10.append(a.getMetadata().getTitle());
        a10.append(' ');
        String a11 = a.getMetadata().getDisplayFriendlyAuthors();
        if (StringUtil.isNotEmpty((String)a11)) {
            a10.append('(');
            a10.append(a11);
            a10.append(')');
        }
        a10.append(m);
        a10.append(k);
        a10.append(' ');
        a10.append(a5.B);
        a10.append(' ');
        if (a4 != null && a4.isPageNumberingSupported()) {
            a8 = a4.getPageLabelForLastPosition((ByteOffsetBasedPosition)a3);
            boolean a12 = ((String)a8).length() != 0;
            a7 = a12 ? a9.getString("reader.clipping.labeled.page") : a9.getString("reader.clipping.unlabeled.page");
            Object[] a13 = new Object[]{a8};
            String a14 = MessageFormat.format((String)a7, a13);
            a6 = a14 + " | " + a5.D;
        } else if (a.getType() == 3) {
            a8 = a9.getString("reader.clipping.pdf.location");
            a6 = MessageFormat.format((String)a8, a5.D);
        } else {
            a6 = a5.D;
        }
        a10.append(a6);
        a8 = DateFormat.getDateTimeInstance(0, 0);
        String a15 = "";
        try {
            a7 = (SimpleDateFormat)a8;
            ((SimpleDateFormat)a7).applyPattern("EEEE, MMMM dd, yyyy, hh:mm aa");
            a15 = ((DateFormat)a7).format(a2);
        }
        catch (ClassCastException a16) {
            a15 = ((DateFormat)a8).format(a2);
        }
        a10.append(" | Added on ");
        a10.append(a15);
        a10.append(m);
        a10.append(m);
        a10.append(a5.K);
        a10.append(m);
        a10.append(h);
        a10.append(m);
        return a10.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeToFile(String a) {
        block29: {
            Clipping a2;
            if (!a2.b.exists()) {
                a2.K = true;
            }
            FileOutputStream a3 = null;
            OutputStreamWriter a4 = null;
            BufferedWriter a5 = null;
            a3 = FileSystemUtil.createFileOutputStream((File)a2.b, (boolean)true);
            a4 = new OutputStreamWriter((OutputStream)a3, c);
            a5 = new BufferedWriter(a4);
            if (a2.K) {
                a5.write(l, 0, l.length());
            }
            a5.write(a, 0, a.length());
            a5.flush();
            Object var7_5 = null;
            try {
                if (a5 != null) {
                    a5.close();
                }
                if (a4 != null) {
                    a4.close();
                }
                if (a3 != null) {
                    a3.close();
                }
                break block29;
            }
            catch (IOException a6) {
                H.error("Failed closing MyClippings file", (Throwable)a6);
            }
            break block29;
            {
                catch (FileNotFoundException a7) {
                    H.error("MyClippings file not found", (Throwable)a7);
                    Object var7_6 = null;
                    try {
                        if (a5 != null) {
                            a5.close();
                        }
                        if (a4 != null) {
                            a4.close();
                        }
                        if (a3 != null) {
                            a3.close();
                        }
                        break block29;
                    }
                    catch (IOException a6) {
                        H.error("Failed closing MyClippings file", (Throwable)a6);
                    }
                    break block29;
                }
                catch (UnsupportedEncodingException a8) {
                    H.error("Unsupported encoding for MyClippings file", (Throwable)a8);
                    Object var7_7 = null;
                    try {
                        if (a5 != null) {
                            a5.close();
                        }
                        if (a4 != null) {
                            a4.close();
                        }
                        if (a3 != null) {
                            a3.close();
                        }
                        break block29;
                    }
                    catch (IOException a6) {
                        H.error("Failed closing MyClippings file", (Throwable)a6);
                    }
                    break block29;
                }
                catch (IOException a9) {
                    H.error("Failed writing to MyClippings file", (Throwable)a9);
                    Object var7_8 = null;
                    try {
                        if (a5 != null) {
                            a5.close();
                        }
                        if (a4 != null) {
                            a4.close();
                        }
                        if (a3 != null) {
                            a3.close();
                        }
                        break block29;
                    }
                    catch (IOException a6) {
                        H.error("Failed closing MyClippings file", (Throwable)a6);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (a5 != null) {
                        a5.close();
                    }
                    if (a4 != null) {
                        a4.close();
                    }
                    if (a3 != null) {
                        a3.close();
                    }
                }
                catch (IOException a6) {
                    H.error("Failed closing MyClippings file", (Throwable)a6);
                }
                throw throwable;
            }
        }
    }
}

