/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.plugin.action;

import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.ReaderPlugin;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.event.EventHandler;
import com.amazon.ebook.booklet.reader.sdk.event.ShownBookHandler;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUI;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUIContext;
import com.amazon.ebook.util.log.Log;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.booklet.ChromeException;
import com.amazon.kindle.booklet.ChromeHeaderBar;
import com.amazon.kindle.booklet.ChromeSearchBarRequest;
import java.net.URI;
import java.util.Map;

public class ActionPlugin
extends ReaderPlugin
implements ShownBookHandler {
    private static final Log k = Log.getInstance((String)"ActionPlugin");
    private static final String m = "goto";
    private static final String h = "annotation";
    private static final String A = "search";
    private static final String H = "action";
    private ReaderSDK K;
    private String B;

    public ActionPlugin() {
        ActionPlugin a;
    }

    public String getName() {
        return "Action";
    }

    public void pluginLoad(ReaderSDK a) throws BookException {
        ActionPlugin a2;
        a2.K = a;
        a.getRegistry().registerHandler((EventHandler)a2);
    }

    public synchronized boolean openURI(URI a, Map a2) throws BookException {
        ActionPlugin a3;
        a3.B = (String)a2.get(H);
        if (a3.B == null) {
            return false;
        }
        a3.openBook(a, a2);
        if (a3.B.equals(m)) {
            a3.K.invokeLater((Runnable)a3.new GoToDialogRunnable());
        } else if (a3.B.equals(h)) {
            a3.K.invokeLater((Runnable)a3.new AnnotationRunnable());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openBook(URI a, Map a2) throws BookException {
        Book a3 = null;
        boolean a4 = false;
        try {
            ActionPlugin a5;
            a3 = a5.K.openBook(a.getPath());
            a5.K.switchToBook(a3, "", null);
            a4 = true;
            Object var6_5 = null;
            if (a3 == null) return;
            if (a4) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (a3 == null || a4) throw throwable;
            try {
                a3.close();
                throw throwable;
            }
            catch (Exception a6) {
                k.warning("Failed to close book", (Throwable)a6);
            }
            throw throwable;
        }
        try {
            a3.close();
            return;
        }
        catch (Exception a6) {
            k.warning("Failed to close book", (Throwable)a6);
        }
    }

    public void pluginUnload() {
    }

    private void popChromeAndFocus() {
        ActionPlugin a;
        BookletContext a2 = (BookletContext)a.K.getActiveContext();
        Booklet a3 = (Booklet)a.K.getActiveBooklet();
        ChromeHeaderBar a4 = (ChromeHeaderBar)a2.getService(ChromeHeaderBar.class);
        if (a4 != null) {
            ChromeSearchBarRequest a5 = new ChromeSearchBarRequest(a2.getName());
            try {
                a4.setSearchBarSearchState(a3, a5, null, true);
            }
            catch (ChromeException a6) {
                k.error("chrome exception", (Throwable)a6);
            }
            a4.setTransientChromeVisible(true);
        }
    }

    public synchronized void shownBookEvent(Book a) {
        ActionPlugin a2;
        if (a2.B != null && a2.B.equals(A)) {
            a2.popChromeAndFocus();
            a2.B = null;
        }
    }

    private class PopChromeHeaderFocusRunnable
    implements Runnable {
        private PopChromeHeaderFocusRunnable() {
            PopChromeHeaderFocusRunnable a;
        }

        public void run() {
            PopChromeHeaderFocusRunnable a;
            a.ActionPlugin.this.popChromeAndFocus();
        }
    }

    private class AnnotationRunnable
    implements Runnable {
        private AnnotationRunnable() {
            AnnotationRunnable a;
        }

        public void run() {
            AnnotationRunnable a;
            ReaderUI a2 = a.ActionPlugin.this.K.getUI();
            if (a2 != null) {
                ReaderUIContext a3 = a2.getAnnotationView();
                a3.initData();
                a2.showContent(a3);
            }
        }
    }

    private class GoToDialogRunnable
    implements Runnable {
        private GoToDialogRunnable() {
            GoToDialogRunnable a;
        }

        public void run() {
            GoToDialogRunnable a;
            if (a.ActionPlugin.this.K.getUI() != null && a.ActionPlugin.this.K.getUI().getGotoAction() != null) {
                a.ActionPlugin.this.K.getUI().getGotoAction().actionPerformed(null);
            }
        }
    }
}

