/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.util.prelayout.image;

import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContents;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.Profiler;
import com.amazon.ebook.util.prelayout.CacheManager;
import com.amazon.ebook.util.prelayout.PrelayoutEngine;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;

public class ArticleListPrelayoutEngine
extends PrelayoutEngine {
    private static final Log LOG;
    private static final boolean CACHE_ENABLED = true;
    private static final int DEFAULT_PRECACHE_FACTOR = 4;
    private static final Profiler p;
    private static final MediaTracker imageTracker;
    private int preCacheFactor = 4;
    private Book book;
    private TableOfContents toc;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ArticleListPrelayoutEngine(CacheManager a) {
        super(a);
        ArticleListPrelayoutEngine a2;
    }

    public void setBook(Book a) {
        a.book = a;
        a.toc = a.getTOC();
    }

    public Book getBook() {
        ArticleListPrelayoutEngine a;
        return a.book;
    }

    public void setPreCacheFactor(int a) {
        a.preCacheFactor = a;
    }

    public int getPreCacheFactor() {
        ArticleListPrelayoutEngine a;
        return a.preCacheFactor;
    }

    protected void prelayoutAndCache(Object a) {
        ArticleListPrelayoutEngineData a2;
        TableOfContentsEntry a3;
        ArticleListPrelayoutEngine a4;
        if (a4.toc == null) {
            return;
        }
        if (!(a instanceof ArticleListPrelayoutEngineData)) {
            return;
        }
        if (Log.isDebugOn()) {
            LOG.debug("Starting prelayout {{{");
        }
        if ((a3 = (a2 = (ArticleListPrelayoutEngineData)a).getTOCEntry()) == null) {
            return;
        }
        ImageDimensionController a5 = a2.getDimensionController();
        if (Log.isDebugOn()) {
            LOG.debug("Starting to cache previous page nodes {{{");
        }
        a4.cachePrevPageNodes(a3, a5);
        if (Log.isDebugOn()) {
            LOG.debug("Done caching previous page nodes }}}");
        }
        if (a4.shouldTerminate()) {
            if (Log.isDebugOn()) {
                LOG.debug("Found terminate flag. Exiting prelayout");
            }
            return;
        }
        if (Log.isDebugOn()) {
            LOG.debug("Starting to cache next page nodes {{{");
        }
        a4.cacheNextPageNodes(a3, a5);
        if (Log.isDebugOn()) {
            LOG.debug("Done caching next page nodes }}}");
        }
        if (a4.shouldTerminate()) {
            if (Log.isDebugOn()) {
                LOG.debug("Found terminate flag. Exiting prelayout");
            }
            return;
        }
        if (Log.isDebugOn()) {
            LOG.debug("Finished prelayout }}}");
        }
    }

    private void cachePrevPageNodes(TableOfContentsEntry a, ImageDimensionController a2) {
        ArticleListPrelayoutEngine a3;
        a3.cacheNodes(1, a, a2);
    }

    private void cacheNextPageNodes(TableOfContentsEntry a, ImageDimensionController a2) {
        ArticleListPrelayoutEngine a3;
        int a4;
        TableOfContentsEntry a5 = a;
        TableOfContentsEntry a6 = null;
        int n = a4 = 0;
        ArticleListPrelayoutEngine articleListPrelayoutEngine = a3;
        while (n < articleListPrelayoutEngine.preCacheFactor - 1 && a5 != null) {
            a6 = a5;
            try {
                a5 = a3.toc.getNextEntry(a5);
            }
            catch (BookException a7) {
                LOG.error("Exception when tryin to get next entry", (Throwable)a7);
                break;
            }
            n = ++a4;
            articleListPrelayoutEngine = a3;
        }
        if (a5 == null) {
            a5 = a6;
        }
        a3.cacheNodes(0, a5, a2);
    }

    public Image get(TableOfContentsEntry a, Dimension a2) {
        ArticleListPrelayoutEngine a3;
        ArticleListCacheKey a4 = new ArticleListCacheKey(a, a2);
        Object a5 = a3.cache.get(a4);
        if (a5 instanceof ArticleListCacheValue) {
            return ((ArticleListCacheValue)a5).getImage();
        }
        return null;
    }

    public void put(Image a, TableOfContentsEntry a2, Dimension a3) {
        ArticleListPrelayoutEngine a4;
        a4.cache.put(new ArticleListViewCacheable(a2, a3, new ArticleListCacheValue(a)));
    }

    private TableOfContentsEntry getNextNode(TableOfContentsEntry a, int a2, boolean a3) throws BookException {
        ArticleListPrelayoutEngine a4;
        if (a2 == 1) {
            TableOfContentsEntry a5 = a4.toc.getPreviousEntry(a);
            if (a5 != null) {
                return a5;
            }
            if (!a3) {
                return null;
            }
            return a4.getLastNodePrevSection(a);
        }
        if (a2 == 0) {
            TableOfContentsEntry a6 = a4.toc.getNextEntry(a);
            if (a6 != null) {
                return a6;
            }
            if (!a3) {
                return null;
            }
            return a4.getFirstNodeNextSection(a);
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"code path not supported");
        }
        return null;
    }

    private TableOfContentsEntry getLastNodePrevSection(TableOfContentsEntry a) throws BookException {
        ArticleListPrelayoutEngine a2;
        TableOfContentsEntry a3 = a2.getPrevUncle(a);
        if (a3 == null) {
            return null;
        }
        return a2.toc.getLastChild(a3);
    }

    private TableOfContentsEntry getFirstNodeNextSection(TableOfContentsEntry a) throws BookException {
        ArticleListPrelayoutEngine a2;
        TableOfContentsEntry a3 = a2.getNextUncle(a);
        if (a3 == null) {
            return null;
        }
        return a2.toc.getChild(a3);
    }

    private TableOfContentsEntry getPrevUncle(TableOfContentsEntry a) throws BookException {
        ArticleListPrelayoutEngine a2;
        if (a == null) {
            return null;
        }
        TableOfContentsEntry a3 = a2.toc.getParent(a);
        if (a3 == null) {
            return null;
        }
        TableOfContentsEntry a4 = a2.toc.getPreviousEntry(a3);
        if (a4 == null) {
            if (Log.isDebugOn()) {
                LOG.debug("Unable to find prev uncle of node: " + a);
                LOG.debug("Trying to wrap around section list");
            }
            TableOfContentsEntry a5 = a2.toc.getParent(a3);
            a4 = a2.toc.getLastChild(a5);
        }
        return a4;
    }

    private TableOfContentsEntry getNextUncle(TableOfContentsEntry a) throws BookException {
        TableOfContentsEntry a2;
        ArticleListPrelayoutEngine a3;
        if (a == null) {
            return null;
        }
        TableOfContentsEntry a4 = a3.toc.getParent(a);
        if (a4 == null) {
            return null;
        }
        TableOfContentsEntry a5 = a3.toc.getNextEntry(a4);
        if (a5 == null && (a2 = a3.toc.getParent(a4)) != null) {
            a3.toc.getChild(a2);
        }
        return a5;
    }

    private void cacheNodes(int a, TableOfContentsEntry a2, ImageDimensionController a3) {
        ArticleListPrelayoutEngine a4;
        int a5;
        if (a2 == null) {
            return;
        }
        int n = a5 = 1;
        while (n <= a4.preCacheFactor) {
            try {
                a2 = a4.getNextNode(a2, a, true);
            }
            catch (BookException a6) {
                LOG.error("Exception when tryin to get next node", (Throwable)a6);
                break;
            }
            if (a2 == null) break;
            Dimension a7 = a3.getImageDimension(a2);
            if (Log.isDebugOn()) {
                LOG.debug("Trying to prelayout [" + a2.getLabel() + "] for dimension " + a7);
            }
            if (a4.get(a2, a7) == null) {
                Image[] a8 = a2.getImages(a7);
                if (a4.shouldTerminate()) {
                    return;
                }
                Image a9 = null;
                if (a8 != null) {
                    a9 = a8[0];
                }
                if (a9 != null) {
                    imageTracker.addImage(a9, 0);
                    try {
                        p.mark();
                        imageTracker.waitForID(0);
                        p.dump("waitForId took");
                    }
                    catch (InterruptedException a10) {
                        LOG.error("Error while waiting to load image with imageTracker", (Throwable)a10);
                    }
                    imageTracker.removeImage(a9);
                    a4.cache.put(new ArticleListViewCacheable(a2, a7, new ArticleListCacheValue(a9)));
                    if (a4.shouldTerminate()) {
                        return;
                    }
                }
            }
            n = ++a5;
        }
    }

    static {
        $assertionsDisabled = !ArticleListPrelayoutEngine.class.desiredAssertionStatus();
        LOG = Log.getInstance((String)"ArticleListPrelayoutEngine");
        p = new Profiler("ArticleListPrelayoutEngine");
        imageTracker = new MediaTracker(new Component(){
            {
                1 a;
            }

            public synchronized boolean imageUpdate(Image a, int a2, int a3, int a4, int a5, int a6) {
                return (a2 & 0x20) == 0 && (a2 & 0x80) == 0;
            }
        });
    }

    private static class ArticleListViewCacheable
    implements CacheManager.Cacheable {
        TableOfContentsEntry entry;
        Dimension dimension;
        ArticleListCacheValue image;

        public ArticleListViewCacheable(TableOfContentsEntry a, Dimension a2, ArticleListCacheValue a3) {
            ArticleListViewCacheable a4;
            a4.entry = a;
            a4.dimension = a2;
            a4.image = a3;
        }

        public Object getId() {
            ArticleListViewCacheable a;
            return new ArticleListCacheKey(a.entry, a.dimension);
        }

        public CacheManager.CacheableValue getValue() {
            ArticleListViewCacheable a;
            return a.image;
        }

        public String toString() {
            ArticleListViewCacheable a;
            StringBuffer a2 = new StringBuffer();
            a2.append("ArticleListViewCacheable [entry=");
            a2.append(a.entry.getLabel());
            a2.append(", dim=");
            a2.append(a.dimension);
            a2.append("]");
            return a2.toString();
        }
    }

    private static class ArticleListCacheKey {
        TableOfContentsEntry entry;
        Dimension dimension;

        public ArticleListCacheKey(TableOfContentsEntry a, Dimension a2) {
            ArticleListCacheKey a3;
            a3.entry = a;
            a3.dimension = a2;
        }

        public boolean equals(Object a) {
            if (a instanceof ArticleListCacheKey) {
                ArticleListCacheKey a2;
                ArticleListCacheKey a3 = (ArticleListCacheKey)a;
                if (a2.entry == null && a3.entry != null || a2.dimension == null && a3.dimension != null) {
                    return false;
                }
                return a2.entry.getPosition().equals((Object)a3.entry.getPosition()) && a2.dimension.equals(a3.dimension) && a2.entry.getNodeType().equals(a3.entry.getNodeType());
            }
            return false;
        }

        public int hashCode() {
            ArticleListCacheKey a;
            if (a.entry != null && a.entry.getPosition() != null && a.dimension != null) {
                return a.entry.getPosition().hashCode() + a.dimension.hashCode() << 2;
            }
            return super.hashCode();
        }

        public String toString() {
            ArticleListCacheKey a;
            StringBuffer a2 = new StringBuffer();
            a2.append("[entry=");
            a2.append(a.entry.getLabel());
            a2.append(", d=");
            a2.append(a.dimension);
            a2.append("]");
            return a2.toString();
        }
    }

    private static class ArticleListCacheValue
    implements CacheManager.CacheableValue {
        private Image image;

        public ArticleListCacheValue(Image a) {
            ArticleListCacheValue a2;
            a2.image = a;
        }

        public long getMass() {
            ArticleListCacheValue a;
            int a2 = 8;
            if (a.image != null) {
                return a.image.getHeight(null) * a.image.getWidth(null) * a2;
            }
            return 0L;
        }

        public Image getImage() {
            ArticleListCacheValue a;
            return a.image;
        }
    }

    public static interface ImageDimensionController {
        public Dimension getImageDimension(TableOfContentsEntry var1);
    }

    public static class ArticleListPrelayoutEngineData {
        TableOfContentsEntry entry;
        ImageDimensionController dimensionController;

        public ArticleListPrelayoutEngineData(TableOfContentsEntry a, ImageDimensionController a2) {
            ArticleListPrelayoutEngineData a3;
            a3.entry = a;
            a3.dimensionController = a2;
        }

        public TableOfContentsEntry getTOCEntry() {
            ArticleListPrelayoutEngineData a;
            return a.entry;
        }

        public ImageDimensionController getDimensionController() {
            ArticleListPrelayoutEngineData a;
            return a.dimensionController;
        }
    }

    private static class PRECACHING_DIRECTION {
        public static final int NEXT_PAGE = 0;
        public static final int PREV_PAGE = 1;
        public static final int NEXT_SECTION = 2;
        public static final int PREV_SECTION = 3;

        private PRECACHING_DIRECTION() {
            PRECACHING_DIRECTION a;
        }
    }
}

